/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.CCWFlag;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class Orientation {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int index(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD.orientationIndex(p1, p2, q);
    }

    public static boolean isCCW(Coordinate[] ring) {
        return Orientation.isCCW(new CoordinateArraySequence(ring, 2, 0));
    }

    public static boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        if (nPts < 3) {
            return false;
        }
        Coordinate upHiPt = ring.getCoordinate(0);
        double prevY = upHiPt.y;
        Coordinate upLowPt = null;
        int iUpHi = 0;
        for (int i = 1; i <= nPts; ++i) {
            double py = ring.getOrdinate(i, 1);
            if (py > prevY && py >= upHiPt.y) {
                upHiPt = ring.getCoordinate(i);
                iUpHi = i;
                upLowPt = ring.getCoordinate(i - 1);
            }
            prevY = py;
        }
        if (iUpHi == 0) {
            return false;
        }
        int iDownLow = iUpHi;
        while ((iDownLow = (iDownLow + 1) % nPts) != iUpHi && ring.getOrdinate(iDownLow, 1) == upHiPt.y) {
        }
        Coordinate downLowPt = ring.getCoordinate(iDownLow);
        int iDownHi = iDownLow > 0 ? iDownLow - 1 : nPts - 1;
        Coordinate downHiPt = ring.getCoordinate(iDownHi);
        if (upHiPt.equals2D(downHiPt)) {
            if (upLowPt.equals2D(upHiPt) || downLowPt.equals2D(upHiPt) || upLowPt.equals2D(downLowPt)) {
                return false;
            }
            int index = Orientation.index(upLowPt, upHiPt, downLowPt);
            return index == 1;
        }
        double delX = downHiPt.x - upHiPt.x;
        return delX < 0.0;
    }

    public static boolean isCCWArea(Coordinate[] ring) {
        return Area.ofRingSigned(ring) < 0.0;
    }

    public static CCWFlag isCCW_NG(CoordinateSequence ring) {
        boolean downResult;
        boolean rightResult;
        double delY;
        boolean leftResult;
        double delX;
        boolean upResult;
        int nPts = ring.size() - 1;
        if (nPts < 3) {
            return new CCWFlag(false, false);
        }
        Coordinate upHiPt = ring.getCoordinate(0);
        double upPrevY = upHiPt.y;
        Coordinate upLowPt = ring.getCoordinate(ring.size() - 1);
        Coordinate leftSmallPt = ring.getCoordinate(0);
        double leftPrevX = leftSmallPt.x;
        Coordinate leftBigPt = ring.getCoordinate(ring.size() - 1);
        Coordinate rightBigPt = ring.getCoordinate(0);
        double rightPrevX = rightBigPt.x;
        Coordinate rightSmallPt = ring.getCoordinate(ring.size() - 1);
        Coordinate downLowPt = ring.getCoordinate(0);
        double downPrevY = downLowPt.y;
        Coordinate downHiPt = ring.getCoordinate(ring.size() - 1);
        int iUpHi = 0;
        int iLeftSmall = 0;
        int iRightBig = 0;
        int iDownLow = 0;
        for (int i = 1; i <= nPts; ++i) {
            double py = ring.getOrdinate(i, 1);
            double px = ring.getOrdinate(i, 0);
            if (py > upPrevY && py >= upHiPt.y) {
                upHiPt = ring.getCoordinate(i);
                iUpHi = i;
                upLowPt = ring.getCoordinate(i - 1);
            }
            if (px < leftPrevX && px <= leftSmallPt.x) {
                leftSmallPt = ring.getCoordinate(i);
                iLeftSmall = i;
                leftBigPt = ring.getCoordinate(i - 1);
            }
            if (px > rightPrevX && px >= rightBigPt.x) {
                rightBigPt = ring.getCoordinate(i);
                iRightBig = i;
                rightSmallPt = ring.getCoordinate(i - 1);
            }
            if (py < downPrevY && py <= downLowPt.y) {
                downLowPt = ring.getCoordinate(i);
                iDownLow = i;
                downHiPt = ring.getCoordinate(i - 1);
            }
            upPrevY = py;
            downPrevY = py;
            leftPrevX = px;
            rightPrevX = px;
        }
        if (iUpHi == 0 && iLeftSmall == 0 && iRightBig == 0 && iDownLow == 0) {
            return new CCWFlag(false, false);
        }
        int iUpLowAfterHi = iUpHi;
        while ((iUpLowAfterHi = (iUpLowAfterHi + 1) % nPts) != iUpHi && ring.getOrdinate(iUpLowAfterHi, 1) == upHiPt.y) {
        }
        Coordinate upLowAfterHiPt = ring.getCoordinate(iUpLowAfterHi);
        int iUpLowHi = iUpLowAfterHi > 0 ? iUpLowAfterHi - 1 : nPts - 1;
        Coordinate upLowHiPt = ring.getCoordinate(iUpLowHi);
        int iLeftBigAfterSmall = iLeftSmall;
        while ((iLeftBigAfterSmall = (iLeftBigAfterSmall + 1) % nPts) != iLeftSmall && ring.getOrdinate(iLeftBigAfterSmall, 0) == leftSmallPt.x) {
        }
        Coordinate leftBigAfterSmallPt = ring.getCoordinate(iLeftBigAfterSmall);
        int iLeftBigSmall = iLeftBigAfterSmall > 0 ? iLeftBigAfterSmall - 1 : nPts - 1;
        Coordinate leftBigSmallPt = ring.getCoordinate(iLeftBigSmall);
        int iRightSmallAfterBig = iRightBig;
        while ((iRightSmallAfterBig = (iRightSmallAfterBig + 1) % nPts) != iRightBig && ring.getOrdinate(iRightSmallAfterBig, 0) == rightBigPt.x) {
        }
        Coordinate rightSmallAfterBigPt = ring.getCoordinate(iRightSmallAfterBig);
        int iRightSmallBig = iRightSmallAfterBig > 0 ? iRightSmallAfterBig - 1 : nPts - 1;
        Coordinate rightSmallBigPt = ring.getCoordinate(iRightSmallBig);
        int iDownHiAfterLow = iDownLow;
        while ((iDownHiAfterLow = (iDownHiAfterLow + 1) % nPts) != iDownLow && ring.getOrdinate(iDownHiAfterLow, 1) == downLowPt.y) {
        }
        Coordinate downHiAfterLowPt = ring.getCoordinate(iDownHiAfterLow);
        int iDownHiLow = iDownHiAfterLow > 0 ? iDownHiAfterLow - 1 : nPts - 1;
        Coordinate downHiLowPt = ring.getCoordinate(iDownHiLow);
        if (upHiPt.equals2D(upLowHiPt)) {
            upResult = upLowPt.equals2D(upHiPt) || upLowAfterHiPt.equals2D(upHiPt) || upLowPt.equals2D(upLowAfterHiPt) ? false : Orientation.index(upLowPt, upHiPt, upLowAfterHiPt) == 1;
        } else {
            delX = upLowHiPt.x - upHiPt.x;
            boolean bl = upResult = delX < 0.0;
        }
        if (leftSmallPt.equals2D(leftBigSmallPt)) {
            leftResult = leftBigPt.equals2D(leftSmallPt) || leftBigAfterSmallPt.equals2D(leftSmallPt) || leftBigPt.equals2D(leftBigAfterSmallPt) ? false : Orientation.index(leftBigPt, leftSmallPt, leftBigAfterSmallPt) == 1;
        } else {
            delY = leftBigSmallPt.y - leftSmallPt.y;
            boolean bl = leftResult = delY < 0.0;
        }
        if (rightBigPt.equals2D(rightSmallBigPt)) {
            rightResult = rightSmallPt.equals2D(rightBigPt) || rightSmallAfterBigPt.equals2D(rightBigPt) || rightSmallPt.equals2D(rightSmallAfterBigPt) ? false : Orientation.index(rightSmallPt, rightBigPt, rightSmallAfterBigPt) == 1;
        } else {
            delY = rightSmallBigPt.y - rightBigPt.y;
            boolean bl = rightResult = delY > 0.0;
        }
        if (downLowPt.equals2D(downHiLowPt)) {
            downResult = downHiPt.equals2D(downLowPt) || downHiAfterLowPt.equals2D(downLowPt) || downHiPt.equals2D(downHiAfterLowPt) ? false : Orientation.index(downHiPt, downLowPt, downHiAfterLowPt) == 1;
        } else {
            delX = downHiLowPt.x - downLowPt.x;
            boolean bl = downResult = delX > 0.0;
        }
        if (upResult != downResult || leftResult != rightResult || upResult != leftResult) {
            Boolean[] results = new Boolean[]{upResult, leftResult, rightResult, downResult};
            int trueCount = 0;
            int falseCount = 0;
            for (Boolean resultFlag : results) {
                if (resultFlag.booleanValue()) {
                    ++trueCount;
                    continue;
                }
                ++falseCount;
            }
            boolean resultFlag = upResult;
            if (trueCount > falseCount) {
                resultFlag = true;
            } else if (trueCount < falseCount) {
                resultFlag = false;
            }
            return new CCWFlag(resultFlag, true);
        }
        return new CCWFlag(upResult, false);
    }
}

