/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Clipper;
import com.geoway.atlas.jts.Envelope2D;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryCursor;
import com.geoway.atlas.jts.InternalUtils;
import com.geoway.atlas.jts.ProgressTracker;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.SpatialReferenceImpl;

class OperatorClipCursor
extends GeometryCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReferenceImpl m_spatialRefImpl;
    Envelope2D m_envelope;
    double m_tolerance;
    int m_index = -1;

    OperatorClipCursor(GeometryCursor geoms, Envelope2D envelope, SpatialReference spatial_ref, ProgressTracker progress_tracker) {
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_envelope = envelope;
        this.m_inputGeometryCursor = geoms;
        this.m_spatialRefImpl = (SpatialReferenceImpl)spatial_ref;
        this.m_tolerance = InternalUtils.calculateToleranceFromGeometry(spatial_ref, envelope, false);
    }

    @Override
    public Geometry next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return Clipper.clip(geometry, this.m_envelope, this.m_tolerance, 0.0);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

