/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts.ogc;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryEngine;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorExportToWkb;
import com.geoway.atlas.jts.OperatorFactoryLocal;
import com.geoway.atlas.jts.Polygon;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.ogc.OGCGeometry;
import com.geoway.atlas.jts.ogc.OGCLineString;
import com.geoway.atlas.jts.ogc.OGCLinearRing;
import com.geoway.atlas.jts.ogc.OGCMultiCurve;
import com.geoway.atlas.jts.ogc.OGCMultiPolygon;
import com.geoway.atlas.jts.ogc.OGCSurface;
import java.nio.ByteBuffer;

public class OGCPolygon
extends OGCSurface {
    public static String TYPE = "Polygon";
    Polygon polygon;

    public OGCPolygon(Polygon src, int exteriorRing, SpatialReference sr) {
        this.polygon = new Polygon();
        int n = src.getPathCount();
        for (int i = exteriorRing; !(i >= n || i > exteriorRing && src.isExteriorRing(i)); ++i) {
            this.polygon.addPath(src, i, true);
        }
        this.esriSR = sr;
    }

    public OGCPolygon(Polygon geom, SpatialReference sr) {
        this.polygon = geom;
        if (geom.getExteriorRingCount() > 1) {
            throw new IllegalArgumentException("Polygon has to have one exterior ring. Simplify geom with OperatorSimplify.");
        }
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 16);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(16, this.getEsriGeometry(), null);
    }

    public OGCLineString exteriorRing() {
        if (this.polygon.isEmpty()) {
            return new OGCLinearRing((Polygon)this.polygon.createInstance(), 0, this.esriSR, true);
        }
        return new OGCLinearRing(this.polygon, 0, this.esriSR, true);
    }

    public int numInteriorRing() {
        return this.polygon.getPathCount() - 1;
    }

    public OGCLineString interiorRingN(int n) {
        return new OGCLinearRing(this.polygon, n + 1, this.esriSR, true);
    }

    @Override
    public OGCMultiCurve boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCPolygon.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.polygon != null ? this.polygon.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiPolygon(this.polygon, this.esriSR);
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        return this;
    }
}

