/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.data.vector.parquet.common.io;

import com.geoway.atlas.data.vector.common.wkb.WkbUtils$;
import com.geoway.data.vector.parquet.common.io.SimpleFeatureParquetSchema$;
import com.geoway.data.vector.parquet.common.io.SimpleFeatureWriterUtils$;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00115r!\u00024h\u0011\u00031h!\u0002=h\u0011\u0003I\bbBA\u0001\u0003\u0011\u0005\u00111\u0001\u0004\u0007\u0003\u000b\t\u0001!a\u0002\t\u0015\u0005%1A!A!\u0002\u0013\tY\u0001C\u0004\u0002\u0002\r!\t!!\"\t\u000f\u0005u4\u0001\"\u0001\u0002\f\u001e9\u0011QU\u0001\t\u0002\u0005\u001dfaBA\u0003\u0003!\u0005\u0011\u0011\u0016\u0005\b\u0003\u0003AA\u0011AAV\u0011\u001d\t\u0019\u0006\u0003C\u0001\u0003[Cq!a3\u0002\t\u0003\ti\rC\u0004\u0002L\u0006!\t!!?\t\u000f\u0005-\u0017\u0001\"\u0001\u0003\\!9!qN\u0001\u0005\n\tEdaBA\u000b\u0003\u0005\u0005\u0011q\u0003\u0005\u000b\u00037y!\u0011!Q\u0001\n\u0005u\u0001BCA\u001a\u001f\t\u0005\t\u0015!\u0003\u00026!9\u0011\u0011A\b\u0005\u0002\u0005m\u0002bBA*\u001f\u0011\u0005\u0011Q\u000b\u0005\b\u0003{za\u0011CA@\r\u0019\u0011\u0019)\u0001\u0001\u0003\u0006\"Q\u00111D\u000b\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005MRC!A!\u0002\u0013\t)\u0004C\u0004\u0002\u0002U!\tA!'\t\u000f\u0005uT\u0003\"\u0015\u0003\"\u001a1!qU\u0001\u0001\u0005SC!\"a\u0007\u001b\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t\u0019D\u0007B\u0001B\u0003%\u0011Q\u0007\u0005\b\u0003\u0003QB\u0011\u0001B]\u0011\u001d\tiH\u0007C)\u0005\u00034aAa2\u0002\u0001\t%\u0007BCA\u000e?\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u00111G\u0010\u0003\u0002\u0003\u0006I!!\u000e\t\u000f\u0005\u0005q\u0004\"\u0001\u0003Z\"9\u0011QP\u0010\u0005R\t\u0005hA\u0002Bt\u0003\u0001\u0011I\u000f\u0003\u0006\u0002\u001c\u0011\u0012\t\u0011)A\u0005\u0003;A!\"a\r%\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011\u001d\t\t\u0001\nC\u0001\u0005gDq!! %\t#\u0012YP\u0002\u0004\u0004\u0002\u0005\u000111\u0001\u0005\u000b\u00037I#\u0011!Q\u0001\n\u0005u\u0001BCA\u001aS\t\u0005\t\u0015!\u0003\u00026!9\u0011\u0011A\u0015\u0005\u0002\r5\u0001bBA?S\u0011E3Q\u0003\u0004\u0007\u00077\t\u0001a!\b\t\u0015\u0005maF!A!\u0002\u0013\ti\u0002\u0003\u0006\u000249\u0012\t\u0011)A\u0005\u0003kAq!!\u0001/\t\u0003\u00199\u0003C\u0004\u0002~9\"\tfa\f\u0007\r\rU\u0012\u0001AB\u001c\u0011)\tYb\rB\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003g\u0019$\u0011!Q\u0001\n\u0005U\u0002bBA\u0001g\u0011\u00051\u0011\t\u0005\b\u0003{\u001aD\u0011KB%\r\u0019\u0019y%\u0001\u0001\u0004R!Q\u00111\u0004\u001d\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005M\u0002H!A!\u0002\u0013\t)\u0004C\u0004\u0002\u0002a\"\ta!\u0016\t\u000f\u0005u\u0004\b\"\u0015\u0004^\u0019111M\u0001\u0001\u0007KB!\"a\u0007>\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t\u0019$\u0010B\u0001B\u0003%\u0011Q\u0007\u0005\b\u0003\u0003iD\u0011AB9\u0011\u001d\ti(\u0010C)\u0007s2aaa \u0002\u0001\r\u0005\u0005BCA\u000e\u0005\n\u0005\t\u0015!\u0003\u0002\u001e!Q\u00111\u0007\"\u0003\u0002\u0003\u0006I!!\u000e\t\u000f\u0005\u0005!\t\"\u0001\u0004\f\"9\u0011Q\u0010\"\u0005R\rMeABBM\u0003\u0001\u0019Y\n\u0003\u0006\u0002\u001c\u001d\u0013\t\u0011)A\u0005\u0003;A!\"a\rH\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011)\u0019)k\u0012B\u0001B\u0003%!q\u0004\u0005\b\u0003\u00039E\u0011ABT\u0011%\u0019\tl\u0012b\u0001\n\u0013\u0019\u0019\f\u0003\u0005\u00046\u001e\u0003\u000b\u0011BA\t\u0011\u001d\tih\u0012C)\u0007o3aa!0\u0002\u0001\r}\u0006BCA\u000e\u001f\n\u0005\t\u0015!\u0003\u0002\u001e!Q\u00111G(\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\r\u001dwJ!A!\u0002\u0013\u0011y\u0002\u0003\u0006\u0004&>\u0013\t\u0011)A\u0005\u0005?Aq!!\u0001P\t\u0003\u0019I\rC\u0005\u0004V>\u0013\r\u0011\"\u0003\u00044\"A1q[(!\u0002\u0013\t\t\u0002C\u0005\u0004Z>\u0013\r\u0011\"\u0003\u00044\"A11\\(!\u0002\u0013\t\t\u0002C\u0004\u0002~=#\tf!8\u0007\r\r\r\u0018\u0001ABs\u0011)\tYB\u0017B\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003gQ&\u0011!Q\u0001\n\u0005U\u0002bBA\u00015\u0012\u00051q\u001e\u0005\b\u0003{RF\u0011KB|\r\u0019\u0019i0\u0001\u0001\u0004\u0000\"Q\u00111D0\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005MxL!A!\u0002\u0013\t\u0019\r\u0003\u0006\u0002x~\u0013\t\u0011)A\u0005\u0003;Aq!!\u0001`\t\u0003!9\u0002C\u0004\u0002T}#\t\u0005\"\t\t\u000f\u0005ut\f\"\u0015\u0005(\u0005A2+[7qY\u00164U-\u0019;ve\u0016<&/\u001b;feV#\u0018\u000e\\:\u000b\u0005!L\u0017AA5p\u0015\tQ7.\u0001\u0004d_6lwN\u001c\u0006\u0003Y6\fq\u0001]1scV,GO\u0003\u0002o_\u00061a/Z2u_JT!\u0001]9\u0002\t\u0011\fG/\u0019\u0006\u0003eN\faaZ3po\u0006L(\"\u0001;\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005]\fQ\"A4\u00031MKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:Vi&d7o\u0005\u0002\u0002uB\u00111P`\u0007\u0002y*\tQ0A\u0003tG\u0006d\u0017-\u0003\u0002\u0000y\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001<\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:\u0014\u0005\rQ\u0018AC1uiJL'-\u001e;fgB)10!\u0004\u0002\u0012%\u0019\u0011q\u0002?\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005MqB_\u0007\u0002\u0003\ty\u0011\t\u001e;sS\n,H/Z,sSR,'/\u0006\u0003\u0002\u001a\u0005\r3CA\b{\u0003\u0011q\u0017-\\3\u0011\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tI\u0003E\u0002\u0002$ql!!!\n\u000b\u0007\u0005\u001dR/\u0001\u0004=e>|GOP\u0005\u0004\u0003Wa\u0018A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,q\fQ!\u001b8eKb\u00042a_A\u001c\u0013\r\tI\u0004 \u0002\u0004\u0013:$HCBA\u001f\u0003\u001f\n\t\u0006E\u0003\u0002\u0014=\ty\u0004\u0005\u0003\u0002B\u0005\rC\u0002\u0001\u0003\b\u0003\u000bz!\u0019AA$\u0005\u0005!\u0016cAA%uB\u001910a\u0013\n\u0007\u00055CPA\u0004O_RD\u0017N\\4\t\u000f\u0005m!\u00031\u0001\u0002\u001e!9\u00111\u0007\nA\u0002\u0005U\u0012!B1qa2LHCBA,\u0003;\nI\bE\u0002|\u00033J1!a\u0017}\u0005\u0011)f.\u001b;\t\u000f\u0005}3\u00031\u0001\u0002b\u0005A1m\u001c8tk6,'\u000f\u0005\u0003\u0002d\u0005UTBAA3\u0015\u0011\t9'!\u001b\u0002\u0007\u0005\u0004\u0018NC\u0002i\u0003WR1\u0001\\A7\u0015\u0011\ty'!\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019(A\u0002pe\u001eLA!a\u001e\u0002f\tq!+Z2pe\u0012\u001cuN\\:v[\u0016\u0014\bbBA>'\u0001\u0007\u0011qH\u0001\u0006m\u0006dW/Z\u0001\u0006oJLG/\u001a\u000b\u0007\u0003/\n\t)a!\t\u000f\u0005}C\u00031\u0001\u0002b!9\u00111\u0010\u000bA\u0002\u0005}B\u0003BAD\u0003\u0013\u00032!a\u0005\u0004\u0011\u001d\tI!\u0002a\u0001\u0003\u0017!b!a\u0016\u0002\u000e\u0006=\u0005bBA0\r\u0001\u0007\u0011\u0011\r\u0005\b\u0003w2\u0001\u0019AAI!\u0011\t\u0019*!)\u000e\u0005\u0005U%\u0002BAL\u00033\u000baa]5na2,'\u0002BAN\u0003;\u000bqAZ3biV\u0014XM\u0003\u0003\u0002 \u0006E\u0014aB8qK:<\u0017n]\u0005\u0005\u0003G\u000b)JA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0014'&l\u0007\u000f\\3GK\u0006$XO]3Xe&$XM\u001d\t\u0004\u0003'A1C\u0001\u0005{)\t\t9\u000b\u0006\u0005\u0002\b\u0006=\u0016\u0011XAc\u0011\u001d\t\tL\u0003a\u0001\u0003g\u000b1a\u001d4u!\u0011\t\u0019*!.\n\t\u0005]\u0016Q\u0013\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007bBA^\u0015\u0001\u0007\u0011QX\u0001\rM&,G\u000e\u001a(b[\u0016l\u0015\r\u001d\t\t\u0003?\ty,!\b\u0002D&!\u0011\u0011YA\u0019\u0005\ri\u0015\r\u001d\t\u0006w\u00065\u0011Q\u0007\u0005\b\u0003\u000fT\u0001\u0019AAe\u0003-\u0011'm\u001c=OC6,W*\u00199\u0011\u0011\u0005}\u0011qXA\u000f\u0003;\t\u0011\"\u0019;ue&\u0014W\u000f^3\u0015\u0011\u0005=\u0017\u0011]Ay\u0003k\u0004D!!5\u0002VB)\u00111C\b\u0002TB!\u0011\u0011IAk\t-\t9nCA\u0001\u0002\u0003\u0015\t!!7\u0003\u0007}#3'\u0005\u0003\u0002J\u0005m\u0007cA>\u0002^&\u0019\u0011q\u001c?\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002d.\u0001\r!!:\u0002\u0015\u0011,7o\u0019:jaR|'\u000f\u0005\u0003\u0002h\u00065XBAAu\u0015\u0011\tY/!'\u0002\tQL\b/Z\u0005\u0005\u0003_\fIOA\nBiR\u0014\u0018NY;uK\u0012+7o\u0019:jaR|'\u000fC\u0004\u0002t.\u0001\r!a1\u0002\u000f%tG-\u001a=fg\"9\u0011q_\u0006A\u0002\u0005u\u0011\u0001\u00032c_bt\u0015-\\3\u0015\u0011\u0005m(Q\u0001B\u0004\u0005\u0013\u0001D!!@\u0003\u0002A)\u00111C\b\u0002\u0000B!\u0011\u0011\tB\u0001\t-\u0011\u0019\u0001DA\u0001\u0002\u0003\u0015\t!!7\u0003\u0007}#C\u0007C\u0004\u0002\u001c1\u0001\r!!\b\t\u000f\u0005MH\u00021\u0001\u0002D\"9!1\u0002\u0007A\u0002\t5\u0011\u0001\u00032j]\u0012LgnZ:\u0011\r\t=!\u0011\u0004B\u0010\u001d\u0011\u0011\tB!\u0006\u000f\t\u0005\r\"1C\u0005\u0002{&\u0019!q\u0003?\u0002\u000fA\f7m[1hK&!!1\u0004B\u000f\u0005\r\u0019V-\u001d\u0006\u0004\u0005/a\b\u0003\u0002B\u0011\u0005+rAAa\t\u0003P9!!Q\u0005B&\u001d\u0011\u00119Ca\u0012\u000f\t\t%\"1\t\b\u0005\u0005W\u0011yD\u0004\u0003\u0003.\tmb\u0002\u0002B\u0018\u0005oqAA!\r\u000369!\u00111\u0005B\u001a\u0013\u0005!\u0018B\u0001:t\u0013\r\u0011I$]\u0001\u0006CRd\u0017m]\u0005\u0004a\nu\"b\u0001B\u001dc&\u0019aN!\u0011\u000b\u0007A\u0014i$C\u0002k\u0005\u000bR1A\u001cB!\u0013\u0011\tYJ!\u0013\u000b\u0007)\u0014)%\u0003\u0003\u00022\n5#\u0002BAN\u0005\u0013JAA!\u0015\u0003T\u0005QqJ\u00196fGR$\u0016\u0010]3\u000b\t\u0005E&QJ\u0005\u0005\u0005/\u0012IF\u0001\u0006PE*,7\r\u001e+za\u0016TAA!\u0015\u0003TQQ!Q\fB4\u0005S\u0012YG!\u001c1\t\t}#1\r\t\u0006\u0003'y!\u0011\r\t\u0005\u0003\u0003\u0012\u0019\u0007B\u0006\u0003f5\t\t\u0011!A\u0003\u0002\u0005e'aA0%k!9\u00111D\u0007A\u0002\u0005u\u0001bBAz\u001b\u0001\u0007\u00111\u0019\u0005\b\u0005\u0017i\u0001\u0019\u0001B\u0007\u0011\u001d\t90\u0004a\u0001\u0003;\t\u0001bZ3p[\u0016$(/\u001f\u000b\t\u0005g\u0012iHa \u0003\u0002B\"!Q\u000fB=!\u0015\t\u0019b\u0004B<!\u0011\t\tE!\u001f\u0005\u0017\tmd\"!A\u0001\u0002\u000b\u0005\u0011\u0011\u001c\u0002\u0004?\u00122\u0004bBA\u000e\u001d\u0001\u0007\u0011Q\u0004\u0005\b\u0003gt\u0001\u0019AAb\u0011\u001d\t9P\u0004a\u0001\u0003;\u0011!\u0002R1uK^\u0013\u0018\u000e^3s'\r)\"q\u0011\t\u0006\u0003'y!\u0011\u0012\t\u0005\u0005\u0017\u0013)*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003\u0011)H/\u001b7\u000b\u0005\tM\u0015\u0001\u00026bm\u0006LAAa&\u0003\u000e\n!A)\u0019;f)\u0019\u0011YJ!(\u0003 B\u0019\u00111C\u000b\t\u000f\u0005m\u0001\u00041\u0001\u0002\u001e!9\u00111\u0007\rA\u0002\u0005UBCBA,\u0005G\u0013)\u000bC\u0004\u0002`e\u0001\r!!\u0019\t\u000f\u0005m\u0014\u00041\u0001\u0003\n\naAi\\;cY\u0016<&/\u001b;feN\u0019!Da+\u0011\u000b\u0005MqB!,\u0011\t\t=&QW\u0007\u0003\u0005cSAAa-\u0003\u0012\u0006!A.\u00198h\u0013\u0011\u00119L!-\u0003\r\u0011{WO\u00197f)\u0019\u0011YL!0\u0003@B\u0019\u00111\u0003\u000e\t\u000f\u0005mQ\u00041\u0001\u0002\u001e!9\u00111G\u000fA\u0002\u0005UBCBA,\u0005\u0007\u0014)\rC\u0004\u0002`y\u0001\r!!\u0019\t\u000f\u0005md\u00041\u0001\u0003.\n\u0001\")[4EK\u000eLW.\u00197Xe&$XM]\n\u0004?\t-\u0007#BA\n\u001f\t5\u0007\u0003\u0002Bh\u0005+l!A!5\u000b\t\tM'\u0011S\u0001\u0005[\u0006$\b.\u0003\u0003\u0003X\nE'A\u0003\"jO\u0012+7-[7bYR1!1\u001cBo\u0005?\u00042!a\u0005 \u0011\u001d\tYB\ta\u0001\u0003;Aq!a\r#\u0001\u0004\t)\u0004\u0006\u0004\u0002X\t\r(Q\u001d\u0005\b\u0003?\u001a\u0003\u0019AA1\u0011\u001d\tYh\ta\u0001\u0005\u001b\u00141B\u00127pCR<&/\u001b;feN\u0019AEa;\u0011\u000b\u0005MqB!<\u0011\t\t=&q^\u0005\u0005\u0005c\u0014\tLA\u0003GY>\fG\u000f\u0006\u0004\u0003v\n](\u0011 \t\u0004\u0003'!\u0003bBA\u000eO\u0001\u0007\u0011Q\u0004\u0005\b\u0003g9\u0003\u0019AA\u001b)\u0019\t9F!@\u0003\u0000\"9\u0011q\f\u0015A\u0002\u0005\u0005\u0004bBA>Q\u0001\u0007!Q\u001e\u0002\u000e\u0013:$XmZ3s/JLG/\u001a:\u0014\u0007%\u001a)\u0001E\u0003\u0002\u0014=\u00199\u0001\u0005\u0003\u00030\u000e%\u0011\u0002BB\u0006\u0005c\u0013q!\u00138uK\u001e,'\u000f\u0006\u0004\u0004\u0010\rE11\u0003\t\u0004\u0003'I\u0003bBA\u000eY\u0001\u0007\u0011Q\u0004\u0005\b\u0003ga\u0003\u0019AA\u001b)\u0019\t9fa\u0006\u0004\u001a!9\u0011qL\u0017A\u0002\u0005\u0005\u0004bBA>[\u0001\u00071q\u0001\u0002\f'\"|'\u000f^,sSR,'oE\u0002/\u0007?\u0001R!a\u0005\u0010\u0007C\u0001BAa,\u0004$%!1Q\u0005BY\u0005\u0015\u0019\u0006n\u001c:u)\u0019\u0019Ica\u000b\u0004.A\u0019\u00111\u0003\u0018\t\u000f\u0005m\u0011\u00071\u0001\u0002\u001e!9\u00111G\u0019A\u0002\u0005UBCBA,\u0007c\u0019\u0019\u0004C\u0004\u0002`I\u0002\r!!\u0019\t\u000f\u0005m$\u00071\u0001\u0004\"\tQAj\u001c8h/JLG/\u001a:\u0014\u0007M\u001aI\u0004E\u0003\u0002\u0014=\u0019Y\u0004\u0005\u0003\u00030\u000eu\u0012\u0002BB \u0005c\u0013A\u0001T8oOR111IB#\u0007\u000f\u00022!a\u00054\u0011\u001d\tYB\u000ea\u0001\u0003;Aq!a\r7\u0001\u0004\t)\u0004\u0006\u0004\u0002X\r-3Q\n\u0005\b\u0003?:\u0004\u0019AA1\u0011\u001d\tYh\u000ea\u0001\u0007w\u0011Ab\u0015;sS:<wK]5uKJ\u001c2\u0001OB*!\u0015\t\u0019bDA\u000f)\u0019\u00199f!\u0017\u0004\\A\u0019\u00111\u0003\u001d\t\u000f\u0005m1\b1\u0001\u0002\u001e!9\u00111G\u001eA\u0002\u0005UBCBA,\u0007?\u001a\t\u0007C\u0004\u0002`q\u0002\r!!\u0019\t\u000f\u0005mD\b1\u0001\u0002\u001e\tY!)\u001f;fg^\u0013\u0018\u000e^3s'\ri4q\r\t\u0006\u0003'y1\u0011\u000e\t\u0006w\u0006511\u000e\t\u0004w\u000e5\u0014bAB8y\n!!)\u001f;f)\u0019\u0019\u0019h!\u001e\u0004xA\u0019\u00111C\u001f\t\u000f\u0005m\u0001\t1\u0001\u0002\u001e!9\u00111\u0007!A\u0002\u0005UBCBA,\u0007w\u001ai\bC\u0004\u0002`\u0005\u0003\r!!\u0019\t\u000f\u0005m\u0014\t1\u0001\u0004j\ti!i\\8mK\u0006twK]5uKJ\u001c2AQBB!\u0015\t\u0019bDBC!\u0011\u0011yka\"\n\t\r%%\u0011\u0017\u0002\b\u0005>|G.Z1o)\u0019\u0019iia$\u0004\u0012B\u0019\u00111\u0003\"\t\u000f\u0005mQ\t1\u0001\u0002\u001e!9\u00111G#A\u0002\u0005UBCBA,\u0007+\u001b9\nC\u0004\u0002`\u0019\u0003\r!!\u0019\t\u000f\u0005md\t1\u0001\u0004\u0006\nQA*[:u/JLG/\u001a:\u0014\u0007\u001d\u001bi\nE\u0003\u0002\u0014=\u0019y\nE\u0003\u0003\f\u000e\u0005&0\u0003\u0003\u0004$\n5%\u0001\u0002'jgR\f\u0011B^1mk\u0016$\u0016\u0010]3\u0015\u0011\r%61VBW\u0007_\u00032!a\u0005H\u0011\u001d\tYb\u0013a\u0001\u0003;Aq!a\rL\u0001\u0004\t)\u0004C\u0004\u0004&.\u0003\rAa\b\u0002\u001b\u0015dW-\\3oi^\u0013\u0018\u000e^3s+\t\t\t\"\u0001\bfY\u0016lWM\u001c;Xe&$XM\u001d\u0011\u0015\r\u0005]3\u0011XB^\u0011\u001d\tyF\u0014a\u0001\u0003CBq!a\u001fO\u0001\u0004\u0019yJA\u0005NCB<&/\u001b;feN\u0019qj!1\u0011\u000b\u0005Mqba1\u0011\r\t-5Q\u0019>{\u0013\u0011\t\tM!$\u0002\u000f-,\u0017\u0010V=qKRQ11ZBg\u0007\u001f\u001c\tna5\u0011\u0007\u0005Mq\nC\u0004\u0002\u001cQ\u0003\r!!\b\t\u000f\u0005MB\u000b1\u0001\u00026!91q\u0019+A\u0002\t}\u0001bBBS)\u0002\u0007!qD\u0001\nW\u0016LxK]5uKJ\f!b[3z/JLG/\u001a:!\u0003-1\u0018\r\\;f/JLG/\u001a:\u0002\u0019Y\fG.^3Xe&$XM\u001d\u0011\u0015\r\u0005]3q\\Bq\u0011\u001d\ty&\u0017a\u0001\u0003CBq!a\u001fZ\u0001\u0004\u0019\u0019M\u0001\u0006Vk&$wK]5uKJ\u001c2AWBt!\u0015\t\u0019bDBu!\u0011\u0011Yia;\n\t\r5(Q\u0012\u0002\u0005+VKE\t\u0006\u0004\u0004r\u000eM8Q\u001f\t\u0004\u0003'Q\u0006bBA\u000e;\u0002\u0007\u0011Q\u0004\u0005\b\u0003gi\u0006\u0019AA\u001b)\u0019\t9f!?\u0004|\"9\u0011q\f0A\u0002\u0005\u0005\u0004bBA>=\u0002\u00071\u0011\u001e\u0002\u001b\u000f\u0016|W.\u001a;ss^['-\u0011;ue&\u0014W\u000f^3Xe&$XM]\n\u0004?\u0012\u0005\u0001#BA\n\u001f\u0011\r\u0001\u0003\u0002C\u0003\t'i!\u0001b\u0002\u000b\t\u0011%A1B\u0001\u0005O\u0016|WN\u0003\u0003\u0005\u000e\u0011=\u0011a\u00016ug*!A\u0011CA9\u00031awnY1uS>tG/Z2i\u0013\u0011!)\u0002b\u0002\u0003\u0011\u001d+w.\\3uef$\u0002\u0002\"\u0007\u0005\u001c\u0011uAq\u0004\t\u0004\u0003'y\u0006bBA\u000eG\u0002\u0007\u0011Q\u0004\u0005\b\u0003g\u001c\u0007\u0019AAb\u0011\u001d\t9p\u0019a\u0001\u0003;!b!a\u0016\u0005$\u0011\u0015\u0002bBA0I\u0002\u0007\u0011\u0011\r\u0005\b\u0003w\"\u0007\u0019\u0001C\u0002)\u0019\t9\u0006\"\u000b\u0005,!9\u0011qL3A\u0002\u0005\u0005\u0004bBA>K\u0002\u0007A1\u0001")
public final class SimpleFeatureWriterUtils {
    public static AttributeWriter<?> attribute(String string, int[] nArray, Seq<Enumeration.Value> seq, String string2) {
        return SimpleFeatureWriterUtils$.MODULE$.attribute(string, nArray, seq, string2);
    }

    public static AttributeWriter<?> attribute(String string, int[] nArray, Seq<Enumeration.Value> seq) {
        return SimpleFeatureWriterUtils$.MODULE$.attribute(string, nArray, seq);
    }

    public static AttributeWriter<?> attribute(AttributeDescriptor attributeDescriptor, int[] nArray, String string) {
        return SimpleFeatureWriterUtils$.MODULE$.attribute(attributeDescriptor, nArray, string);
    }

    public static abstract class AttributeWriter<T> {
        private final String name;
        private final int index;

        public void apply(RecordConsumer consumer, T value) {
            block0: {
                if (value == null) break block0;
                consumer.startField(this.name, this.index);
                this.write(consumer, value);
                consumer.endField(this.name, this.index);
            }
        }

        public abstract void write(RecordConsumer var1, T var2);

        public AttributeWriter(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }

    public static class BigDecimalWriter
    extends AttributeWriter<BigDecimal> {
        @Override
        public void write(RecordConsumer consumer, BigDecimal value) {
            consumer.addDouble(value.doubleValue());
        }

        public BigDecimalWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class BooleanWriter
    extends AttributeWriter<Boolean> {
        @Override
        public void write(RecordConsumer consumer, Boolean value) {
            consumer.addBoolean(Predef$.MODULE$.Boolean2boolean(value));
        }

        public BooleanWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class BytesWriter
    extends AttributeWriter<byte[]> {
        @Override
        public void write(RecordConsumer consumer, byte[] value) {
            consumer.addBinary(Binary.fromConstantByteArray((byte[])value));
        }

        public BytesWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class DateWriter
    extends AttributeWriter<Date> {
        @Override
        public void write(RecordConsumer consumer, Date value) {
            consumer.addLong(value.getTime());
        }

        public DateWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class DoubleWriter
    extends AttributeWriter<Double> {
        @Override
        public void write(RecordConsumer consumer, Double value) {
            consumer.addDouble(Predef$.MODULE$.Double2double(value));
        }

        public DoubleWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class FloatWriter
    extends AttributeWriter<Float> {
        @Override
        public void write(RecordConsumer consumer, Float value) {
            consumer.addFloat(Predef$.MODULE$.Float2float(value));
        }

        public FloatWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class GeometryWkbAttributeWriter
    extends AttributeWriter<Geometry> {
        private final String name;
        private final int[] indexes;
        private final String bboxName;

        @Override
        public void apply(RecordConsumer consumer, Geometry value) {
            block0: {
                if (value == null) break block0;
                this.write(consumer, value);
            }
        }

        @Override
        public void write(RecordConsumer consumer, Geometry value) {
            consumer.startField(this.name, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indexes)).head()));
            consumer.addBinary(Binary.fromConstantByteArray((byte[])WkbUtils$.MODULE$.write(value, false)));
            consumer.endField(this.name, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indexes)).head()));
            consumer.startField(this.bboxName, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indexes)).last()));
            Envelope env = value.getEnvelopeInternal();
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnXmin(), 0);
            consumer.addDouble(env.getMinX());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnXmin(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnYmin(), 1);
            consumer.addDouble(env.getMinY());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnYmin(), 1);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnXmax(), 2);
            consumer.addDouble(env.getMaxX());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnXmax(), 2);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnYmax(), 3);
            consumer.addDouble(env.getMaxY());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnYmax(), 3);
            consumer.endGroup();
            consumer.endField(this.bboxName, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indexes)).last()));
        }

        public GeometryWkbAttributeWriter(String name, int[] indexes, String bboxName) {
            this.name = name;
            this.indexes = indexes;
            this.bboxName = bboxName;
            super(name, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indexes)).head()));
        }
    }

    public static class IntegerWriter
    extends AttributeWriter<Integer> {
        @Override
        public void write(RecordConsumer consumer, Integer value) {
            consumer.addInteger(Predef$.MODULE$.Integer2int(value));
        }

        public IntegerWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class ListWriter
    extends AttributeWriter<java.util.List<Object>> {
        private final AttributeWriter<Object> elementWriter;

        private AttributeWriter<Object> elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void write(RecordConsumer consumer, java.util.List<Object> value) {
            consumer.startGroup();
            if (!value.isEmpty()) {
                consumer.startField("list", 0);
                Iterator<Object> iter = value.iterator();
                while (iter.hasNext()) {
                    consumer.startGroup();
                    Object item = iter.next();
                    if (item != null) {
                        this.elementWriter().apply(consumer, item);
                    }
                    consumer.endGroup();
                }
                consumer.endField("list", 0);
            }
            consumer.endGroup();
        }

        public ListWriter(String name, int index, Enumeration.Value valueType) {
            super(name, index);
            this.elementWriter = SimpleFeatureWriterUtils$.MODULE$.attribute("element", new int[]{0}, (Seq<Enumeration.Value>)((Seq)new .colon.colon((Object)valueType, (List)Nil$.MODULE$)));
        }
    }

    public static class LongWriter
    extends AttributeWriter<Long> {
        @Override
        public void write(RecordConsumer consumer, Long value) {
            consumer.addLong(Predef$.MODULE$.Long2long(value));
        }

        public LongWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MapWriter
    extends AttributeWriter<Map<Object, Object>> {
        private final AttributeWriter<Object> keyWriter;
        private final AttributeWriter<Object> valueWriter;

        private AttributeWriter<Object> keyWriter() {
            return this.keyWriter;
        }

        private AttributeWriter<Object> valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void write(RecordConsumer consumer, Map<Object, Object> value) {
            consumer.startGroup();
            if (!value.isEmpty()) {
                consumer.startField("map", 0);
                for (Map.Entry<Object, Object> entry : value.entrySet()) {
                    consumer.startGroup();
                    this.keyWriter().apply(consumer, entry.getKey());
                    Object v = entry.getValue();
                    if (v != null) {
                        this.valueWriter().apply(consumer, v);
                    }
                    consumer.endGroup();
                }
                consumer.endField("map", 0);
            }
            consumer.endGroup();
        }

        public MapWriter(String name, int index, Enumeration.Value keyType, Enumeration.Value valueType) {
            super(name, index);
            this.keyWriter = SimpleFeatureWriterUtils$.MODULE$.attribute("key", new int[]{0}, (Seq<Enumeration.Value>)((Seq)new .colon.colon((Object)keyType, (List)Nil$.MODULE$)));
            this.valueWriter = SimpleFeatureWriterUtils$.MODULE$.attribute("value", new int[]{1}, (Seq<Enumeration.Value>)((Seq)new .colon.colon((Object)valueType, (List)Nil$.MODULE$)));
        }
    }

    public static class ShortWriter
    extends AttributeWriter<Short> {
        @Override
        public void write(RecordConsumer consumer, Short value) {
            consumer.addInteger(value.intValue());
        }

        public ShortWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class SimpleFeatureWriter {
        private final AttributeWriter<Object>[] attributes;

        public void write(RecordConsumer consumer, SimpleFeature value) {
            consumer.startMessage();
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].apply(consumer, value.getAttribute(i));
            }
            consumer.endMessage();
        }

        public SimpleFeatureWriter(AttributeWriter<Object>[] attributes) {
            this.attributes = attributes;
        }
    }

    public static class StringWriter
    extends AttributeWriter<String> {
        @Override
        public void write(RecordConsumer consumer, String value) {
            consumer.addBinary(Binary.fromString((String)value));
        }

        public StringWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class UuidWriter
    extends AttributeWriter<UUID> {
        @Override
        public void write(RecordConsumer consumer, UUID value) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(value.getMostSignificantBits());
            bb.putLong(value.getLeastSignificantBits());
            consumer.addBinary(Binary.fromConstantByteArray((byte[])bb.array()));
        }

        public UuidWriter(String name, int index) {
            super(name, index);
        }
    }
}

