/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.serialization.common.index;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.StandardOutput;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.data.vector.serialization.common.index.EnvelopeSerializer$;
import com.geoway.atlas.index.vector.common.partitionIndex.strtree.STRtreePartitionVectorIndex;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.STRtree;
import scala.Predef$;
import scala.runtime.BoxedUnit;

public final class STRtreeIndexSerializer$ {
    public static STRtreeIndexSerializer$ MODULE$;

    static {
        new STRtreeIndexSerializer$();
    }

    public void serializableSTRtree(StandardOutput out, STRtreePartitionVectorIndex<String> t) {
        package$.MODULE$.RichStandardOutput(out).writeInt(t.strTree().getNodeCapacity(), ByteOrder.LITTLE_ENDIAN);
        if (t.isEmpty()) {
            out.write(0);
        } else {
            out.write(1);
            out.write(Predef$.MODULE$.Boolean2boolean(t.strTree().isBuilt()) ? 1 : 0);
            if (!Predef$.MODULE$.Boolean2boolean(t.strTree().isBuilt())) {
                ArrayList itemBoundables = t.strTree().getItemBoundables();
                package$.MODULE$.RichStandardOutput(out).writeInt(itemBoundables.size(), ByteOrder.LITTLE_ENDIAN);
                int limit$macro$4 = itemBoundables.size();
                for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                    Object itemBoundableObj = itemBoundables.get(index$macro$2);
                    Object e = itemBoundableObj;
                    if (!(e instanceof ItemBoundable)) {
                        String x$1 = new StringBuilder(11).append("\u5fc5\u987b\u5305\u542b\u7684\u662f").append(ItemBoundable.class.getSimpleName()).append("\u7c7b\u578b\u7684\u5bf9\u8c61").toString();
                        Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                        int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                        throw new NotSupportException(x$1, x$2, x$3);
                    }
                    ItemBoundable itemBoundable = (ItemBoundable)e;
                    this.writeItemBoundable(out, itemBoundable);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                this.writeSTRtreeNode(out, t.strTree().getRoot());
            }
        }
    }

    public void writeItemBoundable(StandardOutput output, ItemBoundable boundable) {
        EnvelopeSerializer$.MODULE$.writeEnvelope(output, (Envelope)boundable.getBounds());
        byte[] bytes = ((String)boundable.getItem()).getBytes(StandardCharsets.UTF_8);
        package$.MODULE$.RichStandardOutput(output).writeInt(bytes.length, ByteOrder.LITTLE_ENDIAN);
        output.write(bytes);
    }

    public void writeSTRtreeNode(StandardOutput output, AbstractNode node) {
        package$.MODULE$.RichStandardOutput(output).writeInt(node.getLevel(), ByteOrder.LITTLE_ENDIAN);
        List children = node.getChildBoundables();
        int childrenSize = children.size();
        package$.MODULE$.RichStandardOutput(output).writeInt(childrenSize, ByteOrder.LITTLE_ENDIAN);
        if (childrenSize > 0) {
            int limit$macro$4 = childrenSize;
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                BoxedUnit boxedUnit;
                Object e = children.get(index$macro$2);
                if (e instanceof AbstractNode) {
                    AbstractNode abstractNode = (AbstractNode)e;
                    output.write(0);
                    this.writeSTRtreeNode(output, abstractNode);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (e instanceof ItemBoundable) {
                    ItemBoundable itemBoundable = (ItemBoundable)e;
                    output.write(1);
                    this.writeItemBoundable(output, itemBoundable);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                String x$1 = new StringBuilder(10).append("\u4e0d\u652f\u6301\u5f53\u524d\u8282\u70b9\u7c7b\u578b:").append(e.getClass().getSimpleName()).toString();
                Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                throw new NotSupportException(x$1, x$2, x$3);
            }
        }
    }

    public STRtreePartitionVectorIndex<Object> deSerializableSTRtree(StandardInput input) {
        STRtreePartitionVectorIndex index;
        block3: {
            boolean built;
            int nodeCapacity = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
            boolean notEmpty = (package$.MODULE$.RichStandardInput(input).readByte(ByteOrder.LITTLE_ENDIAN) & 1) == 1;
            index = new STRtreePartitionVectorIndex();
            index.strTree_$eq(new STRtree(nodeCapacity));
            if (!notEmpty) break block3;
            boolean bl = built = (package$.MODULE$.RichStandardInput(input).readByte(ByteOrder.LITTLE_ENDIAN) & 1) == 1;
            if (built) {
                index.strTree().setBuilt(Predef$.MODULE$.boolean2Boolean(true));
                index.strTree().setItemBoundables(null);
                index.strTree().setRoot((AbstractNode)this.readSTRtreeNode(input));
            } else {
                ArrayList<ItemBoundable> itemBoundables = new ArrayList<ItemBoundable>();
                int itemSize = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
                int limit$macro$4 = itemSize;
                for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                    itemBoundables.add(this.readItemBoundable(input));
                }
                index.strTree().setItemBoundables(itemBoundables);
            }
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public STRtree.STRtreeNode readSTRtreeNode(StandardInput input) {
        void var3_3;
        int level = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
        STRtree.STRtreeNode node = new STRtree.STRtreeNode(level);
        int childrenSize = package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN);
        ArrayList<Object> children = new ArrayList<Object>();
        if (childrenSize > 0) {
            int limit$macro$4 = childrenSize;
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                boolean isLeaf;
                boolean bl = isLeaf = (package$.MODULE$.RichStandardInput(input).readByte(ByteOrder.LITTLE_ENDIAN) & 1) == 1;
                if (isLeaf) {
                    children.add(this.readItemBoundable(input));
                    continue;
                }
                children.add(this.readSTRtreeNode(input));
            }
        }
        node.setChildBoundables(children);
        return var3_3;
    }

    public ItemBoundable readItemBoundable(StandardInput input) {
        Envelope envelope = EnvelopeSerializer$.MODULE$.readEnvelope(input);
        byte[] bytes = new byte[package$.MODULE$.RichStandardInput(input).readInt(ByteOrder.LITTLE_ENDIAN)];
        input.read(bytes);
        return new ItemBoundable((Object)envelope, (Object)new String(bytes, StandardCharsets.UTF_8));
    }

    private STRtreeIndexSerializer$() {
        MODULE$ = this;
    }
}

