/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.serialization.esri.shapefile;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.io.StandardOutput;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.serialization.common.GeometrySerializer;
import com.geoway.atlas.data.vector.serialization.common.GeometrySerializer$;
import com.geoway.atlas.data.vector.serialization.common.GeometryType$;
import com.geoway.atlas.data.vector.serialization.esri.shapefile.ShpGeometrySerializer$;
import java.io.Serializable;
import java.nio.ByteOrder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\n\u0015\u0001\u0015BQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005B]BQa\u0013\u0001\u0005\n1CQA\u0014\u0001\u0005\n=CQA\u0015\u0001\u0005\nMCQA\u0016\u0001\u0005\n]CQA\u0017\u0001\u0005BmCQa\u001c\u0001\u0005\u0002ADQa\u001e\u0001\u0005\u0002aDQ! \u0001\u0005\u0002yDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\b\u000f\u0005uB\u0003#\u0001\u0002@\u001911\u0003\u0006E\u0001\u0003\u0003BaA\r\b\u0005\u0002\u0005\r\u0003\"CA#\u001d\t\u0007I\u0011AA$\u0011!\tIE\u0004Q\u0001\n\u0005]\u0002bBA&\u001d\u0011\u0005\u0011Q\n\u0002\u0016'\"\u0004x)Z8nKR\u0014\u0018pU3sS\u0006d\u0017N_3s\u0015\t)b#A\u0005tQ\u0006\u0004XMZ5mK*\u0011q\u0003G\u0001\u0005KN\u0014\u0018N\u0003\u0002\u001a5\u0005i1/\u001a:jC2L'0\u0019;j_:T!a\u0007\u000f\u0002\rY,7\r^8s\u0015\tib$\u0001\u0003eCR\f'BA\u0010!\u0003\u0015\tG\u000f\\1t\u0015\t\t#%\u0001\u0004hK><\u0018-\u001f\u0006\u0002G\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\ti\u0003'D\u0001/\u0015\ty\u0003$\u0001\u0004d_6lwN\\\u0005\u0003c9\u0012!cR3p[\u0016$(/_*fe&\fG.\u001b>fe\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003k\u0001i\u0011\u0001F\u0001\nO\u0016$H*\u001a8hi\"$2\u0001O\u001e>!\t9\u0013(\u0003\u0002;Q\t\u0019\u0011J\u001c;\t\u000bq\u0012\u0001\u0019\u0001\u001d\u0002\u0019\u001d,w.\\3uef$\u0016\u0010]3\t\u000by\u0012\u0001\u0019A \u0002\u0011\u001d,w.\\3uef\u0004\"\u0001Q%\u000e\u0003\u0005S!AQ\"\u0002\t\u001d,w.\u001c\u0006\u0003\t\u0016\u000b1A\u001b;t\u0015\t1u)\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\u0006\u0013\u0001bR3p[\u0016$(/_\u0001\u000fO\u0016$\bk\\5oi2+gn\u001a;i)\tAT\nC\u0003=\u0007\u0001\u0007\u0001(A\nhKRlU\u000f\u001c;j!>Lg\u000e\u001e'f]\u001e$\b\u000eF\u00029!FCQA\u0010\u0003A\u0002}BQ\u0001\u0010\u0003A\u0002a\nQbZ3u\u0019&tW\rT3oORDGc\u0001\u001dU+\")a(\u0002a\u0001\u007f!)A(\u0002a\u0001q\u0005\u0001r-\u001a;Q_2Lxm\u001c8MK:<G\u000f\u001b\u000b\u0004qaK\u0006\"\u0002 \u0007\u0001\u0004y\u0004\"\u0002\u001f\u0007\u0001\u0004A\u0014AC:fe&\fG.\u001b>feR)Al\u00185jUB\u0011q%X\u0005\u0003=\"\u0012A!\u00168ji\")\u0001m\u0002a\u0001C\u0006q1\u000f^1oI\u0006\u0014HmT;uaV$\bC\u00012g\u001b\u0005\u0019'B\u00013f\u0003\tIwN\u0003\u00020=%\u0011qm\u0019\u0002\u000f'R\fg\u000eZ1sI>+H\u000f];u\u0011\u0015at\u00011\u00019\u0011\u0015qt\u00011\u0001@\u0011\u0015Yw\u00011\u0001m\u0003\t9g\r\u0005\u0002A[&\u0011a.\u0011\u0002\u0010\u000f\u0016|W.\u001a;ss\u001a\u000b7\r^8ss\u0006QqO]5uKB{\u0017N\u001c;\u0015\u000bq\u000b(o];\t\u000byB\u0001\u0019A \t\u000bqB\u0001\u0019\u0001\u001d\t\u000bQD\u0001\u0019A1\u0002\r=,H\u000f];u\u0011\u00151\b\u00021\u0001m\u0003\u001d1\u0017m\u0019;pef\fqb\u001e:ji\u0016d\u0015N\\3TiJLgn\u001a\u000b\u00069fT8\u0010 \u0005\u0006}%\u0001\ra\u0010\u0005\u0006y%\u0001\r\u0001\u000f\u0005\u0006i&\u0001\r!\u0019\u0005\u0006m&\u0001\r\u0001\\\u0001\roJLG/\u001a)pYf<wN\u001c\u000b\t9~\f\t!a\u0001\u0002\u0006!)aH\u0003a\u0001\u007f!)AH\u0003a\u0001q!)AO\u0003a\u0001C\")aO\u0003a\u0001Y\u0006yqO]5uK6+H\u000e^5Q_&tG\u000fF\u0005]\u0003\u0017\ti!a\u0004\u0002\u0012!)ah\u0003a\u0001\u007f!)Ah\u0003a\u0001q!)Ao\u0003a\u0001C\")ao\u0003a\u0001Y\u0006Q1-\u00198Qe>\u001cWm]:\u0015\t\u0005]\u0011Q\u0004\t\u0004O\u0005e\u0011bAA\u000eQ\t9!i\\8mK\u0006t\u0007bBA\u0010\u0019\u0001\u0007\u0011\u0011E\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0011\u0005\r\u0012\u0011GA\u001c\u0003oqA!!\n\u0002.A\u0019\u0011q\u0005\u0015\u000e\u0005\u0005%\"bAA\u0016I\u00051AH]8pizJ1!a\f)\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\ri\u0015\r\u001d\u0006\u0004\u0003_A\u0003\u0003BA\u0012\u0003sIA!a\u000f\u00026\t11\u000b\u001e:j]\u001e\fQc\u00155q\u000f\u0016|W.\u001a;ssN+'/[1mSj,'\u000f\u0005\u00026\u001dM\u0011aB\n\u000b\u0003\u0003\u007f\t1a\u0015%Q+\t\t9$\u0001\u0003T\u0011B\u0003\u0013a\u0002>NS:l\u0015\r\u001f\u000b\u00069\u0006=\u0013\u0011\f\u0005\b\u0003#\u0012\u0002\u0019AA*\u0003\t\u00197\u000fE\u0002A\u0003+J1!a\u0016B\u0005I\u0019un\u001c:eS:\fG/Z*fcV,gnY3\t\u000f\u0005m#\u00031\u0001\u0002^\u00051A/\u0019:hKR\u0004RaJA0\u0003GJ1!!\u0019)\u0005\u0015\t%O]1z!\r9\u0013QM\u0005\u0004\u0003OB#A\u0002#pk\ndW\r")
public class ShpGeometrySerializer
implements GeometrySerializer {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static void zMinMax(CoordinateSequence coordinateSequence, double[] dArray) {
        ShpGeometrySerializer$.MODULE$.zMinMax(coordinateSequence, dArray);
    }

    public static String SHP() {
        return ShpGeometrySerializer$.MODULE$.SHP();
    }

    private Logger logger$lzycompute() {
        ShpGeometrySerializer shpGeometrySerializer = this;
        synchronized (shpGeometrySerializer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public int getLength(int geometryType, Geometry geometry) {
        int n;
        int n2 = geometryType;
        if (GeometryType$.MODULE$.NULL() == n2) {
            n = 2;
        } else {
            boolean bl = GeometryType$.MODULE$.POINT() == n2 ? true : (GeometryType$.MODULE$.POINTM() == n2 ? true : GeometryType$.MODULE$.POINTZM() == n2);
            if (bl) {
                n = this.getPointLength(geometryType);
            } else {
                boolean bl2 = GeometryType$.MODULE$.ARC() == n2 ? true : (GeometryType$.MODULE$.ARCM() == n2 ? true : GeometryType$.MODULE$.ARCZM() == n2);
                if (bl2) {
                    n = this.getLineLength(geometry, geometryType);
                } else {
                    boolean bl3 = GeometryType$.MODULE$.POLYGON() == n2 ? true : (GeometryType$.MODULE$.POLYGONM() == n2 ? true : GeometryType$.MODULE$.POLYGONZM() == n2);
                    if (bl3) {
                        n = this.getPolygonLength(geometry, geometryType);
                    } else {
                        boolean bl4 = GeometryType$.MODULE$.MULTIPOINT() == n2 ? true : (GeometryType$.MODULE$.MULTIPOINTM() == n2 ? true : GeometryType$.MODULE$.MULTIPOINTZM() == n2);
                        if (bl4) {
                            n = this.getMultiPointLength(geometry, geometryType);
                        } else {
                            String x$1 = "\u4e0d\u671f\u671b\u7684\u56fe\u5f62\u7c7b\u578b";
                            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                            throw new NotSupportException(x$1, x$2, x$3);
                        }
                    }
                }
            }
        }
        return n;
    }

    private int getPointLength(int geometryType) {
        int n;
        int n2 = geometryType;
        if (GeometryType$.MODULE$.POINT() == n2) {
            n = 20;
        } else if (GeometryType$.MODULE$.POINTM() == n2) {
            n = 28;
        } else if (GeometryType$.MODULE$.POINTZM() == n2) {
            n = 36;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
        }
        return n;
    }

    private int getMultiPointLength(Geometry geometry, int geometryType) {
        int n;
        int n2 = geometryType;
        if (GeometryType$.MODULE$.MULTIPOINT() == n2) {
            n = geometry.getNumGeometries() * 16 + 40;
        } else if (GeometryType$.MODULE$.MULTIPOINTM() == n2) {
            n = geometry.getNumGeometries() * 16 + 40 + 16 + 8 * geometry.getNumGeometries();
        } else if (GeometryType$.MODULE$.MULTIPOINTZM() == n2) {
            n = geometry.getNumGeometries() * 16 + 40 + 16 + 8 * geometry.getNumGeometries() + 16 + 8 * geometry.getNumGeometries();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
        }
        return n;
    }

    private int getLineLength(Geometry geometry, int geometryType) {
        int n;
        int numLines = geometry.getNumGeometries();
        int numPoints = geometry.getNumPoints();
        int n2 = geometryType;
        if (GeometryType$.MODULE$.ARC() == n2) {
            n = 44 + 4 * numLines + numPoints * 16;
        } else if (GeometryType$.MODULE$.ARCM() == n2) {
            n = 44 + 4 * numLines + numPoints * 16 + 8 + 8 + 8 * numPoints;
        } else if (GeometryType$.MODULE$.ARCZM() == n2) {
            n = 44 + 4 * numLines + numPoints * 16 + 8 + 8 + 8 * numPoints + 8 + 8 + 8 * numPoints;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
        }
        return n;
    }

    private int getPolygonLength(Geometry geometry, int geometryType) {
        int n;
        BoxedUnit boxedUnit;
        MultiPolygon multi = null;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof MultiPolygon) {
            MultiPolygon multiPolygon;
            multi = multiPolygon = (MultiPolygon)geometry2;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            multi = geometry.getFactory().createMultiPolygon((Polygon[])((Object[])new Polygon[]{(Polygon)geometry}));
            boxedUnit = BoxedUnit.UNIT;
        }
        int nRings = 0;
        for (int index$macro$1 = 0; index$macro$1 < multi.getNumGeometries(); ++index$macro$1) {
            Polygon p = (Polygon)multi.getGeometryN(index$macro$1);
            nRings = nRings + 1 + p.getNumInteriorRing();
        }
        int nPoints = multi.getNumPoints();
        int n2 = geometryType;
        if (GeometryType$.MODULE$.POLYGONZM() == n2) {
            n = 44 + 4 * nRings + 16 * nPoints + 8 * nPoints + 16 + 8 * nPoints + 16;
        } else if (GeometryType$.MODULE$.POLYGONM() == n2) {
            n = 44 + 4 * nRings + 16 * nPoints + 8 * nPoints + 16;
        } else if (GeometryType$.MODULE$.POLYGON() == n2) {
            n = 44 + 4 * nRings + 16 * nPoints;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
        }
        return n;
    }

    public void serializer(StandardOutput standardOutput, int geometryType, Geometry geometry, GeometryFactory gf) {
        int n = geometryType;
        if (GeometryType$.MODULE$.NULL() == n) {
            this.logger().warn("\u5199\u5165\u7a7a\u56fe\u6591");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = GeometryType$.MODULE$.POINT() == n ? true : (GeometryType$.MODULE$.POINTM() == n ? true : GeometryType$.MODULE$.POINTZM() == n);
            if (bl) {
                this.writePoint(geometry, geometryType, standardOutput, gf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = GeometryType$.MODULE$.ARC() == n ? true : (GeometryType$.MODULE$.ARCM() == n ? true : GeometryType$.MODULE$.ARCZM() == n);
                if (bl2) {
                    this.writeLineString(geometry, geometryType, standardOutput, gf);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl3 = GeometryType$.MODULE$.POLYGON() == n ? true : (GeometryType$.MODULE$.POLYGONM() == n ? true : GeometryType$.MODULE$.POLYGONZM() == n);
                    if (bl3) {
                        this.writePolygon(geometry, geometryType, standardOutput, gf);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean bl4 = GeometryType$.MODULE$.MULTIPOINT() == n ? true : (GeometryType$.MODULE$.MULTIPOINTM() == n ? true : GeometryType$.MODULE$.MULTIPOINTZM() == n);
                        if (bl4) {
                            this.writeMultiPoint(geometry, geometryType, standardOutput, gf);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String x$1 = "\u4e0d\u671f\u671b\u7684\u56fe\u5f62\u7c7b\u578b";
                            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                            throw new NotSupportException(x$1, x$2, x$3);
                        }
                    }
                }
            }
        }
    }

    public void writePoint(Geometry geometry, int geometryType, StandardOutput output, GeometryFactory factory) {
        block3: {
            Point point = (Point)geometry;
            Coordinate c = point.getCoordinate();
            package$.MODULE$.RichStandardOutput(output).writeDouble(c.x, ByteOrder.LITTLE_ENDIAN);
            package$.MODULE$.RichStandardOutput(output).writeDouble(c.y, ByteOrder.LITTLE_ENDIAN);
            if (geometryType == GeometryType$.MODULE$.POINTZM()) {
                if (Double.isNaN(c.getZ())) {
                    package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                } else {
                    package$.MODULE$.RichStandardOutput(output).writeDouble(c.getZ(), ByteOrder.LITTLE_ENDIAN);
                }
            }
            if (geometryType != GeometryType$.MODULE$.POINTZM() && geometryType != GeometryType$.MODULE$.POINTM()) break block3;
            double m = point.getCoordinateSequence().getM(0);
            package$.MODULE$.RichStandardOutput(output).writeDouble(Double.isNaN(m) ? 0.0 : m, ByteOrder.LITTLE_ENDIAN);
        }
    }

    public void writeLineString(Geometry geometry, int geometryType, StandardOutput output, GeometryFactory factory) {
        MultiLineString multi = (MultiLineString)geometry;
        Envelope box = multi.getEnvelopeInternal();
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMinX(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMinY(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMaxX(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMaxY(), ByteOrder.LITTLE_ENDIAN);
        int numParts = multi.getNumGeometries();
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        int nPoints = multi.getNumPoints();
        package$.MODULE$.RichStandardOutput(output).writeInt(numParts, ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeInt(nPoints, ByteOrder.LITTLE_ENDIAN);
        int idx = 0;
        for (int index$macro$1 = 0; index$macro$1 < numParts; ++index$macro$1) {
            lines[index$macro$1] = ((LineString)multi.getGeometryN(index$macro$1)).getCoordinateSequence();
            package$.MODULE$.RichStandardOutput(output).writeInt(idx, ByteOrder.LITTLE_ENDIAN);
            idx += lines[index$macro$1].size();
        }
        for (int index$macro$3 = 0; index$macro$3 < lines.length; ++index$macro$3) {
            CoordinateSequence coords = lines[index$macro$3];
            if (geometryType == GeometryType$.MODULE$.ARCZM()) {
                ShpGeometrySerializer$.MODULE$.zMinMax(coords, zExtreame);
            }
            int nCoords = coords.size();
            for (int index$macro$2 = 0; index$macro$2 < nCoords; ++index$macro$2) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(coords.getX(index$macro$2), ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(coords.getY(index$macro$2), ByteOrder.LITTLE_ENDIAN);
            }
        }
        if (geometryType == GeometryType$.MODULE$.ARCZM()) {
            if (Double.isNaN(zExtreame[0])) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
            } else {
                package$.MODULE$.RichStandardOutput(output).writeDouble(zExtreame[0], ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(zExtreame[1], ByteOrder.LITTLE_ENDIAN);
            }
            for (int index$macro$5 = 0; index$macro$5 < lines.length; ++index$macro$5) {
                CoordinateSequence coords = lines[index$macro$5];
                int nCoords = coords.size();
                double z = -1.0;
                for (int index$macro$4 = 0; index$macro$4 < nCoords; ++index$macro$4) {
                    z = coords.getOrdinate(index$macro$4, 2);
                    if (Double.isNaN(z)) {
                        package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                        continue;
                    }
                    package$.MODULE$.RichStandardOutput(output).writeDouble(z, ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
        if (geometryType == GeometryType$.MODULE$.ARCZM() || geometryType == GeometryType$.MODULE$.ARCM()) {
            Buffer mValues = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            int tt = multi.getNumGeometries();
            for (int index$macro$7 = 0; index$macro$7 < tt; ++index$macro$7) {
                LineString line = (LineString)multi.getGeometryN(index$macro$7);
                CoordinateSequence seq = line.getCoordinateSequence();
                for (int index$macro$6 = 0; index$macro$6 < seq.size(); ++index$macro$6) {
                    mValues.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{line.getCoordinateSequence().getM(index$macro$6)}));
                }
            }
            package$.MODULE$.RichStandardOutput(output).writeDouble(BoxesRunTime.unboxToDouble((Object)mValues.min((Ordering)Ordering.Double$.MODULE$)), ByteOrder.LITTLE_ENDIAN);
            package$.MODULE$.RichStandardOutput(output).writeDouble(BoxesRunTime.unboxToDouble((Object)mValues.max((Ordering)Ordering.Double$.MODULE$)), ByteOrder.LITTLE_ENDIAN);
            int nMValues = mValues.size();
            for (int index$macro$8 = 0; index$macro$8 < nMValues; ++index$macro$8) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(BoxesRunTime.unboxToDouble((Object)mValues.apply(index$macro$8)), ByteOrder.LITTLE_ENDIAN);
            }
        }
    }

    public void writePolygon(Geometry geometry, int geometryType, StandardOutput output, GeometryFactory factory) {
        BoxedUnit boxedUnit;
        MultiPolygon multi = null;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof MultiPolygon) {
            MultiPolygon multiPolygon;
            multi = multiPolygon = (MultiPolygon)geometry2;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            multi = factory.createMultiPolygon((Polygon[])((Object[])new Polygon[]{(Polygon)geometry}));
            boxedUnit = BoxedUnit.UNIT;
        }
        Envelope box = multi.getEnvelopeInternal();
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMinX(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMinY(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMaxX(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMaxY(), ByteOrder.LITTLE_ENDIAN);
        Buffer allCoords = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int index$macro$2 = 0; index$macro$2 < multi.getNumGeometries(); ++index$macro$2) {
            Polygon p = (Polygon)multi.getGeometryN(index$macro$2);
            allCoords.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoordinateSequence[]{p.getExteriorRing().getCoordinateSequence()}));
            for (int index$macro$1 = 0; index$macro$1 < p.getNumInteriorRing(); ++index$macro$1) {
                allCoords.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoordinateSequence[]{p.getInteriorRingN(index$macro$1).getCoordinateSequence()}));
            }
        }
        CoordinateSequence[] coordinates = (CoordinateSequence[])allCoords.toArray(ClassTag$.MODULE$.apply(CoordinateSequence.class));
        int nRings = coordinates.length;
        int nPoints = multi.getNumPoints();
        package$.MODULE$.RichStandardOutput(output).writeInt(nRings, ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeInt(nPoints, ByteOrder.LITTLE_ENDIAN);
        int count = 0;
        for (int index$macro$3 = 0; index$macro$3 < nRings; ++index$macro$3) {
            package$.MODULE$.RichStandardOutput(output).writeInt(count, ByteOrder.LITTLE_ENDIAN);
            count += coordinates[index$macro$3].size();
        }
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        for (int index$macro$5 = 0; index$macro$5 < nRings; ++index$macro$5) {
            CoordinateSequence coords = coordinates[index$macro$5];
            ShpGeometrySerializer$.MODULE$.zMinMax(coords, zExtreame);
            int seqSize = coords.size();
            for (int index$macro$4 = 0; index$macro$4 < seqSize; ++index$macro$4) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(coords.getOrdinate(index$macro$4, 0), ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(coords.getOrdinate(index$macro$4, 1), ByteOrder.LITTLE_ENDIAN);
            }
        }
        if (geometryType == GeometryType$.MODULE$.POLYGONZM()) {
            if (Double.isNaN(zExtreame[0])) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
            } else {
                package$.MODULE$.RichStandardOutput(output).writeDouble(zExtreame[0], ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(zExtreame[1], ByteOrder.LITTLE_ENDIAN);
            }
            for (int index$macro$7 = 0; index$macro$7 < nRings; ++index$macro$7) {
                CoordinateSequence coords = coordinates[index$macro$7];
                int seqSize = coords.size();
                double z = -1.0;
                for (int index$macro$6 = 0; index$macro$6 < seqSize; ++index$macro$6) {
                    z = coords.getOrdinate(index$macro$6, 2);
                    if (Double.isNaN(z)) {
                        package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                        continue;
                    }
                    package$.MODULE$.RichStandardOutput(output).writeDouble(z, ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
        if (geometryType == GeometryType$.MODULE$.POLYGONM() || geometryType == GeometryType$.MODULE$.POLYGONZM()) {
            Buffer values = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            for (int index$macro$9 = 0; index$macro$9 < nRings; ++index$macro$9) {
                CoordinateSequence coords = coordinates[index$macro$9];
                int seqSize = coords.size();
                for (int index$macro$8 = 0; index$macro$8 < seqSize; ++index$macro$8) {
                    values.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{coords.getM(index$macro$8)}));
                }
            }
            double mMin = BoxesRunTime.unboxToDouble((Object)values.min((Ordering)Ordering.Double$.MODULE$));
            package$.MODULE$.RichStandardOutput(output).writeDouble(!Double.isNaN(mMin) ? mMin : -1.0E41, ByteOrder.LITTLE_ENDIAN);
            double mMax = BoxesRunTime.unboxToDouble((Object)values.max((Ordering)Ordering.Double$.MODULE$));
            package$.MODULE$.RichStandardOutput(output).writeDouble(!Double.isNaN(mMax) ? mMax : -1.0E41, ByteOrder.LITTLE_ENDIAN);
            int nValues = values.size();
            for (int index$macro$10 = 0; index$macro$10 < nValues; ++index$macro$10) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(Double.isNaN(mMax) ? -1.0E41 : BoxesRunTime.unboxToDouble((Object)values.apply(index$macro$10)), ByteOrder.LITTLE_ENDIAN);
            }
        }
    }

    public void writeMultiPoint(Geometry geometry, int geometryType, StandardOutput output, GeometryFactory factory) {
        MultiPoint mp = (MultiPoint)geometry;
        Envelope box = mp.getEnvelopeInternal();
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMinX(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMinY(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMaxX(), ByteOrder.LITTLE_ENDIAN);
        package$.MODULE$.RichStandardOutput(output).writeDouble(box.getMaxY(), ByteOrder.LITTLE_ENDIAN);
        int numGeometries = mp.getNumGeometries();
        package$.MODULE$.RichStandardOutput(output).writeInt(numGeometries, ByteOrder.LITTLE_ENDIAN);
        for (int index$macro$1 = 0; index$macro$1 < numGeometries; ++index$macro$1) {
            Coordinate c = mp.getGeometryN(index$macro$1).getCoordinate();
            package$.MODULE$.RichStandardOutput(output).writeDouble(c.x, ByteOrder.LITTLE_ENDIAN);
            package$.MODULE$.RichStandardOutput(output).writeDouble(c.y, ByteOrder.LITTLE_ENDIAN);
        }
        if (geometryType == GeometryType$.MODULE$.MULTIPOINTZM()) {
            double[] result = new double[]{Double.NaN, Double.NaN};
            ShpGeometrySerializer$.MODULE$.zMinMax((CoordinateSequence)new CoordinateArraySequence(mp.getCoordinates()), result);
            double[] zExtreame = result;
            if (Double.isNaN(zExtreame[0])) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
            } else {
                package$.MODULE$.RichStandardOutput(output).writeDouble(zExtreame[0], ByteOrder.LITTLE_ENDIAN);
                package$.MODULE$.RichStandardOutput(output).writeDouble(zExtreame[1], ByteOrder.LITTLE_ENDIAN);
            }
            for (int index$macro$2 = 0; index$macro$2 < mp.getNumGeometries(); ++index$macro$2) {
                Coordinate c = mp.getGeometryN(index$macro$2).getCoordinate();
                double z = c.getZ();
                if (Double.isNaN(z)) {
                    package$.MODULE$.RichStandardOutput(output).writeDouble(0.0, ByteOrder.LITTLE_ENDIAN);
                    continue;
                }
                package$.MODULE$.RichStandardOutput(output).writeDouble(z, ByteOrder.LITTLE_ENDIAN);
            }
        }
        if (geometryType == GeometryType$.MODULE$.MULTIPOINTM() || geometryType == GeometryType$.MODULE$.MULTIPOINTZM()) {
            Buffer mvalues = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{numGeometries}));
            for (int index$macro$3 = 0; index$macro$3 < numGeometries; ++index$macro$3) {
                Point point = (Point)mp.getGeometryN(index$macro$3);
                mvalues.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{point.getCoordinateSequence().getM(0)}));
            }
            package$.MODULE$.RichStandardOutput(output).writeDouble(BoxesRunTime.unboxToDouble((Object)mvalues.min((Ordering)Ordering.Double$.MODULE$)), ByteOrder.LITTLE_ENDIAN);
            package$.MODULE$.RichStandardOutput(output).writeDouble(BoxesRunTime.unboxToDouble((Object)mvalues.max((Ordering)Ordering.Double$.MODULE$)), ByteOrder.LITTLE_ENDIAN);
            for (int index$macro$4 = 0; index$macro$4 < numGeometries; ++index$macro$4) {
                package$.MODULE$.RichStandardOutput(output).writeDouble(BoxesRunTime.unboxToDouble((Object)mvalues.apply(index$macro$4)), ByteOrder.LITTLE_ENDIAN);
            }
        }
    }

    public boolean canProcess(Map<String, String> params) {
        return params.get((Object)GeometrySerializer$.MODULE$.SERIALIZER()).exists((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)ShpGeometrySerializer.$anonfun$canProcess$1(x$47)));
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(String x$47) {
        return ShpGeometrySerializer$.MODULE$.SHP().equals(x$47);
    }

    public ShpGeometrySerializer() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

