/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.serialization.esri;

import com.geoway.atlas.common.config.AtlasSystemProperties;
import java.io.Serializable;
import org.locationtech.jts.algorithm.CCWFlag;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryUtils$;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.valid.IsValidOp;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class EsriDeserializerUtils$ {
    public static EsriDeserializerUtils$ MODULE$;
    private final boolean REPAIR_VECTOR;

    static {
        new EsriDeserializerUtils$();
    }

    private boolean REPAIR_VECTOR() {
        return this.REPAIR_VECTOR;
    }

    public Geometry createMultiPolygon(int numPoints, int numParts, int[] partOffsets, CoordinateSequence coords, int csDimension, int measures, Envelope envelope, GeometryFactory gf, Map<Object, Coordinate[]> curveInfo) {
        Buffer shells = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer holes = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef offset = IntRef.create((int)0);
        IntRef start = IntRef.create((int)-1);
        IntRef finish = IntRef.create((int)-1);
        int length = -1;
        boolean hasTopologyException = false;
        for (int index$macro$7 = 0; index$macro$7 < numParts; ++index$macro$7) {
            start.elem = partOffsets[index$macro$7];
            finish.elem = index$macro$7 == numParts - 1 ? numPoints : partOffsets[index$macro$7 + 1];
            length = finish.elem - start.elem;
            int close = 0;
            if (coords.getOrdinate(start.elem, 0) != coords.getOrdinate(finish.elem - 1, 0) || coords.getOrdinate(start.elem, 1) != coords.getOrdinate(finish.elem - 1, 1)) {
                close = 1;
            }
            if (coords.hasZ() && coords.getZ(start.elem) != coords.getZ(finish.elem - 1)) {
                close = 1;
            }
            Map insertMap = (Map)curveInfo.filter((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)EsriDeserializerUtils$.$anonfun$createMultiPolygon$1(finish, start, tuple)));
            Set insertIndexMap = insertMap.keySet();
            int curveInsertNum = BoxesRunTime.unboxToInt((Object)((TraversableOnce)insertMap.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)EsriDeserializerUtils$.$anonfun$createMultiPolygon$2(x$3)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            CoordinateArraySequence csRing = new CoordinateArraySequence(length + curveInsertNum + close, csDimension, measures);
            IntRef nIndex = IntRef.create((int)0);
            for (int index$macro$6 = 0; index$macro$6 < length; ++index$macro$6) {
                csRing.setOrdinate(nIndex.elem, 0, coords.getOrdinate(offset.elem, 0));
                csRing.setOrdinate(nIndex.elem, 1, coords.getOrdinate(offset.elem, 1));
                if (coords.hasZ()) {
                    csRing.getCoordinate(index$macro$6).setZ(coords.getZ(offset.elem));
                }
                if (coords.hasM()) {
                    csRing.getCoordinate(index$macro$6).setM(coords.getM(offset.elem));
                }
                if (insertIndexMap.contains((Object)BoxesRunTime.boxToInteger((int)offset.elem))) {
                    Coordinate[] insertCoords = (Coordinate[])insertMap.apply((Object)BoxesRunTime.boxToInteger((int)offset.elem));
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])insertCoords)).indices().foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> EsriDeserializerUtils$.$anonfun$createMultiPolygon$3(nIndex, (CoordinateSequence)csRing, insertCoords, coords, offset, arg_0)));
                }
                ++nIndex.elem;
                ++offset.elem;
            }
            if (close == 1) {
                csRing.setOrdinate(length + curveInsertNum, 0, coords.getOrdinate(start.elem, 0));
                csRing.setOrdinate(length + curveInsertNum, 1, coords.getOrdinate(start.elem, 1));
                if (csRing.hasZ()) {
                    csRing.getCoordinate(length + curveInsertNum).setZ(coords.getZ(start.elem));
                }
                if (csRing.hasM()) {
                    csRing.getCoordinate(length + curveInsertNum).setM(coords.getM(start.elem));
                }
            }
            if (csRing.size() != 0 && csRing.size() <= 3) continue;
            LinearRing ring = gf.createLinearRing((CoordinateSequence)csRing);
            CCWFlag ccwFlag = Orientation.isCCW_NG((CoordinateSequence)ring.getCoordinateSequence());
            if (ccwFlag.isHasTopologyException()) {
                hasTopologyException = true;
            }
            if (ccwFlag.isCCW()) {
                holes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{ring}));
                continue;
            }
            shells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{ring}));
        }
        Polygon geometry = null;
        if (shells.size() == 1) {
            geometry = gf.createPolygon((LinearRing)shells.head(), (LinearRing[])holes.toArray(ClassTag$.MODULE$.apply(LinearRing.class)));
        } else if (holes.nonEmpty() && shells.isEmpty()) {
            if (holes.size() == 1) {
                geometry = gf.createPolygon((LinearRing)holes.head(), (LinearRing[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LinearRing.class)));
            } else {
                Buffer<LinearRing>[] holesForShells = this.assignHolesToOneShells((Buffer<LinearRing>)shells, (Buffer<LinearRing>)holes);
                geometry = this.buildGeometries((Buffer<LinearRing>)shells, (Buffer<LinearRing>)holes, holesForShells, gf);
            }
        } else {
            Buffer<LinearRing>[] holesForShells = this.assignHolesToShells((Buffer<LinearRing>)shells, (Buffer<LinearRing>)holes);
            geometry = this.buildGeometries((Buffer<LinearRing>)shells, (Buffer<LinearRing>)holes, holesForShells, gf);
        }
        if (hasTopologyException) {
            if (!IsValidOp.isValid((Geometry)(geometry = GeometryFixer.fix((Geometry)geometry)))) {
                geometry = geometry.buffer(0.0);
            }
        } else if (this.REPAIR_VECTOR() && !IsValidOp.isValid((Geometry)geometry) && !IsValidOp.isValid((Geometry)(geometry = GeometryFixer.fix((Geometry)geometry)))) {
            geometry = geometry.buffer(0.0);
        }
        GeometryUtils$.MODULE$.RichGeometry((Geometry)geometry).setEnvelope(envelope);
        return geometry;
    }

    public Map<Object, Coordinate[]> createMultiPolygon$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public Geometry createMultiLineString(int numPoints, int numParts, int[] partOffsets, CoordinateSequence coords, int csDimension, int measures, Envelope envelope, GeometryFactory gf, Map<Object, Coordinate[]> curveInfo) {
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        IntRef offset = IntRef.create((int)0);
        IntRef finish = IntRef.create((int)0);
        IntRef start = IntRef.create((int)0);
        int length = 0;
        boolean clonePoint = false;
        for (int index$macro$7 = 0; index$macro$7 < numParts; ++index$macro$7) {
            start.elem = partOffsets[index$macro$7];
            finish.elem = index$macro$7 == numParts - 1 ? numPoints : partOffsets[index$macro$7 + 1];
            length = finish.elem - start.elem;
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            Map insertMap = (Map)curveInfo.filter((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)EsriDeserializerUtils$.$anonfun$createMultiLineString$1(finish, start, tuple)));
            Set insertIndexMap = insertMap.keySet();
            int curveInsertNum = BoxesRunTime.unboxToInt((Object)((TraversableOnce)insertMap.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)EsriDeserializerUtils$.$anonfun$createMultiLineString$2(x$8)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            CoordinateArraySequence csRing = new CoordinateArraySequence(length + curveInsertNum + (clonePoint ? 1 : 0), csDimension, measures);
            IntRef nIndex = IntRef.create((int)0);
            for (int index$macro$6 = 0; index$macro$6 < length; ++index$macro$6) {
                csRing.setOrdinate(nIndex.elem, 0, coords.getOrdinate(offset.elem, 0));
                csRing.setOrdinate(nIndex.elem, 1, coords.getOrdinate(offset.elem, 1));
                if (coords.hasZ()) {
                    csRing.getCoordinate(index$macro$6).setZ(coords.getZ(offset.elem));
                }
                if (coords.hasM()) {
                    csRing.getCoordinate(index$macro$6).setM(coords.getM(offset.elem));
                }
                if (insertIndexMap.contains((Object)BoxesRunTime.boxToInteger((int)offset.elem))) {
                    Coordinate[] insertCoords = (Coordinate[])insertMap.apply((Object)BoxesRunTime.boxToInteger((int)offset.elem));
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])insertCoords)).indices().foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> EsriDeserializerUtils$.$anonfun$createMultiLineString$3(nIndex, (CoordinateSequence)csRing, insertCoords, coords, offset, arg_0)));
                }
                ++nIndex.elem;
                ++offset.elem;
            }
            if (clonePoint) {
                csRing.setOrdinate(length + curveInsertNum, 0, coords.getOrdinate(start.elem, 0));
                csRing.setOrdinate(length + curveInsertNum, 1, coords.getOrdinate(start.elem, 1));
                if (csRing.hasZ()) {
                    csRing.getCoordinate(length + curveInsertNum).setZ(coords.getZ(start.elem));
                }
                if (csRing.hasM()) {
                    csRing.getCoordinate(length + curveInsertNum).setM(coords.getM(start.elem));
                }
            }
            lines[index$macro$7] = csRing;
        }
        LineString[] lineStrings = new LineString[numParts];
        for (int index$macro$8 = 0; index$macro$8 < numParts; ++index$macro$8) {
            lineStrings[index$macro$8] = gf.createLineString(lines[index$macro$8]);
        }
        MultiLineString geometry = gf.createMultiLineString(lineStrings);
        GeometryUtils$.MODULE$.RichGeometry((Geometry)geometry).setEnvelope(envelope);
        return geometry;
    }

    public Map<Object, Coordinate[]> createMultiLineString$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    private Buffer<LinearRing>[] assignHolesToOneShells(Buffer<LinearRing> shells, Buffer<LinearRing> holes) {
        LinearRing maxRing = (LinearRing)holes.head();
        int maxIndex = 0;
        for (int index$macro$1 = 1; index$macro$1 < holes.size(); ++index$macro$1) {
            LinearRing testRing = (LinearRing)holes.apply(index$macro$1);
            Envelope env = testRing.getEnvelopeInternal();
            if (!env.contains(maxRing.getEnvelopeInternal())) continue;
            maxRing = testRing;
            maxIndex = index$macro$1;
        }
        shells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{maxRing}));
        holes.remove(maxIndex);
        ArrayBuffer holesForShells = new ArrayBuffer();
        for (int index$macro$2 = 0; index$macro$2 < shells.length(); ++index$macro$2) {
            holesForShells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{(Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)}));
        }
        for (int index$macro$4 = 0; index$macro$4 < holes.length(); ++index$macro$4) {
            LinearRing testRing = (LinearRing)holes.apply(index$macro$4);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            LinearRing tryRing = null;
            for (int index$macro$3 = 0; index$macro$3 < shells.length(); ++index$macro$3) {
                tryRing = (LinearRing)shells.apply(index$macro$3);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (PointLocation.isInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                shells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{testRing}));
                holesForShells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{(Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)}));
                continue;
            }
            ((BufferLike)holesForShells.apply(shells.indexOf(minShell))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{testRing}));
        }
        return (Buffer[])holesForShells.toArray(ClassTag$.MODULE$.apply(Buffer.class));
    }

    private Buffer<LinearRing>[] assignHolesToShells(Buffer<LinearRing> shells, Buffer<LinearRing> holes) {
        ArrayBuffer holesForShells = new ArrayBuffer(shells.length());
        for (int index$macro$1 = 0; index$macro$1 < shells.length(); ++index$macro$1) {
            holesForShells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{new ArrayBuffer()}));
        }
        for (int index$macro$3 = 0; index$macro$3 < holes.length(); ++index$macro$3) {
            LinearRing testRing = (LinearRing)holes.apply(index$macro$3);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            LinearRing tryRing = null;
            for (int index$macro$2 = 0; index$macro$2 < shells.length(); ++index$macro$2) {
                tryRing = (LinearRing)shells.apply(index$macro$2);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (PointLocation.isInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                shells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{testRing}));
                holesForShells.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Buffer[]{new ArrayBuffer()}));
                continue;
            }
            ((BufferLike)holesForShells.apply(shells.indexOf(minShell))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LinearRing[]{testRing}));
        }
        return (Buffer[])holesForShells.toArray(ClassTag$.MODULE$.apply(Buffer.class));
    }

    private Geometry buildGeometries(Buffer<LinearRing> shells, Buffer<LinearRing> holes, Buffer<LinearRing>[] holesForShells, GeometryFactory gf) {
        Polygon[] polygons = null;
        polygons = shells.nonEmpty() ? new Polygon[shells.size()] : new Polygon[holes.size()];
        for (int index$macro$1 = 0; index$macro$1 < shells.length(); ++index$macro$1) {
            polygons[index$macro$1] = gf.createPolygon((LinearRing)shells.apply(index$macro$1), (LinearRing[])holesForShells[index$macro$1].toArray(ClassTag$.MODULE$.apply(LinearRing.class)));
        }
        if (shells.isEmpty()) {
            for (int index$macro$2 = 0; index$macro$2 < holes.length(); ++index$macro$2) {
                LinearRing hole = (LinearRing)holes.apply(index$macro$2);
                polygons[index$macro$2] = gf.createPolygon(hole, null);
            }
        }
        return gf.createMultiPolygon(polygons);
    }

    private boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        Coordinate p = null;
        int end$macro$3 = 0;
        for (int index$macro$2 = pointList.length - 1; index$macro$2 <= end$macro$3; ++index$macro$2) {
            p = pointList[index$macro$2];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && testPoint.z == testPoint.z) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createMultiPolygon$1(IntRef finish$1, IntRef start$1, Tuple2 tuple) {
        return tuple._1$mcI$sp() < finish$1.elem && tuple._1$mcI$sp() >= start$1.elem;
    }

    public static final /* synthetic */ int $anonfun$createMultiPolygon$2(Tuple2 x$3) {
        return ((Coordinate[])x$3._2()).length;
    }

    public static final /* synthetic */ void $anonfun$createMultiPolygon$3(IntRef nIndex$1, CoordinateSequence csRing$1, Coordinate[] insertCoords$1, CoordinateSequence coords$1, IntRef offset$1, int j) {
        block1: {
            ++nIndex$1.elem;
            csRing$1.setOrdinate(nIndex$1.elem, 0, insertCoords$1[j].x);
            csRing$1.setOrdinate(nIndex$1.elem, 1, insertCoords$1[j].y);
            if (coords$1.hasZ()) {
                csRing$1.setOrdinate(nIndex$1.elem, 2, coords$1.getZ(offset$1.elem));
            }
            if (!coords$1.hasM()) break block1;
            csRing$1.setOrdinate(nIndex$1.elem, 3, coords$1.getM(offset$1.elem));
        }
    }

    public static final /* synthetic */ boolean $anonfun$createMultiLineString$1(IntRef finish$2, IntRef start$2, Tuple2 tuple) {
        return tuple._1$mcI$sp() < finish$2.elem && tuple._1$mcI$sp() >= start$2.elem;
    }

    public static final /* synthetic */ int $anonfun$createMultiLineString$2(Tuple2 x$8) {
        return ((Coordinate[])x$8._2()).length;
    }

    public static final /* synthetic */ void $anonfun$createMultiLineString$3(IntRef nIndex$2, CoordinateSequence csRing$2, Coordinate[] insertCoords$2, CoordinateSequence coords$2, IntRef offset$2, int j) {
        block1: {
            ++nIndex$2.elem;
            csRing$2.setOrdinate(nIndex$2.elem, 0, insertCoords$2[j].x);
            csRing$2.setOrdinate(nIndex$2.elem, 1, insertCoords$2[j].y);
            if (coords$2.hasZ()) {
                csRing$2.setOrdinate(nIndex$2.elem, 2, coords$2.getZ(offset$2.elem));
            }
            if (!coords$2.hasM()) break block1;
            csRing$2.setOrdinate(nIndex$2.elem, 3, coords$2.getM(offset$2.elem));
        }
    }

    private EsriDeserializerUtils$() {
        MODULE$ = this;
        this.REPAIR_VECTOR = BoxesRunTime.unboxToBoolean((Object)new AtlasSystemProperties.SystemProperty("atlas.data.vector.repair", AtlasSystemProperties.SystemProperty$.MODULE$.apply$default$2()).toBoolean().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }
}

