/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.serialization.esri.shapefile;

import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.package;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.data.vector.serialization.common.GeometryDeserializer;
import com.geoway.atlas.data.vector.serialization.common.GeometryDeserializer$;
import com.geoway.atlas.data.vector.serialization.common.GeometryType$;
import com.geoway.atlas.data.vector.serialization.esri.EsriDeserializerUtils$;
import com.geoway.atlas.data.vector.serialization.esri.shapefile.ShpGeometryDeserializer$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryUtils$;
import org.locationtech.jts.geom.MultiPoint;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u000e\u001d\u00015BQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001A\u0002\u0013\u0005q\bC\u0004D\u0001\u0001\u0007I\u0011\u0001#\t\r)\u0003\u0001\u0015)\u0003A\u0011\u0015Q\u0004\u0001\"\u0001L\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015a\u0006\u0001\"\u0011~\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\u0006\u0001\t\u0003\t)\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005=\u0002\u0001\"\u0001\u0002<!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA#\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\tY\u0006\u0001C\u0001\u0003OBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002r\u0001!I!a\"\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005vaBAS9!\u0005\u0011q\u0015\u0004\u00077qA\t!!+\t\ri*B\u0011AAV\u0011%\ti+\u0006b\u0001\n\u0003\ty\u000bC\u0004\u00022V\u0001\u000b\u0011B-\t\u0013\u0005MVC1A\u0005\u0002\u0005=\u0006bBA[+\u0001\u0006I!\u0017\u0002\u0018'\"\u0004x)Z8nKR\u0014\u0018\u0010R3tKJL\u0017\r\\5{KJT!!\b\u0010\u0002\u0013MD\u0017\r]3gS2,'BA\u0010!\u0003\u0011)7O]5\u000b\u0005\u0005\u0012\u0013!D:fe&\fG.\u001b>bi&|gN\u0003\u0002$I\u00051a/Z2u_JT!!\n\u0014\u0002\t\u0011\fG/\u0019\u0006\u0003O!\nQ!\u0019;mCNT!!\u000b\u0016\u0002\r\u001d,wn^1z\u0015\u0005Y\u0013aA2p[\u000e\u00011c\u0001\u0001/iA\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0011\u0002\r\r|W.\\8o\u0013\tIdG\u0001\u000bHK>lW\r\u001e:z\t\u0016\u001cXM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"!\u0010\u0001\u000e\u0003q\ta\u0002\\1zKJ$\u0015.\\3og&|g.F\u0001A!\ty\u0013)\u0003\u0002Ca\t!!)\u001f;f\u0003Ia\u0017-_3s\t&lWM\\:j_:|F%Z9\u0015\u0005\u0015C\u0005CA\u0018G\u0013\t9\u0005G\u0001\u0003V]&$\bbB%\u0004\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0014a\u00047bs\u0016\u0014H)[7f]NLwN\u001c\u0011\u0015\u0005qb\u0005\"B'\u0006\u0001\u0004q\u0015A\u00029be\u0006l7\u000f\u0005\u0003P-fKfB\u0001)U!\t\t\u0006'D\u0001S\u0015\t\u0019F&\u0001\u0004=e>|GOP\u0005\u0003+B\na\u0001\u0015:fI\u00164\u0017BA,Y\u0005\ri\u0015\r\u001d\u0006\u0003+B\u0002\"a\u0014.\n\u0005mC&AB*ue&tw-\u0001\u0007eKN,'/[1mSj,'\u000f\u0006\u0003_UND\bCA0i\u001b\u0005\u0001'BA1c\u0003\u00119Wm\\7\u000b\u0005\r$\u0017a\u00016ug*\u0011QMZ\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002O\u0006\u0019qN]4\n\u0005%\u0004'\u0001C$f_6,GO]=\t\u000b-4\u0001\u0019\u00017\u0002\u001bM$\u0018M\u001c3be\u0012Le\u000e];u!\ti\u0017/D\u0001o\u0015\ty\u0007/\u0001\u0002j_*\u0011qGJ\u0005\u0003e:\u0014Qb\u0015;b]\u0012\f'\u000fZ%oaV$\b\"\u0002;\u0007\u0001\u0004)\u0018\u0001D4f_6,GO]=UsB,\u0007CA\u0018w\u0013\t9\bGA\u0002J]RDQ!\u001f\u0004A\u0002i\f!a\u001a4\u0011\u0005}[\u0018B\u0001?a\u0005=9Um\\7fiJLh)Y2u_JLHC\u00020\u007f\u0003#\t\u0019\u0002\u0003\u0004\u0000\u000f\u0001\u0007\u0011\u0011A\u0001\u000bEf$XMQ;gM\u0016\u0014\b\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0004]&|'BAA\u0006\u0003\u0011Q\u0017M^1\n\t\u0005=\u0011Q\u0001\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"\u0002;\b\u0001\u0004)\b\"B=\b\u0001\u0004Q\u0018A\u00039beN,\u0007k\\5oiRIa,!\u0007\u0002\u001c\u0005}\u00111\u0005\u0005\u0006W\"\u0001\r\u0001\u001c\u0005\u0007\u0003;A\u0001\u0019A;\u0002\u0017\r\u001cH)[7f]NLwN\u001c\u0005\u0007\u0003CA\u0001\u0019A;\u0002\u00115,\u0017m];sKNDQ!\u001f\u0005A\u0002i$\u0012BXA\u0014\u0003S\tY#!\f\t\r}L\u0001\u0019AA\u0001\u0011\u0019\ti\"\u0003a\u0001k\"1\u0011\u0011E\u0005A\u0002UDQ!_\u0005A\u0002i\f\u0001\u0003]1sg\u0016d\u0015N\\3IC:$G.\u001a:\u0015\u0013y\u000b\u0019$!\u000e\u00028\u0005e\u0002\"B6\u000b\u0001\u0004a\u0007BBA\u000f\u0015\u0001\u0007Q\u000f\u0003\u0004\u0002\")\u0001\r!\u001e\u0005\u0006s*\u0001\rA\u001f\u000b\n=\u0006u\u0012qHA!\u0003\u0007Baa`\u0006A\u0002\u0005\u0005\u0001BBA\u000f\u0017\u0001\u0007Q\u000f\u0003\u0004\u0002\"-\u0001\r!\u001e\u0005\u0006s.\u0001\rA_\u0001\u0014a\u0006\u00148/\u001a)pYf<wN\u001c%b]\u0012dWM\u001d\u000b\n=\u0006%\u00131JA'\u0003\u001fBQa\u001b\u0007A\u00021Da!!\b\r\u0001\u0004)\bBBA\u0011\u0019\u0001\u0007Q\u000fC\u0003z\u0019\u0001\u0007!\u0010F\u0005_\u0003'\n)&a\u0016\u0002Z!1q0\u0004a\u0001\u0003\u0003Aa!!\b\u000e\u0001\u0004)\bBBA\u0011\u001b\u0001\u0007Q\u000fC\u0003z\u001b\u0001\u0007!0A\bqCJ\u001cX-T;mi&\u0004v.\u001b8u)%q\u0016qLA1\u0003G\n)\u0007C\u0003l\u001d\u0001\u0007A\u000e\u0003\u0004\u0002\u001e9\u0001\r!\u001e\u0005\u0007\u0003Cq\u0001\u0019A;\t\u000bet\u0001\u0019\u0001>\u0015\u0013y\u000bI'a\u001b\u0002n\u0005=\u0004BB@\u0010\u0001\u0004\t\t\u0001\u0003\u0004\u0002\u001e=\u0001\r!\u001e\u0005\u0007\u0003Cy\u0001\u0019A;\t\u000be|\u0001\u0019\u0001>\u0002\u001fI,\u0017\rZ\"p_J$\u0017N\\1uKN$B\"!\u001e\u0002|\u0005u\u0014\u0011QAB\u0003\u000b\u00032aXA<\u0013\r\tI\b\u0019\u0002\u0013\u0007>|'\u000fZ5oCR,7+Z9vK:\u001cW\rC\u0003l!\u0001\u0007A\u000e\u0003\u0004\u0002\u0000A\u0001\r!^\u0001\n]Vl\u0007k\\5oiNDa!!\b\u0011\u0001\u0004)\bBBA\u0011!\u0001\u0007Q\u000fC\u0003z!\u0001\u0007!\u0010\u0006\u0007\u0002v\u0005%\u00151RAG\u0003\u001f\u000b\t\n\u0003\u0004\u0000#\u0001\u0007\u0011\u0011\u0001\u0005\u0007\u0003\u007f\n\u0002\u0019A;\t\r\u0005u\u0011\u00031\u0001v\u0011\u0019\t\t#\u0005a\u0001k\")\u00110\u0005a\u0001u\u0006Q1-\u00198Qe>\u001cWm]:\u0015\t\u0005]\u0015Q\u0014\t\u0004_\u0005e\u0015bAANa\t9!i\\8mK\u0006t\u0007\"B'\u0013\u0001\u0004q\u0015\u0001B5oSR$B!a&\u0002$\")Qj\u0005a\u0001\u001d\u000692\u000b\u001b9HK>lW\r\u001e:z\t\u0016\u001cXM]5bY&TXM\u001d\t\u0003{U\u0019\"!\u0006\u0018\u0015\u0005\u0005\u001d\u0016aA*I!V\t\u0011,\u0001\u0003T\u0011B\u0003\u0013a\u0004'B3\u0016\u0013v\fR%N\u000b:\u001b\u0016j\u0014(\u0002!1\u000b\u0015,\u0012*`\t&kUIT*J\u001f:\u0003\u0003")
public class ShpGeometryDeserializer
implements GeometryDeserializer {
    private byte layerDimension = (byte)2;

    public static String LAYER_DIMENSION() {
        return ShpGeometryDeserializer$.MODULE$.LAYER_DIMENSION();
    }

    public static String SHP() {
        return ShpGeometryDeserializer$.MODULE$.SHP();
    }

    public byte layerDimension() {
        return this.layerDimension;
    }

    public void layerDimension_$eq(byte x$1) {
        this.layerDimension = x$1;
    }

    public Geometry deserializer(StandardInput standardInput, int geometryType, GeometryFactory gf) {
        Geometry geometry;
        Tuple2 tuple2 = GeometryType$.MODULE$.getCSZM(geometryType);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte csDimension = BoxesRunTime.unboxToByte((Object)tuple2._1());
        byte measures = BoxesRunTime.unboxToByte((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)csDimension), (Object)BoxesRunTime.boxToByte((byte)measures));
        Tuple2 tuple23 = tuple22;
        byte csDimension2 = BoxesRunTime.unboxToByte((Object)tuple23._1());
        byte measures2 = BoxesRunTime.unboxToByte((Object)tuple23._2());
        int n = geometryType;
        if (GeometryType$.MODULE$.NULL() == n) {
            geometry = gf.createEmpty((int)this.layerDimension());
        } else {
            boolean bl = GeometryType$.MODULE$.POINT() == n ? true : (GeometryType$.MODULE$.POINTM() == n ? true : GeometryType$.MODULE$.POINTZM() == n);
            if (bl) {
                geometry = this.parsePoint(standardInput, (int)csDimension2, (int)measures2, gf);
            } else {
                boolean bl2 = GeometryType$.MODULE$.ARC() == n ? true : (GeometryType$.MODULE$.ARCM() == n ? true : GeometryType$.MODULE$.ARCZM() == n);
                if (bl2) {
                    geometry = this.parseLineHandler(standardInput, (int)csDimension2, (int)measures2, gf);
                } else {
                    boolean bl3 = GeometryType$.MODULE$.POLYGON() == n ? true : (GeometryType$.MODULE$.POLYGONM() == n ? true : GeometryType$.MODULE$.POLYGONZM() == n);
                    if (bl3) {
                        geometry = this.parsePolygonHandler(standardInput, (int)csDimension2, (int)measures2, gf);
                    } else {
                        boolean bl4 = GeometryType$.MODULE$.MULTIPOINT() == n ? true : (GeometryType$.MODULE$.MULTIPOINTM() == n ? true : GeometryType$.MODULE$.MULTIPOINTZM() == n);
                        if (bl4) {
                            geometry = this.parseMultiPoint(standardInput, (int)csDimension2, (int)measures2, gf);
                        } else {
                            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u7684\u56fe\u6591\u7c7b\u578b:").append(geometryType).toString();
                            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                            throw new NotSupportException(x$1, x$2, x$3);
                        }
                    }
                }
            }
        }
        return geometry;
    }

    public Geometry deserializer(ByteBuffer byteBuffer, int geometryType, GeometryFactory gf) {
        Geometry geometry;
        Tuple2 tuple2 = GeometryType$.MODULE$.getCSZM(geometryType);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte csDimension = BoxesRunTime.unboxToByte((Object)tuple2._1());
        byte measures = BoxesRunTime.unboxToByte((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)csDimension), (Object)BoxesRunTime.boxToByte((byte)measures));
        Tuple2 tuple23 = tuple22;
        byte csDimension2 = BoxesRunTime.unboxToByte((Object)tuple23._1());
        byte measures2 = BoxesRunTime.unboxToByte((Object)tuple23._2());
        int n = geometryType;
        if (GeometryType$.MODULE$.NULL() == n) {
            geometry = gf.createEmpty((int)this.layerDimension());
        } else {
            boolean bl = GeometryType$.MODULE$.POINT() == n ? true : (GeometryType$.MODULE$.POINTM() == n ? true : GeometryType$.MODULE$.POINTZM() == n);
            if (bl) {
                geometry = this.parsePoint(byteBuffer, (int)csDimension2, (int)measures2, gf);
            } else {
                boolean bl2 = GeometryType$.MODULE$.ARC() == n ? true : (GeometryType$.MODULE$.ARCM() == n ? true : GeometryType$.MODULE$.ARCZM() == n);
                if (bl2) {
                    geometry = this.parseLineHandler(byteBuffer, (int)csDimension2, (int)measures2, gf);
                } else {
                    boolean bl3 = GeometryType$.MODULE$.POLYGON() == n ? true : (GeometryType$.MODULE$.POLYGONM() == n ? true : GeometryType$.MODULE$.POLYGONZM() == n);
                    if (bl3) {
                        geometry = this.parsePolygonHandler(byteBuffer, (int)csDimension2, (int)measures2, gf);
                    } else {
                        boolean bl4 = GeometryType$.MODULE$.MULTIPOINT() == n ? true : (GeometryType$.MODULE$.MULTIPOINTM() == n ? true : GeometryType$.MODULE$.MULTIPOINTZM() == n);
                        if (bl4) {
                            geometry = this.parseMultiPoint(byteBuffer, (int)csDimension2, (int)measures2, gf);
                        } else {
                            String x$1 = new StringBuilder(9).append("\u4e0d\u652f\u6301\u7684\u56fe\u6591\u7c7b\u578b:").append(geometryType).toString();
                            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                            throw new NotSupportException(x$1, x$2, x$3);
                        }
                    }
                }
            }
        }
        return geometry;
    }

    public Geometry parsePoint(StandardInput standardInput, int csDimension, int measures, GeometryFactory gf) {
        Coordinate cs;
        block1: {
            cs = Coordinates.create((int)csDimension, (int)measures);
            cs.setX(package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN));
            cs.setY(package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN));
            if (csDimension == 3 && measures == 0 || csDimension == 4) {
                cs.setZ(package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN));
            }
            if (measures != 1) break block1;
            cs.setM(package$.MODULE$.RichStandardInput(standardInput).readDouble(ByteOrder.LITTLE_ENDIAN));
        }
        return gf.createPoint(cs);
    }

    public Geometry parsePoint(ByteBuffer byteBuffer, int csDimension, int measures, GeometryFactory gf) {
        Coordinate cs;
        block1: {
            cs = Coordinates.create((int)csDimension, (int)measures);
            cs.setX(byteBuffer.getDouble());
            cs.setY(byteBuffer.getDouble());
            if (csDimension == 3 && measures == 0 || csDimension == 4) {
                cs.setZ(byteBuffer.getDouble());
            }
            if (measures != 1) break block1;
            cs.setM(byteBuffer.getDouble());
        }
        return gf.createPoint(cs);
    }

    public Geometry parseLineHandler(StandardInput standardInput, int csDimension, int measures, GeometryFactory gf) {
        double[] bbox = package$.MODULE$.RichStandardInput(standardInput).readDoubleArray(4, ByteOrder.LITTLE_ENDIAN);
        Envelope envelope = new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        int numParts = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        int numPoints = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        int[] partOffsets = new int[numParts];
        for (int index$macro$1 = 0; index$macro$1 < numParts; ++index$macro$1) {
            partOffsets[index$macro$1] = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        }
        CoordinateSequence coords = this.readCoordinates(standardInput, numPoints, csDimension, measures, gf);
        return EsriDeserializerUtils$.MODULE$.createMultiLineString(numPoints, numParts, partOffsets, coords, csDimension, measures, envelope, gf, EsriDeserializerUtils$.MODULE$.createMultiLineString$default$9());
    }

    public Geometry parseLineHandler(ByteBuffer byteBuffer, int csDimension, int measures, GeometryFactory gf) {
        double[] bbox = new double[]{byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble()};
        Envelope envelope = new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        int numParts = byteBuffer.getInt();
        int numPoints = byteBuffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int index$macro$1 = 0; index$macro$1 < numParts; ++index$macro$1) {
            partOffsets[index$macro$1] = byteBuffer.getInt();
        }
        CoordinateSequence coords = this.readCoordinates(byteBuffer, numPoints, csDimension, measures, gf);
        return EsriDeserializerUtils$.MODULE$.createMultiLineString(numPoints, numParts, partOffsets, coords, csDimension, measures, envelope, gf, EsriDeserializerUtils$.MODULE$.createMultiLineString$default$9());
    }

    public Geometry parsePolygonHandler(StandardInput standardInput, int csDimension, int measures, GeometryFactory gf) {
        double[] bbox = package$.MODULE$.RichStandardInput(standardInput).readDoubleArray(4, ByteOrder.LITTLE_ENDIAN);
        Envelope envelope = new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        int numParts = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        int numPoints = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        int[] partOffsets = new int[numParts];
        for (int index$macro$1 = 0; index$macro$1 < numParts; ++index$macro$1) {
            partOffsets[index$macro$1] = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        }
        CoordinateSequence coords = this.readCoordinates(standardInput, numPoints, csDimension, measures, gf);
        return EsriDeserializerUtils$.MODULE$.createMultiPolygon(numPoints, numParts, partOffsets, coords, csDimension, measures, envelope, gf, EsriDeserializerUtils$.MODULE$.createMultiPolygon$default$9());
    }

    public Geometry parsePolygonHandler(ByteBuffer byteBuffer, int csDimension, int measures, GeometryFactory gf) {
        double[] bbox = new double[]{byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble()};
        Envelope envelope = new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        int numParts = byteBuffer.getInt();
        int numPoints = byteBuffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int index$macro$1 = 0; index$macro$1 < numParts; ++index$macro$1) {
            partOffsets[index$macro$1] = byteBuffer.getInt();
        }
        CoordinateSequence coords = this.readCoordinates(byteBuffer, numPoints, csDimension, measures, gf);
        return EsriDeserializerUtils$.MODULE$.createMultiPolygon(numPoints, numParts, partOffsets, coords, csDimension, measures, envelope, gf, EsriDeserializerUtils$.MODULE$.createMultiPolygon$default$9());
    }

    public Geometry parseMultiPoint(StandardInput standardInput, int csDimension, int measures, GeometryFactory gf) {
        double[] bbox = package$.MODULE$.RichStandardInput(standardInput).readDoubleArray(4, ByteOrder.LITTLE_ENDIAN);
        Envelope envelope = new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        int numPoints = package$.MODULE$.RichStandardInput(standardInput).readInt(ByteOrder.LITTLE_ENDIAN);
        CoordinateSequence cs = this.readCoordinates(standardInput, numPoints, csDimension, measures, gf);
        MultiPoint multiPoint = gf.createMultiPoint(cs);
        GeometryUtils$.MODULE$.RichGeometry((Geometry)multiPoint).setEnvelope(envelope);
        return multiPoint;
    }

    public Geometry parseMultiPoint(ByteBuffer byteBuffer, int csDimension, int measures, GeometryFactory gf) {
        double[] bbox = new double[]{byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble()};
        Envelope envelope = new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
        int numPoints = byteBuffer.getInt();
        CoordinateSequence cs = this.readCoordinates(byteBuffer, numPoints, csDimension, measures, gf);
        MultiPoint multiPoint = gf.createMultiPoint(cs);
        GeometryUtils$.MODULE$.RichGeometry((Geometry)multiPoint).setEnvelope(envelope);
        return multiPoint;
    }

    private CoordinateSequence readCoordinates(StandardInput standardInput, int numPoints, int csDimension, int measures, GeometryFactory gf) {
        CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(numPoints, csDimension, measures);
        double[] ordinates = package$.MODULE$.RichStandardInput(standardInput).readDoubleArray(numPoints * 2, ByteOrder.LITTLE_ENDIAN);
        for (int index$macro$1 = 0; index$macro$1 < numPoints; ++index$macro$1) {
            cs.setOrdinate(index$macro$1, 0, ordinates[index$macro$1 * 2]);
            cs.setOrdinate(index$macro$1, 1, ordinates[index$macro$1 * 2 + 1]);
        }
        if (csDimension == 3 && measures == 0 || csDimension == 4) {
            standardInput.skip(16L);
            package.RichStandardInput qual$1 = package$.MODULE$.RichStandardInput(standardInput);
            int x$1 = numPoints;
            ByteOrder x$2 = qual$1.readDoubleArray$default$2();
            ordinates = qual$1.readDoubleArray(x$1, x$2);
            for (int index$macro$2 = 0; index$macro$2 < numPoints; ++index$macro$2) {
                cs.getCoordinate(index$macro$2).setZ(ordinates[index$macro$2]);
            }
        }
        if (measures == 1) {
            standardInput.skip(16L);
            package.RichStandardInput qual$2 = package$.MODULE$.RichStandardInput(standardInput);
            int x$3 = numPoints;
            ByteOrder x$4 = qual$2.readDoubleArray$default$2();
            ordinates = qual$2.readDoubleArray(x$3, x$4);
            for (int index$macro$3 = 0; index$macro$3 < numPoints; ++index$macro$3) {
                cs.getCoordinate(index$macro$3).setM(ordinates[index$macro$3]);
            }
        }
        return cs;
    }

    private CoordinateSequence readCoordinates(ByteBuffer byteBuffer, int numPoints, int csDimension, int measures, GeometryFactory gf) {
        CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(numPoints, csDimension, measures);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        double[] ordinates = new double[numPoints * 2];
        doubleBuffer.get(ordinates);
        for (int index$macro$1 = 0; index$macro$1 < numPoints; ++index$macro$1) {
            cs.setOrdinate(index$macro$1, 0, ordinates[index$macro$1 * 2]);
            cs.setOrdinate(index$macro$1, 1, ordinates[index$macro$1 * 2 + 1]);
        }
        if (csDimension == 3 && measures == 0 || csDimension == 4) {
            doubleBuffer.get(new double[2]);
            ordinates = new double[numPoints];
            doubleBuffer.get(ordinates);
            for (int index$macro$2 = 0; index$macro$2 < numPoints; ++index$macro$2) {
                cs.getCoordinate(index$macro$2).setZ(ordinates[index$macro$2]);
            }
        }
        if (measures == 1) {
            doubleBuffer.get(new double[2]);
            ordinates = new double[numPoints];
            doubleBuffer.get(ordinates);
            for (int index$macro$3 = 0; index$macro$3 < numPoints; ++index$macro$3) {
                cs.getCoordinate(index$macro$3).setM(ordinates[index$macro$3]);
            }
        }
        return cs;
    }

    public boolean canProcess(Map<String, String> params) {
        return params.get((Object)GeometryDeserializer$.MODULE$.DESERIALIZER()).exists((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ShpGeometryDeserializer.$anonfun$canProcess$1(x$23))) && this.init(params);
    }

    public boolean init(Map<String, String> params) {
        boolean bl;
        Object object = new Object();
        try {
            this.layerDimension_$eq(new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)ShpGeometryDeserializer$.MODULE$.LAYER_DIMENSION(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl.mcZ.sp(object, false);
            }))).toByte());
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(String x$23) {
        return ShpGeometryDeserializer$.MODULE$.SHP().equals(x$23);
    }

    public ShpGeometryDeserializer() {
    }

    public ShpGeometryDeserializer(Map<String, String> params) {
        this();
        if (!this.init(params)) {
            String x$1 = "\u7f3a\u5c11\u53c2\u6570\u503c\uff0c\u65e0\u6cd5\u6267\u884c\u89e3\u6790!";
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$1);
            throw new NotFoundException(x$1, x$2, x$3);
        }
    }
}

