/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.shapefile.common.sbn;

import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.IoException$;
import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.data.vector.shapefile.common.sbn.SbnHeader$;
import com.geoway.atlas.data.vector.shapefile.common.sbn.query.SBNSearchInfo;
import java.nio.ByteOrder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u000e\u001d\u00015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)A\t\u0001C\u0001\u000b\"9!\n\u0001a\u0001\n\u0013Y\u0005bB(\u0001\u0001\u0004%I\u0001\u0015\u0005\u0007-\u0002\u0001\u000b\u0015\u0002'\t\u000f]\u0003\u0001\u0019!C\u0005\u0017\"9\u0001\f\u0001a\u0001\n\u0013I\u0006BB.\u0001A\u0003&A\nC\u0004]\u0001\u0001\u0007I\u0011B&\t\u000fu\u0003\u0001\u0019!C\u0005=\"1\u0001\r\u0001Q!\n1CQ!\u0019\u0001\u0005\u0002\tDQa\u001c\u0001\u0005\nADQA\u001d\u0001\u0005\nMDQ!\u001e\u0001\u0005\nYDQa\u001e\u0001\u0005\naDQ\u0001 \u0001\u0005\nuDaa \u0001\u0005\n\u0005\u0005\u0001BBA\u0003\u0001\u0011\u00051\n\u0003\u0004\u0002\b\u0001!\ta\u0013\u0005\u0007\u0003\u0013\u0001A\u0011A&\b\u000f\u0005-A\u0004#\u0001\u0002\u000e\u001911\u0004\bE\u0001\u0003\u001fAa\u0001\u0012\r\u0005\u0002\u0005E\u0001bBA\n1\u0011\u0005\u0011Q\u0003\u0002\n'\nt\u0007*Z1eKJT!!\b\u0010\u0002\u0007M\u0014gN\u0003\u0002 A\u000511m\\7n_:T!!\t\u0012\u0002\u0013MD\u0017\r]3gS2,'BA\u0012%\u0003\u00191Xm\u0019;pe*\u0011QEJ\u0001\u0005I\u0006$\u0018M\u0003\u0002(Q\u0005)\u0011\r\u001e7bg*\u0011\u0011FK\u0001\u0007O\u0016|w/Y=\u000b\u0003-\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u00035\u0019(M\\*fCJ\u001c\u0007.\u00138g_B\u0011a'O\u0007\u0002o)\u0011\u0001\bH\u0001\u0006cV,'/_\u0005\u0003u]\u0012Qb\u0015\"O'\u0016\f'o\u00195J]\u001a|\u0017!\u00032zi\u0016|%\u000fZ3s!\ti$)D\u0001?\u0015\ty\u0004)A\u0002oS>T\u0011!Q\u0001\u0005U\u00064\u0018-\u0003\u0002D}\tI!)\u001f;f\u001fJ$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019C\u0015\n\u0005\u0002H\u00015\tA\u0004C\u00035\u0007\u0001\u0007Q\u0007C\u0003<\u0007\u0001\u0007A(A\u0005o\u001b\u0006Dhj\u001c3fgV\tA\n\u0005\u00020\u001b&\u0011a\n\r\u0002\u0004\u0013:$\u0018!\u00048NCbtu\u000eZ3t?\u0012*\u0017\u000f\u0006\u0002R)B\u0011qFU\u0005\u0003'B\u0012A!\u00168ji\"9Q+BA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005Qa.T1y\u001d>$Wm\u001d\u0011\u0002\u001b9tu\u000eZ3EKN\u001c7+\u001b>f\u0003Eqgj\u001c3f\t\u0016\u001c8mU5{K~#S-\u001d\u000b\u0003#jCq!\u0016\u0005\u0002\u0002\u0003\u0007A*\u0001\bo\u001d>$W\rR3tGNK'0\u001a\u0011\u0002\u001d9tu\u000eZ3EKN\u001c7i\\;oi\u0006\u0011bNT8eK\u0012+7oY\"pk:$x\fJ3r)\t\tv\fC\u0004V\u0017\u0005\u0005\t\u0019\u0001'\u0002\u001f9tu\u000eZ3EKN\u001c7i\\;oi\u0002\na\u0001]1sg\u0016\u0014HCA2g!\tyC-\u0003\u0002fa\t9!i\\8mK\u0006t\u0007\"B4\u000e\u0001\u0004A\u0017!D:uC:$\u0017M\u001d3J]B,H\u000f\u0005\u0002j[6\t!N\u0003\u0002lY\u0006\u0011\u0011n\u001c\u0006\u0003?\u0019J!A\u001c6\u0003\u001bM#\u0018M\u001c3be\u0012Le\u000e];u\u0003Q\u0019\u0007.Z2l\u0011\u0016\fG-\u001a:TS\u001et\u0017\r^;sKR\u0011\u0011+\u001d\u0005\u0006O:\u0001\r\u0001[\u0001\u000fg\u0016$h*^7PMNC\u0017\r]3t)\t\u0019G\u000fC\u0003h\u001f\u0001\u0007\u0001.\u0001\u0007tKRtU*\u0019=EKB$\b\u000eF\u0001R\u00039\u0019X\r\u001e\"pk:$\u0017N\\4C_b$2!U={\u0011\u00159\u0017\u00031\u0001i\u0011\u0015Y\u0018\u00031\u00016\u0003\u0011A7K\u0011(\u0002\u001f\rDWmY6GSJ\u001cHOQ5o\u0013\u0012$\"!\u0015@\t\u000b\u001d\u0014\u0002\u0019\u00015\u0002#\rDWmY6O_\u0012,G)Z:d'&TX\rF\u0002R\u0003\u0007AQaZ\nA\u0002!\fAbZ3u\u001d6\u000b\u0007PT8eKN\f\u0001cZ3u\u001d:{G-\u001a#fg\u000e\u001c\u0016N_3\u0002#\u001d,GO\u0014(pI\u0016$Um]2D_VtG/A\u0005TE:DU-\u00193feB\u0011q\tG\n\u000319\"\"!!\u0004\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0019\u000b9\"!\u0007\t\u000bQR\u0002\u0019A\u001b\t\u000bmR\u0002\u0019\u0001\u001f")
public class SbnHeader {
    private final SBNSearchInfo sbnSearchInfo;
    private final ByteOrder byteOrder;
    private int nMaxNodes;
    private int nNodeDescSize;
    private int nNodeDescCount;

    public static SbnHeader apply(SBNSearchInfo sBNSearchInfo, ByteOrder byteOrder) {
        return SbnHeader$.MODULE$.apply(sBNSearchInfo, byteOrder);
    }

    private int nMaxNodes() {
        return this.nMaxNodes;
    }

    private void nMaxNodes_$eq(int x$1) {
        this.nMaxNodes = x$1;
    }

    private int nNodeDescSize() {
        return this.nNodeDescSize;
    }

    private void nNodeDescSize_$eq(int x$1) {
        this.nNodeDescSize = x$1;
    }

    private int nNodeDescCount() {
        return this.nNodeDescCount;
    }

    private void nNodeDescCount_$eq(int x$1) {
        this.nNodeDescCount = x$1;
    }

    public boolean parser(StandardInput standardInput) {
        if (standardInput.position() != 0L) {
            standardInput.seek(0L);
        }
        this.checkHeaderSignature(standardInput);
        standardInput.skip(20L);
        boolean isEmpty = this.setNumOfShapes(standardInput);
        if (isEmpty) {
            return isEmpty;
        }
        this.setNMaxDepth();
        this.setBoundingBox(standardInput, this.sbnSearchInfo);
        standardInput.skip(36L);
        this.checkFirstBinId(standardInput);
        this.checkNodeDescSize(standardInput);
        return false;
    }

    private void checkHeaderSignature(StandardInput standardInput) {
        byte[] checkHeader = package$.MODULE$.RichStandardInput(standardInput).readByteArray(8);
        if (checkHeader[0] != 0 || checkHeader[1] != 0 || checkHeader[2] != 39 || checkHeader[3] != 10 && checkHeader[3] != 13 || checkHeader[4] != 255 || checkHeader[5] != 255 || checkHeader[6] != 254 || checkHeader[7] != 112) {
            String x$1 = "\u68c0\u67e5sbn\u6587\u4ef6\u5934\u9519\u8bef!";
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
    }

    private boolean setNumOfShapes(StandardInput standardInput) {
        int nShapeCount = package$.MODULE$.RichStandardInput(standardInput).readInt(this.byteOrder);
        this.sbnSearchInfo.nShapeCount_$eq(nShapeCount);
        if (nShapeCount < 0 || nShapeCount > 256000000) {
            String x$1 = "sbn\u6587\u4ef6\u5305\u542b\u9519\u8bef\u7684\u56fe\u6591\u6570\u91cf";
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
        return nShapeCount == 0;
    }

    private void setNMaxDepth() {
        int nMaxDepth;
        for (nMaxDepth = 2; nMaxDepth < 24 && this.sbnSearchInfo.nShapeCount() > ((1 << nMaxDepth) - 1) * 8; ++nMaxDepth) {
        }
        this.sbnSearchInfo.nMaxDepth_$eq(nMaxDepth);
        this.nMaxNodes_$eq((1 << nMaxDepth) - 1);
    }

    private void setBoundingBox(StandardInput standardInput, SBNSearchInfo hSBN) {
        double[] boundary = package$.MODULE$.RichStandardInput(standardInput).readDoubleArray(4, this.byteOrder);
        hSBN.setDfMinX(boundary[0]);
        hSBN.setDfMinY(boundary[1]);
        hSBN.setDfMaxX(boundary[2]);
        hSBN.setDfMaxY(boundary[3]);
        if (hSBN.dfMinX() > hSBN.dfMaxX() || hSBN.dfMinY() > hSBN.dfMaxY()) {
            String x$1 = "sbn\u6587\u4ef6\u4e2d\u7684\u5916\u5305\u77e9\u5f62\u8303\u56f4\u9519\u8bef!";
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
    }

    private void checkFirstBinId(StandardInput standardInput) {
        int firstBinId = package$.MODULE$.RichStandardInput(standardInput).readInt(this.byteOrder);
        if (firstBinId != 1) {
            String x$1 = "sbn\u6587\u4ef6\u4e2d\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\u7684id\u9519\u8bef!";
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
    }

    private void checkNodeDescSize(StandardInput standardInput) {
        this.nNodeDescSize_$eq(package$.MODULE$.RichStandardInput(standardInput).readInt(this.byteOrder));
        this.nNodeDescSize_$eq(this.nNodeDescSize() * 2);
        this.nNodeDescCount_$eq(this.nNodeDescSize() / 8);
        if (this.nNodeDescSize() % 8 != 0 || this.nNodeDescCount() < 0 || this.nNodeDescCount() > this.nMaxNodes()) {
            String x$1 = "sbn\u4e2d\u5305\u542b\u4e0d\u53ef\u7528\u7684\u8282\u70b9\u63cf\u8ff0\u5927\u5c0f!";
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
    }

    public int getNMaxNodes() {
        return this.nMaxNodes();
    }

    public int getNNodeDescSize() {
        return this.nNodeDescSize();
    }

    public int getNNodeDescCount() {
        return this.nNodeDescCount();
    }

    public SbnHeader(SBNSearchInfo sbnSearchInfo, ByteOrder byteOrder) {
        this.sbnSearchInfo = sbnSearchInfo;
        this.byteOrder = byteOrder;
        this.nMaxNodes = 0;
        this.nNodeDescSize = 0;
        this.nNodeDescCount = 0;
    }
}

