/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.shapefile.common;

import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.common.io.StandardOutput;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.common.utils.CollectionUtils$;
import com.geoway.atlas.common.utils.StringUtils$;
import com.geoway.atlas.common.with.WithClose$;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.vector.common.feature.sft.SimpleFeatureTypeUtils$;
import com.geoway.atlas.data.vector.common.feature.sft.package$;
import com.geoway.atlas.data.vector.serialization.common.GeometryType$;
import com.geoway.atlas.data.vector.shapefile.common.cpg.CpgReader$;
import com.geoway.atlas.data.vector.shapefile.common.cpg.CpgWriter$;
import com.geoway.atlas.data.vector.shapefile.common.dbf.DbaseFileHeader;
import com.geoway.atlas.data.vector.shapefile.common.dbf.field.DbaseField;
import com.geoway.atlas.data.vector.shapefile.common.prj.PrjReader$;
import com.geoway.atlas.data.vector.shapefile.common.prj.PrjWriter$;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShpHeader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ShapeFileHandle$
implements LazyLogging {
    public static ShapeFileHandle$ MODULE$;
    private final String SHP_FIELD;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ShapeFileHandle$();
    }

    private Logger logger$lzycompute() {
        ShapeFileHandle$ shapeFileHandle$ = this;
        synchronized (shapeFileHandle$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String SHP_FIELD() {
        return this.SHP_FIELD;
    }

    public void readDbaseFileHeader(DbaseFileHeader dbaseFileHeader, StandardInput standardInput) {
        WithClose$.MODULE$.apply((AutoCloseable)standardInput).apply((Function1 & Serializable & scala.Serializable)x$1 -> {
            dbaseFileHeader.readHeader(standardInput);
            return BoxedUnit.UNIT;
        });
    }

    public void readShpFileHeader(ShpHeader shpHeader, StandardInput standardInput) {
        WithClose$.MODULE$.apply((AutoCloseable)standardInput).apply((Function1 & Serializable & scala.Serializable)x$2 -> {
            shpHeader.read(standardInput);
            return BoxedUnit.UNIT;
        });
    }

    public String readPrj(StandardInput standardInput) {
        return (String)WithClose$.MODULE$.apply((AutoCloseable)standardInput).apply((Function1 & Serializable & scala.Serializable)x$3 -> PrjReader$.MODULE$.read(standardInput));
    }

    public void writePrj(CoordinateReferenceSystem crs, StandardOutput standardOutput) {
        WithClose$.MODULE$.apply((AutoCloseable)standardOutput).apply((Function1 & Serializable & scala.Serializable)x$4 -> {
            PrjWriter$.MODULE$.write(crs, standardOutput);
            return BoxedUnit.UNIT;
        });
    }

    public Charset readCharset(StandardInput standardInput) {
        return (Charset)WithClose$.MODULE$.apply((AutoCloseable)standardInput).apply((Function1 & Serializable & scala.Serializable)x$5 -> CpgReader$.MODULE$.read(standardInput));
    }

    public void writeCharset(StandardOutput standardOutput) {
        WithClose$.MODULE$.apply((AutoCloseable)standardOutput).apply((Function1 & Serializable & scala.Serializable)x$6 -> {
            CpgWriter$.MODULE$.write(standardOutput, StandardCharsets.UTF_8);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleFeatureType getSchema(AtlasDataName storageName, DbaseFileHeader dbaseFileHeader, ShpHeader shpHeader, String wkt) {
        DbaseField[] fields = dbaseFileHeader.getFields();
        HashMap userdata = new HashMap();
        Envelope envelope = shpHeader.getEnvelope();
        byte dimension = GeometryType$.MODULE$.getGeometryDimension(shpHeader.getShapeType());
        int zm = GeometryType$.MODULE$.getGeometryZM(shpHeader.getShapeType());
        this.logger().debug(new StringBuilder(21).append("start get crs time : ").append(System.currentTimeMillis()).toString());
        int srid = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.WKT_TO_SRID(wkt);
        CoordinateReferenceSystem crs = com.geoway.atlas.data.vector.common.crs.package$.MODULE$.SRID_WKT_TO_CRS(srid, wkt);
        this.logger().debug(new StringBuilder(19).append("end get crs time : ").append(System.currentTimeMillis()).toString());
        GeometryDescriptor geometryDescriptor = SimpleFeatureTypeUtils$.MODULE$.createGeometryDescriptor(StringUtils$.MODULE$.getUniqueStringFromSeq(SimpleFeatureTypeUtils$.MODULE$.SHP_FIELD(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.fieldName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), userdata, crs, envelope);
        AttributeDescriptor[] attributeDescriptors = new AttributeDescriptor[fields.length + 1];
        attributeDescriptors[0] = geometryDescriptor;
        if (CollectionUtils$.MODULE$.nonEmpty((Seq)Predef$.MODULE$.wrapRefArray((Object[])dbaseFileHeader.getFields()))) {
            for (int index$macro$1 = 0; index$macro$1 < fields.length; ++index$macro$1) {
                Class<?> fieldClass = dbaseFileHeader.getFieldClass(index$macro$1);
                Object defaultValue = SimpleFeatureTypeUtils$.MODULE$.getDefaultValue(fieldClass);
                DbaseField field = fields[index$macro$1];
                attributeDescriptors[index$macro$1 + 1] = SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor(field.fieldName(), fieldClass, null, defaultValue, field.fieldLength(), SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$6(), SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$7(), SimpleFeatureTypeUtils$.MODULE$.createAttributeDescriptor$default$8());
            }
        }
        SimpleFeatureType nSft = SimpleFeatureTypeUtils$.MODULE$.createSimpleFeatureType(storageName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeDescriptors), geometryDescriptor.getLocalName());
        package$.MODULE$.RichSimpleFeatureType(nSft).setGeometryDimension((dimension << 2) + zm);
        return nSft;
    }

    private ShapeFileHandle$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.SHP_FIELD = "shape";
    }
}

