/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.shapefile.common.shp;

import com.geoway.atlas.common.error.NotMatchException;
import com.geoway.atlas.common.error.NotMatchException$;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.io.StandardOutput;
import com.geoway.atlas.common.io.package$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.serialization.common.GeometrySerializer;
import com.geoway.atlas.data.vector.serialization.common.GeometrySerializer$;
import com.geoway.atlas.data.vector.serialization.common.GeometrySerializerFactory$;
import com.geoway.atlas.data.vector.serialization.common.GeometryType$;
import com.geoway.atlas.data.vector.serialization.esri.shapefile.ShpType$;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShpHeader;
import com.geoway.atlas.data.vector.shapefile.common.shp.ShpHeader$;
import java.nio.ByteOrder;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0006\r\u0001uAQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u00049\u0001\u0001\u0006I!\r\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u00199\u0005\u0001)A\u0005w!)\u0001\n\u0001C\u0001\u0013\")\u0001\n\u0001C\u0005i\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003g\u0001A\u0011BA\u001b\u0005%\u0019\u0006\u000e],sSR,'O\u0003\u0002\u000e\u001d\u0005\u00191\u000f\u001b9\u000b\u0005=\u0001\u0012AB2p[6|gN\u0003\u0002\u0012%\u0005I1\u000f[1qK\u001aLG.\u001a\u0006\u0003'Q\taA^3di>\u0014(BA\u000b\u0017\u0003\u0011!\u0017\r^1\u000b\u0005]A\u0012!B1uY\u0006\u001c(BA\r\u001b\u0003\u00199Wm\\<bs*\t1$A\u0002d_6\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013*\u001b\u00051#BA\u0014)\u0003\rawn\u001a\u0006\u0003\u001fYI!A\u000b\u0014\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u00031\tAb]3sS\u0006d\u0017N_1u_J,\u0012!\r\t\u0003eYj\u0011a\r\u0006\u0003\u001fQR!!\u000e\n\u0002\u001bM,'/[1mSj\fG/[8o\u0013\t94G\u0001\nHK>lW\r\u001e:z'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!D:fe&\fG.\u001b>bi>\u0014\b%\u0001\u0002hMV\t1\b\u0005\u0002=\u000b6\tQH\u0003\u0002?\u007f\u0005!q-Z8n\u0015\t\u0001\u0015)A\u0002kiNT!AQ\"\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UHA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0003\r9g\rI\u0001\roJLG/\u001a%fC\u0012,'o]\u000b\u0003\u0015\u0006$BaS)keB!q\u0004\u0014(O\u0013\ti\u0005E\u0001\u0004UkBdWM\r\t\u0003]=K!\u0001\u0015\u0007\u0003\u0013MC\u0007\u000fS3bI\u0016\u0014\b\"\u0002*\u0007\u0001\u0004\u0019\u0016AC4f_6,GO]5fgB\u0019A\u000bX0\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u001d\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002\\A\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\r\u0019V-\u001d\u0006\u00037\u0002\u0002\"\u0001Y1\r\u0001\u0011)!M\u0002b\u0001G\n\tA+\u0005\u0002eOB\u0011q$Z\u0005\u0003M\u0002\u0012qAT8uQ&tw\r\u0005\u0002 Q&\u0011\u0011\u000e\t\u0002\u0004\u0003:L\b\"B6\u0007\u0001\u0004a\u0017!C:ia>+H\u000f];u!\ti\u0007/D\u0001o\u0015\ty\u0007&\u0001\u0002j_&\u0011\u0011O\u001c\u0002\u000f'R\fg\u000eZ1sI>+H\u000f];u\u0011\u0015\u0019h\u00011\u0001m\u0003%\u0019\b\u000e_(viB,H\u000fF\u0005LkZ<H0a\u0001\u0002\b!)1n\u0002a\u0001Y\")1o\u0002a\u0001Y\")\u0001p\u0002a\u0001s\u00061!m\\;oIN\u0004\"\u0001\u0010>\n\u0005ml$\u0001C#om\u0016dw\u000e]3\t\u000bu<\u0001\u0019\u0001@\u0002\u0019\u001d,w.\\3uef$\u0016\u0010]3\u0011\u0005}y\u0018bAA\u0001A\t\u0019\u0011J\u001c;\t\r\u0005\u0015q\u00011\u0001\u007f\u0003IqW/\u001c2fe>3w)Z8nKR\u0014\u0018.Z:\t\r\u0005%q\u00011\u0001\u007f\u0003)1\u0017\u000e\\3MK:<G\u000f[\u0001\u000eoJLG/Z$f_6,GO]=\u0015\u0019\u0005=\u0011QCA\f\u00033\ti\"a\b\u0011\u0007}\t\t\"C\u0002\u0002\u0014\u0001\u0012A!\u00168ji\")1\u000e\u0003a\u0001Y\")1\u000f\u0003a\u0001Y\"1\u00111\u0004\u0005A\u0002y\f\u0001bZ3p\u0013:$W\r\u001f\u0005\u0006{\"\u0001\rA \u0005\b\u0003CA\u0001\u0019AA\u0012\u0003!9Wm\\7fiJL\bc\u0001\u001f\u0002&%\u0019\u0011qE\u001f\u0003\u0011\u001d+w.\\3uef\f\u0011c\u001e:ji\u0016tU\u000f\u001c7HK>lW\r\u001e:z)\u0015q\u0018QFA\u0018\u0011\u0015Y\u0017\u00021\u0001m\u0011\u0019\t\t$\u0003a\u0001}\u0006)\u0011N\u001c3fq\u0006!rO]5uK:{gNT;mY\u001e+w.\\3uef$\u0012B`A\u001c\u0003s\tY$!\u0010\t\u000b-T\u0001\u0019\u00017\t\r\u0005m!\u00021\u0001\u007f\u0011\u0015i(\u00021\u0001\u007f\u0011\u001d\t\tC\u0003a\u0001\u0003G\u0001")
public class ShpWriter
implements LazyLogging {
    private final GeometrySerializer serializator;
    private final GeometryFactory gf;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ShpWriter shpWriter = this;
        synchronized (shpWriter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private GeometrySerializer serializator() {
        return this.serializator;
    }

    private GeometryFactory gf() {
        return this.gf;
    }

    public <T> Tuple2<ShpHeader, ShpHeader> writeHeaders(Seq<T> geometries, StandardOutput shpOutput, StandardOutput shxOutput) {
        int fileLength = 100;
        Envelope envelope = new Envelope();
        Class<Lineal> geometryClass = null;
        int geometryType = -1;
        int geomNum = geometries.length();
        this.logger().info(new StringBuilder(7).append(Thread.currentThread().getName()).append("-\u56fe\u6591\u6570\u91cf\u4e3a:").append(geomNum).toString());
        for (int index$macro$1 = geomNum - 1; index$macro$1 >= 0; --index$macro$1) {
            BoxedUnit boxedUnit;
            Object t = geometries.apply(index$macro$1);
            Geometry geometry = null;
            Object object = t;
            if (object instanceof Geometry) {
                Geometry geometry2;
                geometry = geometry2 = (Geometry)object;
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof SimpleFeature) {
                Object object2 = object;
                geometry = (Geometry)((SimpleFeature)object2).getDefaultGeometry();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                String x$1 = new StringBuilder(11).append("\u4e0d\u671f\u671b\u7684\u8f93\u5165\u6570\u636e\u7c7b\u578b:").append(t.getClass()).toString();
                Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                throw new NotSupportException(x$1, x$2, x$3);
            }
            if (geometryClass != null) {
                if (!geometryClass.isAssignableFrom(geometry.getClass())) {
                    String x$4 = new StringBuilder(16).append("\u5f53\u524d\u6570\u636e\u96c6\u5747\u4e3a").append(geometryClass.getSimpleName()).append("\u7c7b\u578b\uff0c").append("\u4e0d\u80fd\u6dfb\u52a0").append(geometry.getClass().getSimpleName()).append("\u7c7b\u578b").toString();
                    Thread x$5 = NotMatchException$.MODULE$.apply$default$2(x$4);
                    int x$6 = NotMatchException$.MODULE$.apply$default$3(x$4);
                    throw new NotMatchException(x$4, x$5, x$6);
                }
            } else {
                Class<Lineal> clazz;
                Geometry geometry3 = geometry;
                if (geometry3 instanceof Lineal) {
                    clazz = Lineal.class;
                } else if (geometry3 instanceof Polygonal) {
                    clazz = Polygonal.class;
                } else if (geometry3 instanceof Puntal) {
                    clazz = Puntal.class;
                } else {
                    throw new MatchError((Object)geometry3);
                }
                geometryClass = clazz;
                geometryType = ShpType$.MODULE$.getGeometryLayerType(geometryClass, true);
            }
            int size = this.serializator().getLength(geometryType, geometry) + 8;
            fileLength += size;
            envelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return this.writeHeaders(shpOutput, shxOutput, envelope, geometryType, geomNum, fileLength);
    }

    private Tuple2<ShpHeader, ShpHeader> writeHeaders(StandardOutput shpOutput, StandardOutput shxOutput, Envelope bounds, int geometryType, int numberOfGeometries, int fileLength) {
        ShpHeader shpHeader = ShpHeader$.MODULE$.apply(geometryType, fileLength / 2, bounds);
        shpHeader.write(shpOutput);
        ShpHeader shxHeader = ShpHeader$.MODULE$.apply(geometryType, 50 + 4 * numberOfGeometries, bounds);
        shxHeader.write(shxOutput);
        return new Tuple2((Object)shpHeader, (Object)shxHeader);
    }

    public void writeGeometry(StandardOutput shpOutput, StandardOutput shxOutput, int geoIndex, int geometryType, Geometry geometry) {
        int lp = (int)shpOutput.position();
        int length = -1;
        length = geometry == null ? this.writeNullGeometry(shpOutput, geoIndex) : this.writeNonNullGeometry(shpOutput, geoIndex, geometryType, geometry);
        if ((long)(length * 2) != shpOutput.position() - (long)lp - 8L) {
            String x$1 = "\u5199\u5165\u957f\u5ea6\u51fa\u9519!";
            Thread x$2 = NotMatchException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotMatchException$.MODULE$.apply$default$3(x$1);
            throw new NotMatchException(x$1, x$2, x$3);
        }
        package$.MODULE$.RichStandardOutput(shxOutput).writeInt(lp / 2, ByteOrder.BIG_ENDIAN);
        package$.MODULE$.RichStandardOutput(shxOutput).writeInt(length, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    private int writeNullGeometry(StandardOutput shpOutput, int index) {
        void var3_3;
        int length = 4;
        package$.MODULE$.RichStandardOutput(shpOutput).writeInt(index + 1, ByteOrder.BIG_ENDIAN);
        package$.MODULE$.RichStandardOutput(shpOutput).writeInt(length /= 2, ByteOrder.BIG_ENDIAN);
        package$.MODULE$.RichStandardOutput(shpOutput).writeInt(GeometryType$.MODULE$.NULL(), ByteOrder.LITTLE_ENDIAN);
        return (int)var3_3;
    }

    private int writeNonNullGeometry(StandardOutput shpOutput, int geoIndex, int geometryType, Geometry geometry) {
        int length = this.serializator().getLength(geometryType, geometry);
        package$.MODULE$.RichStandardOutput(shpOutput).writeInt(geoIndex + 1, ByteOrder.BIG_ENDIAN);
        package$.MODULE$.RichStandardOutput(shpOutput).writeInt(length /= 2, ByteOrder.BIG_ENDIAN);
        package$.MODULE$.RichStandardOutput(shpOutput).writeInt(geometryType, ByteOrder.LITTLE_ENDIAN);
        this.serializator().serializer(shpOutput, geometryType, geometry, this.gf());
        return length;
    }

    public ShpWriter() {
        LazyLogging.$init$((LazyLogging)this);
        this.serializator = GeometrySerializerFactory$.MODULE$.getSerializer((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeometrySerializer$.MODULE$.SERIALIZER()), (Object)"shp")})));
        this.gf = new GeometryFactory();
    }
}

