/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.rules.atlas_rule;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.framework.spark.vector.sql.AtlasRelationFunction;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.spark.sql.atlas_sql.udt.GeometryUDT$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AtlasDataSourceOptimization$
implements LazyLogging {
    public static AtlasDataSourceOptimization$ MODULE$;
    private final transient FilterFactory2 ff;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new AtlasDataSourceOptimization$();
    }

    private Logger logger$lzycompute() {
        AtlasDataSourceOptimization$ atlasDataSourceOptimization$ = this;
        synchronized (atlasDataSourceOptimization$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public FilterFactory2 ff() {
        return this.ff;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Filter> sparkFilterToGTFilter(org.apache.spark.sql.catalyst.expressions.Expression expr) {
        BinaryComparison binaryComparison;
        Option option;
        org.apache.spark.sql.catalyst.expressions.Expression expression2 = expr;
        if (expression2 instanceof AtlasRelationFunction) {
            AtlasRelationFunction atlasRelationFunction = (AtlasRelationFunction)expression2;
            return this.arFunctoGTFilter((org.apache.spark.sql.catalyst.expressions.Expression)atlasRelationFunction);
        }
        if (expression2 instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression2)).isEmpty()) {
            None$ none$;
            org.apache.spark.sql.catalyst.expressions.Expression left = (org.apache.spark.sql.catalyst.expressions.Expression)((Tuple2)option.get())._1();
            org.apache.spark.sql.catalyst.expressions.Expression right = (org.apache.spark.sql.catalyst.expressions.Expression)((Tuple2)option.get())._2();
            Option<Expression> leftExpr = this.sparkExprToGTExpr(left);
            Option<Expression> rightExpr = this.sparkExprToGTExpr(right);
            if (leftExpr.isEmpty() || rightExpr.isEmpty()) {
                none$ = None$.MODULE$;
                return none$;
            } else {
                void var4_18;
                BinaryComparison binaryComparison2 = binaryComparison;
                if (binaryComparison2 instanceof EqualTo) {
                    Some some = new Some((Object)this.ff().equals((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof LessThan) {
                    Some some = new Some((Object)this.ff().less((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof LessThanOrEqual) {
                    Some some = new Some((Object)this.ff().lessOrEqual((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof GreaterThan) {
                    Some some = new Some((Object)this.ff().greater((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof GreaterThanOrEqual) {
                    Some some = new Some((Object)this.ff().greaterOrEqual((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else {
                    None$ none$2 = None$.MODULE$;
                }
                none$ = var4_18;
            }
            return none$;
        }
        if (expression2 instanceof In) {
            In in = (In)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression attr = in.value();
            Seq values = in.list();
            Option<Expression> baseExpr = this.sparkExprToGTExpr(attr);
            Seq otherExprs = (Seq)values.map((Function1 & Serializable & scala.Serializable)expression -> MODULE$.sparkExprToGTExpr((org.apache.spark.sql.catalyst.expressions.Expression)expression), Seq$.MODULE$.canBuildFrom());
            if (baseExpr.isEmpty()) return new Some((Object)Filter.INCLUDE);
            if (!otherExprs.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()))) return new Some((Object)this.ff().or((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)((TraversableLike)otherExprs.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDefined()))).map((Function1 & Serializable & scala.Serializable)expressionOpt -> MODULE$.ff().equals((Expression)baseExpr.get(), (Expression)MODULE$.ff().literal(expressionOpt.get())), Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()));
            return new Some((Object)Filter.INCLUDE);
        }
        if (expression2 instanceof UnaryExpression) {
            None$ none$;
            UnaryExpression unaryExpression = (UnaryExpression)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression sparkExpr = (org.apache.spark.sql.catalyst.expressions.Expression)unaryExpression.child();
            Option<Expression> gtExpr = this.sparkExprToGTExpr(sparkExpr);
            if (gtExpr.isEmpty()) {
                none$ = None$.MODULE$;
                return none$;
            } else {
                void var3_31;
                UnaryExpression unaryExpression2 = unaryExpression;
                if (unaryExpression2 instanceof IsNotNull) {
                    Some some = new Some((Object)this.ff().not((Filter)this.ff().isNull((Expression)gtExpr.get())));
                } else if (unaryExpression2 instanceof IsNull) {
                    Some some = new Some((Object)this.ff().isNull((Expression)gtExpr.get()));
                } else {
                    None$ none$3 = None$.MODULE$;
                }
                none$ = var3_31;
            }
            return none$;
        }
        if (expression2 instanceof Like) {
            Like like = (Like)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression left = like.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = like.right();
            if (left != null) {
                org.apache.spark.sql.catalyst.expressions.Expression expression3 = left;
                if (right != null) {
                    org.apache.spark.sql.catalyst.expressions.Expression expression4 = right;
                    Option<Expression> leftExpr = this.sparkExprToGTExpr(expression3);
                    Option rightExpr = this.sparkExprToGTExpr(expression4).map((Function1 & Serializable & scala.Serializable)x$4 -> (Literal)x$4);
                    return leftExpr.isEmpty() || rightExpr.isEmpty() ? None$.MODULE$ : new Some((Object)this.ff().like((Expression)leftExpr.get(), ((Literal)rightExpr.get()).getValue().toString()));
                }
            }
        }
        this.logger().debug(new StringBuilder(68).append("Got expr: ").append(expr).append(".  Don't know how to turn this into a GeoTools Expression.").toString());
        return None$.MODULE$;
    }

    public Option<Filter> arFunctoGTFilter(org.apache.spark.sql.catalyst.expressions.Expression udf) {
        AtlasRelationFunction atlasRelationFunction;
        org.apache.spark.sql.catalyst.expressions.Expression expression = udf;
        Option<Filter> option = expression instanceof AtlasRelationFunction && ((TreeNode)(atlasRelationFunction = (AtlasRelationFunction)expression)).children().length() == 2 ? this.buildGTFilter(atlasRelationFunction, (org.apache.spark.sql.catalyst.expressions.Expression)((TreeNode)atlasRelationFunction).children().head(), (org.apache.spark.sql.catalyst.expressions.Expression)((TreeNode)atlasRelationFunction).children().last()) : None$.MODULE$;
        return option;
    }

    private Option<Filter> buildGTFilter(AtlasRelationFunction expr, org.apache.spark.sql.catalyst.expressions.Expression exprA, org.apache.spark.sql.catalyst.expressions.Expression exprB) {
        return this.funcToFF(expr).flatMap((Function1 & Serializable & scala.Serializable)builder -> MODULE$.sparkExprToGTExpr(exprA).flatMap((Function1 & Serializable & scala.Serializable)gtExprA -> MODULE$.sparkExprToGTExpr(exprB).map((Function1 & Serializable & scala.Serializable)gtExprB -> (Filter)builder.apply(gtExprA, gtExprB))));
    }

    public Option<Function2<Expression, Expression, Filter>> funcToFF(AtlasRelationFunction expr) {
        return new Some((Function2 & Serializable & scala.Serializable)(expr1, expr2) -> expr.toGTFilter(expr1, expr2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Expression> sparkExprToGTExpr(org.apache.spark.sql.catalyst.expressions.Expression expression) {
        boolean bl = false;
        org.apache.spark.sql.catalyst.expressions.Literal literal = null;
        org.apache.spark.sql.catalyst.expressions.Expression expression2 = expression;
        if (expression2 instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression2;
            return new Some((Object)this.ff().property(unresolvedAttribute.name().toLowerCase()));
        }
        if (expression2 instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression2;
            String string = attributeReference.name();
            String string2 = "__fid__";
            if (string == null ? string2 != null : !string.equals(string2)) {
                return new Some((Object)this.ff().property(attributeReference.name().toLowerCase()));
            }
        }
        if (expression2 instanceof org.apache.spark.sql.catalyst.expressions.Literal) {
            bl = true;
            literal = (org.apache.spark.sql.catalyst.expressions.Literal)expression2;
            DataType dataType = literal.dataType();
            GeometryUDT$ geometryUDT$ = GeometryUDT$.MODULE$;
            if (dataType == null) {
                if (geometryUDT$ == null) return new Some((Object)this.ff().literal((Object)GeometryUDT$.MODULE$.deserialize(literal.value())));
            } else if (dataType.equals(geometryUDT$)) {
                return new Some((Object)this.ff().literal((Object)GeometryUDT$.MODULE$.deserialize(literal.value())));
            }
        }
        if (bl) {
            DataType dataType = literal.dataType();
            DataType dataType2 = DataTypes.StringType;
            if (dataType == null) {
                if (dataType2 == null) return new Some((Object)this.ff().literal(Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString()).orNull(Predef$.MODULE$.$conforms())));
            } else if (dataType.equals(dataType2)) {
                return new Some((Object)this.ff().literal(Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString()).orNull(Predef$.MODULE$.$conforms())));
            }
        }
        if (bl) {
            DataType dataType = literal.dataType();
            DataType dataType3 = DataTypes.TimestampType;
            if (dataType == null) {
                if (dataType3 == null) return new Some((Object)this.ff().literal((Object)new Date(BoxesRunTime.unboxToLong((Object)literal.value()) / 1000L)));
            } else if (dataType.equals(dataType3)) {
                return new Some((Object)this.ff().literal((Object)new Date(BoxesRunTime.unboxToLong((Object)literal.value()) / 1000L)));
            }
        }
        if (bl) {
            return new Some((Object)this.ff().literal(literal.value()));
        }
        this.logger().debug(new StringBuilder(37).append("Can't turn expression into geotools: ").append(expression).toString());
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Filter> sparkFilterAllToCQLFilter(org.apache.spark.sql.catalyst.expressions.Expression filterExpression) {
        BinaryComparison binaryComparison;
        Option option;
        org.apache.spark.sql.catalyst.expressions.Expression expression2 = filterExpression;
        if (expression2 instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression2)).isEmpty()) {
            Some some;
            org.apache.spark.sql.catalyst.expressions.Expression left = (org.apache.spark.sql.catalyst.expressions.Expression)((Tuple2)option.get())._1();
            org.apache.spark.sql.catalyst.expressions.Expression right = (org.apache.spark.sql.catalyst.expressions.Expression)((Tuple2)option.get())._2();
            Option<Expression> leftExpr = this.sparkExprToGTExpr(left);
            Option<Expression> rightExpr = this.sparkExprToGTExpr(right);
            if (leftExpr.isEmpty() || rightExpr.isEmpty()) {
                some = new Some((Object)Filter.INCLUDE);
                return some;
            } else {
                Some some2;
                BinaryComparison binaryComparison2 = binaryComparison;
                if (binaryComparison2 instanceof EqualTo) {
                    some2 = new Some((Object)this.ff().equals((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof LessThan) {
                    some2 = new Some((Object)this.ff().less((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof LessThanOrEqual) {
                    some2 = new Some((Object)this.ff().lessOrEqual((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof GreaterThan) {
                    some2 = new Some((Object)this.ff().greater((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else if (binaryComparison2 instanceof GreaterThanOrEqual) {
                    some2 = new Some((Object)this.ff().greaterOrEqual((Expression)leftExpr.get(), (Expression)rightExpr.get()));
                } else {
                    this.logger().info(new StringBuilder(7).append("\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f:").append(binaryComparison2.toString()).toString());
                    some2 = new Some((Object)Filter.INCLUDE);
                }
                some = some2;
            }
            return some;
        }
        if (expression2 instanceof In) {
            In in = (In)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression attr = in.value();
            Seq values = in.list();
            Option<Expression> baseExpr = this.sparkExprToGTExpr(attr);
            Seq otherExprs = (Seq)values.map((Function1 & Serializable & scala.Serializable)expression -> MODULE$.sparkExprToGTExpr((org.apache.spark.sql.catalyst.expressions.Expression)expression), Seq$.MODULE$.canBuildFrom());
            if (baseExpr.isEmpty()) return new Some((Object)Filter.INCLUDE);
            if (!otherExprs.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty()))) return new Some((Object)this.ff().or((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)((TraversableLike)otherExprs.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDefined()))).map((Function1 & Serializable & scala.Serializable)expressionOpt -> MODULE$.ff().equals((Expression)baseExpr.get(), (Expression)MODULE$.ff().literal(expressionOpt.get())), Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()));
            return new Some((Object)Filter.INCLUDE);
        }
        if (expression2 instanceof And) {
            And and = (And)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression left = and.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = and.right();
            return new Some((Object)this.ff().and((Filter)this.sparkFilterAllToCQLFilter(left).get(), (Filter)this.sparkFilterAllToCQLFilter(right).get()));
        }
        if (expression2 instanceof Or) {
            Or or = (Or)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression left = or.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = or.right();
            return new Some((Object)this.ff().or((Filter)this.sparkFilterAllToCQLFilter(left).get(), (Filter)this.sparkFilterAllToCQLFilter(right).get()));
        }
        if (expression2 instanceof Not) {
            Not not = (Not)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression f = not.child();
            return new Some((Object)this.ff().not((Filter)this.sparkFilterAllToCQLFilter(f).get()));
        }
        if (expression2 instanceof UnaryExpression) {
            Some some;
            UnaryExpression unaryExpression = (UnaryExpression)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression sparkExpr = (org.apache.spark.sql.catalyst.expressions.Expression)unaryExpression.child();
            Option<Expression> gtExpr = this.sparkExprToGTExpr(sparkExpr);
            if (gtExpr.isEmpty()) {
                some = new Some((Object)Filter.INCLUDE);
                return some;
            } else {
                Some some3;
                UnaryExpression unaryExpression2 = unaryExpression;
                if (unaryExpression2 instanceof IsNotNull) {
                    some3 = new Some((Object)this.ff().not((Filter)this.ff().isNull((Expression)gtExpr.get())));
                } else if (unaryExpression2 instanceof IsNull) {
                    some3 = new Some((Object)this.ff().isNull((Expression)gtExpr.get()));
                } else {
                    this.logger().info(new StringBuilder(7).append("\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f:").append(unaryExpression2.toString()).toString());
                    some3 = new Some((Object)Filter.INCLUDE);
                }
                some = some3;
            }
            return some;
        }
        if (expression2 instanceof Like) {
            Like like = (Like)expression2;
            org.apache.spark.sql.catalyst.expressions.Expression left = like.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = like.right();
            if (left != null) {
                org.apache.spark.sql.catalyst.expressions.Expression expression3 = left;
                if (right != null) {
                    org.apache.spark.sql.catalyst.expressions.Expression expression4 = right;
                    Option<Expression> leftExpr = this.sparkExprToGTExpr(expression3);
                    Option rightExpr = this.sparkExprToGTExpr(expression4).map((Function1 & Serializable & scala.Serializable)x$8 -> (Literal)x$8);
                    if (!leftExpr.isEmpty()) {
                        if (!rightExpr.isEmpty()) return new Some((Object)this.ff().like((Expression)leftExpr.get(), ((Literal)rightExpr.get()).getValue().toString()));
                    }
                    String x$1 = "\u4e0d\u652f\u6301\u7a7a\u8868\u8fbe\u5f0f";
                    Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                    int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                    throw new NotSupportException(x$1, x$2, x$3);
                }
            }
        }
        this.logger().info(new StringBuilder(7).append("\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f:").append(expression2.toString()).toString());
        return new Some((Object)Filter.INCLUDE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sparkFilterRelationAttr(org.apache.spark.sql.catalyst.expressions.Expression filterExpression, Buffer<String> attrs) {
        org.apache.spark.sql.catalyst.expressions.Expression expression;
        while (true) {
            org.apache.spark.sql.catalyst.expressions.Expression f;
            BinaryComparison binaryComparison;
            Option option;
            if ((expression = filterExpression) instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
                org.apache.spark.sql.catalyst.expressions.Expression left = (org.apache.spark.sql.catalyst.expressions.Expression)((Tuple2)option.get())._1();
                org.apache.spark.sql.catalyst.expressions.Expression right = (org.apache.spark.sql.catalyst.expressions.Expression)((Tuple2)option.get())._2();
                this.getSparkFilterAttr(left, attrs);
                this.getSparkFilterAttr(right, attrs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (expression instanceof In) {
                In in = (In)expression;
                org.apache.spark.sql.catalyst.expressions.Expression attr = in.value();
                this.getSparkFilterAttr(attr, attrs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (expression instanceof And) {
                And and = (And)expression;
                org.apache.spark.sql.catalyst.expressions.Expression left = and.left();
                org.apache.spark.sql.catalyst.expressions.Expression right = and.right();
                this.sparkFilterRelationAttr(left, attrs);
                filterExpression = right;
                continue;
            }
            if (expression instanceof Or) {
                Or or = (Or)expression;
                org.apache.spark.sql.catalyst.expressions.Expression left = or.left();
                org.apache.spark.sql.catalyst.expressions.Expression right = or.right();
                this.sparkFilterRelationAttr(left, attrs);
                filterExpression = right;
                continue;
            }
            if (!(expression instanceof Not)) break;
            Not not = (Not)expression;
            filterExpression = f = not.child();
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            org.apache.spark.sql.catalyst.expressions.Expression sparkExpr = (org.apache.spark.sql.catalyst.expressions.Expression)unaryExpression.child();
            this.getSparkFilterAttr(sparkExpr, attrs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (expression instanceof Like) {
            Like like = (Like)expression;
            org.apache.spark.sql.catalyst.expressions.Expression left = like.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = like.right();
            if (left != null) {
                org.apache.spark.sql.catalyst.expressions.Expression expression2 = left;
                if (right != null) {
                    this.getSparkFilterAttr(expression2, attrs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        this.logger().info(new StringBuilder(7).append("\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f:").append(expression.toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void getSparkFilterAttr(org.apache.spark.sql.catalyst.expressions.Expression expression, Buffer<String> attrs) {
        block6: {
            org.apache.spark.sql.catalyst.expressions.Expression expression2;
            while (true) {
                if ((expression2 = expression) instanceof UnresolvedAttribute) {
                    UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression2;
                    attrs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{unresolvedAttribute.name().toLowerCase()}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (expression2 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)expression2;
                    String string = attributeReference.name();
                    String string2 = "__fid__";
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        attrs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{attributeReference.name().toLowerCase()}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                }
                if (!(expression2 instanceof Cast)) break;
                Cast cast = (Cast)expression2;
                expression = cast.child();
            }
            if (expression2 instanceof org.apache.spark.sql.catalyst.expressions.Literal) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logger().debug(new StringBuilder(37).append("Can't turn expression into geotools: ").append(expression).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private AtlasDataSourceOptimization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.ff = CommonFactoryFinder.getFilterFactory2();
    }
}

