/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.dataset.vector.common;

import com.geoway.atlas.common.time.AtlasTimer$;
import com.geoway.atlas.common.utils.CollectionUtils$;
import com.geoway.atlas.common.utils.StringUtils$;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.data.AtlasDataName$;
import com.geoway.atlas.data.vector.common.feature.sft.deencode.SimpleFeatureTypes$;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema;
import com.geoway.atlas.dataset.vector.common.AtlasVectorSchema$;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AtlasVectorSchemas$ {
    public static AtlasVectorSchemas$ MODULE$;

    static {
        new AtlasVectorSchemas$();
    }

    public String encodeSft(SimpleFeatureType sft) {
        ObjectRef sftString = ObjectRef.create(null);
        AtlasTimer$.MODULE$.costTime("sft\u5e8f\u5217\u5316\u8017\u65f6", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String serializeName = sft.getName().toString();
            String serializeSft = SimpleFeatureTypes$.MODULE$.encodeType(sft, true);
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils$.MODULE$.hexEncodeFormat((short)serializeName.length())).append(serializeName).append(serializeSft);
            sftString$1.elem = sb.toString();
        });
        return (String)sftString.elem;
    }

    public SimpleFeatureType decodeSft(String string) {
        ObjectRef sft = ObjectRef.create(null);
        AtlasTimer$.MODULE$.costTime("sft\u53cd\u5e8f\u5217\u5316\u8017\u65f6", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            short nameLength = StringUtils$.MODULE$.hexDecodeShortFormat(StringUtils.substring((String)string, (int)0, (int)4));
            String serializeName = StringUtils.substring((String)string, (int)4, (int)(nameLength + 4));
            String sftString = StringUtils.substring((String)string, (int)(nameLength + 4));
            sft$2.elem = SimpleFeatureTypes$.MODULE$.createType(serializeName, sftString);
        });
        return (SimpleFeatureType)sft.elem;
    }

    public String encode(AtlasVectorSchema atlasVectorSchema) {
        ObjectRef avsString = ObjectRef.create(null);
        AtlasTimer$.MODULE$.costTime("avs\u5e8f\u5217\u5316\u8017\u65f6", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AtlasDataName dataName = atlasVectorSchema.dataName();
            String serializeName = AtlasDataName$.MODULE$.serializable(dataName);
            AtlasDataName originDataName = atlasVectorSchema.getOriginDataName();
            String serializeOriginName = null;
            serializeOriginName = originDataName != null ? AtlasDataName$.MODULE$.serializable(originDataName) : AtlasDataName$.MODULE$.serializable(new AtlasDataName("", ""));
            String serializeSft = MODULE$.encodeSft(atlasVectorSchema.getSimpleFeatureType());
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils$.MODULE$.hexEncodeFormat((short)serializeName.length())).append(serializeName).append(StringUtils$.MODULE$.hexEncodeFormat((short)serializeOriginName.length())).append(serializeOriginName).append(StringUtils$.MODULE$.hexEncodeFormat(serializeSft.length())).append(serializeSft);
            if (CollectionUtils$.MODULE$.nonEmpty(atlasVectorSchema.getSimpleFeatureTypes())) {
                atlasVectorSchema.getSimpleFeatureTypes().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    String serializeSubSft = MODULE$.encodeSft((SimpleFeatureType)atlasVectorSchema.getSimpleFeatureTypes().apply(i));
                    sb.append(StringUtils$.MODULE$.hexEncodeFormat(serializeSubSft.length())).append(serializeSubSft);
                });
            }
            avsString$1.elem = sb.toString();
        });
        return (String)avsString.elem;
    }

    public AtlasVectorSchema decode(String schemaString) {
        ObjectRef avs = ObjectRef.create(null);
        AtlasTimer$.MODULE$.costTime("avs\u53cd\u5e8f\u5217\u5316\u8017\u65f6", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int offset = 0;
            short dataNameLength = StringUtils$.MODULE$.hexDecodeShortFormat(StringUtils.substring((String)schemaString, (int)offset, (int)(offset + 4)));
            String serializeName = StringUtils.substring((String)schemaString, (int)(offset += 4), (int)(offset + dataNameLength));
            AtlasDataName atlasDataName = AtlasDataName$.MODULE$.deserializable(serializeName);
            short originNameLength = StringUtils$.MODULE$.hexDecodeShortFormat(StringUtils.substring((String)schemaString, (int)(offset += dataNameLength), (int)(offset + 4)));
            String originName = StringUtils.substring((String)schemaString, (int)(offset += 4), (int)(offset + originNameLength));
            AtlasDataName originDataName = AtlasDataName$.MODULE$.deserializable(originName);
            int sftLength = StringUtils$.MODULE$.hexDecodeIntFormat(StringUtils.substring((String)schemaString, (int)(offset += originNameLength), (int)(offset + 8)));
            String mainSftString = StringUtils.substring((String)schemaString, (int)(offset += 8), (int)(offset + sftLength));
            offset += sftLength;
            SimpleFeatureType mainSft = MODULE$.decodeSft(mainSftString);
            Buffer sftSeq = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (offset < schemaString.length()) {
                int subSftLength = StringUtils$.MODULE$.hexDecodeIntFormat(StringUtils.substring((String)schemaString, (int)offset, (int)(offset + 8)));
                String subSftString = StringUtils.substring((String)schemaString, (int)(offset += 8), (int)(offset + subSftLength));
                sftSeq.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeatureType[]{MODULE$.decodeSft(subSftString)}));
                offset += subSftLength;
            }
            avs$1.elem = AtlasVectorSchema$.MODULE$.apply(atlasDataName);
            ((AtlasVectorSchema)((Object)((Object)avs$1.elem))).setSimpleFeatureType(mainSft);
            ((AtlasVectorSchema)((Object)((Object)avs$1.elem))).setSimpleFeatureTypes((Seq<SimpleFeatureType>)sftSeq);
            ((AtlasVectorSchema)((Object)((Object)avs$1.elem))).setOriginDataName(originDataName);
        });
        return (AtlasVectorSchema)((Object)avs.elem);
    }

    public AtlasVectorSchema decode(AtlasDataName atlasDataName, String schemaString) {
        ObjectRef avs = ObjectRef.create(null);
        AtlasTimer$.MODULE$.costTime("avs\u53cd\u5e8f\u5217\u5316\u8017\u65f6", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int offset = 0;
            short dataNameLength = StringUtils$.MODULE$.hexDecodeShortFormat(StringUtils.substring((String)schemaString, (int)offset, (int)(offset + 4)));
            String serializeName = StringUtils.substring((String)schemaString, (int)(offset += 4), (int)(offset + dataNameLength));
            AtlasDataName restoreAtlasDataName = AtlasDataName$.MODULE$.deserializable(serializeName);
            short originNameLength = StringUtils$.MODULE$.hexDecodeShortFormat(StringUtils.substring((String)schemaString, (int)(offset += dataNameLength), (int)(offset + 4)));
            String originName = StringUtils.substring((String)schemaString, (int)(offset += 4), (int)(offset + originNameLength));
            AtlasDataName originDataName = AtlasDataName$.MODULE$.deserializable(originName);
            int sftLength = StringUtils$.MODULE$.hexDecodeIntFormat(StringUtils.substring((String)schemaString, (int)(offset += originNameLength), (int)(offset + 8)));
            String mainSftString = StringUtils.substring((String)schemaString, (int)(offset += 8), (int)(offset + sftLength));
            offset += sftLength;
            SimpleFeatureType mainSft = MODULE$.decodeSft(mainSftString);
            Buffer sftSeq = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (offset < schemaString.length()) {
                int subSftLength = StringUtils$.MODULE$.hexDecodeIntFormat(StringUtils.substring((String)schemaString, (int)offset, (int)(offset + 8)));
                String subSftString = StringUtils.substring((String)schemaString, (int)(offset += 8), (int)(offset + subSftLength));
                sftSeq.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeatureType[]{MODULE$.decodeSft(subSftString)}));
                offset += subSftLength;
            }
            avs$2.elem = AtlasVectorSchema$.MODULE$.apply(atlasDataName);
            ((AtlasVectorSchema)((Object)((Object)avs$2.elem))).setSimpleFeatureType(mainSft);
            ((AtlasVectorSchema)((Object)((Object)avs$2.elem))).setSimpleFeatureTypes((Seq<SimpleFeatureType>)sftSeq);
            ((AtlasVectorSchema)((Object)((Object)avs$2.elem))).setOriginDataName(originDataName);
        });
        return (AtlasVectorSchema)((Object)avs.elem);
    }

    private AtlasVectorSchemas$() {
        MODULE$ = this;
    }
}

