/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.framework.spark.common;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.CancelOpException;
import com.geoway.atlas.common.error.CancelOpException$;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.common.utils.RuntimeUtils$;
import com.geoway.atlas.framework.spark.common.SparkRuntime;
import com.geoway.atlas.framework.spark.common.SparkRuntime$StartMode$;
import com.geoway.atlas.framework.spark.common.register.SqlRegister$;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.LongAccumulator;
import org.graphframes.GraphFrame;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class SparkRuntime$
implements LazyLogging {
    public static SparkRuntime$ MODULE$;
    private final String ATLAS_TOTAL_EXECUTOR_NUM;
    private final String LOCAL_DIR;
    private final String APP_NAME;
    private final String ATLAS_TASK_ID;
    private final String DEFAULT_STORAGE_LEVEL;
    private SparkSession sparkSession;
    private final Try<Function3<LogicalRelation, BaseRelation, Seq<AttributeReference>, LogicalRelation>> com$geoway$atlas$framework$spark$common$SparkRuntime$$_copyLogicalRelation;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SparkRuntime$();
    }

    private Logger logger$lzycompute() {
        SparkRuntime$ sparkRuntime$ = this;
        synchronized (sparkRuntime$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String ATLAS_TOTAL_EXECUTOR_NUM() {
        return this.ATLAS_TOTAL_EXECUTOR_NUM;
    }

    public String LOCAL_DIR() {
        return this.LOCAL_DIR;
    }

    public String APP_NAME() {
        return this.APP_NAME;
    }

    public String ATLAS_TASK_ID() {
        return this.ATLAS_TASK_ID;
    }

    public String DEFAULT_STORAGE_LEVEL() {
        return this.DEFAULT_STORAGE_LEVEL;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private void sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    public void startLocal() {
        this.start(SparkRuntime$StartMode$.MODULE$.LOCAL(), this.APP_NAME(), -1.0, 1, RuntimeUtils$.MODULE$.getPhysicsCores());
    }

    public void startCluster(String appName, double memoryFunc, int numExecutors, int executorCores) {
        this.start(SparkRuntime$StartMode$.MODULE$.CLUSTER(), appName, memoryFunc, numExecutors, executorCores);
    }

    public void start(String startMode, String appName, double memoryFunc, int numExecutors, int executorCores) {
        SparkRuntime sparkRuntime = new SparkRuntime(startMode, appName, memoryFunc, numExecutors, executorCores);
        this.sparkSession_$eq(sparkRuntime.start());
        this.sqlRegister();
    }

    public void sqlRegister() {
        SqlRegister$.MODULE$.registerUDT();
        SqlRegister$.MODULE$.registerFunction();
        SqlRegister$.MODULE$.registerOptimizations();
    }

    public SparkSession getSparkSession() {
        if (this.sparkSession() == null) {
            String x$1 = "\u672a\u53d1\u73b0SparkSession!";
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$1);
            throw new NotFoundException(x$1, x$2, x$3);
        }
        if (this.sparkSession().sparkContext().isStopped()) {
            String x$4 = "\u5f53\u524dSpark\u8fd0\u884c\u65f6\u5df2\u505c\u6b62!";
            Thread x$5 = CancelOpException$.MODULE$.apply$default$2(x$4);
            int x$6 = CancelOpException$.MODULE$.apply$default$3(x$4);
            throw new CancelOpException(x$4, x$5, x$6);
        }
        return this.sparkSession();
    }

    public SparkContext getSparkContext() {
        return this.getSparkSession().sparkContext();
    }

    public <T> Broadcast<T> broadcast(T value, ClassTag<T> evidence$1) {
        return this.getSparkContext().broadcast(value, evidence$1);
    }

    public <T> Option<Object> persist(RDD<T> rdd) {
        return this.persist(rdd, null, false);
    }

    public <T> Option<Object> persist(RDD<T> rdd, boolean isTempData) {
        return this.persist(rdd, null, isTempData);
    }

    public void persist(String viewName) {
        this.getSparkSession().sql(new StringBuilder(12).append("cache table ").append(viewName).toString());
    }

    public void persist(Dataset<Row> dataFrame, String viewName) {
        block1: {
            block0: {
                if (!StringUtils.isNotBlank((CharSequence)viewName)) break block0;
                dataFrame.createOrReplaceTempView(viewName);
                this.persist(viewName);
                long count = dataFrame.count();
                this.logger().info(new StringBuilder(7).append("\u6570\u636e\u96c6\u6570\u91cf\u4e3a:").append(count).toString());
                break block1;
            }
            if (dataFrame.storageLevel().isValid()) break block1;
            dataFrame.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
            long count = dataFrame.count();
            this.logger().info(new StringBuilder(7).append("\u6570\u636e\u96c6\u6570\u91cf\u4e3a:").append(count).toString());
        }
    }

    public void persist(GraphFrame graphFrame) {
        this.persist(graphFrame.vertices(), null);
        this.persist(graphFrame.edges(), null);
    }

    public void unPersist(GraphFrame graphFrame) {
        this.unPersist(graphFrame.vertices());
        this.unPersist(graphFrame.edges());
    }

    public <T> Option<Object> persist(RDD<T> rdd, String rddName, boolean isTempData) {
        None$ none$;
        if (!rdd.getStorageLevel().isValid()) {
            if (StringUtils.isNotBlank((CharSequence)rddName)) {
                rdd.setName(rddName);
                rdd.persist(this.getDefaultStorageLevel());
                this.logger().info(new StringBuilder(8).append("\u6301\u4e45\u5316\u6570\u636e\u96c6: ").append(rddName).toString());
                long count = rdd.count();
                this.logger().info(new StringBuilder(7).append("\u6570\u636e\u96c6\u6570\u91cf\u4e3a:").append(count).toString());
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)count));
            } else {
                rdd.persist(this.getDefaultStorageLevel());
                this.logger().info(new StringBuilder(8).append("\u6301\u4e45\u5316\u6570\u636e\u96c6: ").append(rdd.name()).toString());
                long count = rdd.count();
                this.logger().info(new StringBuilder(7).append("\u6570\u636e\u96c6\u6570\u91cf\u4e3a:").append(count).toString());
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)count));
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <T> void unPersist(RDD<T> rdd) {
        block0: {
            if (!rdd.getStorageLevel().isValid()) break block0;
            rdd.unpersist(rdd.unpersist$default$1());
        }
    }

    public void unPersist(String viewName) {
        this.getSparkSession().sql(new StringBuilder(24).append("uncache table if exists ").append(viewName).toString());
    }

    public void unPersist(Dataset<Row> dataFrame) {
        dataFrame.unpersist();
    }

    public String getExecutorId() {
        return SparkEnv$.MODULE$.get().executorId();
    }

    public int getTotalExecutorNums() {
        return new StringOps(Predef$.MODULE$.augmentString(this.sparkSession().sparkContext().getConf().get(this.ATLAS_TOTAL_EXECUTOR_NUM()))).toInt();
    }

    public StorageLevel getDefaultStorageLevel() {
        String defaultStorageLevel = AtlasSystemProperties$.MODULE$.getProperty(this.DEFAULT_STORAGE_LEVEL());
        return StringUtils.isNotEmpty((CharSequence)defaultStorageLevel) ? StorageLevel$.MODULE$.fromString(defaultStorageLevel) : StorageLevel$.MODULE$.MEMORY_AND_DISK_SER();
    }

    public RDD<Object> getAllExecutorRDD() {
        int totalExecutorNums = this.getTotalExecutorNums();
        return this.getSparkSession().sparkContext().parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalExecutorNums), totalExecutorNums, ClassTag$.MODULE$.Int());
    }

    public LongAccumulator getLongAccumulator(String name) {
        return this.sparkSession().sparkContext().longAccumulator(name);
    }

    public void renameTable(String rawName, String newName) {
        this.sql(new StringBuilder(22).append("ALTER VIEW ").append(rawName).append(" RENAME TO ").append(newName).toString());
    }

    public Dataset<Row> sql(String sqlString) {
        this.logger().info(new StringBuilder(13).append("\u6267\u884cSparkSql : ").append(sqlString).toString());
        return this.sparkSession().sql(sqlString);
    }

    public Try<Function3<LogicalRelation, BaseRelation, Seq<AttributeReference>, LogicalRelation>> com$geoway$atlas$framework$spark$common$SparkRuntime$$_copyLogicalRelation() {
        return this.com$geoway$atlas$framework$spark$common$SparkRuntime$$_copyLogicalRelation;
    }

    public LogicalRelation copy(LogicalRelation r) {
        return r;
    }

    public void setLocalProperty(String key, String value) {
        this.sparkSession().sparkContext().setLocalProperty(key, value);
    }

    public <T> Map<String, String> tryPersist(RDD<T> rdd, StorageLevel storageLevel, Function2<RDD<T>, Object, Map<String, String>> fn) {
        Map map;
        try {
            rdd.persist(storageLevel);
            long count = rdd.count();
            map = (Map)fn.apply(rdd, (Object)BoxesRunTime.boxToLong((long)count));
        }
        catch (Throwable throwable) {
            rdd.unpersist(rdd.unpersist$default$1());
            throw throwable;
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$_copyLogicalRelation$2(Method m) {
        String string = m.getName();
        String string2 = "copy";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).contains((Object)BoxesRunTime.boxToInteger((int)m.getParameterCount()))) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$_copyLogicalRelation$4(Method x$3) {
        String string = x$3.getName();
        String string2 = "isStreaming";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private SparkRuntime$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.ATLAS_TOTAL_EXECUTOR_NUM = "atlas.spark.total.executor.num";
        this.LOCAL_DIR = "D:\\workspace\\sparkTemp";
        this.APP_NAME = "Atlas-GSpark";
        this.ATLAS_TASK_ID = "atlas.task.id";
        this.DEFAULT_STORAGE_LEVEL = "atlas.spark.default.storage.level";
        this.com$geoway$atlas$framework$spark$common$SparkRuntime$$_copyLogicalRelation = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Function3 & Serializable & scala.Serializable intersect;
            Method[] methods = LogicalRelation.class.getMethods();
            Method m2 = (Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)SparkRuntime$.$anonfun$_copyLogicalRelation$2(m))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NoSuchMethodError(new StringBuilder(44).append("Could not find method named 'copy' in class ").append(LogicalRelation.class.getName()).toString());
            });
            if (m2.getParameterCount() == 4) {
                Method streaming = (Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkRuntime$.$anonfun$_copyLogicalRelation$4(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NoSuchMethodError(new StringBuilder(51).append("Could not find method named 'isStreaming' in class ").append(LogicalRelation.class.getName()).toString());
                });
                intersect = (Function3 & Serializable & scala.Serializable)(r, b, o) -> (LogicalRelation)m2.invoke(r, b, o, r.catalogTable(), streaming.invoke(r, new Object[0]));
            } else {
                intersect = (Function3 & Serializable & scala.Serializable)(r, b, o) -> (LogicalRelation)m2.invoke(r, b, o, r.catalogTable());
            }
            return intersect;
        });
    }
}

