/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.framework.spark.common.sql;

import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.framework.spark.common.sql.IndexRange;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedWith;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class SqlTreeParser$
implements LazyLogging {
    public static SqlTreeParser$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SqlTreeParser$();
    }

    private Logger logger$lzycompute() {
        SqlTreeParser$ sqlTreeParser$ = this;
        synchronized (sqlTreeParser$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public LogicalPlan parserSql(String sqlString) {
        return SparkRuntime$.MODULE$.getSparkSession().sessionState().sqlParser().parsePlan(sqlString);
    }

    public void extractRelatedTable(LogicalPlan plan, Buffer<UnresolvedRelation> relations, Buffer<UnresolvedStar> stars, Buffer<UnresolvedAttribute> attributes) {
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            relations.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedRelation[]{unresolvedRelation}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (logicalPlan instanceof LeafNode) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Seq expressions = plan.expressions();
            if (expressions.nonEmpty()) {
                expressions.foreach((Function1 & Serializable & scala.Serializable)ep -> {
                    SqlTreeParser$.MODULE$.visitor(ep, (Buffer<UnresolvedRelation>)relations, (Buffer<UnresolvedStar>)stars, (Buffer<UnresolvedAttribute>)attributes);
                    return BoxedUnit.UNIT;
                });
            }
            Iterator pIterator = plan.children().iterator();
            while (pIterator.hasNext()) {
                this.visitor((LogicalPlan)pIterator.next(), relations, stars, attributes);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void visitor(LogicalPlan plan, Buffer<UnresolvedRelation> relations, Buffer<UnresolvedStar> stars, Buffer<UnresolvedAttribute> attributes) {
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            relations.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedRelation[]{unresolvedRelation}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (logicalPlan instanceof UnresolvedWith) {
            UnresolvedWith unresolvedWith = (UnresolvedWith)logicalPlan;
            this.visitor(unresolvedWith.child(), relations, stars, attributes);
            LogicalPlan[] logicalPlans = (LogicalPlan[])((TraversableOnce)unresolvedWith.cteRelations().map((Function1 & Serializable & scala.Serializable)x$1 -> ((SubqueryAlias)x$1._2()).child(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalPlan.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logicalPlans)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> MODULE$.visitor(logicalPlans[i], relations, stars, attributes));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (logicalPlan instanceof LeafNode) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Seq expressions = plan.expressions();
            if (expressions.nonEmpty()) {
                expressions.foreach((Function1 & Serializable & scala.Serializable)ep -> {
                    SqlTreeParser$.MODULE$.visitor(ep, (Buffer<UnresolvedRelation>)relations, (Buffer<UnresolvedStar>)stars, (Buffer<UnresolvedAttribute>)attributes);
                    return BoxedUnit.UNIT;
                });
            }
            for (LogicalPlan pClildren : plan.children()) {
                this.visitor(pClildren, relations, stars, attributes);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void visitor(Expression expression, Buffer<UnresolvedRelation> relations, Buffer<UnresolvedStar> stars, Buffer<UnresolvedAttribute> attributes) {
        Expression expression2 = expression;
        if (expression2 instanceof UnresolvedStar) {
            UnresolvedStar unresolvedStar = (UnresolvedStar)expression2;
            stars.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedStar[]{unresolvedStar}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression2 instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression2;
            attributes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{unresolvedAttribute}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression2 instanceof SubqueryExpression) {
            SubqueryExpression subqueryExpression = (SubqueryExpression)expression2;
            this.visitor((LogicalPlan)subqueryExpression.plan(), relations, stars, attributes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            Seq eps = expression2.children();
            if (eps.nonEmpty()) {
                eps.foreach((Function1 & Serializable & scala.Serializable)subEp -> {
                    SqlTreeParser$.MODULE$.visitor(subEp, (Buffer<UnresolvedRelation>)relations, (Buffer<UnresolvedStar>)stars, (Buffer<UnresolvedAttribute>)attributes);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public String replaceTableName(String rawSqlString, Map<String, String> replaceTableMap) {
        String string;
        this.logger().info(new StringBuilder(11).append("\u83b7\u53d6\u5230\u539f\u59cbsql\u4e3a:\n").append(rawSqlString).toString());
        String sqlString = StringUtils.replaceEach((String)rawSqlString, (String[])((String[])((Object[])new String[]{"\r", "\n"})), (String[])((String[])((Object[])new String[]{" ", " "})));
        LogicalPlan logicalPlan = this.parserSql(sqlString);
        ArrayBuffer unresolvedRelations = new ArrayBuffer();
        ArrayBuffer unresolvedStars = new ArrayBuffer();
        ArrayBuffer unresolvedAttributes = new ArrayBuffer();
        String[] lowTableNames = (String[])((TraversableOnce)replaceTableMap.keySet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        Map lowReplaceTableMap = (Map)replaceTableMap.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((String)kv._1()).toLowerCase(), kv._2()), Map$.MODULE$.canBuildFrom());
        this.visitor(logicalPlan, (Buffer<UnresolvedRelation>)unresolvedRelations, (Buffer<UnresolvedStar>)unresolvedStars, (Buffer<UnresolvedAttribute>)unresolvedAttributes);
        scala.collection.mutable.StringBuilder nSqlBuilder = new scala.collection.mutable.StringBuilder();
        ObjectRef replacePoints = ObjectRef.create((Object)new ArrayBuffer());
        if (unresolvedRelations.nonEmpty()) {
            unresolvedRelations.foreach((Function1 & Serializable & scala.Serializable)unresolvedRelation -> {
                SqlTreeParser$.$anonfun$replaceTableName$3(lowTableNames, sqlString, lowReplaceTableMap, replacePoints, unresolvedRelation);
                return BoxedUnit.UNIT;
            });
        }
        if (unresolvedStars.nonEmpty()) {
            unresolvedStars.foreach((Function1 & Serializable & scala.Serializable)unresolvedStar -> {
                SqlTreeParser$.$anonfun$replaceTableName$4(lowTableNames, sqlString, lowReplaceTableMap, replacePoints, unresolvedStar);
                return BoxedUnit.UNIT;
            });
        }
        if (unresolvedAttributes.nonEmpty()) {
            unresolvedAttributes.foreach((Function1 & Serializable & scala.Serializable)unresolvedAttribute -> {
                SqlTreeParser$.$anonfun$replaceTableName$5(lowTableNames, sqlString, lowReplaceTableMap, replacePoints, unresolvedAttribute);
                return BoxedUnit.UNIT;
            });
        }
        replacePoints.elem = (ArrayBuffer)((ArrayBuffer)replacePoints.elem).sortBy((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToInteger((int)SqlTreeParser$.$anonfun$replaceTableName$6(tuple)), (Ordering)Ordering.Int$.MODULE$);
        IntRef lastEndIndex = IntRef.create((int)-1);
        ((ArrayBuffer)replacePoints.elem).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTreeParser$.$anonfun$replaceTableName$7(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            SqlTreeParser$.$anonfun$replaceTableName$8(lastEndIndex, nSqlBuilder, sqlString, x$3);
            return BoxedUnit.UNIT;
        });
        if (lastEndIndex.elem != -1) {
            nSqlBuilder.append(sqlString.substring(lastEndIndex.elem));
            string = nSqlBuilder.toString();
        } else {
            string = sqlString;
        }
        String nSql = string;
        this.logger().info(new StringBuilder(9).append("\u8f6c\u6362\u540eSql\u4e3a:\n").append(nSql).toString());
        return nSql;
    }

    private String getReplaceSql(IndexRange range, String tableName, Map<String, String> tableMap) {
        String nTableName = (String)tableMap.apply((Object)tableName);
        return range.tableBackticks() ? new StringBuilder(2).append("`").append(nTableName).append("`").toString() : nTableName;
    }

    private String getReplaceSql(IndexRange range, String tableName, Map<String, String> tableMap, String attributeString) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        String nTableName = (String)tableMap.apply((Object)tableName);
        scala.collection.mutable.StringBuilder stringBuilder = range.tableBackticks() ? sb.append(new StringBuilder(2).append("`").append(nTableName).append("`").toString()) : sb.append(nTableName);
        sb.append(".");
        scala.collection.mutable.StringBuilder stringBuilder2 = range.attributeBackticks() ? sb.append(new StringBuilder(2).append("`").append(attributeString).append("`").toString()) : sb.append(attributeString);
        return sb.toString();
    }

    private IndexRange getRange(String context, int startIndex, String tableName, String lastMark) {
        int lastIndex;
        boolean tableBackticks = false;
        boolean attributeBackticks = false;
        int tbnIndex = StringUtils.indexOf((CharSequence)context, (CharSequence)tableName, (int)startIndex);
        if (tbnIndex != startIndex) {
            tableBackticks = true;
        }
        if ((lastIndex = StringUtils.indexOf((CharSequence)context, (CharSequence)lastMark, (int)(tbnIndex + tableName.length())) + lastMark.length()) < context.length() && ((Object)BoxesRunTime.boxToCharacter((char)context.charAt(lastIndex))).equals(BoxesRunTime.boxToCharacter((char)'`'))) {
            ++lastIndex;
            attributeBackticks = true;
        }
        return new IndexRange(startIndex, lastIndex, tableBackticks, attributeBackticks);
    }

    public static final /* synthetic */ void $anonfun$replaceTableName$3(String[] lowTableNames$1, String sqlString$1, Map lowReplaceTableMap$1, ObjectRef replacePoints$1, UnresolvedRelation unresolvedRelation) {
        block0: {
            int sqlStartPoint = BoxesRunTime.unboxToInt((Object)unresolvedRelation.origin().startPosition().get());
            String tableName = unresolvedRelation.tableName();
            String lowerTableName = tableName.toLowerCase();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lowTableNames$1)).contains((Object)lowerTableName)) break block0;
            int tbIndex = StringUtils.indexOf((CharSequence)sqlString$1, (CharSequence)tableName, (int)sqlStartPoint);
            IndexRange replaceRange = tbIndex == sqlStartPoint ? new IndexRange(sqlStartPoint, sqlStartPoint + tableName.length(), false, false) : new IndexRange(sqlStartPoint, sqlStartPoint + tableName.length() + 2, true, false);
            String nTableName = MODULE$.getReplaceSql(replaceRange, lowerTableName, (Map<String, String>)lowReplaceTableMap$1);
            ((ArrayBuffer)replacePoints$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)replaceRange, (Object)nTableName)}));
        }
    }

    public static final /* synthetic */ void $anonfun$replaceTableName$4(String[] lowTableNames$1, String sqlString$1, Map lowReplaceTableMap$1, ObjectRef replacePoints$1, UnresolvedStar unresolvedStar) {
        block1: {
            if (!unresolvedStar.target().nonEmpty() || !((TraversableOnce)unresolvedStar.target().get()).nonEmpty()) break block1;
            String tableName = (String)((IterableLike)unresolvedStar.target().get()).head();
            String lowerTableName = tableName.toLowerCase();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lowTableNames$1)).contains((Object)lowerTableName)) {
                IndexRange starRange = MODULE$.getRange(sqlString$1, BoxesRunTime.unboxToInt((Object)unresolvedStar.origin().startPosition().get()), (String)((IterableLike)unresolvedStar.target().get()).head(), "*");
                String nTableName = MODULE$.getReplaceSql(starRange, lowerTableName, (Map<String, String>)lowReplaceTableMap$1);
                ((ArrayBuffer)replacePoints$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)starRange, (Object)new StringBuilder(2).append(nTableName).append(".*").toString())}));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$replaceTableName$5(String[] lowTableNames$1, String sqlString$1, Map lowReplaceTableMap$1, ObjectRef replacePoints$1, UnresolvedAttribute unresolvedAttribute) {
        block1: {
            if (unresolvedAttribute.nameParts().size() != 2) break block1;
            String tableName = (String)unresolvedAttribute.nameParts().head();
            String lowerTableName = tableName.toLowerCase();
            String attributeName = (String)unresolvedAttribute.nameParts().last();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lowTableNames$1)).contains((Object)lowerTableName)) {
                IndexRange attributeRange = MODULE$.getRange(sqlString$1, BoxesRunTime.unboxToInt((Object)unresolvedAttribute.origin().startPosition().get()), tableName, (String)unresolvedAttribute.nameParts().last());
                String nTableAttribute = MODULE$.getReplaceSql(attributeRange, lowerTableName, (Map<String, String>)lowReplaceTableMap$1, attributeName);
                ((ArrayBuffer)replacePoints$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)attributeRange, (Object)nTableAttribute)}));
            }
        }
    }

    public static final /* synthetic */ int $anonfun$replaceTableName$6(Tuple2 tuple) {
        return ((IndexRange)tuple._1()).startIncludeIndex();
    }

    public static final /* synthetic */ boolean $anonfun$replaceTableName$7(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$replaceTableName$8(IntRef lastEndIndex$1, scala.collection.mutable.StringBuilder nSqlBuilder$1, String sqlString$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexRange index = (IndexRange)tuple2._1();
        String text = (String)tuple2._2();
        scala.collection.mutable.StringBuilder stringBuilder = lastEndIndex$1.elem == -1 ? nSqlBuilder$1.append(sqlString$1.substring(0, index.startIncludeIndex())) : nSqlBuilder$1.append(sqlString$1.substring(lastEndIndex$1.elem, index.startIncludeIndex()));
        nSqlBuilder$1.append(text);
        lastEndIndex$1.elem = index.endExcludeIndex();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SqlTreeParser$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

