/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.examples;

import java.io.Serializable;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.examples.BeliefPropagation;
import org.graphframes.examples.Graphs$;
import org.graphframes.lib.AggregateMessages$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class BeliefPropagation$ {
    public static BeliefPropagation$ MODULE$;

    static {
        new BeliefPropagation$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("BeliefPropagation example").getOrCreate();
        GraphFrame g = Graphs$.MODULE$.gridIsingModel(spark, 3);
        Predef$.MODULE$.println((Object)"Original Ising model:");
        g.vertices().show();
        g.edges().show();
        int numIter = 5;
        GraphFrame results = this.runBPwithGraphX(g, numIter);
        Dataset beliefs = results.vertices().select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"belief"}));
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("Done with BP. Final beliefs after ").append(numIter).append(" iterations:").toString());
        beliefs.show();
        spark.stop();
    }

    private GraphFrame colorGraph(GraphFrame g) {
        UserDefinedFunction colorUDF = functions$.MODULE$.udf((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(i, j) -> (i + j) % 2, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int());
        Dataset v = g.vertices().withColumn("color", colorUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("i"), functions$.MODULE$.col("j")})));
        return GraphFrame$.MODULE$.apply((Dataset<Row>)v, g.edges());
    }

    public GraphFrame runBPwithGraphX(GraphFrame g, int numIter) {
        GraphFrame colorG = this.colorGraph(g);
        int numColors = (int)colorG.vertices().select("color", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        Graph<Row, Row> gx0 = colorG.toGraphX();
        Map<String, Object> vColsMap = colorG.vertexColumnMap();
        Map<String, Object> eColsMap = colorG.edgeColumnMap();
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BeliefPropagation$.$anonfun$runBPwithGraphX$1(vColsMap, BoxesRunTime.unboxToLong((Object)x0$1), x1$1);
        ClassTag x$2 = ClassTag$.MODULE$.apply(BeliefPropagation.VertexAttr.class);
        Null$ x$32 = gx0.mapVertices$default$3((Function2)x$1);
        Graph gx1 = gx0.mapVertices((Function2)x$1, x$2, null);
        Function1 & Serializable & scala.Serializable extractEdgeAttr = (Function1 & Serializable & scala.Serializable)e -> new BeliefPropagation.EdgeAttr(((Row)e.attr()).getDouble(BoxesRunTime.unboxToInt((Object)eColsMap.apply((Object)"b"))));
        ObjectRef gx = ObjectRef.create((Object)gx1.mapEdges((Function1)extractEdgeAttr, ClassTag$.MODULE$.apply(BeliefPropagation.EdgeAttr.class)));
        package$.MODULE$.Range().apply(0, numIter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> package$.MODULE$.Range().apply(0, numColors).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)color -> {
            Graph qual$1 = (Graph)gx$1.elem;
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)ctx -> {
                BeliefPropagation$.$anonfun$runBPwithGraphX$5(color, ctx);
                return BoxedUnit.UNIT;
            };
            JFunction2.mcDDD.sp & Serializable & scala.Serializable x$5 = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2;
            TripletFields x$6 = qual$1.aggregateMessages$default$3();
            VertexRDD msgs = qual$1.aggregateMessages((Function1)x$4, (Function2)x$5, x$6, ClassTag$.MODULE$.Double());
            gx$1.elem = ((Graph)gx$1.elem).outerJoinVertices((RDD)msgs, (Function3 & Serializable & scala.Serializable)(x0$2, x1$2, x2$1) -> BeliefPropagation$.$anonfun$runBPwithGraphX$7(color, BoxesRunTime.unboxToLong((Object)x0$2), x1$2, x2$1), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BeliefPropagation.VertexAttr.class), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        }));
        Graph qual$2 = (Graph)gx.elem;
        Function2 & Serializable & scala.Serializable x$7 = (Function2 & Serializable & scala.Serializable)(x$3, attr) -> BoxesRunTime.boxToDouble((double)attr.belief());
        ClassTag x$8 = ClassTag$.MODULE$.Double();
        Null$ x$9 = qual$2.mapVertices$default$3((Function2)x$7);
        Graph gxFinal = qual$2.mapVertices((Function2)x$7, x$8, null).mapEdges((Function1 & Serializable & scala.Serializable)x$4 -> {
            BeliefPropagation$.$anonfun$runBPwithGraphX$10(x$4);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.Unit());
        return GraphFrame$.MODULE$.fromGraphX(colorG, gxFinal, (Seq<String>)((Seq)new .colon.colon((Object)"belief", (List)Nil$.MODULE$)), GraphFrame$.MODULE$.fromGraphX$default$4(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Unit());
    }

    public GraphFrame runBPwithGraphFrames(GraphFrame g, int numIter) {
        GraphFrame colorG = this.colorGraph(g);
        int numColors = (int)colorG.vertices().select("color", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        ObjectRef gx = ObjectRef.create((Object)GraphFrame$.MODULE$.apply((Dataset<Row>)colorG.vertices().withColumn("belief", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))), colorG.edges()));
        package$.MODULE$.Range().apply(0, numIter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> package$.MODULE$.Range().apply(0, numColors).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)color -> {
            AggregateMessages$ AM = AggregateMessages$.MODULE$;
            Column msgForSrc = functions$.MODULE$.when(AM.src().apply((Object)"color").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)color)), (Object)AM.edge().apply((Object)"b").$times((Object)AM.dst().apply((Object)"belief")));
            Column msgForDst = functions$.MODULE$.when(AM.dst().apply((Object)"color").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)color)), (Object)AM.edge().apply((Object)"b").$times((Object)AM.src().apply((Object)"belief")));
            UserDefinedFunction logistic = functions$.MODULE$.udf((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> scala.math.package$.MODULE$.exp(-MODULE$.log1pExp(-x)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double());
            Dataset<Row> aggregates = ((GraphFrame)gx$2.elem).aggregateMessages().sendToSrc(msgForSrc).sendToDst(msgForDst).agg(functions$.MODULE$.sum(AM.msg()).as("aggMess"));
            Dataset<Row> v = ((GraphFrame)gx$2.elem).vertices();
            Column newBeliefCol = functions$.MODULE$.when(v.apply("color").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)color)).$amp$amp((Object)aggregates.apply("aggMess").isNotNull()), (Object)logistic.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{aggregates.apply("aggMess").$plus((Object)v.apply("a"))}))).otherwise((Object)v.apply("belief"));
            Dataset newVertices = v.join(aggregates, v.apply("id").$eq$eq$eq((Object)aggregates.apply("id")), "left_outer").drop(aggregates.apply("id")).withColumn("newBelief", newBeliefCol).drop("aggMess").drop("belief").withColumnRenamed("newBelief", "belief");
            Dataset<Row> cachedNewVertices = AM.getCachedDataFrame((Dataset<Row>)newVertices);
            gx$2.elem = GraphFrame$.MODULE$.apply(cachedNewVertices, ((GraphFrame)gx$2.elem).edges());
        }));
        return GraphFrame$.MODULE$.apply((Dataset<Row>)((GraphFrame)gx.elem).vertices().drop("color"), ((GraphFrame)gx.elem).edges());
    }

    private double log1pExp(double x) {
        return x > 0.0 ? x + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-x)) : scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(x));
    }

    public static final /* synthetic */ BeliefPropagation.VertexAttr $anonfun$runBPwithGraphX$1(Map vColsMap$1, long x0$1, Row x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Row attr = (Row)tuple2._2();
        BeliefPropagation.VertexAttr vertexAttr = new BeliefPropagation.VertexAttr(attr.getDouble(BoxesRunTime.unboxToInt((Object)vColsMap$1.apply((Object)"a"))), 0.0, attr.getInt(BoxesRunTime.unboxToInt((Object)vColsMap$1.apply((Object)"color"))));
        return vertexAttr;
    }

    public static final /* synthetic */ void $anonfun$runBPwithGraphX$5(int color$1, EdgeContext ctx) {
        block1: {
            double msg;
            block0: {
                if (((BeliefPropagation.VertexAttr)ctx.dstAttr()).color() != color$1) break block0;
                double msg2 = ((BeliefPropagation.EdgeAttr)ctx.attr()).b() * ((BeliefPropagation.VertexAttr)ctx.srcAttr()).belief();
                if (msg2 == 0.0) break block1;
                ctx.sendToDst((Object)BoxesRunTime.boxToDouble((double)msg2));
                break block1;
            }
            if (((BeliefPropagation.VertexAttr)ctx.srcAttr()).color() != color$1 || (msg = ((BeliefPropagation.EdgeAttr)ctx.attr()).b() * ((BeliefPropagation.VertexAttr)ctx.dstAttr()).belief()) == 0.0) break block1;
            ctx.sendToSrc((Object)BoxesRunTime.boxToDouble((double)msg));
        }
    }

    public static final /* synthetic */ BeliefPropagation.VertexAttr $anonfun$runBPwithGraphX$7(int color$1, long x0$2, BeliefPropagation.VertexAttr x1$2, Option x2$1) {
        BeliefPropagation.VertexAttr vertexAttr;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$2, (Object)x2$1);
        if (tuple3 != null) {
            BeliefPropagation.VertexAttr vAttr = (BeliefPropagation.VertexAttr)tuple3._2();
            Option optMsg = (Option)tuple3._3();
            if (vAttr.color() == color$1) {
                double x = vAttr.a() + BoxesRunTime.unboxToDouble((Object)optMsg.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                double newBelief = scala.math.package$.MODULE$.exp(-MODULE$.log1pExp(-x));
                vertexAttr = new BeliefPropagation.VertexAttr(vAttr.a(), newBelief, color$1);
            } else {
                vertexAttr = vAttr;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BeliefPropagation.VertexAttr vertexAttr2 = vertexAttr;
        return vertexAttr2;
    }

    public static final /* synthetic */ void $anonfun$runBPwithGraphX$10(Edge x$4) {
    }

    private BeliefPropagation$() {
        MODULE$ = this;
    }
}

