/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.process.vector.common.area;

import com.geoway.atlas.common.cache.AtlasThreadSafeCache;
import com.geoway.atlas.process.vector.common.area.GeodesicAreaCalculator$;
import com.geoway.atlas.process.vector.common.area.GeodesicAreaCalculator$CGCS2000$;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002(P\u0001yC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005S\"AQ\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!\u0011\bA!A!\u0002\u0013y\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u0011Q\u0004!\u0011!Q\u0001\n%DQ!\u001e\u0001\u0005\u0002YD\u0011\"!\u0001\u0001\u0005\u0004%\t!a\u0001\t\u000f\u0005\u0015\u0001\u0001)A\u0005S\"I\u0011q\u0001\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003j\u0011%\tY\u0001\u0001b\u0001\n\u0003\t\u0019\u0001C\u0004\u0002\u000e\u0001\u0001\u000b\u0011B5\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005\r\u0001bBA\t\u0001\u0001\u0006I!\u001b\u0005\n\u0003'\u0001!\u0019!C\u0001\u0003+A\u0001\"a\t\u0001A\u0003%\u0011q\u0003\u0005\n\u0003K\u0001!\u0019!C\u0001\u0003\u0007Aq!a\n\u0001A\u0003%\u0011\u000eC\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002\u0016!A\u00111\u0006\u0001!\u0002\u0013\t9\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u0002\u0004!9\u0011q\u0006\u0001!\u0002\u0013I\u0007\"CA\u0019\u0001\t\u0007I\u0011AA\u000b\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005]\u0001\"CA\u001b\u0001\t\u0007I\u0011AA\u0002\u0011\u001d\t9\u0004\u0001Q\u0001\n%D\u0011\"!\u000f\u0001\u0005\u0004%\t!!\u0006\t\u0011\u0005m\u0002\u0001)A\u0005\u0003/A\u0011\"!\u0010\u0001\u0005\u0004%\t!a\u0001\t\u000f\u0005}\u0002\u0001)A\u0005S\"I\u0011\u0011\t\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002\u0018!I\u0011Q\t\u0001C\u0002\u0013%\u00111\u0001\u0005\b\u0003\u000f\u0002\u0001\u0015!\u0003j\u0011%\tI\u0005\u0001b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002L\u0001\u0001\u000b\u0011B5\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA,\u0001\u0001\u0006I!!\u0015\t\u0013\u0005e\u0003A1A\u0005\n\u0005=\u0003\u0002CA.\u0001\u0001\u0006I!!\u0015\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!a'\u0001\t\u0013\ti\nC\u0004\u0002.\u0002!I!a,\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAj\u0001\u0011%\u0011Q[\u0004\b\u00037|\u0005\u0012AAo\r\u0019qu\n#\u0001\u0002`\"1QO\u000eC\u0001\u0003CD\u0011\"a97\u0005\u0004%I!a\u0001\t\u000f\u0005\u0015h\u0007)A\u0005S\"I\u0011q\u001d\u001cC\u0002\u0013%\u00111\u0001\u0005\b\u0003S4\u0004\u0015!\u0003j\u000f\u001d\tYO\u000eE\u0001\u0003[4q!!=7\u0011\u0003\t\u0019\u0010\u0003\u0004v{\u0011\u0005\u0011Q\u001f\u0005\n\u0003ol$\u0019!C\u0001\u0003\u0007Aq!!?>A\u0003%\u0011\u000eC\u0005\u0002|v\u0012\r\u0011\"\u0001\u0002\u0004!9\u0011Q`\u001f!\u0002\u0013I\u0007\"CA\u0000{\t\u0007I\u0011AA\u0002\u0011\u001d\u0011\t!\u0010Q\u0001\n%D\u0011Ba\u0001>\u0005\u0004%\t!a\u0001\t\u000f\t\u0015Q\b)A\u0005S\"I!qA\u001fC\u0002\u0013\u0005\u00111\u0001\u0005\b\u0005\u0013i\u0004\u0015!\u0003j\u0011%\u0011YA\u000eb\u0001\n\u0003\u0011i\u0001\u0003\u0005\u00032Y\u0002\u000b\u0011\u0002B\b\u0011\u001d\u0011\u0019D\u000eC\u0001\u0005kAqA!\u000f7\t\u0003\u0011Y\u0004C\u0005\u0003BY\n\t\u0011\"\u0003\u0003D\t1r)Z8eKNL7-\u0011:fC\u000e\u000bGnY;mCR|'O\u0003\u0002Q#\u0006!\u0011M]3b\u0015\t\u00116+\u0001\u0004d_6lwN\u001c\u0006\u0003)V\u000baA^3di>\u0014(B\u0001,X\u0003\u001d\u0001(o\\2fgNT!\u0001W-\u0002\u000b\u0005$H.Y:\u000b\u0005i[\u0016AB4f_^\f\u0017PC\u0001]\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q,\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0002E\u0006)1oY1mC&\u0011A-\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00014\u0017BA4b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\t'+\u00193jkN\u0004\"\u0001\u00196\n\u0005-\f'A\u0002#pk\ndW-A\u0004c%\u0006$\u0017.^:\u0002\u000bA\f'/Y\"\u0002#%\u001c\bK]8kK\u000e$(+Z:feZ,G\u0007\u0005\u0002aa&\u0011\u0011/\u0019\u0002\b\u0005>|G.Z1o\u0003eIg\u000e^3sa>d\u0017\r^5p]RC\u0017M\\\u001c1\u001b\u0016$XM]:\u0002\u000f\r,g\u000e\u001e:bY\u0006aQ-Y:u\t&\u001cH/\u00198dK\u00061A(\u001b8jiz\"\u0002b^={wrlhp \t\u0003q\u0002i\u0011a\u0014\u0005\u0006Q\"\u0001\r!\u001b\u0005\u0006Y\"\u0001\r!\u001b\u0005\u0006[\"\u0001\r!\u001b\u0005\u0006]\"\u0001\ra\u001c\u0005\u0006e\"\u0001\ra\u001c\u0005\u0006g\"\u0001\r!\u001b\u0005\u0006i\"\u0001\r![\u0001\u0007a\u0006\u0014\u0018-R\u0019\u0016\u0003%\fq\u0001]1sC\u0016\u000b\u0004%\u0001\u0004qCJ\fWIM\u0001\ba\u0006\u0014\u0018-\u0012\u001a!\u0003\u0019\u0001\u0018M]1B\r\u00069\u0001/\u0019:b\u0003\u001a\u0003\u0013A\u00029be\u0006l\u0017)A\u0004qCJ\fW.\u0011\u0011\u0002\u0013A\f'/Y7B\u0005&<WCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fC\u0006!Q.\u0019;i\u0013\u0011\t\t#a\u0007\u0003\u0015\tKw\rR3dS6\fG.\u0001\u0006qCJ\fW.\u0011\"jO\u0002\na\u0001]1sC6\u0014\u0015a\u00029be\u0006l'\tI\u0001\na\u0006\u0014\u0018-\u001c\"CS\u001e\f!\u0002]1sC6\u0014%)[4!\u0003\u0019\u0001\u0018M]1n\u0007\u00069\u0001/\u0019:b[\u000e\u0003\u0013!\u00039be\u0006l7IQ5h\u0003)\u0001\u0018M]1n\u0007\nKw\rI\u0001\u0007a\u0006\u0014\u0018-\u001c#\u0002\u000fA\f'/Y7EA\u0005I\u0001/\u0019:b[\u0012\u0013\u0015nZ\u0001\u000ba\u0006\u0014\u0018-\u001c#CS\u001e\u0004\u0013A\u00029be\u0006lW)A\u0004qCJ\fW.\u0012\u0011\u0002\u0013A\f'/Y7F\u0005&<\u0017A\u00039be\u0006lWIQ5hA\u0005\u0011Q\tN\u0001\u0004\u000bR\u0002\u0013AA#7\u0003\r)e\u0007I\u0001\be\u0006tGm\\75+\t\t\t\u0006E\u0003a\u0003'J\u0017.C\u0002\u0002V\u0005\u0014\u0011BR;oGRLwN\\\u0019\u0002\u0011I\fg\u000eZ8ni\u0001\nqA]1oI>lg'\u0001\u0005sC:$w.\u001c\u001c!\u0003!\u0019\u0017\r\\2HK>lGcA5\u0002b!9\u00111M\u0016A\u0002\u0005\u0015\u0014\u0001C4f_6,GO]=\u0011\t\u0005\u001d\u0014\u0011P\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005!q-Z8n\u0015\u0011\ty'!\u001d\u0002\u0007)$8O\u0003\u0003\u0002t\u0005U\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'BAA<\u0003\ry'oZ\u0005\u0005\u0003w\nIG\u0001\u0005HK>lW\r\u001e:z\u0003A\u0019\u0017\r\\2vY\u0006$X\rU8ms\u001e|g\u000eF\u0002j\u0003\u0003Cq!a\u001b-\u0001\u0004\t)'A\u000bdC2\u001cW\u000f\\1uK6+H\u000e^5Q_2Lxm\u001c8\u0015\u0007%\f9\tC\u0004\u0002l5\u0002\r!!\u001a\u00027\r\fGnY;mCR,w)Z8nKR\u0014\u0018pQ8mY\u0016\u001cG/[8o)\rI\u0017Q\u0012\u0005\b\u0003Wr\u0003\u0019AA3\u0003=\u0019\u0017\r\\2FY2L\u0007o]3Be\u0016\fGcA5\u0002\u0014\"9\u00111N\u0018A\u0002\u0005U\u0005\u0003BA4\u0003/KA!!'\u0002j\tQA*\u001b8f'R\u0014\u0018N\\4\u0002\u0011\r\fGnY#eO\u0016$R![AP\u0003SCq!!)1\u0001\u0004\t\u0019+A\bgSJ\u001cHoQ8pe\u0012Lg.\u0019;f!\u0011\t9'!*\n\t\u0005\u001d\u0016\u0011\u000e\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007bBAVa\u0001\u0007\u00111U\u0001\u0011g\u0016\u001cwN\u001c3D_>\u0014H-\u001b8bi\u0016\fAbY8naV$X\rW-HK>$b!!-\u00028\u0006m\u0006\u0003\u00021\u00024&L1!!.b\u0005\u0015\t%O]1z\u0011\u0019\tI,\ra\u0001S\u0006\t\u0001\u0010\u0003\u0004\u0002>F\u0002\r![\u0001\u0002s\u0006!q-\u001a;C)\u0019\t\t,a1\u0002H\"1\u0011Q\u0019\u001aA\u0002%\f!!_\u0019\t\r\u0005%'\u00071\u0001j\u0003\t\u0011g-\u0001\tue\u0006t7\u000fR3he\u0016,Gk\\!sGR\u0019\u0011.a4\t\r\u0005E7\u00071\u0001j\u0003\u0019!Wm\u001a:fK\u0006\u0001BO]1og\u0006\u00138\rV8TK\u000e|g\u000e\u001a\u000b\u0004S\u0006]\u0007BBAmi\u0001\u0007\u0011.A\u0002be\u000e\facR3pI\u0016\u001c\u0018nY!sK\u0006\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003qZ\u001a2AN0f)\t\ti.A\u0002S\u0003\u0012\u000bAAU!EA\u0005iA)R$S\u000b\u0016{FkT0B%\u000e\u000ba\u0002R#H%\u0016+u\fV(`\u0003J\u001b\u0005%\u0001\u0005D\u000f\u000e\u001b&\u0007\r\u00191!\r\ty/P\u0007\u0002m\tA1iR\"TeA\u0002\u0004g\u0005\u0002>?R\u0011\u0011Q^\u0001\u0003WB\n1a\u001b\u0019!\u0003\tY\u0017'A\u0002lc\u0001\n!a\u001b\u001a\u0002\u0007-\u0014\u0004%\u0001\u0002lg\u0005\u00191n\r\u0011\u0002\u0005-$\u0014aA65A\u0005y1-\u00197dk2\fGo\u001c:DC\u000eDW-\u0006\u0002\u0003\u0010A9!\u0011\u0003B\r\u0005;9XB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u000b\r\f7\r[3\u000b\u0005I;\u0016\u0002\u0002B\u000e\u0005'\u0011A#\u0011;mCN$\u0006N]3bIN\u000bg-Z\"bG\",\u0007\u0003\u0002B\u0010\u0005[i!A!\t\u000b\t\t\r\"QE\u0001\u0004GJ\u001c(\u0002\u0002B\u0014\u0005S\t1B]3gKJ,gnY5oO*!!1FA;\u0003\u001dy\u0007/\u001a8hSNLAAa\f\u0003\"\tI2i\\8sI&t\u0017\r^3SK\u001a,'/\u001a8dKNK8\u000f^3n\u0003A\u0019\u0017\r\\2vY\u0006$xN]\"bG\",\u0007%A\u0007hKR\u001c\u0015\r\\2vY\u0006$xN\u001d\u000b\u0004o\n]\u0002b\u0002B\u0012\u0017\u0002\u0007!QD\u0001\nG\u0006d7-\u001e7bi\u0016$R!\u001bB\u001f\u0005\u007fAq!a\u0019M\u0001\u0004\t)\u0007C\u0004\u0003$1\u0003\rA!\b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000b\u0002BAa\u0012\u0003R5\u0011!\u0011\n\u0006\u0005\u0005\u0017\u0012i%\u0001\u0003mC:<'B\u0001B(\u0003\u0011Q\u0017M^1\n\t\tM#\u0011\n\u0002\u0007\u001f\nTWm\u0019;")
public class GeodesicAreaCalculator
implements scala.Serializable {
    private final double bRadius;
    private final double paraC;
    private final boolean isProjectReserve4;
    private final boolean interpolationThan70Meters;
    private final double central;
    private final double eastDistance;
    private final double paraE1;
    private final double paraE2;
    private final double paraAF;
    private final double paramA;
    private final BigDecimal paramABig;
    private final double paramB;
    private final BigDecimal paramBBig;
    private final double paramC;
    private final BigDecimal paramCBig;
    private final double paramD;
    private final BigDecimal paramDBig;
    private final double paramE;
    private final BigDecimal paramEBig;
    private final double E4;
    private final double E6;
    private final Function1<Object, Object> random4;
    private final Function1<Object, Object> random6;

    public static double calculate(Geometry geometry, CoordinateReferenceSystem coordinateReferenceSystem) {
        return GeodesicAreaCalculator$.MODULE$.calculate(geometry, coordinateReferenceSystem);
    }

    public static GeodesicAreaCalculator getCalculator(CoordinateReferenceSystem coordinateReferenceSystem) {
        return GeodesicAreaCalculator$.MODULE$.getCalculator(coordinateReferenceSystem);
    }

    public static AtlasThreadSafeCache<CoordinateReferenceSystem, GeodesicAreaCalculator> calculatorCache() {
        return GeodesicAreaCalculator$.MODULE$.calculatorCache();
    }

    public double paraE1() {
        return this.paraE1;
    }

    public double paraE2() {
        return this.paraE2;
    }

    public double paraAF() {
        return this.paraAF;
    }

    public double paramA() {
        return this.paramA;
    }

    public BigDecimal paramABig() {
        return this.paramABig;
    }

    public double paramB() {
        return this.paramB;
    }

    public BigDecimal paramBBig() {
        return this.paramBBig;
    }

    public double paramC() {
        return this.paramC;
    }

    public BigDecimal paramCBig() {
        return this.paramCBig;
    }

    public double paramD() {
        return this.paramD;
    }

    public BigDecimal paramDBig() {
        return this.paramDBig;
    }

    public double paramE() {
        return this.paramE;
    }

    public BigDecimal paramEBig() {
        return this.paramEBig;
    }

    private double E4() {
        return this.E4;
    }

    private double E6() {
        return this.E6;
    }

    private Function1<Object, Object> random4() {
        return this.random4;
    }

    private Function1<Object, Object> random6() {
        return this.random6;
    }

    public double calcGeom(Geometry geometry) {
        double d;
        if (geometry == null || geometry.isEmpty()) {
            d = 0.0;
        } else {
            String string = geometry.getGeometryType();
            String string2 = "Polygon";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                d = this.calculatePolygon(geometry);
            } else {
                String string3 = geometry.getGeometryType();
                String string4 = "MultiPolygon";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    d = this.calculateMultiPolygon(geometry);
                } else {
                    String string5 = geometry.getGeometryType();
                    String string6 = "GeometryCollection";
                    d = !(string5 != null ? !string5.equals(string6) : string6 != null) ? this.calculateGeometryCollection(geometry) : 0.0;
                }
            }
        }
        return d;
    }

    private double calculatePolygon(Geometry geom) {
        double d;
        Polygon geomPoly = (Polygon)geom;
        LinearRing exterRing = geomPoly.getExteriorRing();
        if (exterRing == null || exterRing.isEmpty()) {
            d = 0.0;
        } else {
            double area = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(this.calcEllipseArea((LineString)exterRing)));
            DoubleRef holesArea = DoubleRef.create((double)0.0);
            int nCount = geomPoly.getNumInteriorRing();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                LinearRing g = geomPoly.getInteriorRingN(i);
                holesArea$1.elem += RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(this.calcEllipseArea((LineString)g)));
            });
            d = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(area - holesArea.elem));
        }
        return d;
    }

    private double calculateMultiPolygon(Geometry geom) {
        MultiPolygon geomMultiPoly = (MultiPolygon)geom;
        int numGeoms = geomMultiPoly.getNumGeometries();
        DoubleRef area = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numGeoms).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Geometry g = geomMultiPoly.getGeometryN(i);
            area$1.elem += this.calculatePolygon(g);
        });
        return area.elem;
    }

    private double calculateGeometryCollection(Geometry geom) {
        ObjectRef geomCollection = ObjectRef.create((Object)((GeometryCollection)geom));
        int numGeoms = ((GeometryCollection)geomCollection.elem).getNumGeometries();
        DoubleRef area = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numGeoms).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> area$2.elem += this.calcGeom(((GeometryCollection)geomCollection$1.elem).getGeometryN(i)));
        return area.elem;
    }

    private double calcEllipseArea(LineString geom) {
        DoubleRef areaSum = DoubleRef.create((double)0.0);
        Coordinate[] points = geom.getCoordinates();
        int nCount = points.length;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), nCount - 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Coordinate firstCoord = points[i];
            Coordinate secondCoord = points[i + 1];
            Coordinate[] coordinates = (Coordinate[])((Object[])new Coordinate[]{firstCoord, secondCoord});
            if ($this.interpolationThan70Meters && $this.eastDistance > 0.0) {
                int maxLen = 70;
                double lineLength = Math.sqrt(Math.pow(secondCoord.x - firstCoord.x, 2.0) + Math.pow(secondCoord.y - firstCoord.y, 2.0));
                if (lineLength > (double)maxLen) {
                    int interpolationCount = (int)(lineLength / (double)maxLen);
                    double xCell = (secondCoord.x - firstCoord.x) / (double)(interpolationCount + 1);
                    double yCell = (secondCoord.y - firstCoord.y) / (double)(interpolationCount + 1);
                    coordinates = new Coordinate[interpolationCount + 2];
                    coordinates[0] = firstCoord;
                    coordinates[coordinates.length - 1] = secondCoord;
                    int limit$macro$4 = interpolationCount;
                    for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                        int coordth = index$macro$2 + 1;
                        coordinates[coordth] = new Coordinate(xCell * (double)coordth + firstCoord.x, yCell * (double)coordth + firstCoord.y);
                    }
                }
            }
            for (int index$macro$6 = 0; index$macro$6 < coordinates.length - 1; ++index$macro$6) {
                areaSum$1.elem += this.calcEdge(coordinates[index$macro$6], coordinates[index$macro$6 + 1]);
            }
        });
        return areaSum.elem;
    }

    private double calcEdge(Coordinate firstCoordinate, Coordinate secondCoordinate) {
        double[] BL = this.computeXYGeo(firstCoordinate.y, firstCoordinate.x);
        double[] BL1 = this.computeXYGeo(secondCoordinate.y, secondCoordinate.x);
        double B = BL[0] / GeodesicAreaCalculator$.MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD();
        double L = BL[1] / GeodesicAreaCalculator$.MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD();
        double B1 = BL1[0] / GeodesicAreaCalculator$.MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD();
        double L1 = BL1[1] / GeodesicAreaCalculator$.MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD();
        double[] itemValue = new double[5];
        double bDifference = (B1 - B) / 2.0;
        double bSum = (B1 + B) / 2.0;
        double lDifference = (L1 + L) / 2.0;
        double radDiffVal = this.bRadius * lDifference * this.bRadius * (double)2;
        double cosVal = package$.MODULE$.cos(bSum);
        double sinVal = package$.MODULE$.sin(bDifference);
        itemValue[0] = radDiffVal * this.paramA() * cosVal * sinVal;
        itemValue[1] = radDiffVal * this.paramB() * package$.MODULE$.sin(bDifference * 3.0) * package$.MODULE$.cos(bSum * 3.0);
        itemValue[2] = radDiffVal * this.paramC() * package$.MODULE$.sin(bDifference * 5.0) * package$.MODULE$.cos(bSum * 5.0);
        itemValue[3] = radDiffVal * this.paramD() * package$.MODULE$.sin(bDifference * 7.0) * package$.MODULE$.cos(bSum * 7.0);
        itemValue[4] = radDiffVal * this.paramE() * package$.MODULE$.sin(bDifference * 9.0) * package$.MODULE$.cos(bSum * 9.0);
        double areaVal = itemValue[0] - itemValue[1] + itemValue[2] - itemValue[3] + itemValue[4];
        return areaVal;
    }

    private double[] computeXYGeo(double x, double y) {
        double[] dArray;
        if (this.eastDistance < 0.0) {
            double b = x * 3600.0;
            double l = y * 3600.0;
            double B = this.random6().apply$mcDD$sp(b);
            double L = this.random6().apply$mcDD$sp(l);
            double[] dArray2 = new double[2];
            dArray2[0] = B;
            dArray = dArray2;
            dArray2[1] = L;
        } else {
            double xRound = x;
            double yRound = y;
            if (this.isProjectReserve4) {
                xRound = this.random4().apply$mcDD$sp(x);
                yRound = this.random4().apply$mcDD$sp(y);
            }
            double y1 = yRound - this.eastDistance;
            double e = GeodesicAreaCalculator$CGCS2000$.MODULE$.k0() * xRound;
            double se = package$.MODULE$.sin(e);
            double bf = e + package$.MODULE$.cos(e) * (GeodesicAreaCalculator$CGCS2000$.MODULE$.k1() * se - GeodesicAreaCalculator$CGCS2000$.MODULE$.k2() * se * se * se + GeodesicAreaCalculator$CGCS2000$.MODULE$.k3() * se * se * se * se * se - GeodesicAreaCalculator$CGCS2000$.MODULE$.k4() * se * se * se * se * se * se * se);
            double[] coords = this.getB(y1, bf);
            dArray = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coords)).map(this.random6(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return dArray;
    }

    private double[] getB(double y1, double bf) {
        double t = package$.MODULE$.tan(bf);
        double n1 = package$.MODULE$.cos(bf) * this.paraE2() * package$.MODULE$.cos(bf);
        double v = package$.MODULE$.sqrt(n1 + 1.0);
        double N = this.paraC / v;
        double yn = y1 / N;
        double vt = v * t * v;
        double t2 = t * t;
        double B = bf - yn * vt * yn / 2.0 + (5.0 + 3.0 * t2 + n1 - 9.0 * n1 * t2) * yn * vt * yn * yn * yn / 24.0 - (61.0 + 90.0 * t2 + 45.0 * t2 * t2) * yn * vt * yn * yn * yn * yn * yn / 720.0;
        B = this.transArcToSecond(B);
        double cbf = 1.0 / package$.MODULE$.cos(bf);
        double L = cbf * yn - (1.0 + 2.0 * t2 + n1) * cbf * yn * yn * yn / 6.0 + (5.0 + 28.0 * t2 + 24.0 * t2 * t2 + 6.0 * n1 + 8.0 * n1 * t2) * cbf * yn * yn * yn * yn * yn / 120.0 + this.central;
        L = this.transArcToSecond(L);
        return new double[]{B, L};
    }

    private double transDegreeToArc(double degree) {
        return degree * GeodesicAreaCalculator$.MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$DEGREE_TO_ARC();
    }

    private double transArcToSecond(double arc) {
        return arc * GeodesicAreaCalculator$.MODULE$.com$geoway$atlas$process$vector$common$area$GeodesicAreaCalculator$$RAD();
    }

    public GeodesicAreaCalculator(double aRadius, double bRadius, double paraC, boolean isProjectReserve4, boolean interpolationThan70Meters, double central, double eastDistance) {
        this.bRadius = bRadius;
        this.paraC = paraC;
        this.isProjectReserve4 = isProjectReserve4;
        this.interpolationThan70Meters = interpolationThan70Meters;
        this.central = central;
        this.eastDistance = eastDistance;
        this.paraE1 = 1.0 - Math.pow(bRadius, 2.0) / Math.pow(aRadius, 2.0);
        this.paraE2 = Math.pow(aRadius, 2.0) / Math.pow(bRadius, 2.0) - 1.0;
        this.paraAF = 1.0 - bRadius / aRadius;
        this.paramA = 1.0 + 0.5 * this.paraE1() + 0.375 * this.paraE1() * this.paraE1() + 0.3125 * this.paraE1() * this.paraE1() * this.paraE1() + 0.2734375 * this.paraE1() * this.paraE1() * this.paraE1() * this.paraE1();
        this.paramABig = scala.package$.MODULE$.BigDecimal().apply(this.paramA());
        this.paramB = 0.16666666666666666 * this.paraE1() + 0.1875 * this.paraE1() * this.paraE1() + 0.1875 * this.paraE1() * this.paraE1() * this.paraE1() + 0.18229166666666666 * this.paraE1() * this.paraE1() * this.paraE1() * this.paraE1();
        this.paramBBig = scala.package$.MODULE$.BigDecimal().apply(this.paramB());
        this.paramC = 0.0375 * this.paraE1() * this.paraE1() + 0.0625 * this.paraE1() * this.paraE1() * this.paraE1() + 0.078125 * this.paraE1() * this.paraE1() * this.paraE1() * this.paraE1();
        this.paramCBig = scala.package$.MODULE$.BigDecimal().apply(this.paramC());
        this.paramD = 0.008928571428571428 * this.paraE1() * this.paraE1() * this.paraE1() + 0.01953125 * this.paraE1() * this.paraE1() * this.paraE1() * this.paraE1();
        this.paramDBig = scala.package$.MODULE$.BigDecimal().apply(this.paramD());
        this.paramE = 0.002170138888888889 * this.paraE1() * this.paraE1() * this.paraE1() * this.paraE1();
        this.paramEBig = scala.package$.MODULE$.BigDecimal().apply(this.paramE());
        this.E4 = Math.pow(10.0, 4.0);
        this.E6 = Math.pow(10.0, 6.0);
        this.random4 = (JFunction1.mcDD.sp & Serializable & scala.Serializable)d -> (double)Math.round(d * this.E4()) / this.E4();
        this.random6 = (JFunction1.mcDD.sp & Serializable & scala.Serializable)d -> (double)Math.round(d * this.E6()) / this.E6();
    }
}

