/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.spark.common.rpc.common;

import com.geoway.atlas.common.error.GSparkException;
import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.UnCatchException;
import com.geoway.atlas.data.vector.spark.common.rpc.common.AtlasRpcServerException;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcExceptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(GrpcExceptionUtil.class);
    public static final Metadata.Key<byte[]> EXCEPTION_KEY = Metadata.Key.of((String)"exception-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StatusRuntimeException wrapException(Throwable throwable) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            Throwable serializerException = throwable;
            serializerException = throwable instanceof GSparkException || throwable instanceof UnCatchException ? new AtlasRpcServerException(throwable.getMessage(), throwable.getStackTrace()) : new AtlasRpcServerException(ExceptionUtils.getRootCauseMessage((Throwable)throwable), ExceptionUtils.getRootCause((Throwable)throwable));
            oos.writeObject(serializerException);
            Metadata metadata = new Metadata();
            metadata.put(EXCEPTION_KEY, (Object)Arrays.copyOfRange(bos.toByteArray(), 0, bos.size()));
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.asRuntimeException(metadata);
            return statusRuntimeException;
        }
        catch (IOException ioException) {
            logger.error("\u65e0\u6cd5\u5411\u5ba2\u6237\u7aef\u53d1\u9001\u5931\u8d25\u8bf7\u6c42!");
            return Status.INTERNAL.withCause((Throwable)ioException).asRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Throwable unwrapException(StatusRuntimeException sre) {
        Metadata trailers = sre.getTrailers();
        if (trailers == null) return sre;
        if (!trailers.containsKey(EXCEPTION_KEY)) return sre;
        if (trailers.get(EXCEPTION_KEY) == null) {
            return sre;
        }
        byte[] bytes = (byte[])trailers.get(EXCEPTION_KEY);
        try (ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes, 0, bytes.length));){
            Object exception = oin.readObject();
            Throwable throwable = (Throwable)exception;
            return throwable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IoException("\u8bfb\u53d6\u670d\u52a1\u7aef\u9519\u8bef\u5931\u8d25!", Thread.currentThread(), 3);
        }
    }

    public static void throwException(Throwable throwable) {
        if (throwable instanceof GSparkException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof StatusRuntimeException) {
            Throwable nt = GrpcExceptionUtil.unwrapException((StatusRuntimeException)throwable);
            if (nt instanceof RuntimeException) {
                throw (RuntimeException)nt;
            }
            throw new AtlasRpcServerException(nt.getMessage(), nt.getStackTrace());
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new AtlasRpcServerException(throwable.getMessage(), throwable.getStackTrace());
    }
}

