/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.spark.common.rpc.client;

import com.geoway.atlas.data.vector.spark.common.rpc.AtlasBaseOpGrpc;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasJobInfo;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import com.geoway.atlas.data.vector.spark.common.rpc.EnvInfo;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcAtlasBaseOpRespons;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcBinaryProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDeleteDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDeleteRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcExistDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcExistDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcListProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcLoadDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcNilProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcPersistDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcPersistRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRenameDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRenameDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRespondMessage;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcSaveDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcShowDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcTaskId;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcTaskRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcUnPersistDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcUnPersistRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcUnitaryProcessParams;
import com.geoway.atlas.data.vector.spark.common.rpc.SparkDataManagerGrpc;
import com.geoway.atlas.data.vector.spark.common.rpc.SparkVectorProcessGrpc;
import com.geoway.atlas.data.vector.spark.common.rpc.common.GrpcExceptionUtil;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRpcClientApi {
    public static final int MAX_INBOUND_METADATA_SIZE = 0xA00000;
    private static final Logger logger = LoggerFactory.getLogger(SparkRpcClientApi.class);
    private final ManagedChannel channel;
    private final SparkDataManagerGrpc.SparkDataManagerBlockingStub blockDataStub;
    private final SparkDataManagerGrpc.SparkDataManagerStub dataStub;
    private final SparkVectorProcessGrpc.SparkVectorProcessBlockingStub blockProcessStub;
    private final SparkVectorProcessGrpc.SparkVectorProcessStub processStub;
    private final AtlasBaseOpGrpc.AtlasBaseOpBlockingStub blockAtlasBaseOpStub;
    private final AtlasBaseOpGrpc.AtlasBaseOpStub atlasBaseOpStub;

    public SparkRpcClientApi(String target, ExecutorService rpcClientPool) {
        this(ManagedChannelBuilder.forTarget((String)target).maxInboundMetadataSize(0xA00000), rpcClientPool);
    }

    public SparkRpcClientApi(String address, int port, ExecutorService rpcClientPool) {
        this(ManagedChannelBuilder.forAddress((String)address, (int)port).maxInboundMetadataSize(0xA00000), rpcClientPool);
    }

    public SparkRpcClientApi(ManagedChannelBuilder<?> channelBuilder, ExecutorService rpcClientPool) {
        logger.info("\u542f\u52a8\u5ba2\u6237\u7aef");
        this.channel = channelBuilder.executor((Executor)rpcClientPool).usePlaintext().build();
        this.blockDataStub = SparkDataManagerGrpc.newBlockingStub((Channel)this.channel);
        this.dataStub = SparkDataManagerGrpc.newStub((Channel)this.channel);
        this.blockProcessStub = SparkVectorProcessGrpc.newBlockingStub((Channel)this.channel);
        this.processStub = SparkVectorProcessGrpc.newStub((Channel)this.channel);
        this.blockAtlasBaseOpStub = AtlasBaseOpGrpc.newBlockingStub((Channel)this.channel);
        this.atlasBaseOpStub = AtlasBaseOpGrpc.newStub((Channel)this.channel);
    }

    public String loadData(String dataType, AtlasRpcDataTag atlasRpcDataTag, String dataStoreFormat, Map<String, String> loadParams, String taskId, String jobId) {
        final RpcRespondMessage[] result = new RpcRespondMessage[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRespondMessage> streamObserver = new StreamObserver<RpcRespondMessage>(){

            public void onNext(RpcRespondMessage value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.loadData(RpcLoadDataParams.newBuilder().setDataType(dataType).setDataTag(atlasRpcDataTag).setDataStoreFormat(dataStoreFormat).putAllLoadParams(loadParams).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getResponse();
    }

    public String saveData(String dataType, AtlasRpcDataTag atlasRpcDataTag, String dataStoreFormat, Map<String, String> saveParams, String taskId, String jobId) {
        final RpcRespondMessage[] result = new RpcRespondMessage[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRespondMessage> streamObserver = new StreamObserver<RpcRespondMessage>(){

            public void onNext(RpcRespondMessage value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.saveData(RpcSaveDataParams.newBuilder().setDataType(dataType).setDataTag(atlasRpcDataTag).setDataStoreFormat(dataStoreFormat).putAllSaveParams(saveParams).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getResponse();
    }

    public List<AtlasRpcDataTag> showData() {
        final RpcShowDataRespond[] result = new RpcShowDataRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcShowDataRespond> streamObserver = new StreamObserver<RpcShowDataRespond>(){

            public void onNext(RpcShowDataRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.showData(Empty.newBuilder().build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getDataTagsList();
    }

    public String deleteData(AtlasRpcDataTag atlasRpcDataTag, String taskId, String jobId) {
        final RpcDeleteRespond[] result = new RpcDeleteRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcDeleteRespond> streamObserver = new StreamObserver<RpcDeleteRespond>(){

            public void onNext(RpcDeleteRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.deleteData(RpcDeleteDataParams.newBuilder().setDeleteDataTag(atlasRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getMessage();
    }

    public RpcDescDataRespond descData(AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcDescDataRespond[] result = new RpcDescDataRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcDescDataRespond> streamObserver = new StreamObserver<RpcDescDataRespond>(){

            public void onNext(RpcDescDataRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.descData(RpcDescDataParams.newBuilder().setDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0];
    }

    public RpcExistDataRespond existData(AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcExistDataRespond[] result = new RpcExistDataRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcExistDataRespond> streamObserver = new StreamObserver<RpcExistDataRespond>(){

            public void onNext(RpcExistDataRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.existData(RpcExistDataParams.newBuilder().setDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0];
    }

    public RpcPersistRespond persistData(AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcPersistRespond[] result = new RpcPersistRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcPersistRespond> streamObserver = new StreamObserver<RpcPersistRespond>(){

            public void onNext(RpcPersistRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.persistData(RpcPersistDataParams.newBuilder().setPersistDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0];
    }

    public RpcUnPersistRespond unPersistData(AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcUnPersistRespond[] result = new RpcUnPersistRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcUnPersistRespond> streamObserver = new StreamObserver<RpcUnPersistRespond>(){

            public void onNext(RpcUnPersistRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.unPersistData(RpcUnPersistDataParams.newBuilder().setUnpersistDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0];
    }

    public RpcRenameDataRespond renameData(AtlasRpcDataTag rawRpcDataTag, AtlasRpcDataTag newRpcDataTag, String taskId, String jobId) {
        final RpcRenameDataRespond[] result = new RpcRenameDataRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRenameDataRespond> streamObserver = new StreamObserver<RpcRenameDataRespond>(){

            public void onNext(RpcRenameDataRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.dataStub.renameData(RpcRenameDataParams.newBuilder().setRawDataTag(rawRpcDataTag).setNewDataTag(newRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0];
    }

    public String nilProcess(String processName, Map<String, String> processParams, AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcRespondMessage[] result = new RpcRespondMessage[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRespondMessage> streamObserver = new StreamObserver<RpcRespondMessage>(){

            public void onNext(RpcRespondMessage value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.processStub.nilProcess(RpcNilProcessParams.newBuilder().setProcess(processName).putAllProcessParams(processParams).setResultDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getResponse();
    }

    public String unitaryProcess(AtlasRpcDataTag atlasRpcDataTag, String processName, Map<String, String> processParams, AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcRespondMessage[] result = new RpcRespondMessage[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRespondMessage> streamObserver = new StreamObserver<RpcRespondMessage>(){

            public void onNext(RpcRespondMessage value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.processStub.unitaryProcess(RpcUnitaryProcessParams.newBuilder().setDataTag(atlasRpcDataTag).setProcess(processName).putAllProcessParams(processParams).setResultDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getResponse();
    }

    public String binaryProcess(AtlasRpcDataTag baseDatTag, AtlasRpcDataTag otherDatTag, String processName, Map<String, String> processParams, AtlasRpcDataTag resultDatTag, String taskId, String jobId) {
        final RpcRespondMessage[] result = new RpcRespondMessage[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRespondMessage> streamObserver = new StreamObserver<RpcRespondMessage>(){

            public void onNext(RpcRespondMessage value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.processStub.binaryProcess(RpcBinaryProcessParams.newBuilder().setBaseDataTag(baseDatTag).setOtherDataTag(otherDatTag).setProcess(processName).putAllProcessParams(processParams).setResultDataTag(resultDatTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getResponse();
    }

    public String listProcess(List<AtlasRpcDataTag> atlasRpcDataTags, String processName, Map<String, String> processParams, AtlasRpcDataTag resultRpcDataTag, String taskId, String jobId) {
        final RpcRespondMessage[] result = new RpcRespondMessage[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcRespondMessage> streamObserver = new StreamObserver<RpcRespondMessage>(){

            public void onNext(RpcRespondMessage value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.processStub.listProcess(RpcListProcessParams.newBuilder().addAllDataTags(atlasRpcDataTags).setProcess(processName).putAllProcessParams(processParams).setResultDataTag(resultRpcDataTag).setTaskId(taskId).setJobId(jobId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getResponse();
    }

    public void startMonitorTask(Map<String, String> envParams) {
        RpcAtlasBaseOpRespons rpcAtlasBaseOpRespons = this.blockAtlasBaseOpStub.startMonitorTask(EnvInfo.newBuilder().putAllEnvParams(envParams).build());
        logger.info(rpcAtlasBaseOpRespons.getResponse());
    }

    public String cancelTask(String taskId) {
        final RpcTaskRespond[] result = new RpcTaskRespond[1];
        final Throwable[] throwables = new Throwable[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        StreamObserver<RpcTaskRespond> streamObserver = new StreamObserver<RpcTaskRespond>(){

            public void onNext(RpcTaskRespond value) {
                result[0] = value;
            }

            public void onError(Throwable t) {
                throwables[0] = t;
                countDownLatch.countDown();
            }

            public void onCompleted() {
                countDownLatch.countDown();
            }
        };
        this.processStub.cancelTask(RpcTaskId.newBuilder().setTaskId(taskId).build(), streamObserver);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (throwables[0] != null) {
            GrpcExceptionUtil.throwException((Throwable)throwables[0]);
        }
        return result[0].getRespond();
    }

    public String startJob(String taskId, String jobId, String responseInfo) {
        return this.blockAtlasBaseOpStub.startJob(AtlasJobInfo.newBuilder().setTaskId(taskId).setJobId(jobId).setMessage(responseInfo).build()).getResponse();
    }

    public void finishJob(String taskId, String jobId, String responseInfo) {
        this.blockAtlasBaseOpStub.finishJob(AtlasJobInfo.newBuilder().setTaskId(taskId).setJobId(jobId).setMessage(responseInfo).build());
    }

    public void cancelJob(String taskId, String jobId, String responseInfo) {
        this.blockAtlasBaseOpStub.cancelJob(AtlasJobInfo.newBuilder().setTaskId(taskId).setJobId(jobId).setMessage(responseInfo).build());
    }

    public String getJobReponse(String taskId, String jobId) {
        return this.blockAtlasBaseOpStub.getResponse(AtlasJobInfo.newBuilder().setTaskId(taskId).setJobId(jobId).build()).getResponse();
    }

    public void stop() throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
        }
    }
}

