/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.common.serialization;

import com.geoway.atlas.common.log.LazyLogging;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class JMapSerialization$
implements LazyLogging {
    public static JMapSerialization$ MODULE$;
    private final String nullMapping;
    private final scala.collection.immutable.Map<Class<?>, String> baseClassMappings;
    private final scala.collection.immutable.Map<String, Class<?>> baseClassLookups;
    private final Ordering<Tuple2<Object, Object>> ordering;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JMapSerialization$();
    }

    private Logger logger$lzycompute() {
        JMapSerialization$ jMapSerialization$ = this;
        synchronized (jMapSerialization$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String nullMapping() {
        return this.nullMapping;
    }

    private scala.collection.immutable.Map<Class<?>, String> baseClassMappings() {
        return this.baseClassMappings;
    }

    private scala.collection.immutable.Map<String, Class<?>> baseClassLookups() {
        return this.baseClassLookups;
    }

    private Ordering<Tuple2<Object, Object>> ordering() {
        return this.ordering;
    }

    public void serialize(DataOutputStream out, Map<?, ?> javaMap) {
        SortedSet toWrite = SortedSet$.MODULE$.empty(this.ordering());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(javaMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Object v = tuple2._2();
            SortedSet sortedSet = (SortedSet)toWrite.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v));
            return sortedSet;
        });
        out.writeInt(toWrite.size());
        toWrite.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            JMapSerialization$.$anonfun$serialize$2(out, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void writeString(DataOutputStream out, String value) {
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        out.writeInt(valueBytes.length);
        out.write(valueBytes);
    }

    public Map<Object, Object> deserialize(DataInputStream in) {
        HashMap<Object, Object> hashMap;
        try {
            int size = in.readInt();
            HashMap<Object, Object> map = new HashMap<Object, Object>(size);
            this.deserializeWithSize(in, map, size);
            hashMap = map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logger().error("Error reading serialized kryo user data:", e);
            HashMap hashMap2 = new HashMap();
            hashMap = hashMap2;
        }
        return hashMap;
    }

    public void deserialize(DataInputStream in, Map<Object, Object> map) {
        try {
            this.deserializeWithSize(in, map, in.readInt());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logger().error("Error reading serialized kryo user data:", e);
                new HashMap();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private String readString(DataInputStream inputStream) {
        int valueLength = inputStream.readInt();
        byte[] values = new byte[valueLength];
        inputStream.readFully(values);
        return new String(values, 0, values.length);
    }

    private void deserializeWithSize(DataInputStream in, Map<Object, Object> map, int size) {
        for (int i = 0; i < size; ++i) {
            String valueClass;
            String keyClass = this.readString(in);
            Object key = this.read(in, (Class)this.baseClassLookups().getOrElse((Object)keyClass, (Function0 & Serializable & scala.Serializable)() -> Class.forName(keyClass)));
            String string = valueClass = this.readString(in);
            String string2 = this.nullMapping();
            Object value = !(string != null ? !string.equals(string2) : string2 != null) ? null : this.read(in, (Class)this.baseClassLookups().getOrElse((Object)valueClass, (Function0 & Serializable & scala.Serializable)() -> Class.forName(valueClass)));
            map.put(key, value);
        }
    }

    private void write(DataOutputStream out, Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            this.writeString(out, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            out.writeInt(Predef$.MODULE$.Integer2int(n));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            Long l = (Long)object;
            out.writeLong(Predef$.MODULE$.Long2long(l));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            Float f = (Float)object;
            out.writeFloat(Predef$.MODULE$.Float2float(f));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            Double d = (Double)object;
            out.writeDouble(Predef$.MODULE$.Double2double(d));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            out.writeBoolean(Predef$.MODULE$.Boolean2boolean(bl));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            out.writeLong(date.getTime());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.writeBytes(out, byArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            out.writeLong(uUID.getMostSignificantBits());
            out.writeLong(uUID.getLeastSignificantBits());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof List) {
            List list = (List)object;
            this.writeList(out, list);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported value: ").append(value).append(" (").append(value.getClass()).append(")").toString());
        }
    }

    private Object read(DataInputStream in, Class<?> clas) {
        List<Object> list;
        Class<?> clazz = clas;
        if (String.class.isAssignableFrom(clazz)) {
            list = this.readString(in).intern();
        } else if (Integer.class.isAssignableFrom(clazz)) {
            list = BoxesRunTime.boxToInteger((int)in.readInt());
        } else if (Long.class.isAssignableFrom(clazz)) {
            list = BoxesRunTime.boxToLong((long)in.readLong());
        } else if (Float.class.isAssignableFrom(clazz)) {
            list = BoxesRunTime.boxToFloat((float)in.readFloat());
        } else if (Double.class.isAssignableFrom(clazz)) {
            list = BoxesRunTime.boxToDouble((double)in.readDouble());
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            list = BoxesRunTime.boxToBoolean((boolean)in.readBoolean());
        } else if (java.util.Date.class.isAssignableFrom(clazz)) {
            list = new java.util.Date(in.readLong());
        } else if (Date.class.isAssignableFrom(clazz)) {
            list = new Date(in.readLong());
        } else if (byte[].class.equals(clazz)) {
            list = (List<Object>)this.readBytes(in);
        } else if (UUID.class.isAssignableFrom(clazz)) {
            list = new UUID(in.readLong(), in.readLong());
        } else if (List.class.isAssignableFrom(clazz)) {
            list = this.readList(in);
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported value class: ").append(clas).toString());
        }
        return list;
    }

    private void writeBytes(DataOutputStream out, byte[] bytes2) {
        out.writeInt(bytes2.length);
        out.write(bytes2);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes(DataInputStream in) {
        void var2_2;
        byte[] bytes2 = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.readFully(bytes2);
        return var2_2;
    }

    private void writeList(DataOutputStream out, List<Object> list) {
        out.writeInt(list.size());
        for (Object value : list) {
            if (value == null) {
                this.writeString(out, this.nullMapping());
                continue;
            }
            this.writeString(out, (String)this.baseClassMappings().getOrElse(value.getClass(), (Function0 & Serializable & scala.Serializable)() -> value.getClass().getName()));
            this.write(out, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> readList(DataInputStream in) {
        void var3_3;
        int size = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            String clas;
            String string = clas = this.readString(in);
            String string2 = this.nullMapping();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? list.add(null) : list.add(this.read(in, (Class)this.baseClassLookups().getOrElse((Object)clas, (Function0 & Serializable & scala.Serializable)() -> Class.forName(clas))));
        }
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$baseClassLookups$1(Tuple2 x$1) {
        return ((Class)x$1._1()).isPrimitive();
    }

    public static final /* synthetic */ void $anonfun$serialize$2(DataOutputStream out$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object key = tuple2._1();
            Object value = tuple2._2();
            MODULE$.writeString(out$1, (String)MODULE$.baseClassMappings().getOrElse(key.getClass(), (Function0 & Serializable & scala.Serializable)() -> key.getClass().getName()));
            MODULE$.write(out$1, key);
            if (value == null) {
                MODULE$.writeString(out$1, MODULE$.nullMapping());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                MODULE$.writeString(out$1, (String)MODULE$.baseClassMappings().getOrElse(value.getClass(), (Function0 & Serializable & scala.Serializable)() -> value.getClass().getName()));
                MODULE$.write(out$1, value);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private JMapSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
        this.nullMapping = "$_";
        this.baseClassMappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)"$s"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.TYPE), (Object)"$i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.class), (Object)"$i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.TYPE), (Object)"$l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.class), (Object)"$l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.TYPE), (Object)"$f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.class), (Object)"$f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.TYPE), (Object)"$d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.class), (Object)"$d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.TYPE), (Object)"$b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.class), (Object)"$b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Date.class), (Object)"$D"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(java.util.Date.class), (Object)"$D"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(byte[].class), (Object)"$B")}));
        this.baseClassLookups = (scala.collection.immutable.Map)this.baseClassMappings().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JMapSerialization$.$anonfun$baseClassLookups$1(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), Map$.MODULE$.canBuildFrom());
        this.ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$3 -> x$3._1().toString(), (Ordering)Ordering.String$.MODULE$);
    }
}

