/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.common.utils;

import com.geoway.atlas.common.utils.DateParsing$TemporalQueries$;
import com.geoway.atlas.common.utils.DateUtils$;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import scala.MatchError;

public final class DateParsing$ {
    public static DateParsing$ MODULE$;
    private final DateTimeFormatter format;
    private final ZonedDateTime Epoch;

    static {
        new DateParsing$();
    }

    private DateTimeFormatter format() {
        return this.format;
    }

    public ZonedDateTime Epoch() {
        return this.Epoch;
    }

    public ZonedDateTime parse(String value, DateTimeFormatter format) {
        ZonedDateTime zonedDateTime;
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery(), DateParsing$TemporalQueries$.MODULE$.YearMonthQuery(), DateParsing$TemporalQueries$.MODULE$.YearQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime2;
            zonedDateTime = zonedDateTime2 = (ZonedDateTime)temporalAccessor;
        } else if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            zonedDateTime = localDateTime.atZone(ZoneOffset.UTC);
        } else if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            zonedDateTime = localDate.atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        } else if (temporalAccessor instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)temporalAccessor;
            zonedDateTime = yearMonth.atDay(1).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        } else if (temporalAccessor instanceof Year) {
            Year year = (Year)temporalAccessor;
            zonedDateTime = year.atMonth(1).atDay(1).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        return zonedDateTime;
    }

    public DateTimeFormatter parse$default$2() {
        return this.format();
    }

    public Instant parseInstant(String value, DateTimeFormatter format) {
        Instant instant;
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            instant = zonedDateTime.toInstant();
        } else if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            instant = localDateTime.toInstant(ZoneOffset.UTC);
        } else if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            instant = localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC);
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        return instant;
    }

    public DateTimeFormatter parseInstant$default$2() {
        return this.format();
    }

    public Date parseDate(String value, DateTimeFormatter format) {
        Date date;
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            date = Date.from(zonedDateTime.toInstant());
        } else if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            date = Date.from(localDateTime.toInstant(ZoneOffset.UTC));
        } else if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            date = Date.from(localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC));
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        return date;
    }

    public DateTimeFormatter parseDate$default$2() {
        return this.format();
    }

    public long parseMillis(String value, DateTimeFormatter format) {
        long l;
        TemporalAccessor temporalAccessor = format.parseBest(value, DateParsing$TemporalQueries$.MODULE$.ZonedQuery(), DateParsing$TemporalQueries$.MODULE$.LocalQuery(), DateParsing$TemporalQueries$.MODULE$.LocalDateQuery());
        if (temporalAccessor instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            l = zonedDateTime.toInstant().toEpochMilli();
        } else if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
            l = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        } else if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            l = localDate.atTime(LocalTime.MIN).toInstant(ZoneOffset.UTC).toEpochMilli();
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        return l;
    }

    public DateTimeFormatter parseMillis$default$2() {
        return this.format();
    }

    public String format(ZonedDateTime value, DateTimeFormatter format) {
        return value.format(format);
    }

    public DateTimeFormatter format$default$2() {
        return this.format();
    }

    public String formatDate(Date value, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(value), ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatDate$default$2() {
        return this.format();
    }

    public String formatInstant(Instant value, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(value, ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatInstant$default$2() {
        return this.format();
    }

    public String formatMillis(long value, DateTimeFormatter format) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC).format(format);
    }

    public DateTimeFormatter formatMillis$default$2() {
        return this.format();
    }

    private DateParsing$() {
        MODULE$ = this;
        this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        this.Epoch = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    }
}

