/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.common.utils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.RichChar$;

public final class StringUtils$ {
    public static StringUtils$ MODULE$;
    private final Pattern AlphaNumericPattern;
    private final IndexedSeq<Object> AlphaNumeric;

    static {
        new StringUtils$();
    }

    private Pattern AlphaNumericPattern() {
        return this.AlphaNumericPattern;
    }

    private IndexedSeq<Object> AlphaNumeric() {
        return this.AlphaNumeric;
    }

    public String fitStringRegardingCharset(String s, int bytesCnt, Charset charset) {
        int len = s.length();
        String result = s;
        while (result.getBytes(charset).length > bytesCnt) {
            result = s.substring(0, --len);
        }
        return result;
    }

    public String fitMidStringRegardingCharset(String s, int bytesCnt, Charset charset) {
        int minCnt;
        int len = s.length();
        String result = s;
        int leftEnd = minCnt = len / 2;
        int rightStart = minCnt;
        int index = 0;
        while (result.getBytes(charset).length > bytesCnt) {
            if (index % 2 == 0) {
                --leftEnd;
            } else {
                ++rightStart;
            }
            result = new StringBuilder(0).append(s.substring(0, leftEnd)).append(s.substring(rightStart)).toString();
            ++index;
        }
        return result;
    }

    public String fastParse(byte[] bytes2) {
        return this.fastParse(bytes2, 0, bytes2.length);
    }

    public String fastParse(byte[] bytes2, int fieldOffset, int fieldLen) {
        char[] chars = new char[fieldLen];
        for (int index$macro$1 = 0; index$macro$1 < fieldLen; ++index$macro$1) {
            chars[index$macro$1] = (char)(0xFF & bytes2[fieldOffset + index$macro$1]);
        }
        return new String(chars);
    }

    public String getUniqueStringFromSeq(String uniqueString, List<String> seq) {
        return this.getUniqueStringFromSeq(uniqueString, (Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(seq).asScala()));
    }

    public String getUniqueStringFromSeq(String uniqueString, Seq<String> seq) {
        String suffix = "";
        String tempString = uniqueString;
        int count = 0;
        do {
            tempString = new StringBuilder(0).append(uniqueString).append(suffix).toString();
            suffix = new StringBuilder(1).append("_").append(++count).toString();
        } while (seq.contains((Object)tempString));
        return tempString;
    }

    public String stripMarginAndWhitespace(String string, char separator) {
        scala.collection.mutable.StringBuilder trimmed = new scala.collection.mutable.StringBuilder();
        new StringOps(Predef$.MODULE$.augmentString(string)).linesWithSeparators().foreach((Function1 & Serializable & scala.Serializable)line -> {
            Object object;
            int index = new StringOps(Predef$.MODULE$.augmentString(line)).indexWhere((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringUtils$.$anonfun$stripMarginAndWhitespace$2(BoxesRunTime.unboxToChar((Object)x$3))));
            if (index == -1) {
                object = trimmed.append(line);
            } else {
                if (line.charAt(index) == separator) {
                    ++index;
                }
                while (index < line.length() && RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(line.charAt(index)))) {
                    ++index;
                }
                object = index < line.length() ? trimmed.append(line.substring(index)) : BoxedUnit.UNIT;
            }
            return object;
        });
        return trimmed.toString();
    }

    public char stripMarginAndWhitespace$default$2() {
        return '|';
    }

    public String hexEncodeFormat(short s) {
        byte[] bytes2 = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return Hex.encodeHexString((byte[])bytes2);
    }

    public short hexDecodeShortFormat(String string) {
        byte[] shortBytes = Hex.decodeHex((String)string);
        return (short)(shortBytes[0] << 8 & 0xFF00 | shortBytes[1] & 0xFF);
    }

    public String hexEncodeFormat(int n) {
        byte[] bytes2 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return Hex.encodeHexString((byte[])bytes2);
    }

    public int hexDecodeIntFormat(String string) {
        byte[] intBytes = Hex.decodeHex((String)string);
        return intBytes[0] << 24 & 0xFF000000 | intBytes[1] << 16 & 0xFF0000 | intBytes[2] << 8 & 0xFF00 | intBytes[3] & 0xFF;
    }

    public String alphaNumericSafeString(String input) {
        String string;
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            string = input;
        } else {
            scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
            new StringOps(Predef$.MODULE$.augmentString(input)).foreach((Function1 & Serializable & scala.Serializable)c -> StringUtils$.$anonfun$alphaNumericSafeString$1(sb, BoxesRunTime.unboxToChar((Object)c)));
            string = sb.toString();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$stripMarginAndWhitespace$2(char x$3) {
        return x$3 > ' ';
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$alphaNumericSafeString$1(scala.collection.mutable.StringBuilder sb$1, char c) {
        scala.collection.mutable.StringBuilder stringBuilder;
        if (MODULE$.AlphaNumeric().contains((Object)BoxesRunTime.boxToCharacter((char)c))) {
            stringBuilder = sb$1.append(c);
        } else {
            char[] hex = Hex.encodeHex((byte[])Character.toString(c).getBytes(StandardCharsets.UTF_8));
            String encoded = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(hex)).grouped(2).map((Function1 & Serializable & scala.Serializable)arr -> new StringBuilder(1).append("_").append(arr[0]).append(arr[1]).toString()).mkString().toLowerCase(Locale.US);
            stringBuilder = sb$1.append(encoded);
        }
        return stringBuilder;
    }

    private StringUtils$() {
        MODULE$ = this;
        this.AlphaNumericPattern = Pattern.compile("^[a-zA-Z0-9]+$");
        this.AlphaNumeric = (IndexedSeq)((TraversableLike)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')), IndexedSeq$.MODULE$.canBuildFrom());
    }
}

