/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.dataset.common.manager;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.dataset.AtlasDataSet;
import com.geoway.atlas.dataset.common.manager.AtlasDataTag;
import com.geoway.atlas.dataset.common.manager.AtlasDataTagPair;
import com.geoway.atlas.dataset.common.manager.DataManager;
import java.io.Serializable;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DataManager$ {
    public static DataManager$ MODULE$;
    private final String REGISTER_TIME;
    private final String DATA_TYPE;
    private final String IDENTITY_SUFFIX;
    private final String DATA_MANAGER_CONFIG;
    private DataManager dataManager;

    static {
        new DataManager$();
    }

    public String REGISTER_TIME() {
        return this.REGISTER_TIME;
    }

    public String DATA_TYPE() {
        return this.DATA_TYPE;
    }

    public String IDENTITY_SUFFIX() {
        return this.IDENTITY_SUFFIX;
    }

    public String DATA_MANAGER_CONFIG() {
        return this.DATA_MANAGER_CONFIG;
    }

    public DataManager dataManager() {
        return this.dataManager;
    }

    public void dataManager_$eq(DataManager x$1) {
        this.dataManager = x$1;
    }

    private DataManager getDataManager() {
        String dataManagerOpt = AtlasSystemProperties$.MODULE$.getProperty(this.DATA_MANAGER_CONFIG());
        if (dataManagerOpt == null) {
            String x$12 = new StringBuilder(14).append("\u6ca1\u6709\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u627e\u5230\u914d\u7f6e\u9879:").append(this.DATA_MANAGER_CONFIG()).toString();
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$12);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$12);
            throw new NotFoundException(x$12, x$2, x$3);
        }
        String framework = AtlasSystemProperties$.MODULE$.getFramework();
        Iterator dataManagers = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ServiceLoader.load(DataManager.class).iterator()).asScala();
        Option dmOpt = dataManagers.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canProcess((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataManager$.MODULE$.DATA_MANAGER_CONFIG()), (Object)dataManagerOpt), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasSystemProperties$.MODULE$.ATLAS_FRAMEWORK()), (Object)framework)}))))));
        return (DataManager)dmOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String x$4 = "\u672a\u627e\u5230DataManager\u7684\u5b9e\u73b0\u7c7b!";
            Thread x$5 = NotFoundException$.MODULE$.apply$default$2(x$4);
            int x$6 = NotFoundException$.MODULE$.apply$default$3(x$4);
            throw new NotFoundException(x$4, x$5, x$6);
        });
    }

    public <Q, R, T> void register(AtlasDataSet<Q, R, T> atlasDataSet, Option<Map<String, String>> labelOptions) {
        this.dataManager().register(atlasDataSet, labelOptions);
    }

    public <Q, R, T> void unregister(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOptions) {
        this.dataManager().unregister(atlasDataName, matchLabelOptions);
    }

    public <Q, R, T> void unregister(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOptions, boolean deleteIfRelated) {
        this.dataManager().unregister(atlasDataName, matchLabelOptions, deleteIfRelated);
    }

    public <Q, R, T> void unregister(Option<Map<String, String>> matchLabelOptions) {
        block0: {
            this.dataManager().unregister(matchLabelOptions);
            if (!matchLabelOptions.exists((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)m.contains((Object)DataManager$.MODULE$.IDENTITY_SUFFIX())))) break block0;
            String[] lockKeys = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.dataManager().layerLocks().keySet()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
            String identitySuffix = (String)((MapLike)matchLabelOptions.get()).apply((Object)this.IDENTITY_SUFFIX());
            ConcurrentMap<String, String> concurrentMap = this.dataManager().layerLocks();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lockKeys)).filter((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DataManager$.$anonfun$unregister$4(identitySuffix, k))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (String)concurrentMap.remove(x$1));
        }
    }

    public <Q, R, T> Tuple2<AtlasDataSet<Q, R, T>, Option<Map<String, String>>> get(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOptions) {
        return this.dataManager().get(atlasDataName, matchLabelOptions);
    }

    public void rename(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOptions, AtlasDataName newName) {
        this.dataManager().rename(atlasDataName, matchLabelOptions, newName);
    }

    public String getCurrentDataLock(AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        String identityName = this.getViewName(new AtlasDataTag(atlasDataName, labelOptions), this.getViewName$default$2());
        return this.dataManager().layerLocks().computeIfAbsent(identityName, k -> k);
    }

    public AtlasDataTag getDataTag(AtlasDataName atlasDataName, Option<Map<String, String>> matchLabelOptions) {
        return this.dataManager().getMatchDataTag(atlasDataName, matchLabelOptions);
    }

    public void addRelation(AtlasDataName fatherDataName, Option<Map<String, String>> fatherMatchLabel, AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions, Option<Map<String, String>> dataRelationOption) {
        this.dataManager().addRelation(fatherDataName, fatherMatchLabel, atlasDataName, labelOptions, dataRelationOption);
    }

    public Option<Map<String, String>> getDataRelation(AtlasDataName fatherDataName, Option<Map<String, String>> fatherMatchLabel, AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        return this.dataManager().getDataRelation(fatherDataName, fatherMatchLabel, atlasDataName, labelOptions);
    }

    public Seq<AtlasDataTag> getPreDataTag(AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        return this.dataManager().getPreDataTag(atlasDataName, labelOptions);
    }

    public Seq<AtlasDataTag> getBehDataTag(AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        return this.dataManager().getBehDataTag(atlasDataName, labelOptions);
    }

    public Seq<AtlasDataTagPair> getAllDataRelation(AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        return this.dataManager().getAllDataRelation(atlasDataName, labelOptions);
    }

    public String getViewName(AtlasDataTag atlasDataTag, boolean isAddIdentity) {
        Object object;
        BoxedUnit boxedUnit;
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)atlasDataTag.atlasDataName().nameSpace())) {
            sb.append(atlasDataTag.atlasDataName().nameSpace());
            boxedUnit = sb.append("_");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        sb.append(atlasDataTag.atlasDataName().localName());
        if (isAddIdentity) {
            if (atlasDataTag.labelOptions().isDefined() && ((MapLike)atlasDataTag.labelOptions().get()).contains((Object)this.IDENTITY_SUFFIX())) {
                sb.append("_");
                String suffix = (String)((MapLike)atlasDataTag.labelOptions().get()).apply((Object)this.IDENTITY_SUFFIX());
                object = StringUtils.isNotEmpty((CharSequence)suffix) ? sb.append(suffix) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    public boolean getViewName$default$2() {
        return true;
    }

    public void persistData(AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        this.dataManager().persistData(atlasDataName, labelOptions);
    }

    public void unPersistData(AtlasDataName atlasDataName, Option<Map<String, String>> labelOptions) {
        this.dataManager().persistData(atlasDataName, labelOptions);
    }

    public String getSpecifyDataInfo(AtlasDataTag atlasDataTag, String key) {
        return this.dataManager().getSpecifyDataInfo(atlasDataTag, key);
    }

    public Map<String, String> getAllDataInfo(AtlasDataTag atlasDataTag) {
        return this.dataManager().getAllDataInfo(atlasDataTag);
    }

    public static final /* synthetic */ boolean $anonfun$unregister$4(String identitySuffix$1, String k) {
        return StringUtils.endsWithIgnoreCase((CharSequence)k, (CharSequence)identitySuffix$1);
    }

    private DataManager$() {
        MODULE$ = this;
        this.REGISTER_TIME = "atlas.data.register.time";
        this.DATA_TYPE = "atlas.data.type";
        this.IDENTITY_SUFFIX = "atlas.data.identity.suffix";
        this.DATA_MANAGER_CONFIG = "atlas.data.manager.config";
        this.dataManager = this.getDataManager();
    }
}

