/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2RegionCoverer;
import java.io.Serializable;
import java.util.List;
import org.locationtech.geomesa.curve.S2SFC$;
import org.locationtech.geomesa.curve.SpaceFillingCurve;
import org.locationtech.sfcurve.IndexRange;
import org.locationtech.sfcurve.IndexRange$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015A\u0004\u0001\"\u0011:\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015Q\u0007\u0001\"\u0011l\u000f\u0015\th\u0003#\u0001s\r\u0015)b\u0003#\u0001t\u0011\u0015\t$\u0002\"\u0001u\u0011\u001d)(B1A\u0005\nYDaa\u001e\u0006!\u0002\u0013y\u0004b\u0002=\u000b\u0005\u0004%IA\u001e\u0005\u0007s*\u0001\u000b\u0011B \t\u000fiT!\u0019!C\u0005m\"11P\u0003Q\u0001\n}Bq\u0001 \u0006C\u0002\u0013%a\u000f\u0003\u0004~\u0015\u0001\u0006Ia\u0010\u0005\u0006}*!\ta \u0002\u0006'J\u001afi\u0011\u0006\u0003/a\tQaY;sm\u0016T!!\u0007\u000e\u0002\u000f\u001d,w.\\3tC*\u00111\u0004H\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9\u0003&D\u0001\u0017\u0013\tIcCA\tTa\u0006\u001cWMR5mY&twmQ;sm\u0016\f\u0001\"\\5o\u0019\u00164X\r\u001c\t\u0003C1J!!\f\u0012\u0003\u0007%sG/\u0001\u0005nCbdUM^3m\u0003!aWM^3m\u001b>$\u0017\u0001C7bq\u000e+G\u000e\\:\u0002\rqJg.\u001b;?)\u0015\u0019D'\u000e\u001c8!\t9\u0003\u0001C\u0003+\u000b\u0001\u00071\u0006C\u0003/\u000b\u0001\u00071\u0006C\u00030\u000b\u0001\u00071\u0006C\u00031\u000b\u0001\u00071&A\u0003j]\u0012,\u0007\u0010\u0006\u0003;{\t#\u0005CA\u0011<\u0013\ta$E\u0001\u0003M_:<\u0007\"\u0002 \u0007\u0001\u0004y\u0014!\u0001=\u0011\u0005\u0005\u0002\u0015BA!#\u0005\u0019!u.\u001e2mK\")1I\u0002a\u0001\u007f\u0005\t\u0011\u0010C\u0004F\rA\u0005\t\u0019\u0001$\u0002\u000f1,g.[3oiB\u0011\u0011eR\u0005\u0003\u0011\n\u0012qAQ8pY\u0016\fg.\u0001\u0004sC:<Wm\u001d\u000b\u0005\u0017v\u001bW\rE\u0002M)^s!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005As\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0019&%A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&aA*fc*\u00111K\t\t\u00031nk\u0011!\u0017\u0006\u00035j\tqa\u001d4dkJ4X-\u0003\u0002]3\nQ\u0011J\u001c3fqJ\u000bgnZ3\t\u000by;\u0001\u0019A0\u0002\u0005aL\bc\u0001'UAB1\u0011%Y @\u007f}J!A\u0019\u0012\u0003\rQ+\b\u000f\\35\u0011\u001d!w\u0001%AA\u0002-\n\u0011\u0002\u001d:fG&\u001c\u0018n\u001c8\t\u000f\u0019<\u0001\u0013!a\u0001O\u0006IQ.\u0019=SC:<Wm\u001d\t\u0004C!\\\u0013BA5#\u0005\u0019y\u0005\u000f^5p]\u00061\u0011N\u001c<feR$\"\u0001\\8\u0011\t\u0005jwhP\u0005\u0003]\n\u0012a\u0001V;qY\u0016\u0014\u0004\"\u00029\t\u0001\u0004Q\u0014!A5\u0002\u000bM\u00134KR\"\u0011\u0005\u001dR1C\u0001\u0006!)\u0005\u0011\u0018A\u0002'p]6Kg.F\u0001@\u0003\u001dauN\\'j]\u0002\na\u0001T8o\u001b\u0006D\u0018a\u0002'p]6\u000b\u0007\u0010I\u0001\u0007\u0019\u0006$X*\u001b8\u0002\u000f1\u000bG/T5oA\u00051A*\u0019;NCb\fq\u0001T1u\u001b\u0006D\b%A\u0003baBd\u0017\u0010F\u00054\u0003\u0003\t\u0019!!\u0002\u0002\b!)!\u0006\u0006a\u0001W!)a\u0006\u0006a\u0001W!)q\u0006\u0006a\u0001W!)\u0001\u0007\u0006a\u0001W\u0001")
public class S2SFC
implements SpaceFillingCurve {
    private final int minLevel;
    private final int maxLevel;
    private final int levelMod;
    private final int maxCells;

    public static S2SFC apply(int n, int n2, int n3, int n4) {
        return S2SFC$.MODULE$.apply(n, n2, n3, n4);
    }

    @Override
    public boolean index$default$3() {
        return SpaceFillingCurve.index$default$3$(this);
    }

    @Override
    public Seq<IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y) {
        return SpaceFillingCurve.ranges$(this, x, y);
    }

    @Override
    public Seq<IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y, int precision) {
        return SpaceFillingCurve.ranges$(this, x, y, precision);
    }

    @Override
    public Seq<IndexRange> ranges(Tuple2<Object, Object> x, Tuple2<Object, Object> y, int precision, Option<Object> maxRanges) {
        return SpaceFillingCurve.ranges$(this, x, y, precision, maxRanges);
    }

    @Override
    public int ranges$default$2() {
        return SpaceFillingCurve.ranges$default$2$(this);
    }

    @Override
    public Option<Object> ranges$default$3() {
        return SpaceFillingCurve.ranges$default$3$(this);
    }

    @Override
    public long index(double x, double y, boolean lenient) {
        long l;
        if (lenient) {
            double bx;
            double d = x < S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMin() ? S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMin() : (bx = x > S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMax() ? S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMax() : x);
            double by = y < S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMin() ? S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMin() : (y > S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMax() ? S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMax() : y);
            l = S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)by, (double)bx)).id();
        } else {
            Predef$.MODULE$.require(x >= S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMin() && x <= S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMax() && y >= S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMin() && y <= S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMax(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Value(s) out of bounds ([").append(S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMin()).append(",").append(S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LonMax()).append("], [").append(S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMin()).append(",").append(S2SFC$.MODULE$.org$locationtech$geomesa$curve$S2SFC$$LatMax()).append("]): ").append(x).append(", ").append(y).toString());
            l = S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)y, (double)x)).id();
        }
        return l;
    }

    @Override
    public Seq<IndexRange> ranges(Seq<Tuple4<Object, Object, Object, Object>> xy, int precision, Option<Object> maxRanges) {
        return (Seq)xy.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            S2LatLng lo = S2LatLng.fromDegrees((double)ymin, (double)xmin);
            S2LatLng hi = S2LatLng.fromDegrees((double)ymax, (double)xmax);
            S2LatLngRect rect = new S2LatLngRect(lo, hi);
            S2RegionCoverer cover = new S2RegionCoverer();
            cover.setMinLevel($this.minLevel);
            cover.setMaxLevel($this.maxLevel);
            cover.setLevelMod($this.levelMod);
            cover.setMaxCells($this.maxCells);
            S2CellUnion s2CellUnion = cover.getCovering((S2Region)rect);
            Builder builder = Seq$.MODULE$.newBuilder();
            builder.sizeHint(s2CellUnion.cellIds().size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)s2CellUnion.cellIds()).asScala()).foreach((Function1 & Serializable & scala.Serializable)c -> builder.$plus$eq((Object)IndexRange$.MODULE$.apply(c.rangeMin().id(), c.rangeMax().id(), true)));
            Seq seq = (Seq)builder.result();
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Tuple2<Object, Object> invert(long i) {
        S2LatLng latLon = new S2CellId(i).toLatLng();
        return new Tuple2.mcDD.sp(latLon.lngDegrees(), latLon.latDegrees());
    }

    public S2SFC(int minLevel, int maxLevel, int levelMod, int maxCells) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.levelMod = levelMod;
        this.maxCells = maxCells;
        SpaceFillingCurve.$init$(this);
    }
}

