/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.TimePeriod$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class BinnedTime$
implements Serializable {
    public static BinnedTime$ MODULE$;
    private final ZonedDateTime Epoch;
    private final ZonedDateTime ZMinDate;
    private final ZonedDateTime DaysMaxDate;
    private final ZonedDateTime WeeksMaxDate;
    private final ZonedDateTime MonthsMaxDate;
    private final ZonedDateTime YearsMaxDate;

    static {
        new BinnedTime$();
    }

    public ZonedDateTime Epoch() {
        return this.Epoch;
    }

    public ZonedDateTime ZMinDate() {
        return this.ZMinDate;
    }

    public ZonedDateTime DaysMaxDate() {
        return this.DaysMaxDate;
    }

    public ZonedDateTime WeeksMaxDate() {
        return this.WeeksMaxDate;
    }

    public ZonedDateTime MonthsMaxDate() {
        return this.MonthsMaxDate;
    }

    public ZonedDateTime YearsMaxDate() {
        return this.YearsMaxDate;
    }

    public Function1<Object, BinnedTime> timeToBinnedTime(Enumeration.Value period) {
        Function1 & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (Function1 & java.io.Serializable & Serializable)time -> BinnedTime$.MODULE$.toDayAndMillis(BoxesRunTime.unboxToLong((Object)time));
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (Function1 & java.io.Serializable & Serializable)time -> BinnedTime$.MODULE$.toWeekAndSeconds(BoxesRunTime.unboxToLong((Object)time));
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (Function1 & java.io.Serializable & Serializable)time -> BinnedTime$.MODULE$.toMonthAndSeconds(BoxesRunTime.unboxToLong((Object)time));
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        intersect = (Function1 & java.io.Serializable & Serializable)time -> BinnedTime$.MODULE$.toYearAndMinutes(BoxesRunTime.unboxToLong((Object)time));
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> timeToBin(Enumeration.Value period) {
        Function1 & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (Function1 & java.io.Serializable & Serializable)time -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toDay(BoxesRunTime.unboxToLong((Object)time)));
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (Function1 & java.io.Serializable & Serializable)time -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toWeek(BoxesRunTime.unboxToLong((Object)time)));
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (Function1 & java.io.Serializable & Serializable)time -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toMonth(BoxesRunTime.unboxToLong((Object)time)));
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        intersect = (Function1 & java.io.Serializable & Serializable)time -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toYear(BoxesRunTime.unboxToLong((Object)time)));
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return intersect;
    }

    public Function1<ZonedDateTime, BinnedTime> dateToBinnedTime(Enumeration.Value period) {
        Function1 & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.toDayAndMillis((ZonedDateTime)date);
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.toWeekAndSeconds((ZonedDateTime)date);
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.toMonthAndSeconds((ZonedDateTime)date);
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.toYearAndMinutes((ZonedDateTime)date);
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return intersect;
    }

    public Function1<ZonedDateTime, Object> dateToBin(Enumeration.Value period) {
        Function1 & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (Function1 & java.io.Serializable & Serializable)date -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toDay(date));
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (Function1 & java.io.Serializable & Serializable)date -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toWeek(date));
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (Function1 & java.io.Serializable & Serializable)date -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toMonth(date));
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        intersect = (Function1 & java.io.Serializable & Serializable)date -> BoxesRunTime.boxToShort((short)BinnedTime$.MODULE$.toYear(date));
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return intersect;
    }

    public Function1<BinnedTime, ZonedDateTime> binnedTimeToDate(Enumeration.Value period) {
        Function1 & java.io.Serializable & Serializable intersect;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.fromDayAndMillis((BinnedTime)date);
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.fromWeekAndSeconds((BinnedTime)date);
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.fromMonthAndSeconds((BinnedTime)date);
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        intersect = (Function1 & java.io.Serializable & Serializable)date -> MODULE$.fromYearAndMinutes((BinnedTime)date);
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return intersect;
    }

    public long maxOffset(Enumeration.Value period) {
        long l;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            l = ChronoUnit.DAYS.getDuration().toMillis();
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                l = ChronoUnit.WEEKS.getDuration().toMillis() / 1000L;
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    l = ChronoUnit.DAYS.getDuration().toMillis() / 1000L * 31L;
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        l = ChronoUnit.DAYS.getDuration().toMinutes() * 366L + 10L;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return l;
    }

    public ZonedDateTime maxDate(Enumeration.Value period) {
        ZonedDateTime zonedDateTime;
        Enumeration.Value value = period;
        Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            zonedDateTime = this.DaysMaxDate();
        } else {
            Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                zonedDateTime = this.WeeksMaxDate();
            } else {
                Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    zonedDateTime = this.MonthsMaxDate();
                } else {
                    Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        zonedDateTime = this.YearsMaxDate();
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        return zonedDateTime;
    }

    public Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToIndexableDates(Enumeration.Value period) {
        ZonedDateTime maxDateTime = this.maxDate(period).minus(1L, ChronoUnit.MILLIS);
        return arg_0 -> BinnedTime$.$anonfun$boundsToIndexableDates$1(maxDateTime, arg_0);
    }

    private short toDay(long time) {
        return this.toDay(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private short toDay(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds minimum indexable value (").append(MODULE$.ZMinDate()).append("): ").append(date).toString());
        Predef$.MODULE$.require(this.DaysMaxDate().isAfter(date), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds maximum indexable value (").append(MODULE$.DaysMaxDate()).append("): ").append(date).toString());
        return (short)ChronoUnit.DAYS.between(this.Epoch(), date);
    }

    private BinnedTime toDayAndMillis(long time) {
        return this.toDayAndMillis(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private BinnedTime toDayAndMillis(ZonedDateTime date) {
        short days = this.toDay(date);
        long millisInDay = date.toInstant().toEpochMilli() - this.Epoch().plus(days, ChronoUnit.DAYS).toInstant().toEpochMilli();
        return new BinnedTime(days, millisInDay);
    }

    private ZonedDateTime fromDayAndMillis(BinnedTime date) {
        return this.Epoch().plusDays(date.bin()).plus(date.offset(), ChronoUnit.MILLIS);
    }

    private short toWeek(long time) {
        return this.toWeek(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private short toWeek(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds minimum indexable value (").append(MODULE$.ZMinDate()).append("): ").append(date).toString());
        Predef$.MODULE$.require(this.WeeksMaxDate().isAfter(date), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds maximum indexable value (").append(MODULE$.WeeksMaxDate()).append("): ").append(date).toString());
        return (short)ChronoUnit.WEEKS.between(this.Epoch(), date);
    }

    private BinnedTime toWeekAndSeconds(long time) {
        return this.toWeekAndSeconds(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private BinnedTime toWeekAndSeconds(ZonedDateTime date) {
        short weeks = this.toWeek(date);
        long secondsInWeek = date.toEpochSecond() - this.Epoch().plus(weeks, ChronoUnit.WEEKS).toEpochSecond();
        return new BinnedTime(weeks, secondsInWeek);
    }

    private ZonedDateTime fromWeekAndSeconds(BinnedTime date) {
        return this.Epoch().plusWeeks(date.bin()).plus(date.offset(), ChronoUnit.SECONDS);
    }

    private short toMonth(long time) {
        return this.toMonth(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private short toMonth(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds minimum indexable value (").append(MODULE$.ZMinDate()).append("): ").append(date).toString());
        Predef$.MODULE$.require(this.MonthsMaxDate().isAfter(date), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds maximum indexable value (").append(MODULE$.MonthsMaxDate()).append("): ").append(date).toString());
        return (short)ChronoUnit.MONTHS.between(this.Epoch(), date);
    }

    private BinnedTime toMonthAndSeconds(long time) {
        return this.toMonthAndSeconds(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private BinnedTime toMonthAndSeconds(ZonedDateTime date) {
        short months = this.toMonth(date);
        long secondsInMonth = date.toEpochSecond() - this.Epoch().plus(months, ChronoUnit.MONTHS).toEpochSecond();
        return new BinnedTime(months, secondsInMonth);
    }

    private ZonedDateTime fromMonthAndSeconds(BinnedTime date) {
        return this.Epoch().plusMonths(date.bin()).plus(date.offset(), ChronoUnit.SECONDS);
    }

    private short toYear(long time) {
        return this.toYear(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private short toYear(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds minimum indexable value (").append(MODULE$.ZMinDate()).append("): ").append(date).toString());
        Predef$.MODULE$.require(this.YearsMaxDate().isAfter(date), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Date exceeds maximum indexable value (").append(MODULE$.YearsMaxDate()).append("): ").append(date).toString());
        return (short)ChronoUnit.YEARS.between(this.Epoch(), date);
    }

    private BinnedTime toYearAndMinutes(long time) {
        return this.toYearAndMinutes(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    private BinnedTime toYearAndMinutes(ZonedDateTime date) {
        short years = this.toYear(date);
        long minutesInYear = (date.toEpochSecond() - this.Epoch().plus(years, ChronoUnit.YEARS).toEpochSecond()) / 60L;
        return new BinnedTime(years, minutesInYear);
    }

    private ZonedDateTime fromYearAndMinutes(BinnedTime date) {
        return this.Epoch().plusYears(date.bin()).plus(date.offset(), ChronoUnit.MINUTES);
    }

    public BinnedTime apply(short bin, long offset) {
        return new BinnedTime(bin, offset);
    }

    public Option<Tuple2<Object, Object>> unapply(BinnedTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)x$0.bin()), (Object)BoxesRunTime.boxToLong((long)x$0.offset())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$boundsToIndexableDates$1(ZonedDateTime maxDateTime$1, Tuple2 bounds) {
        block15: {
            block14: {
                block13: {
                    block12: {
                        var5_2 = false;
                        var6_3 = null;
                        var7_4 = (Option)bounds._1();
                        if (!None$.MODULE$.equals(var7_4)) break block12;
                        var3_5 = BinnedTime$.MODULE$.ZMinDate();
                        break block13;
                    }
                    if (!(var7_4 instanceof Some)) ** GOTO lbl-1000
                    var5_2 = true;
                    var6_3 = (Some)var7_4;
                    dt = (ZonedDateTime)var6_3.value();
                    if (dt.isBefore(BinnedTime$.MODULE$.ZMinDate())) {
                        var3_5 = BinnedTime$.MODULE$.ZMinDate();
                    } else if (var5_2 && (dt = (ZonedDateTime)var6_3.value()).isAfter(maxDateTime$1)) {
                        var3_5 = maxDateTime$1;
                    } else if (var5_2) {
                        var3_5 = dt = (ZonedDateTime)var6_3.value();
                    } else {
                        throw new MatchError((Object)var7_4);
                    }
                }
                lo = var3_5;
                var12_10 = false;
                var13_11 = null;
                var14_12 = (Option)bounds._2();
                if (!None$.MODULE$.equals(var14_12)) break block14;
                var2_13 = maxDateTime$1;
                break block15;
            }
            if (!(var14_12 instanceof Some)) ** GOTO lbl-1000
            var12_10 = true;
            var13_11 = (Some)var14_12;
            dt = (ZonedDateTime)var13_11.value();
            if (dt.isBefore(BinnedTime$.MODULE$.ZMinDate())) {
                var2_13 = BinnedTime$.MODULE$.ZMinDate();
            } else if (var12_10 && (dt = (ZonedDateTime)var13_11.value()).isAfter(maxDateTime$1)) {
                var2_13 = maxDateTime$1;
            } else if (var12_10) {
                var2_13 = dt = (ZonedDateTime)var13_11.value();
            } else {
                throw new MatchError((Object)var14_12);
            }
        }
        hi = var2_13;
        return new Tuple2((Object)lo, (Object)hi);
    }

    private BinnedTime$() {
        MODULE$ = this;
        this.Epoch = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        this.ZMinDate = this.Epoch();
        this.DaysMaxDate = this.Epoch().plusDays(Short.MAX_VALUE + 1);
        this.WeeksMaxDate = this.Epoch().plusWeeks(Short.MAX_VALUE + 1);
        this.MonthsMaxDate = this.Epoch().plusMonths(Short.MAX_VALUE + 1);
        this.YearsMaxDate = this.Epoch().plusYears(Short.MAX_VALUE + 1);
    }
}

