/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.gis.toolkit.log.es.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geoway.atlas.common.utils.LogUtils;
import com.geoway.atlas.gis.toolkit.log.EsLogMsg;
import com.geoway.atlas.gis.toolkit.log.EsProvider;
import com.geoway.atlas.gis.toolkit.log.es.EsClientApi;
import com.geoway.atlas.gis.toolkit.log.es.EsFlusher;
import com.geoway.atlas.gis.toolkit.log.es.impl.EsHttpClient;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class EsClient
implements EsClientApi {
    protected static final Logger LOGGER = LogManager.getLogger(EsClient.class);
    protected static final Logger STATUS_LOGGER = StatusLogger.getLogger();
    public static final BlockingQueue LOG_QUEUE = new ArrayBlockingQueue(100000, true);
    private static ThreadLocal<DateFormat> LocalDateFormate = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private static AtomicInteger THREAD_ID = new AtomicInteger(0);
    private static int BULK_SIZE = 1000;
    private static int INTERVAL_MS = 5000;
    private String host;
    private String user;
    private String password;
    private String index;
    private Thread flushThread;
    private EsHttpClient esHttpClient;

    public EsClient(String host, String user, String password, String index) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.index = index;
    }

    @Override
    public void start() {
        this.esHttpClient = new EsHttpClient(this.host, this.user, this.password, this.index);
        if (this.esHttpClient.needCreateIndex()) {
            LOGGER.info("\u521b\u5efa\u65e5\u5fd7\u7d22\u5f15:" + this.index);
            this.esHttpClient.createIndex();
        }
        EsFlusher esFlusher = new EsFlusher(this, INTERVAL_MS);
        String threadName = "Log-Es-Thread-" + THREAD_ID.getAndIncrement();
        this.flushThread = new Thread((Runnable)esFlusher, threadName);
        LOGGER.info("\u542f\u52a8\u5b9a\u65f6\u540c\u6b65\u65e5\u5fd7\u7ebf\u7a0b:" + threadName);
        this.flushThread.start();
    }

    @Override
    public void insert(Map<String, Object> message) {
        EsLogMsg esLogMsg = new EsLogMsg();
        if (message.containsKey("date") && message.get("date") != null) {
            esLogMsg.setTimeStamp(LocalDateFormate.get().format((Date)message.get("date")));
        }
        if (message.containsKey("message") && message.get("message") != null) {
            esLogMsg.setMessage((String)message.get("message"));
        }
        if (message.containsKey("level") && message.get("level") != null) {
            esLogMsg.setLevel(message.get("level").toString());
        }
        if (message.containsKey("loggerName") && message.get("loggerName") != null) {
            esLogMsg.setClassName((String)message.get("loggerName"));
        }
        if (message.containsKey("thrown") && message.get("thrown") != null) {
            esLogMsg.setStackTrace(this.toJSON(message.get("thrown")));
        }
        if (EsProvider.HOSTNAME != null) {
            esLogMsg.setHostName(EsProvider.HOSTNAME);
        }
        if (EsProvider.IP != null) {
            esLogMsg.setIp(EsProvider.IP);
        }
        esLogMsg.setProcessId(EsProvider.PID);
        esLogMsg.setThreadName(message.get("threadName").toString());
        esLogMsg.setApplicationName("AtlasClientGSpark");
        this.setAtlasTaskId(esLogMsg);
        this.insertInternal(esLogMsg);
    }

    private void setAtlasTaskId(EsLogMsg esLogMsg) {
        String threadName = esLogMsg.getThreadName();
        if (StringUtils.startsWithIgnoreCase((CharSequence)threadName, (CharSequence)"Executor task launch worker")) {
            int startIndex = threadName.indexOf("stage") + "stage".length();
            int endIndex = threadName.indexOf("(");
            int stageId = (int)Double.parseDouble(threadName.substring(startIndex, endIndex).trim());
            esLogMsg.setTaskId(LogUtils.getRawTaskId((String)Integer.toString(stageId)));
        } else {
            esLogMsg.setTaskId(LogUtils.getRawTaskId());
        }
    }

    private void insertInternal(EsLogMsg esLogMsg) {
        LOG_QUEUE.add(esLogMsg);
        if (LOG_QUEUE.size() >= BULK_SIZE) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        int flushSize = LOG_QUEUE.size();
        if (flushSize > 0) {
            int msgCount = 0;
            do {
                ArrayList<EsLogMsg> logMsgList = new ArrayList<EsLogMsg>();
                LOG_QUEUE.drainTo(logMsgList, BULK_SIZE);
                msgCount += logMsgList.size();
                this.flushInteral(logMsgList);
            } while ((flushSize -= BULK_SIZE) > 0);
            STATUS_LOGGER.info("\u63d2\u5165" + msgCount + "\u6761\u65e5\u5fd7");
        }
    }

    private void flushInteral(List<EsLogMsg> logMsgList) {
        this.esHttpClient.bulk(logMsgList);
    }

    private String toJSON(Object obj) {
        try {
            return EsProvider.toJSON(obj);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("\u65e0\u6cd5\u5e8f\u5217\u5316\u5bf9\u8c61!", (Throwable)e);
            return "";
        }
    }

    @Override
    public void close() {
        this.flush();
        this.esHttpClient.close();
        this.flushThread.interrupt();
    }
}

