/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.gis.toolkit.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.gis.toolkit.log.EsConnection;
import com.geoway.atlas.gis.toolkit.log.es.EsClientApi;
import com.geoway.atlas.gis.toolkit.log.es.impl.EsClient;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable;

@Plugin(name="elasticsearch", category="Core", printObject=true)
public final class EsProvider
implements NoSqlProvider<EsConnection> {
    public static final String APPLICATION_NAME = "AtlasClientGSpark";
    public static final Integer PID;
    public static final String HOSTNAME;
    public static final String IP;
    public static final ObjectMapper OBJECT_MAPPER;
    private final EsClientApi esClientApi;
    private final String description;

    public static String toJSON(Object object) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(object);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private EsProvider(EsClientApi esClientApi, String description) {
        this.esClientApi = esClientApi;
        this.description = description;
    }

    public EsConnection getConnection() {
        return new EsConnection(this.esClientApi);
    }

    public String toString() {
        return "EsProvider{" + this.description + '}';
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
        PID = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress != null) {
            HOSTNAME = inetAddress.getHostName();
            IP = inetAddress.getHostAddress();
        } else {
            HOSTNAME = null;
            IP = null;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<EsProvider> {
        @PluginBuilderAttribute(value="host")
        private String host = System.getProperty("atlas.es.url");
        @PluginBuilderAttribute(value="user")
        private String user = System.getProperty("atlas.es.user");
        @PluginBuilderAttribute(value="password")
        private String password = System.getProperty("atlas.es.password");
        @PluginBuilderAttribute(value="index")
        private String index = "atlaslog";
        protected static final Logger LOGGER = LogManager.getLogger(EsProvider.class);

        public EsProvider build() {
            if (StringUtils.isEmpty((CharSequence)this.host)) {
                throw new RuntimeException("\u6ca1\u6709\u68c0\u6d4b\u5230\u65e5\u5fd7\u670d\u52a1\u5668\u5730\u5740\u4fe1\u606f!");
            }
            String description = "host=" + this.host + (this.user != null && !this.user.isEmpty() ? ",user=" + this.user + ",password=" + this.password : "") + ",index:" + this.index;
            EsClient esClient = new EsClient(this.host, this.user, this.password, this.index);
            LOGGER.info("\u521b\u5efa\u65e5\u5fd7\u5ba2\u6237\u7aef\uff1a" + description);
            esClient.start();
            return new EsProvider(esClient, description);
        }
    }
}

