/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.test.data.filegdb;

import java.util.Enumeration;
import java.util.Vector;
import org.gdal.gdal.gdal;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;

public class TestGdb {
    public static void main(String[] args) throws FactoryException {
        TestGdb.test2();
    }

    public static boolean test() throws FactoryException {
        Feature poFeature;
        int iField;
        Object poDstDS = null;
        Object poSrcLayer = null;
        String pszNewLayerName = null;
        boolean bOverWrite = true;
        boolean bAppend = false;
        int eGType = 0;
        Vector papszLCO = new Vector();
        Vector papszSelFields = new Vector();
        Vector papszFieldTypesToString = new Vector();
        Object pszZField = null;
        FeatureDefn poSrcFDefn = poSrcLayer.GetLayerDefn();
        SpatialReference poOutputSRS = poSrcLayer.GetSpatialRef();
        poOutputSRS = new SpatialReference(CRS.decode((String)"epsg:4326", (boolean)true).toWKT());
        gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
        Layer poDstLayer = poDstDS.GetLayerByName(pszNewLayerName);
        gdal.PopErrorHandler();
        gdal.ErrorReset();
        int iLayer = -1;
        if (poDstLayer != null) {
            Layer poLayer;
            int nLayerCount = poDstDS.GetLayerCount();
            for (iLayer = 0; !(iLayer >= nLayerCount || (poLayer = poDstDS.GetLayer(iLayer)) != null && poLayer.GetName().equals(poDstLayer.GetName())); ++iLayer) {
            }
            if (iLayer == nLayerCount) {
                poDstLayer = null;
            }
        }
        if (poDstLayer != null && bOverWrite) {
            if (poDstDS.DeleteLayer(iLayer) != 0) {
                System.err.println("DeleteLayer() failed when overwrite requested.");
                return false;
            }
            poDstLayer = null;
        }
        if (poDstLayer == null) {
            if (eGType == -2) {
                eGType = poSrcFDefn.GetGeomType();
                eGType = 6;
            }
            if (!poDstDS.TestCapability("CreateLayer")) {
                System.err.println("Layer " + pszNewLayerName + "not found, and CreateLayer not supported by driver.");
                return false;
            }
            gdal.ErrorReset();
            poDstLayer = poDstDS.CreateLayer(pszNewLayerName, poOutputSRS, eGType, papszLCO);
            if (poDstLayer == null) {
                System.err.println("\u65e0\u6cd5\u521b\u5efa\u56fe\u5c42!" + pszNewLayerName);
                return false;
            }
            bAppend = false;
        } else {
            if (!bAppend) {
                System.err.println("FAILED: Layer " + pszNewLayerName + "already exists, and -append not specified.\n        Consider using -append, or -overwrite.");
                return false;
            }
            if (papszLCO.size() > 0) {
                System.err.println("WARNING: Layer creation options ignored since an existing layer is\n         being appended to.");
            }
        }
        int nSrcFieldCount = poSrcFDefn.GetFieldCount();
        nSrcFieldCount = 3;
        int[] panMap = new int[nSrcFieldCount];
        for (iField = 0; iField < nSrcFieldCount; ++iField) {
            panMap[iField] = -1;
        }
        FeatureDefn poDstFDefn = poDstLayer.GetLayerDefn();
        if (papszSelFields != null && !bAppend) {
            int nDstFieldCount = 0;
            if (poDstFDefn != null) {
                nDstFieldCount = poDstFDefn.GetFieldCount();
            }
            for (iField = 0; iField < papszSelFields.size(); ++iField) {
                int iSrcField = poSrcFDefn.GetFieldIndex((String)papszSelFields.get(iField));
                if (iSrcField >= 0) {
                    FieldDefn poSrcFieldDefn = poSrcFDefn.GetFieldDefn(iSrcField);
                    FieldDefn oFieldDefn = new FieldDefn(poSrcFieldDefn.GetNameRef(), poSrcFieldDefn.GetFieldType());
                    oFieldDefn.SetWidth(poSrcFieldDefn.GetWidth());
                    oFieldDefn.SetPrecision(poSrcFieldDefn.GetPrecision());
                    if (papszFieldTypesToString != null && (TestGdb.CSLFindString(papszFieldTypesToString, "All") != -1 || TestGdb.CSLFindString(papszFieldTypesToString, ogr.GetFieldTypeName((int)poSrcFDefn.GetFieldDefn(iSrcField).GetFieldType())) != -1)) {
                        oFieldDefn.SetType(4);
                    }
                    int iDstField = -1;
                    if (poDstFDefn != null) {
                        iDstField = poDstFDefn.GetFieldIndex(oFieldDefn.GetNameRef());
                    }
                    if (iDstField >= 0) {
                        panMap[iSrcField] = iDstField;
                        continue;
                    }
                    if (poDstLayer.CreateField(oFieldDefn) != 0) continue;
                    if (poDstFDefn == null) {
                        poDstFDefn = poDstLayer.GetLayerDefn();
                    }
                    if (poDstFDefn != null && poDstFDefn.GetFieldCount() != nDstFieldCount + 1) {
                        System.err.println("The output driver has claimed to have added the " + oFieldDefn.GetNameRef() + " field, but it did not!");
                        continue;
                    }
                    panMap[iSrcField] = nDstFieldCount++;
                    continue;
                }
                System.err.println("Field '" + (String)papszSelFields.get(iField) + "' not found in source layer.");
                return false;
            }
        } else if (!bAppend) {
            int nDstFieldCount = 0;
            if (poDstFDefn != null) {
                nDstFieldCount = poDstFDefn.GetFieldCount();
            }
            for (iField = 0; iField < nSrcFieldCount; ++iField) {
                FieldDefn poSrcFieldDefn = poSrcFDefn.GetFieldDefn(iField);
                FieldDefn oFieldDefn = new FieldDefn(poSrcFieldDefn.GetNameRef(), poSrcFieldDefn.GetFieldType());
                oFieldDefn.SetWidth(poSrcFieldDefn.GetWidth());
                oFieldDefn.SetPrecision(poSrcFieldDefn.GetPrecision());
                if (papszFieldTypesToString != null && (TestGdb.CSLFindString(papszFieldTypesToString, "All") != -1 || TestGdb.CSLFindString(papszFieldTypesToString, ogr.GetFieldTypeName((int)poSrcFDefn.GetFieldDefn(iField).GetFieldType())) != -1)) {
                    oFieldDefn.SetType(4);
                }
                int iDstField = -1;
                if (poDstFDefn != null) {
                    iDstField = poDstFDefn.GetFieldIndex(oFieldDefn.GetNameRef());
                }
                if (iDstField >= 0) {
                    panMap[iField] = iDstField;
                    continue;
                }
                if (poDstLayer.CreateField(oFieldDefn) != 0) continue;
                if (poDstFDefn == null) {
                    poDstFDefn = poDstLayer.GetLayerDefn();
                }
                if (poDstFDefn != null && poDstFDefn.GetFieldCount() != nDstFieldCount + 1) {
                    System.err.println("The output driver has claimed to have added the " + oFieldDefn.GetNameRef() + " field, but it did not!");
                    continue;
                }
                panMap[iField] = nDstFieldCount++;
            }
        } else {
            if (poDstFDefn == null) {
                System.err.println("poDstFDefn == NULL.\n");
                return false;
            }
            for (iField = 0; iField < nSrcFieldCount; ++iField) {
                FieldDefn poSrcFieldDefn = poSrcFDefn.GetFieldDefn(iField);
                int iDstField = poDstFDefn.GetFieldIndex(poSrcFieldDefn.GetNameRef());
                if (iDstField < 0) continue;
                panMap[iField] = iDstField;
            }
        }
        int nFeaturesInTransaction = 0;
        int nGroupTransactions = 200;
        long nCount = 0L;
        poSrcLayer.ResetReading();
        poDstLayer.StartTransaction();
        while (true) {
            Feature poDstFeature = null;
            poFeature = poSrcLayer.GetNextFeature();
            if (poFeature == null) break;
            boolean nParts = false;
            boolean nIters = true;
            if (++nFeaturesInTransaction == nGroupTransactions) {
                poDstLayer.CommitTransaction();
                poDstLayer.StartTransaction();
                nFeaturesInTransaction = 0;
            }
            gdal.ErrorReset();
            poDstFeature = new Feature(poDstLayer.GetLayerDefn());
            if (poDstFeature.SetFromWithMap(poFeature, 1, panMap) != 0) {
                if (nGroupTransactions > 0) {
                    poDstLayer.CommitTransaction();
                }
                System.err.println("Unable to translate feature " + poFeature.GetFID() + " from layer " + poSrcFDefn.GetName());
                poFeature.delete();
                poFeature = null;
                poDstFeature.delete();
                poDstFeature = null;
                return false;
            }
            Geometry poDstGeometry = poDstFeature.GetGeometryRef();
            if (poDstGeometry != null) {
                // empty if block
            }
            gdal.ErrorReset();
            if (poDstLayer.CreateFeature(poDstFeature) != 0) {
                if (nGroupTransactions > 0) {
                    poDstLayer.RollbackTransaction();
                }
                poDstFeature.delete();
                poDstFeature = null;
                return false;
            }
            poDstFeature.delete();
            poDstFeature = null;
        }
        poFeature.delete();
        poFeature = null;
        ++nCount;
        if (nGroupTransactions > 0) {
            poDstLayer.CommitTransaction();
        }
        return true;
    }

    public static int CSLFindString(Vector v, String str) {
        int i = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String strIter = (String)e.nextElement();
            if (strIter.equalsIgnoreCase(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void test1() {
        String wkt = String.format("POINT(%f %f)", 10.0, 10.0);
        Geometry geoPoint = ogr.CreateGeometryFromWkt((String)wkt);
        wkt = "POLYGON((0 0,20 0,20 20,0 20,0 0))";
        Geometry geoPolygon = ogr.CreateGeometryFromWkt((String)wkt);
        System.out.println(geoPolygon.Contains(geoPoint));
    }

    public static void test2() throws FactoryException {
        ogr.RegisterAll();
        gdal.SetConfigOption((String)"GDAL_FILENAME_IS_UTF8", (String)"YES");
        gdal.SetConfigOption((String)"SHAPE_ENCODING", (String)"");
        Driver driver = ogr.GetDriverByName((String)"FileGDB");
        System.out.println(driver);
        DataSource dataSource = driver.CreateDataSource("D:\\workspace\\data\\vector\\test.gdb");
        Layer layer = dataSource.CreateLayer("baselayer", new SpatialReference(CRS.decode((String)"epsg:4326", (boolean)true).toWKT()), 3);
        FieldDefn stringField = new FieldDefn("stringField", 4);
        FieldDefn intField = new FieldDefn("intField", 0);
        FieldDefn doubleField = new FieldDefn("doubleField", 2);
        layer.CreateField(stringField);
        layer.CreateField(intField);
        layer.CreateField(doubleField);
        Feature feature = new Feature(layer.GetLayerDefn());
        feature.SetFID(1L);
        feature.SetGeometry(ogr.CreateGeometryFromWkt((String)"Polygon ((109.73088765917877652 33.09898263153684184, 113.05792740447293454 33.43340157500713161, 114.5928246065545153 32.54161772575302791, 110.34827647789315108 28.60576400644885453, 109.73088765917877652 33.09898263153684184))"));
        feature.SetField("stringField", "string");
        feature.SetField("intField", -1);
        feature.SetField("doubleField", -1.0);
        layer.CreateFeature(feature);
        feature.delete();
        layer.delete();
        dataSource.delete();
    }

    public static void printVectorDrivers() {
        ogr.RegisterAll();
        int count = ogr.GetDriverCount();
        System.out.println(count);
        for (int i = 0; i < count; ++i) {
            System.out.println(ogr.GetDriver((int)i).GetName());
            if (!"filegdb".equals(ogr.GetDriver((int)i).GetName().toLowerCase())) continue;
            System.out.println("====================== ok ===================");
        }
        gdal.GDALDestroyDriverManager();
    }
}

