/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u0013'\u0001]BQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0017\u0001A\u0002\u0013%\u0011\fC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\r=\u0004\u0001\u0015)\u0003[\u0011%\u0001\b\u00011AA\u0002\u0013%\u0011\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\"I!\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001d\u0005\nw\u0002\u0001\r\u00111A\u0005\nqD1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b!Q\u00111\u0002\u0001A\u0002\u0003\u0005\u000b\u0015B?\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011q\u0002\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0003C\u0006\u0002(\u0001\u0001\r\u0011!Q!\n\u0005E\u0001\u0002CA\u0015\u0001\t\u0007I\u0011B-\t\u000f\u0005-\u0002\u0001)A\u00055\"9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\tY\u0006\u0001C!\u0003;Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\t9\u000e\u0001C!\u00033Dq!a6\u0001\t\u0003\ni\u000eC\u0004\u0002b\u0002!\t%a9\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bb\u0002B\u0001\u0001\u0011\u0005#1\u0001\u0005\b\u0005\u0017\u0001A\u0011\tB\u0007\u0011\u001d\u0011y\u0001\u0001C\u0005\u0005#AqA!\u0006\u0001\t\u0013\u00119\u0002C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$\t\u0011\"\n\u0012\"D)\u0006\u0014G.Z\"bi\u0006dwn\u001a,3\u0015\t9\u0003&\u0001\u0003kI\n\u001c'BA\u0015+\u0003\t1(G\u0003\u0002,Y\u0005YA-\u0019;bg>,(oY3t\u0015\tic&A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0006M\u0001\u0004gFd'BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u000f!I\u0017:\u0003\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\t1\fgn\u001a\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0004PE*,7\r\u001e\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bqaY1uC2|wM\u0003\u0002F]\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003\u000f\n\u0013A\u0002V1cY\u0016\u001c\u0015\r^1m_\u001e\u0004\"!Q%\n\u0005)\u0013%AE*vaB|'\u000f^:OC6,7\u000f]1dKN\u0004\"!\u0011'\n\u00055\u0013%a\u0004$v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0003\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005M\u0003&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0003\"a\u0016\u0001\u000e\u0003\u0019\n1bY1uC2|wMT1nKV\t!\f\u0005\u0002\\I:\u0011AL\u0019\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?Z\na\u0001\u0010:p_Rt$\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004\u0017A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u00191\u0002\u001f\r\fG/\u00197pO:\u000bW.Z0%KF$\"![7\u0011\u0005)\\W\"\u00011\n\u00051\u0004'\u0001B+oSRDqA\\\u0002\u0002\u0002\u0003\u0007!,A\u0002yIE\nAbY1uC2|wMT1nK\u0002\nqa\u001c9uS>t7/F\u0001s!\t\u0019X/D\u0001u\u0015\t9#&\u0003\u0002wi\nY!\n\u0012\"D\u001fB$\u0018n\u001c8t\u0003-y\u0007\u000f^5p]N|F%Z9\u0015\u0005%L\bb\u00028\u0007\u0003\u0003\u0005\rA]\u0001\t_B$\u0018n\u001c8tA\u00059A-[1mK\u000e$X#A?\u0011\u0007y\f\t!D\u0001\u0000\u0015\t9c&C\u0002\u0002\u0004}\u00141B\u00133cG\u0012K\u0017\r\\3di\u0006YA-[1mK\u000e$x\fJ3r)\rI\u0017\u0011\u0002\u0005\b]&\t\t\u00111\u0001~\u0003!!\u0017.\u00197fGR\u0004\u0013!\u00034v]\u000e$\u0018n\u001c8t+\t\t\t\u0002\u0005\u0004\\\u0003'Q\u0016qC\u0005\u0004\u0003+1'aA'baB!\u0011\u0011DA\u000f\u001b\t\tYBC\u0002\u0002\u000e\tKA!a\b\u0002\u001c\tyQK\u001c2pk:$g)\u001e8di&|g.A\u0007gk:\u001cG/[8og~#S-\u001d\u000b\u0004S\u0006\u0015\u0002\u0002\u00038\r\u0003\u0003\u0005\r!!\u0005\u0002\u0015\u0019,hn\u0019;j_:\u001c\b%\u0001\bE\u000b\u001a\u000bU\u000b\u0014+`'\u000eCU)T!\u0002\u001f\u0011+e)Q+M)~\u001b6\tS#N\u0003\u0002\nAA\\1nKR\t!,\u0001\u0006j]&$\u0018.\u00197ju\u0016$R![A\u001b\u0003oAa!!\f\u0012\u0001\u0004Q\u0006B\u00029\u0012\u0001\u0004\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDL\u0001\u0005kRLG.\u0003\u0003\u0002D\u0005u\"\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006QA.[:u)\u0006\u0014G.Z:\u0015\t\u0005%\u0013Q\u000b\t\u0006U\u0006-\u0013qJ\u0005\u0004\u0003\u001b\u0002'!B!se\u0006L\bcA!\u0002R%\u0019\u00111\u000b\"\u0003\u0015%#WM\u001c;jM&,'\u000fC\u0004\u0002XI\u0001\r!!\u0017\u0002\u00139\fW.Z:qC\u000e,\u0007\u0003\u00026\u0002Li\u000b1\u0002^1cY\u0016,\u00050[:ugR!\u0011qLA3!\rQ\u0017\u0011M\u0005\u0004\u0003G\u0002'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003O\u001a\u0002\u0019AA(\u0003\u0015IG-\u001a8u\u0003%!'o\u001c9UC\ndW\r\u0006\u0003\u0002`\u00055\u0004bBA4)\u0001\u0007\u0011qJ\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0003j\u0003g\n9\bC\u0004\u0002vU\u0001\r!a\u0014\u0002\u0011=dG-\u00133f]RDq!!\u001f\u0016\u0001\u0004\ty%\u0001\u0005oK^LE-\u001a8u\u0003%aw.\u00193UC\ndW\r\u0006\u0003\u0002\u0000\u0005\u0015\u0005cA!\u0002\u0002&\u0019\u00111\u0011\"\u0003\u000bQ\u000b'\r\\3\t\u000f\u0005\u001dd\u00031\u0001\u0002P\u0005Y1M]3bi\u0016$\u0016M\u00197f))\ty(a#\u0002\u000e\u0006u\u0015q\u0016\u0005\b\u0003O:\u0002\u0019AA(\u0011\u001d\tyi\u0006a\u0001\u0003#\u000baa]2iK6\f\u0007\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]e&A\u0003usB,7/\u0003\u0003\u0002\u001c\u0006U%AC*ueV\u001cG\u000fV=qK\"9\u0011qT\fA\u0002\u0005\u0005\u0016A\u00039beRLG/[8ogB)!.a\u0013\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*\u0012\u000b1\"\u001a=qe\u0016\u001c8/[8og&!\u0011QVAT\u0005%!&/\u00198tM>\u0014X\u000eC\u0004\u00022^\u0001\r!a-\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0004\u00026\u0006e&LW\u0007\u0003\u0003oS1!a\u0010=\u0013\u0011\t)\"a.\u0002\u0015\u0005dG/\u001a:UC\ndW\r\u0006\u0004\u0002\u0000\u0005}\u0016\u0011\u0019\u0005\b\u0003OB\u0002\u0019AA(\u0011\u001d\t\u0019\r\u0007a\u0001\u0003\u000b\fqa\u00195b]\u001e,7\u000fE\u0003k\u0003\u000f\fY-C\u0002\u0002J\u0002\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?!\r\t\u0015QZ\u0005\u0004\u0003\u001f\u0014%a\u0003+bE2,7\t[1oO\u0016\fqB\\1nKN\u0004\u0018mY3Fq&\u001cHo\u001d\u000b\u0005\u0003?\n)\u000eC\u0004\u0002Xe\u0001\r!!\u0017\u0002\u001d1L7\u000f\u001e(b[\u0016\u001c\b/Y2fgR\u0011\u00111\u001c\t\u0006U\u0006-\u0013\u0011\f\u000b\u0005\u00037\fy\u000eC\u0004\u0002Xm\u0001\r!!\u0017\u0002+1|\u0017\r\u001a(b[\u0016\u001c\b/Y2f\u001b\u0016$\u0018\rZ1uCR!\u00111WAs\u0011\u001d\t9\u0006\ba\u0001\u00033\nqb\u0019:fCR,g*Y7fgB\f7-\u001a\u000b\u0006S\u0006-\u0018Q\u001e\u0005\b\u0003/j\u0002\u0019AA-\u0011\u001d\ty/\ba\u0001\u0003g\u000b\u0001\"\\3uC\u0012\fG/Y\u0001\u000fC2$XM\u001d(b[\u0016\u001c\b/Y2f)\u0015I\u0017Q_A|\u0011\u001d\t9F\ba\u0001\u00033Bq!a1\u001f\u0001\u0004\tI\u0010E\u0003k\u0003\u000f\fY\u0010E\u0002B\u0003{L1!a@C\u0005=q\u0015-\\3ta\u0006\u001cWm\u00115b]\u001e,\u0017!\u00043s_Bt\u0015-\\3ta\u0006\u001cW\r\u0006\u0004\u0002`\t\u0015!q\u0001\u0005\b\u0003/z\u0002\u0019AA-\u0011\u001d\u0011Ia\ba\u0001\u0003?\nqaY1tG\u0006$W-\u0001\teK\u001a\fW\u000f\u001c;OC6,7\u000f]1dKR\u0011\u0011\u0011L\u0001\u000fG\",7m\u001b(b[\u0016\u001c\b/Y2f)\rI'1\u0003\u0005\b\u0003/\n\u0003\u0019AA-\u000319W\r\u001e+bE2,g*Y7f)\rQ&\u0011\u0004\u0005\b\u0003O\u0012\u0003\u0019AA(\u00035a\u0017n\u001d;Gk:\u001cG/[8ogR!\u0011\u0011\nB\u0010\u0011\u001d\t9f\ta\u0001\u00033\nA\u0002\\8bI\u001a+hn\u0019;j_:$B!a\u0006\u0003&!9\u0011q\r\u0013A\u0002\u0005=\u0003")
public class JDBCTableCatalogV2
implements TableCatalog,
SupportsNamespaces,
FunctionCatalog,
Logging {
    private String catalogName;
    private JDBCOptions options;
    private JdbcDialect dialect;
    private scala.collection.immutable.Map<String, UnboundFunction> functions;
    private final String DEFAULT_SCHEMA;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean functionExists(Identifier x$1) {
        return super.functionExists(x$1);
    }

    public Set<TableCatalogCapability> capabilities() {
        return super.capabilities();
    }

    public Table loadTable(Identifier x$1, String x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public Table loadTable(Identifier x$1, long x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public Table createTable(Identifier x$1, Column[] x$2, Transform[] x$3, Map<String, String> x$4) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return super.createTable(x$1, x$2, x$3, x$4);
    }

    public boolean useNullableQuerySchema() {
        return super.useNullableQuerySchema();
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private JDBCOptions options() {
        return this.options;
    }

    private void options_$eq(JDBCOptions x$1) {
        this.options = x$1;
    }

    private JdbcDialect dialect() {
        return this.dialect;
    }

    private void dialect_$eq(JdbcDialect x$1) {
        this.dialect = x$1;
    }

    private scala.collection.immutable.Map<String, UnboundFunction> functions() {
        return this.functions;
    }

    private void functions_$eq(scala.collection.immutable.Map<String, UnboundFunction> x$1) {
        this.functions = x$1;
    }

    private String DEFAULT_SCHEMA() {
        return this.DEFAULT_SCHEMA;
    }

    public String name() {
        Predef$.MODULE$.require(this.catalogName() != null, (Function0 & Serializable & scala.Serializable)() -> "The JDBC table catalog is not initialed");
        return this.catalogName();
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        Predef$.MODULE$.assert(this.catalogName() == null, (Function0 & Serializable & scala.Serializable)() -> "The JDBC table catalog is already initialed");
        this.catalogName_$eq(name);
        scala.collection.immutable.Map map = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options.asCaseSensitiveMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        this.options_$eq(new JDBCOptions(map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)"__invalid_dbtable"))));
        this.dialect_$eq(JdbcDialects$.MODULE$.get(this.options().url()));
        this.functions_$eq((scala.collection.immutable.Map<String, UnboundFunction>)this.dialect().functions().toMap(Predef$.MODULE$.$conforms()));
    }

    public Identifier[] listTables(String[] namespace) {
        this.checkNamespace(namespace);
        return (Identifier[])JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            String schemaPattern = namespace.length == 1 ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head() : null;
            ResultSet rs = conn.getMetaData().getTables(null, schemaPattern, "%", (String[])((Object[])new String[]{"TABLE"}));
            return (Identifier[])new Iterator<Identifier>(null, rs, namespace){
                private final ResultSet rs$1;
                private final String[] namespace$1;

                public Iterator<Identifier> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Identifier> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Identifier> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Identifier, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Identifier, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Identifier> filter(Function1<Identifier, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Identifier, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Identifier> withFilter(Function1<Identifier, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Identifier> filterNot(Function1<Identifier, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Identifier, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Identifier, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Identifier, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Identifier> takeWhile(Function1<Identifier, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> partition(Function1<Identifier, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> span(Function1<Identifier, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Identifier> dropWhile(Function1<Identifier, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Identifier, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Identifier, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Identifier, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Identifier, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Identifier, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Identifier> find(Function1<Identifier, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Identifier, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Identifier, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Identifier> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Identifier> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Identifier> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Identifier> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Identifier> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Identifier, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Identifier, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Identifier, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Identifier, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Identifier, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Identifier, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Identifier, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Identifier> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Identifier> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Identifier> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Identifier> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> scala.collection.immutable.Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Identifier> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Identifier, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Identifier, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.rs$1.next();
                }

                public Identifier next() {
                    return Identifier.of((String[])this.namespace$1, (String)this.rs$1.getString("TABLE_NAME"));
                }
                {
                    this.rs$1 = rs$1;
                    this.namespace$1 = namespace$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            }.toArray(ClassTag$.MODULE$.apply(Identifier.class));
        });
    }

    public boolean tableExists(Identifier ident) {
        this.checkNamespace(ident.namespace());
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite(this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(30).append("Failed table existence check: ").append(ident).toString(), this.dialect(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.tableExists(x$1, writeOptions))))));
    }

    public boolean dropTable(Identifier ident) {
        this.checkNamespace(ident.namespace());
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalogV2.$anonfun$dropTable$1(this, ident, conn))));
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        this.checkNamespace(oldIdent.namespace());
        JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(31).append("Failed table renaming from ").append(oldIdent).append(" to ").append(newIdent).toString(), this.dialect(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.renameTable(conn, oldIdent, newIdent, this.options()));
            return BoxedUnit.UNIT;
        });
    }

    public Table loadTable(Identifier ident) {
        JDBCTable jDBCTable;
        this.checkNamespace(ident.namespace());
        JDBCOptions optionsWithTableName = new JDBCOptions(this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        try {
            StructType schema = JDBCRDD$.MODULE$.resolveTable(optionsWithTableName);
            jDBCTable = new JDBCTable(ident, schema, optionsWithTableName);
        }
        catch (SQLException sQLException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        return jDBCTable;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.checkNamespace(ident.namespace());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).nonEmpty()) {
            throw QueryExecutionErrors$.MODULE$.cannotCreateJDBCTableWithPartitionsError();
        }
        CaseInsensitiveMap tableOptions = this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident)));
        ObjectRef tableComment = ObjectRef.create((Object)"");
        ObjectRef tableProperties = ObjectRef.create((Object)"");
        if (!properties.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JDBCTableCatalogV2.$anonfun$createTable$1(tableComment, tableProperties, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        String string = (String)tableComment.elem;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_COMMENT()), (Object)((String)tableComment.elem)));
        }
        String string3 = (String)tableProperties.elem;
        String string4 = "";
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_CREATE_TABLE_OPTIONS()), (Object)((String)tableProperties.elem)));
        }
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite(tableOptions);
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(23).append("Failed table creation: ").append(ident).toString(), this.dialect(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.createTable(conn, this.getTableName(ident), schema, caseSensitive, writeOptions));
            return BoxedUnit.UNIT;
        });
        return new JDBCTable(ident, schema, (JDBCOptions)writeOptions);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        this.checkNamespace(ident.namespace());
        return (Table)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(23).append("Failed table altering: ").append(ident).toString(), this.dialect(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.alterTable(conn, this.getTableName(ident), changes, this.options()));
            return this.loadTable(ident);
        });
    }

    public boolean namespaceExists(String[] namespace) {
        boolean bl;
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            this.log().warn(new java.lang.StringBuilder(10).append("\u68c0\u67e5\u547d\u540d\u7a7a\u95f4").append(db).append("\u662f\u5426\u5b58\u5728").toString());
            bl = BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.schemaExists(conn, this.options(), db))));
        } else {
            bl = false;
        }
        return bl;
    }

    public String[][] listNamespaces() {
        return (String[][])JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> JdbcUtils$.MODULE$.listSchemas(conn, this.options()));
    }

    public String[][] listNamespaces(String[] namespace) {
        String[][] stringArray;
        String[] stringArray2 = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray2);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            stringArray = this.listNamespaces();
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray2);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && this.namespaceExists(namespace)) {
                stringArray = (String[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            } else {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
        }
        return stringArray;
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            if (!this.namespaceExists(namespace)) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])((Object[])new String[]{db}));
            }
        } else {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        Map map = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava();
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        Option option;
        String[] stringArray = namespace;
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option2.get()).apply(0);
            if (!this.namespaceExists(namespace)) {
                ObjectRef comment = ObjectRef.create((Object)"");
                if (!metadata.isEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        JDBCTableCatalogV2.$anonfun$createNamespace$1(comment, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                BoxedUnit boxedUnit = (BoxedUnit)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(26).append("Failed create name space: ").append(db).toString(), this.dialect(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.createSchema(conn, this.options(), db, (String)comment$1.elem));
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        if (option.get() == null) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        if (((SeqLike)option.get()).lengthCompare(1) != 0) throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
        throw QueryCompilationErrors$.MODULE$.namespaceAlreadyExistsError(namespace);
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        String db = (String)((SeqLike)option.get()).apply(0);
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCTableCatalogV2.$anonfun$alterNamespace$1(this, db, changes, x0$1);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) {
        String db;
        block3: {
            block2: {
                String[] stringArray = namespace;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block2;
                db = (String)((SeqLike)option.get()).apply(0);
                if (this.namespaceExists(namespace)) break block3;
            }
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        boolean bl = BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalogV2.$anonfun$dropNamespace$1(this, db, cascade, conn))));
        return bl;
    }

    public String[] defaultNamespace() {
        String[] stringArray;
        this.log().warn("\u83b7\u53d6\u9ed8\u8ba4\u7684\u547d\u540d\u7a7a\u95f4");
        if (this.options().parameters().contains(this.DEFAULT_SCHEMA())) {
            this.log().warn(new java.lang.StringBuilder(11).append("\u83b7\u53d6\u9ed8\u8ba4\u7684\u547d\u540d\u7a7a\u95f4\u4e3a\uff1a").append(this.options().parameters().apply((Object)this.DEFAULT_SCHEMA())).toString());
            stringArray = (String[])((Object[])new String[]{(String)this.options().parameters().apply((Object)this.DEFAULT_SCHEMA())});
        } else {
            stringArray = super.defaultNamespace();
        }
        return stringArray;
    }

    private void checkNamespace(String[] namespace) {
        if (namespace.length > 1) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
    }

    private String getTableName(Identifier ident) {
        JdbcDialect jdbcDialect = this.dialect();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> jdbcDialect.quoteIdentifier(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    public Identifier[] listFunctions(String[] namespace) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).isEmpty() ? (Identifier[])((TraversableOnce)this.functions().keys().map((Function1 & Serializable & scala.Serializable)x$2 -> Identifier.of((String[])namespace, (String)x$2), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Identifier.class)) : (Identifier[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public UnboundFunction loadFunction(Identifier ident) {
        UnboundFunction func;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.noSuchFunctionError(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asFunctionIdentifier());
        }
        Option option = this.functions().get((Object)ident.name());
        if (!(option instanceof Some)) {
            throw new NoSuchFunctionException(ident);
        }
        Some some = (Some)option;
        UnboundFunction unboundFunction = func = (UnboundFunction)some.value();
        return unboundFunction;
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$1(JDBCTableCatalogV2 $this, Identifier ident$1, Connection conn) {
        boolean bl;
        try {
            JdbcUtils$.MODULE$.dropTable(conn, $this.getTableName(ident$1), $this.options());
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createTable$1(ObjectRef tableComment$1, ObjectRef tableProperties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k;
            if ("comment".equals(string)) {
                tableComment$1.elem = v;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if ("provider".equals(string)) {
                    throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingProviderError();
                }
                if ("owner".equals(string)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if ("location".equals(string)) {
                        throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingLocationError();
                    }
                    tableProperties$1.elem = new java.lang.StringBuilder(2).append((String)tableProperties$1.elem).append(" ").append(k).append(" ").append(v).toString();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$createNamespace$1(ObjectRef comment$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        String string = k;
        if ("comment".equals(string)) {
            comment$1.elem = v;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("owner".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!"location".equals(string)) throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceWithPropertyError(k);
            throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceUsingProviderError();
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$alterNamespace$1(JDBCTableCatalogV2 $this, String db$3, Seq changes$2, NamespaceChange x0$1) {
        block8: {
            block9: {
                block11: {
                    NamespaceChange.RemoveProperty removeProperty;
                    block12: {
                        String string;
                        String string2;
                        block10: {
                            NamespaceChange namespaceChange;
                            block4: {
                                NamespaceChange.SetProperty setProperty;
                                block6: {
                                    block7: {
                                        String string3;
                                        String string4;
                                        block5: {
                                            namespaceChange = x0$1;
                                            if (!(namespaceChange instanceof NamespaceChange.SetProperty)) break block4;
                                            setProperty = (NamespaceChange.SetProperty)namespaceChange;
                                            string4 = setProperty.property();
                                            string3 = "comment";
                                            if (string4 != null) break block5;
                                            if (string3 == null) break block6;
                                            break block7;
                                        }
                                        if (string4.equals(string3)) break block6;
                                    }
                                    throw QueryCompilationErrors$.MODULE$.cannotSetJDBCNamespaceWithPropertyError(setProperty.property());
                                }
                                BoxedUnit boxedUnit = (BoxedUnit)JdbcUtils$.MODULE$.withConnection($this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                                    JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(37).append("Failed create comment on name space: ").append(db$3).toString(), $this.dialect(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.alterSchemaComment(conn, $this.options(), db$3, setProperty.value()));
                                    return BoxedUnit.UNIT;
                                });
                                break block8;
                            }
                            if (!(namespaceChange instanceof NamespaceChange.RemoveProperty)) break block9;
                            removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
                            string2 = removeProperty.property();
                            string = "comment";
                            if (string2 != null) break block10;
                            if (string == null) break block11;
                            break block12;
                        }
                        if (string2.equals(string)) break block11;
                    }
                    throw QueryCompilationErrors$.MODULE$.cannotUnsetJDBCNamespaceWithPropertyError(removeProperty.property());
                }
                BoxedUnit boxedUnit = (BoxedUnit)JdbcUtils$.MODULE$.withConnection($this.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(37).append("Failed remove comment on name space: ").append(db$3).toString(), $this.dialect(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.removeSchemaComment(conn, $this.options(), db$3));
                    return BoxedUnit.UNIT;
                });
                break block8;
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedJDBCNamespaceChangeInCatalogError(changes$2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$dropNamespace$1(JDBCTableCatalogV2 $this, String db$4, boolean cascade$1, Connection conn) {
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.classifyException(new java.lang.StringBuilder(24).append("Failed drop name space: ").append(db$4).toString(), $this.dialect(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            JdbcUtils$.MODULE$.dropSchema(conn, $this.options(), db$4, cascade$1);
            return true;
        }));
    }

    public JDBCTableCatalogV2() {
        Logging.$init$((Logging)this);
        this.catalogName = null;
        this.DEFAULT_SCHEMA = "default_schema";
    }
}

