/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataName;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class AtlasRpcDataTagSerializer
extends StdSerializer<AtlasRpcDataTag> {
    private static final String DATA_NAME = "dataName";
    private static final String DATA_LABEL = "dataLabel";
    private static final String NAME_SPACE = "nameSpace";
    private static final String LOCAL_NAME = "localName";

    protected AtlasRpcDataTagSerializer() {
        super(AtlasRpcDataTag.class);
    }

    public void serialize(AtlasRpcDataTag atlasRpcDataTag, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        HashMap<String, Map> atlasDataTag = new HashMap<String, Map>();
        HashMap<String, String> atlasDataName = new HashMap<String, String>();
        AtlasRpcDataName rpcDataName = atlasRpcDataTag.getDataName();
        atlasDataName.put(NAME_SPACE, StringUtils.isNotBlank((CharSequence)rpcDataName.getNameSpace()) ? rpcDataName.getNameSpace() : "");
        atlasDataName.put(LOCAL_NAME, rpcDataName.getLocalName());
        atlasDataTag.put(DATA_NAME, atlasDataName);
        if (!atlasRpcDataTag.getDataLabelMap().isEmpty()) {
            atlasDataTag.put(DATA_LABEL, atlasRpcDataTag.getDataLabelMap());
        }
        jsonGenerator.writeObject(atlasDataTag);
    }
}

