/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.serverCenter;

import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.web.api.v2.component.serverCenter.RegisterInfo;
import com.geoway.atlas.web.api.v2.component.serverCenter.ServerHandle;
import com.geoway.atlas.web.api.v2.component.serverCenter.zk.ZkServerHandle;
import com.geoway.atlas.web.api.v2.init.SparkRuntimeArgs;
import com.geoway.atlas.web.api.v2.utils.ApplicationArgumentsUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Component;

@Component
public class ServerCenter {
    private static final Logger log = LoggerFactory.getLogger(ServerCenter.class);
    private ServerHandle serverHandle;
    @Autowired
    private ApplicationArguments args;
    public static final Pattern ZK_PATTERN = Pattern.compile("^(.*?)://((.*?)/(.*)@)?(.*?)((/(.*?))(\\?.*|$))");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(SparkRuntimeArgs sparkRuntimeArgs) {
        String centerServer = ApplicationArgumentsUtils.getSingleValue(this.args, "server.center");
        String domainInfo = ApplicationArgumentsUtils.getSingleValue(this.args, "domain.info");
        String multiServer = ApplicationArgumentsUtils.getSingleValue(this.args, "multi.server");
        boolean hasMultiServer = false;
        if (StringUtils.isNotBlank((CharSequence)multiServer) && BooleanUtils.toBoolean((String)multiServer.trim())) {
            hasMultiServer = BooleanUtils.toBoolean((String)multiServer.trim());
        }
        if (!StringUtils.isNotBlank((CharSequence)centerServer)) return;
        Matcher matcher = ZK_PATTERN.matcher(centerServer);
        if (!matcher.matches()) throw new RuntimeException("\u8f93\u5165\u7684\u670d\u52a1\u4e2d\u5fc3\u8def\u5f84\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f : " + centerServer);
        if (matcher.groupCount() != 9) throw new RuntimeException("\u8f93\u5165\u7684\u670d\u52a1\u4e2d\u5fc3\u8def\u5f84\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f : " + centerServer);
        switch (matcher.group(1).toUpperCase()) {
            case "ZOOKEEPER": {
                this.serverHandle = new ZkServerHandle(matcher.group(5), matcher.group(7), matcher.group(3), matcher.group(4), hasMultiServer);
                RegisterInfo registerInfo = this.getRegisterInfo(domainInfo, sparkRuntimeArgs, false);
                this.serverHandle.register(registerInfo);
                this.serverHandle.monitor(registerInfo);
                RegisterInfo rpcRegisterInfo = this.getRegisterInfo(domainInfo, sparkRuntimeArgs, true);
                this.serverHandle.registerRpc(rpcRegisterInfo);
                this.serverHandle.monitorRpc(rpcRegisterInfo);
                return;
            }
            default: {
                throw new NotSupportException("\u4e0d\u652f\u6301\u6307\u5b9a\u7684\u670d\u52a1\u4e2d\u5fc3\u7c7b\u578b:" + matcher.group(1), Thread.currentThread(), 3);
            }
        }
    }

    public RegisterInfo getRegisterInfo(String domainInfo, SparkRuntimeArgs sparkRuntimeArgs, Boolean isRpc) {
        RegisterInfo registerInfo = new RegisterInfo();
        registerInfo.setScale(0);
        registerInfo.setTotalPercentage(0.0);
        registerInfo.setUsablePercentage(0.0);
        registerInfo.setUsedPercentage(0.0);
        registerInfo.setCpu((double)sparkRuntimeArgs.getNumExecutors().intValue() * (double)sparkRuntimeArgs.getExecutorCores().intValue());
        registerInfo.setMemorySize(sparkRuntimeArgs.getExecutorMemory() * (double)sparkRuntimeArgs.getNumExecutors().intValue());
        if (StringUtils.isNotBlank((CharSequence)domainInfo)) {
            registerInfo.setIp(StringUtils.substringBefore((String)domainInfo, (String)":"));
            registerInfo.setPort(StringUtils.substringAfter((String)domainInfo, (String)":"));
        } else {
            String serverAddress = ApplicationArgumentsUtils.getSingleValue(this.args, "server.address");
            if (StringUtils.isBlank((CharSequence)serverAddress)) {
                try {
                    serverAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    log.error("\u672a\u77e5\u4e3b\u673a\u540d:" + e.getMessage(), (Throwable)e);
                    throw new NotFoundException("\u672a\u77e5\u4e3b\u673a\u540d:" + e.getMessage(), Thread.currentThread(), 3);
                }
            }
            String port = isRpc != false ? ApplicationArgumentsUtils.getSingleValue(this.args, "atlas.rpc.port") : ApplicationArgumentsUtils.getSingleValue(this.args, "server.port");
            registerInfo.setIp(serverAddress);
            registerInfo.setPort(port);
        }
        return registerInfo;
    }

    @PreDestroy
    public void stop() {
        this.serverHandle.stop();
    }
}

