/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.serverCenter.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.web.api.v2.component.serverCenter.RegisterInfo;
import com.geoway.atlas.web.api.v2.component.serverCenter.ServerHandle;
import com.geoway.atlas.web.api.v2.component.serverCenter.zk.NoSaslZookeeperFactory;
import com.geoway.atlas.web.api.v2.utils.UUIDUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.spark.util.ShutdownHookManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.runtime.BoxedUnit;

public class ZkServerHandle
implements ServerHandle {
    public static final Logger log = LoggerFactory.getLogger(ZkServerHandle.class);
    public static final int RETRY_INTERVAL_MS = 3000;
    public static final int SESSION_TIMEOUT = 10000;
    public static final String NAME = "ZOOKEEPER";
    private CuratorFramework curatorFramework;
    private final String zkRawPath;
    private final String userName;
    private final String password;
    private final boolean multiServer;
    private ObjectMapper objectMapper = new ObjectMapper();
    private NodeCache nodeCache;
    private NodeCache nodeRpcCache;
    private RegisterInfo persistRegisterInfo;
    private RegisterInfo persistRpcRegisterInfo;
    private final CuratorFrameworkFactory.Builder builder;

    public ZkServerHandle(String zkIp, String zookPath, String userName, String password, boolean multiServer) {
        RetryForever retryPolicy = new RetryForever(3000);
        this.zkRawPath = zookPath;
        this.userName = userName;
        this.password = password;
        this.multiServer = multiServer;
        this.builder = CuratorFrameworkFactory.builder().zookeeperFactory((ZookeeperFactory)new NoSaslZookeeperFactory()).connectString(zkIp).sessionTimeoutMs(10000).connectionTimeoutMs(10000).retryPolicy((RetryPolicy)retryPolicy);
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
            this.builder.authorization("digest", (userName + ":" + password).getBytes(StandardCharsets.UTF_8));
        }
        this.curatorFramework = this.builder.build();
        this.init();
    }

    private void init() {
        this.curatorFramework.start();
        ZkServerHandle zkServerHandle = this;
        ShutdownHookManager.addShutdownHook((int)ShutdownHookManager.DEFAULT_SHUTDOWN_PRIORITY(), () -> {
            zkServerHandle.stop();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void register(RegisterInfo registerInfo) {
        this.persistentRegister(registerInfo);
    }

    private void ephemeralRegister(RegisterInfo registerInfo) {
        String registerUrl = this.getRegisterUrl(registerInfo);
        byte[] registerInfoBytes = this.getRegisterBytes(registerInfo);
        try {
            ACLBackgroundPathAndBytesable pathAndBytesable = (ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL);
            if (StringUtils.isNotBlank((CharSequence)this.userName) && StringUtils.isNotBlank((CharSequence)this.password)) {
                Id userId = new Id("auth", this.userName + ":" + this.password);
                ACL zkAcl = new ACL(31, userId);
                ArrayList<ACL> zkAcls = new ArrayList<ACL>();
                zkAcls.add(zkAcl);
                ((BackgroundPathAndBytesable)pathAndBytesable.withACL(zkAcls)).forPath(registerUrl, registerInfoBytes);
            } else {
                pathAndBytesable.forPath(registerUrl, registerInfoBytes);
            }
            log.info("\u670d\u52a1\u6ce8\u518c\u6210\u529f:" + registerUrl);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private void persistentRegister(RegisterInfo registerInfo) {
        this.persistRegisterInfo = registerInfo;
        String registerUrl = this.getRegisterUrl(registerInfo);
        byte[] registerInfoBytes = this.getRegisterBytes(registerInfo);
        if (this.exist(registerInfo)) {
            try {
                this.curatorFramework.delete().forPath(registerUrl);
                log.info("\u670d\u52a1\u5220\u9664\u6210\u529f:" + registerUrl);
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
            }
        }
        try {
            ACLBackgroundPathAndBytesable pathAndBytesable = (ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
            if (StringUtils.isNotBlank((CharSequence)this.userName) && StringUtils.isNotBlank((CharSequence)this.password)) {
                Id userId = new Id("auth", this.userName + ":" + this.password);
                ACL zkAcl = new ACL(31, userId);
                ArrayList<ACL> zkAcls = new ArrayList<ACL>();
                zkAcls.add(zkAcl);
                ((BackgroundPathAndBytesable)pathAndBytesable.withACL(zkAcls)).forPath(registerUrl, registerInfoBytes);
            } else {
                pathAndBytesable.forPath(registerUrl, registerInfoBytes);
            }
            log.info("\u670d\u52a1\u6ce8\u518c\u6210\u529f:" + registerUrl);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private boolean exist(RegisterInfo registerInfo) {
        String registerUrl = this.getRegisterUrl(registerInfo);
        try {
            Stat existStat = (Stat)this.curatorFramework.checkExists().forPath(registerUrl);
            return existStat != null;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private String getRegisterUrl(RegisterInfo registerInfo) {
        return this.multiServer ? this.zkRawPath + ":" + registerInfo.getPort() : this.zkRawPath;
    }

    private byte[] getRegisterBytes(RegisterInfo registerInfo) {
        if (this.multiServer) {
            try {
                return this.objectMapper.writeValueAsBytes((Object)registerInfo);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return (registerInfo.getIp() + ":" + registerInfo.getPort()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void monitor(RegisterInfo registerInfo) {
        this.persistentMonitor(registerInfo);
    }

    private void ephemeralMonitor(RegisterInfo registerInfo) {
        String registerUrl = this.getRegisterUrl(registerInfo);
        this.nodeCache = new NodeCache(this.curatorFramework, registerUrl);
        this.addListener(this.nodeCache, registerInfo);
        try {
            this.nodeCache.start();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u76d1\u63a7\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private void persistentMonitor(RegisterInfo registerInfo) {
    }

    public void addListener(NodeCache nodeCache, RegisterInfo registerInfo) {
        NodeCacheListener listener = () -> {
            ChildData childData = nodeCache.getCurrentData();
            if (childData == null) {
                log.info("\u8282\u70b9\u88ab\u5220\u9664:" + nodeCache.getPath());
                this.registerRepeat(registerInfo);
            }
        };
        nodeCache.getListenable().addListener((Object)listener);
    }

    private void registerRepeat(RegisterInfo registerInfo) {
        boolean repeatFlag = true;
        String repeatRegisterTask = UUIDUtils.getUUID();
        log.info("\u5f00\u59cb\u5faa\u73af\u6ce8\u518czk\u4efb\u52a1: " + repeatRegisterTask);
        while (repeatFlag) {
            boolean exist = false;
            boolean isContinue = false;
            try {
                exist = this.exist(registerInfo);
            }
            catch (Throwable throwable) {
                isContinue = true;
            }
            if (!isContinue) {
                if (!exist) {
                    try {
                        this.register(registerInfo);
                        repeatFlag = false;
                    }
                    catch (Throwable throwable) {
                        isContinue = true;
                    }
                } else {
                    repeatFlag = false;
                }
            }
            if (!isContinue) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info("\u5b8c\u6210\u5faa\u73af\u6ce8\u518czk\u4efb\u52a1: " + repeatRegisterTask);
    }

    @Override
    public void registerRpc(RegisterInfo registerInfo) {
        this.persistentRegisterRpc(registerInfo);
    }

    private void ephemeralRegisterRpc(RegisterInfo registerInfo) {
        String registerUrl = this.getRegisterRpcUrl(registerInfo);
        byte[] registerInfoBytes = this.getRegisterRpcBytes(registerInfo);
        try {
            ACLBackgroundPathAndBytesable pathAndBytesable = (ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL);
            if (StringUtils.isNotBlank((CharSequence)this.userName) && StringUtils.isNotBlank((CharSequence)this.password)) {
                Id userId = new Id("auth", this.userName + ":" + this.password);
                ACL zkAcl = new ACL(31, userId);
                ArrayList<ACL> zkAcls = new ArrayList<ACL>();
                zkAcls.add(zkAcl);
                ((BackgroundPathAndBytesable)pathAndBytesable.withACL(zkAcls)).forPath(registerUrl, registerInfoBytes);
            } else {
                pathAndBytesable.forPath(registerUrl, registerInfoBytes);
            }
            log.info("rpc\u670d\u52a1\u6ce8\u518c\u6210\u529f:" + registerUrl);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private void persistentRegisterRpc(RegisterInfo registerInfo) {
        this.persistRpcRegisterInfo = registerInfo;
        String registerUrl = this.getRegisterRpcUrl(registerInfo);
        byte[] registerInfoBytes = this.getRegisterRpcBytes(registerInfo);
        if (this.existRPC(registerInfo)) {
            try {
                this.curatorFramework.delete().forPath(registerUrl);
                log.info("\u670d\u52a1\u5220\u9664\u6210\u529f:" + registerUrl);
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
            }
        }
        try {
            ACLBackgroundPathAndBytesable pathAndBytesable = (ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
            if (StringUtils.isNotBlank((CharSequence)this.userName) && StringUtils.isNotBlank((CharSequence)this.password)) {
                Id userId = new Id("auth", this.userName + ":" + this.password);
                ACL zkAcl = new ACL(31, userId);
                ArrayList<ACL> zkAcls = new ArrayList<ACL>();
                zkAcls.add(zkAcl);
                ((BackgroundPathAndBytesable)pathAndBytesable.withACL(zkAcls)).forPath(registerUrl, registerInfoBytes);
            } else {
                pathAndBytesable.forPath(registerUrl, registerInfoBytes);
            }
            log.info("rpc\u670d\u52a1\u6ce8\u518c\u6210\u529f:" + registerUrl);
            this.curatorFramework.close();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    public boolean existRPC(RegisterInfo registerInfo) {
        String registerUrl = this.getRegisterRpcUrl(registerInfo);
        try {
            Stat existStat = (Stat)this.curatorFramework.checkExists().forPath(registerUrl);
            return existStat != null;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("\u6ce8\u518czk\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private byte[] getRegisterRpcBytes(RegisterInfo registerInfo) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)registerInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRegisterRpcUrl(RegisterInfo registerInfo) {
        return "/atlas/rpc/" + StringUtils.substringAfterLast((String)this.zkRawPath, (String)"/") + "/" + registerInfo.getIp() + ":" + registerInfo.getPort();
    }

    @Override
    public void monitorRpc(RegisterInfo registerInfo) {
        this.persistentMonitorRpc(registerInfo);
    }

    private void ephemeralMonitorRpc(RegisterInfo registerInfo) {
        String registerUrl = this.getRegisterRpcUrl(registerInfo);
        this.nodeRpcCache = new NodeCache(this.curatorFramework, registerUrl);
        this.addRpcListener(this.nodeRpcCache, registerInfo);
        try {
            this.nodeRpcCache.start();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IoException("rpc\u76d1\u63a7\u670d\u52a1\u4e2d\u5fc3\u5f02\u5e38!", Thread.currentThread(), 3);
        }
    }

    private void persistentMonitorRpc(RegisterInfo registerInfo) {
    }

    private void addRpcListener(NodeCache rpcNodeCache, RegisterInfo registerInfo) {
        NodeCacheListener listener = () -> {
            ChildData childData = rpcNodeCache.getCurrentData();
            if (childData == null) {
                log.info("\u8282\u70b9\u88ab\u5220\u9664:" + rpcNodeCache.getPath());
                this.registerRPCRepeat(registerInfo);
            }
        };
        this.nodeRpcCache.getListenable().addListener((Object)listener);
    }

    private void registerRPCRepeat(RegisterInfo registerInfo) {
        boolean repeatFlag = true;
        while (repeatFlag) {
            boolean exist = false;
            boolean isContinue = false;
            try {
                exist = this.existRPC(registerInfo);
            }
            catch (Throwable throwable) {
                isContinue = true;
            }
            if (!isContinue) {
                if (!exist) {
                    try {
                        this.registerRpc(registerInfo);
                        repeatFlag = false;
                    }
                    catch (Throwable throwable) {
                        isContinue = true;
                    }
                } else {
                    repeatFlag = false;
                }
            }
            if (!isContinue) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void stop() {
        this.persistentStop();
        if (this.curatorFramework != null) {
            this.curatorFramework.close();
            log.info("\u5173\u95edzk\u5ba2\u6237\u7aef!");
        }
    }

    private void ephemeralStop() {
        if (this.nodeCache != null) {
            try {
                this.nodeCache.close();
                log.info("\u5173\u95edzk\u76d1\u542c\u5668!");
            }
            catch (IOException e) {
                log.error("\u5173\u95edzk\u76d1\u542c\u5668\u9519\u8bef!", (Throwable)e);
            }
        }
        if (this.nodeRpcCache != null) {
            try {
                this.nodeRpcCache.close();
                log.info("\u5173\u95edzk rpc\u76d1\u542c\u5668!");
            }
            catch (IOException e) {
                log.error("\u5173\u95edzk rpc\u76d1\u542c\u5668\u9519\u8bef!", (Throwable)e);
            }
        }
    }

    private void persistentStop() {
        String registerUrl;
        this.curatorFramework = this.builder.build();
        this.curatorFramework.start();
        if (this.persistRegisterInfo != null) {
            registerUrl = this.getRegisterUrl(this.persistRegisterInfo);
            System.out.println("\u5220\u9664\u670d\u52a1\u8def\u5f84: " + registerUrl);
            try {
                this.curatorFramework.delete().forPath(registerUrl);
                System.out.println("\u670d\u52a1\u5220\u9664\u6210\u529f:" + registerUrl);
            }
            catch (Exception e) {
                System.out.println(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (this.persistRpcRegisterInfo != null) {
            registerUrl = this.getRegisterRpcUrl(this.persistRpcRegisterInfo);
            System.out.println("\u5220\u9664\u670d\u52a1\u8def\u5f84: " + registerUrl);
            try {
                this.curatorFramework.delete().forPath(registerUrl);
                System.out.println("\u670d\u52a1\u5220\u9664\u6210\u529f:" + registerUrl);
            }
            catch (Exception e) {
                System.out.println(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

