/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.impl;

import com.geoway.atlas.common.error.CancelOpException;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.job.JobManager;
import com.geoway.atlas.web.api.v2.service.AtlasServer;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtlasServerImpl
implements AtlasServer {
    private static final Logger log = LoggerFactory.getLogger(AtlasServerImpl.class);
    @Autowired
    private JobManager jobManager;
    @Autowired
    private RpcClientProxy rpcClientProxy;

    @Override
    public Map<String, Object> jobResult(String jobId) {
        return this.jobManager.getJobInfo(jobId);
    }

    @Override
    public Map<String, Object> canceljob(String rawTaskId, String jobId) {
        log.info("1.\u505c\u6b62\u5f02\u6b65\u4efb\u52a1");
        this.jobManager.stopFutures(rawTaskId);
        log.info("2.\u901a\u77e5\u670d\u52a1\u7aef\u505c\u6b62\u4efb\u52a1");
        this.rpcClientProxy.getSparkRpcClientApi().cancelTask(rawTaskId);
        log.info("3.\u8bbe\u7f6e\u505c\u6b62\u4efb\u52a1\u7684\u54cd\u5e94\u4fe1\u606f");
        this.jobManager.cancelJob(rawTaskId, jobId);
        return ResponseBuilder.buildSuccess("\u505c\u6b62\u4efb\u52a1\u6210\u529f");
    }

    @Override
    public Map<String, Object> jobDemo(long duration) {
        try {
            System.out.println("\u7b97\u5b50\u5df2\u542f\u52a8");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            throw new CancelOpException("\u7ebf\u7a0b\u7ec8\u6b62!", Thread.currentThread(), 3);
        }
        return ResponseBuilder.buildSuccess("\u4f60\u597d");
    }
}

