/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.utils.UUIDUtils;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.common.storage.AtlasDataParams;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcExistDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRenameDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.server.AtlasRpcServerException;
import com.geoway.atlas.dataset.common.manager.DataManager;
import com.geoway.atlas.process.vector.common.data.MergeDataProcess$;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.dao.MetadataDao;
import com.geoway.atlas.web.api.v2.domain.metadata.LayerMetadata;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataServerImpl
implements DataServer {
    private static final Logger log = LoggerFactory.getLogger(DataServerImpl.class);
    public static final String LAYER_IDENTITY = "layer_identity";
    public static final String DATA_URL = "atlas.data.url";
    @Autowired
    private RpcClientProxy client;
    @Autowired
    private MetadataDao metadataDao;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Map<String, Object> loadVector(String dataName, String dataStoreFormat, Map<String, String> params, String taskId, String jobId) {
        String message = this.client.getSparkRpcClientApi().loadData(DataManager.DataType$.MODULE$.VECTOR(), AtlasTagUtils.getAtlasRpcDataTag(dataName), dataStoreFormat, params, taskId, jobId);
        return ResponseBuilder.buildSuccess(message);
    }

    @Override
    public Map<String, Object> saveVector(String dataName, String dataStoreFormat, Map<String, String> params, String taskId, String jobId) {
        String message = this.client.getSparkRpcClientApi().saveData(DataManager.DataType$.MODULE$.VECTOR(), AtlasTagUtils.getAtlasRpcDataTag(dataName), dataStoreFormat, params, taskId, jobId);
        return ResponseBuilder.buildSuccess(message);
    }

    @Override
    public Map<String, Object> showVector() {
        List rpcDataTags = this.client.getSparkRpcClientApi().showData();
        return ResponseBuilder.buildSuccess(rpcDataTags);
    }

    @Override
    public Map<String, Object> descVector(String dataName, String taskId, String jobId) {
        RpcDescDataRespond respond = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(dataName), taskId, jobId);
        return ResponseBuilder.buildSuccess(respond);
    }

    @Override
    public Map<String, Object> existVector(String dataName, String taskId, String jobId) {
        RpcExistDataRespond respond = this.client.getSparkRpcClientApi().existData(AtlasTagUtils.getAtlasRpcDataTag(dataName), taskId, jobId);
        return ResponseBuilder.buildSuccess(respond);
    }

    @Override
    public Map<String, Object> renameData(String rawDataName, String newDataName, String taskId, String jobId) {
        RpcRenameDataRespond respond = this.client.getSparkRpcClientApi().renameData(AtlasTagUtils.getAtlasRpcDataTag(rawDataName), AtlasTagUtils.getAtlasRpcDataTag(newDataName), taskId, jobId);
        return ResponseBuilder.buildSuccess(respond);
    }

    @Override
    public String loadVectorLayer(String layerIdentity, Map<String, String> params, String taskId, String jobId) {
        if (StringUtils.isBlank((CharSequence)layerIdentity)) {
            throw new AtlasRpcServerException("\u8f7d\u5165\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a!");
        }
        String[] layerSources = layerIdentity.split(";");
        if (layerSources.length == 1) {
            String layerSource = layerSources[0];
            return this.loadSingleLayer(layerSource, params, taskId, jobId);
        }
        String resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_in_u_" + UUIDUtils.getUUID();
        ArrayList<String> resultLayers = new ArrayList<String>();
        for (String layerSource : layerSources) {
            resultLayers.add(this.loadSingleLayer(layerSource, params, taskId, jobId));
        }
        List rpcDataTags = resultLayers.stream().map(AtlasTagUtils::getAtlasRpcDataTag).collect(Collectors.toList());
        String message = this.client.getSparkRpcClientApi().listProcess(rpcDataTags, MergeDataProcess$.MODULE$.NAME(), params, AtlasTagUtils.getAtlasRpcDataTag(resultLayer), taskId, jobId);
        log.info(message);
        return resultLayer;
    }

    @Override
    public String loadGraphLayer(String layerIdentity, Map<String, String> params, String taskId, String jobId) {
        if (StringUtils.isBlank((CharSequence)layerIdentity)) {
            throw new AtlasRpcServerException("\u8f7d\u5165\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a!");
        }
        String[] layerSources = layerIdentity.split(";");
        if (layerSources.length == 1) {
            String layerSource = layerSources[0];
            return this.loadSingleLayer(layerSource, params, taskId, jobId);
        }
        throw new NotSupportException("\u4e0d\u652f\u6301\u540c\u65f6\u52a0\u8f7d\u591a\u4e2a\u56fe!", Thread.currentThread(), 3);
    }

    @Override
    public String loadRasterLayer(String layerIdentity, Map<String, String> params, String taskId, String jobId) {
        if (StringUtils.isBlank((CharSequence)layerIdentity)) {
            throw new AtlasRpcServerException("\u8f7d\u5165\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a!");
        }
        String[] layerSources = layerIdentity.split(";");
        if (layerSources.length == 1) {
            String layerSource = layerSources[0];
            return this.loadSingleLayer(layerSource, params, taskId, jobId);
        }
        throw new NotSupportException("\u4e0d\u652f\u6301\u540c\u65f6\u52a0\u8f7d\u591a\u4e2a\u6805\u683c\u6570\u636e!", Thread.currentThread(), 3);
    }

    private String loadSingleLayer(String layerSource, Map<String, String> extraParams, String taskId, String jobId) {
        int maoHaoIndex = layerSource.indexOf(":");
        if (maoHaoIndex != -1) {
            String format = layerSource.substring(0, maoHaoIndex);
            if ("spark".equalsIgnoreCase(format)) {
                return layerSource.substring(maoHaoIndex + 1);
            }
            String dataType = "";
            if (LayerMetadata.VECTOR_FORMATS.contains(format.toLowerCase())) {
                dataType = DataManager.DataType$.MODULE$.VECTOR();
            } else if (LayerMetadata.GRAPH_FORMATS.contains(format.toLowerCase())) {
                dataType = DataManager.DataType$.MODULE$.GRAPH();
            } else if (LayerMetadata.RASTER_FORMATS.contains(format.toLowerCase())) {
                dataType = DataManager.DataType$.MODULE$.RASTER();
            } else {
                throw new AtlasException("\u4e0d\u80fd\u627e\u5230\u6570\u636e\u7c7b\u578b!");
            }
            String nDataName = AtlasDataName.TEMP_LAYER_PREFIX() + "_in_i_" + UUIDUtils.getUUID();
            String url = layerSource.substring(maoHaoIndex + 1);
            Map<String, String> loadParams = this.generalLoadParams(format, url);
            loadParams.putAll(extraParams);
            String message = this.client.getSparkRpcClientApi().loadData(dataType, AtlasTagUtils.getAtlasRpcDataTag(nDataName), format, loadParams, taskId, jobId);
            log.info(message);
            return nDataName;
        }
        return layerSource;
    }

    public Map<String, String> generalLoadParams(String dataFormat, String url) {
        HashMap<String, String> loadParams = new HashMap<String, String>();
        switch (dataFormat) {
            case "shapefile": 
            case "filegdb": 
            case "jdbc": 
            case "geojson": 
            case "graph": 
            case "gdal-raster": 
            case "gw-vector": {
                loadParams.put(AtlasDataParams.ATLAS_DATA_URL(), url);
                break;
            }
            case "spark": {
                break;
            }
            default: {
                throw new NotSupportException("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u6570\u636e\u683c\u5f0f:" + dataFormat, Thread.currentThread(), 3);
            }
        }
        return loadParams;
    }

    @Override
    public String generalResultLayerName(String layerUrl) {
        int maoHaoIndex = layerUrl.indexOf(":");
        if (maoHaoIndex == -1) {
            if (StringUtils.isEmpty((CharSequence)layerUrl)) {
                throw new RuntimeException("\u7ed3\u679c\u56fe\u5c42\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            return layerUrl;
        }
        String format = layerUrl.substring(0, maoHaoIndex);
        if (StringUtils.equalsIgnoreCase((CharSequence)format, (CharSequence)"spark")) {
            return layerUrl.substring(maoHaoIndex + 1);
        }
        return layerUrl;
    }

    @Override
    public String generalMemoryLayerName(String layerUrl) {
        return this.generalResultLayerName(layerUrl);
    }

    private void saveLayer(String identity, String persistUrls, Map<String, String> extraSaveParams, String taskId, String jobId) {
        if (StringUtils.isNotEmpty((CharSequence)persistUrls)) {
            String[] persistUrlArray;
            for (String persistUrl : persistUrlArray = StringUtils.split((String)persistUrls, (String)";")) {
                HashMap<String, String> saveParams = new HashMap<String, String>();
                int maoHaoIndex = persistUrl.indexOf(":");
                if (maoHaoIndex == -1) {
                    throw new NotFoundException("\u65e0\u6cd5\u89e3\u6790\u6210\u679c\u5e93\u5730\u5740: " + persistUrl, Thread.currentThread(), 3);
                }
                String format = persistUrl.substring(0, maoHaoIndex);
                String dataType = "";
                if (LayerMetadata.VECTOR_FORMATS.contains(format.toLowerCase())) {
                    dataType = DataManager.DataType$.MODULE$.VECTOR();
                } else if (LayerMetadata.GRAPH_FORMATS.contains(format.toLowerCase())) {
                    dataType = DataManager.DataType$.MODULE$.GRAPH();
                } else if (LayerMetadata.RASTER_FORMATS.contains(format.toLowerCase())) {
                    dataType = DataManager.DataType$.MODULE$.RASTER();
                } else {
                    throw new AtlasException("\u4e0d\u80fd\u627e\u5230\u6570\u636e\u7c7b\u578b!");
                }
                saveParams.put(DATA_URL, persistUrl.substring(maoHaoIndex + 1));
                if (extraSaveParams != null && !extraSaveParams.isEmpty()) {
                    saveParams.putAll(extraSaveParams);
                }
                String message = this.client.getSparkRpcClientApi().saveData(dataType, AtlasTagUtils.getAtlasRpcDataTag(identity), format, saveParams, taskId, jobId);
                log.info(message);
            }
        } else {
            throw new NotFoundException("\u65e0\u6cd5\u89e3\u6790\u6210\u679c\u5e93\u5730\u5740: " + persistUrls, Thread.currentThread(), 3);
        }
    }

    @Override
    public void saveVectorLayer(String identity, String persistUrls, Map<String, String> extraSaveParams, String taskId, String jobId) {
        this.saveLayer(identity, persistUrls, extraSaveParams, taskId, jobId);
    }

    @Override
    public void saveGraphLayer(String identity, String persistUrls, Map<String, String> extraSaveParams, String taskId, String jobId) {
        this.saveLayer(identity, persistUrls, extraSaveParams, taskId, jobId);
    }

    @Override
    public void saveRasterLayer(String identity, String persistUrls, Map<String, String> extraSaveParams, String taskId, String jobId) {
        this.saveLayer(identity, persistUrls, extraSaveParams, taskId, jobId);
    }

    @Override
    public void saveVectorLayer(String identity, String persistUrl, String taskId, String jobId) {
        this.saveVectorLayer(identity, persistUrl, new HashMap<String, String>(), taskId, jobId);
    }

    public String toJSON(Object obj) {
        return this.objectMapper.writeValueAsString(obj);
    }

    public <T> T fromJSON(String jsonString, Class<T> clz) {
        return (T)this.objectMapper.readValue(jsonString, clz);
    }
}

