/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.pkg.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.common.utils.UUIDUtils;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcRenameDataRespond;
import com.geoway.atlas.process.vector.common.crs.TransformCrsProcess$;
import com.geoway.atlas.process.vector.common.field.FieldCalculatorProcess$;
import com.geoway.atlas.process.vector.common.field.FieldJoinProcess;
import com.geoway.atlas.process.vector.common.field.FieldRenameProcess$;
import com.geoway.atlas.process.vector.common.field.GeometryGeneratorProcess$;
import com.geoway.atlas.process.vector.common.graphx.VectorDataToGraphProcess$;
import com.geoway.atlas.process.vector.common.relate.VectorDataSetOverlayRelateProcess$;
import com.geoway.atlas.process.vector.common.sql.AttributeFilterProcess$;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.service.pkg.DataManagerServer;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.InputParamUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataManagerServerImpl
implements DataManagerServer {
    private static final Logger log = LoggerFactory.getLogger(DataManagerServerImpl.class);
    @Autowired
    private DataServer dataServer;
    @Autowired
    private RpcClientProxy client;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Map<String, Object> filterProcess(String baseIdentity, Map<String, String> filterParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = AttributeFilterProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(filterParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, filterParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u5c5e\u6027\u7b5b\u9009\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> vectorIoProcess(String baseIdentity, Map<String, String> ioParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        HashMap<String, String> ioParams2 = new HashMap<String, String>(ioParams);
        ioParams2.putAll(InputParamUtils.getInputVectorParams(ioParams));
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, ioParams2, taskId, UUIDUtils.getUUID());
        String processName = AttributeFilterProcess$.MODULE$.NAME();
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, ioParams2, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, ioParams2, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u77e2\u91cf\u6570\u636e\u8f6c\u6362\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> graphIoProcess(String baseIdentity, Map<String, String> ioParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadGraphLayer(baseIdentity, ioParams, taskId, UUIDUtils.getUUID());
        String processName = AttributeFilterProcess$.MODULE$.NAME();
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        if (persistDisk) {
            this.dataServer.saveGraphLayer(baseLayerName, resultUrl, ioParams, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u56fe\u6570\u636e\u8f6c\u6362\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> toGraphProcess(String baseIdentity, Map<String, String> ioParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(ioParams), taskId, UUIDUtils.getUUID());
        String processName = VectorDataToGraphProcess$.MODULE$.NAME();
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, ioParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveGraphLayer(resultLayerName, resultUrl, ioParams, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u6570\u636e\u8f6c\u6362\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> calcFieldProcess(String baseIdentity, Map<String, String> calcFieldParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = FieldCalculatorProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(calcFieldParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, calcFieldParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u5b57\u6bb5\u8ba1\u7b97\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> geoGeneratorProcess(String baseIdentity, Map<String, String> geoGeneratorParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = GeometryGeneratorProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(geoGeneratorParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, geoGeneratorParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u56fe\u6591\u751f\u6210\u8ba1\u7b97\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> overlayRelate(String baseIdentity, Map<String, String> calcFieldParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = VectorDataSetOverlayRelateProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(calcFieldParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, calcFieldParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u5b57\u6bb5\u8ba1\u7b97\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> fieldRenameProcess(String baseIdentity, Map<String, String> fieldRenameParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = FieldRenameProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(fieldRenameParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, fieldRenameParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u5b57\u6bb5\u91cd\u547d\u540d\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> projectProcess(String baseIdentity, Map<String, String> crsParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = TransformCrsProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(crsParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, crsParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u5750\u6807\u8f6c\u6362\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> mergeProcess(String baseIdentity, String mergeIdentity, Map<String, String> mergeParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String layerIdentity = baseIdentity;
        if (StringUtils.isNotBlank((CharSequence)mergeIdentity)) {
            layerIdentity = layerIdentity + ";" + mergeIdentity;
        }
        HashMap<String, String> fullParams = new HashMap<String, String>(InputParamUtils.getInputVectorParams(mergeParams));
        fullParams.putAll(mergeParams);
        String layerName = this.dataServer.loadVectorLayer(layerIdentity, fullParams, taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        RpcRenameDataRespond renameDataRespond = this.client.getSparkRpcClientApi().renameData(AtlasTagUtils.getAtlasRpcDataTag(layerName), AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u5408\u5e76\u6570\u636e\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> fieldJoinProcess(String baseIdentity, String otherIdentity, Map<String, String> fieldJoinParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = FieldJoinProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, new HashMap<String, String>(), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(otherIdentity, new HashMap<String, String>(), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        log.info("\u8fdb\u5165\u5c5e\u6027\u8fde\u63a5\u6d41\u7a0b\uff0c\u53c2\u6570\u4e3a:" + this.toJSON(fieldJoinParams));
        String message = this.client.getSparkRpcClientApi().binaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), AtlasTagUtils.getAtlasRpcDataTag(otherLayerName), processName, fieldJoinParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, UUIDUtils.getUUID());
        }
        return ResponseBuilder.buildSuccess(message);
    }

    public String toJSON(Object obj) {
        return this.objectMapper.writeValueAsString(obj);
    }
}

