/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.service.pkg.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.atlas.algorithm.vector.overlay.geom.AtlasOverlayOp;
import com.geoway.atlas.common.error.DuplicateException;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotImplementedException;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.ParamException;
import com.geoway.atlas.common.utils.StringUtils;
import com.geoway.atlas.common.utils.UUIDUtils;
import com.geoway.atlas.data.common.data.AtlasDataName;
import com.geoway.atlas.data.vector.spark.common.rpc.AtlasRpcDataTag;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.dataset.vector.manager.VectorDataManager;
import com.geoway.atlas.process.vector.common.area.AtlasProcessCalculateParams;
import com.geoway.atlas.process.vector.common.buffer.AtlasProcessBufferParams;
import com.geoway.atlas.process.vector.common.buffer.BufferProcess$;
import com.geoway.atlas.process.vector.common.crs.AtlasProcessTransformCrsParams;
import com.geoway.atlas.process.vector.common.crs.TransformCrsProcess$;
import com.geoway.atlas.process.vector.common.field.AtlasProcessCreateOidParams;
import com.geoway.atlas.process.vector.common.field.AtlasProcessFieldRemoveParams$;
import com.geoway.atlas.process.vector.common.field.AtlasProcessFieldRenameParams;
import com.geoway.atlas.process.vector.common.field.CreateOidProcess$;
import com.geoway.atlas.process.vector.common.field.FieldRemoveProcess$;
import com.geoway.atlas.process.vector.common.field.FieldRenameProcess$;
import com.geoway.atlas.process.vector.common.graphx.AtlasProcessConnectedComponentsParams;
import com.geoway.atlas.process.vector.common.graphx.VectorDataSetConnectedComponentsProcess;
import com.geoway.atlas.process.vector.common.overlay.clip.ClipProcess;
import com.geoway.atlas.process.vector.common.overlay.dissolve.AtlasProcessDissolveParams;
import com.geoway.atlas.process.vector.common.overlay.dissolve.DissolveProcess;
import com.geoway.atlas.process.vector.common.overlay.erase.EraseProcess;
import com.geoway.atlas.process.vector.common.overlay.identity.IdentityProcess;
import com.geoway.atlas.process.vector.common.overlay.intersection.IntersectionProcess;
import com.geoway.atlas.process.vector.common.overlay.intersection.IntersectionProcess$;
import com.geoway.atlas.process.vector.common.overlay.union.UnionProcess;
import com.geoway.atlas.process.vector.common.partition.VectorDataSetGridSplitProcess$;
import com.geoway.atlas.process.vector.common.sql.AtlasProcessAttributeFilterParams;
import com.geoway.atlas.process.vector.common.sql.AtlasProcessRunSqlParams;
import com.geoway.atlas.process.vector.common.sql.RunSqlProcess$;
import com.geoway.atlas.process.vector.spark.common.api.simple.sql.SqlSimpleApiFactory;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.dto.LayerIdentityDto;
import com.geoway.atlas.web.api.v2.dto.pack.ComputeLayerInfo;
import com.geoway.atlas.web.api.v2.dto.pack.CreateOidLayerInfo;
import com.geoway.atlas.web.api.v2.dto.vector.FieldInfo;
import com.geoway.atlas.web.api.v2.job.JobManager;
import com.geoway.atlas.web.api.v2.service.DataServer;
import com.geoway.atlas.web.api.v2.service.ProcessServer;
import com.geoway.atlas.web.api.v2.service.pkg.SpatialAnalysisServer;
import com.geoway.atlas.web.api.v2.service.pkg.impl.assigin.AssignType;
import com.geoway.atlas.web.api.v2.utils.AtlasTagUtils;
import com.geoway.atlas.web.api.v2.utils.GeometryBoundaryUtils;
import com.geoway.atlas.web.api.v2.utils.InputParamUtils;
import com.geoway.atlas.web.api.v2.utils.PluginParallelManager;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import com.geoway.atlas.web.api.v2.utils.RpcNameUtils;
import com.geoway.atlas.web.api.v2.utils.RpcRespondUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpatialAnalysisServerImpl
implements SpatialAnalysisServer {
    private static final Logger log = LoggerFactory.getLogger(SpatialAnalysisServerImpl.class);
    private static final String BAK_FIELD_SUFFIX = "_bak";
    private static final String AREA_FIELD_PREFIX = "area";
    private static final String OID_FIELD_PREFIX = "oid";
    private static final String ROW_KEY_PREFIX = "row";
    private static final String DISSOLVE_TYPE_NONE = "NONE";
    private static final String DISSOLVE_TYPE_GRID = "GRID";
    private static final String DISSOLVE_TYPE_CONNECTIVITY = "CONNECT";
    private static final Double OVERLAY_OPTIMIZE_RATE = 0.5;
    private static final Map<String, Integer> BUFFER_DICT = new HashMap<String, Integer>(){
        {
            this.put("FULL", AtlasOverlayOp.SideType$.MODULE$.FULL());
            this.put("LEFT", AtlasOverlayOp.SideType$.MODULE$.LEFT());
            this.put("RIGHT", AtlasOverlayOp.SideType$.MODULE$.RIGHT());
            this.put("OUTSIDE_ONLY", AtlasOverlayOp.SideType$.MODULE$.OUTSIDE_ONLY());
            this.put("ROUND", AtlasOverlayOp.EndType$.MODULE$.ROUND());
            this.put("FLAT", AtlasOverlayOp.EndType$.MODULE$.FLAT());
        }
    };
    @Autowired
    private DataServer dataServer;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RpcClientProxy client;
    @Autowired
    private ProcessServer processServer;
    @Autowired
    private JobManager jobManager;

    @Override
    public Map<String, Object> intersectionProcess(String baseIdentity, String baseFilter, String recomputeBaseFields, String otherIdentity, String otherFilter, Map<String, String> intersectionParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = IntersectionProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(baseFilter), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(otherIdentity, InputParamUtils.getSourceFilterParams(otherFilter), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.overlay(baseLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)baseIdentity, (CharSequence)baseLayerName), baseFilter, recomputeBaseFields, otherLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)otherIdentity, (CharSequence)otherLayerName), otherFilter, null, processName, intersectionParams, resultLayerName, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u6c42\u4ea4\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> clipProcess(String baseIdentity, String baseFilter, String recomputeBaseFields, String otherIdentity, String otherFilter, Map<String, String> intersectionParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = ClipProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(baseFilter), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(otherIdentity, InputParamUtils.getSourceFilterParams(otherFilter), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.overlay(baseLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)baseIdentity, (CharSequence)baseLayerName), baseFilter, recomputeBaseFields, otherLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)otherIdentity, (CharSequence)otherLayerName), otherFilter, null, processName, intersectionParams, resultLayerName, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u88c1\u5207\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> eraseProcess(String baseIdentity, String baseFilter, String recomputeBaseFields, String otherIdentity, String otherFilter, Map<String, String> intersectionParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = EraseProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(baseFilter), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(otherIdentity, InputParamUtils.getSourceFilterParams(otherFilter), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.overlay(baseLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)baseIdentity, (CharSequence)baseLayerName), baseFilter, recomputeBaseFields, otherLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)otherIdentity, (CharSequence)otherLayerName), otherFilter, null, processName, intersectionParams, resultLayerName, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u64e6\u9664\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> unionProcess(String baseIdentity, String baseFilter, String recomputeBaseFields, String unionIdentity, String otherFilter, String recomputeOtherFields, Map<String, String> params, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = UnionProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(baseFilter), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(unionIdentity, InputParamUtils.getSourceFilterParams(otherFilter), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.overlay(baseLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)baseIdentity, (CharSequence)baseLayerName), baseFilter, recomputeBaseFields, otherLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)unionIdentity, (CharSequence)otherLayerName), otherFilter, recomputeOtherFields, processName, params, resultLayerName, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u8054\u5408\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> assignProcess(String baseIdentity, String baseFilter, String otherIdentity, String otherFilter, String assignFields, String assignType, boolean isConsiderNull, String defaultValue, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(baseFilter), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(otherIdentity, InputParamUtils.getSourceFilterParams(otherFilter), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.overlayAssign(baseLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)baseIdentity, (CharSequence)baseLayerName), baseFilter, otherLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)otherIdentity, (CharSequence)otherLayerName), otherFilter, assignFields, assignType, isConsiderNull, defaultValue, resultLayerName, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u53e0\u52a0\u8d4b\u503c\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> identityProcess(String baseIdentity, String baseFilter, String recomputeBaseFields, String otherIdentity, String otherFilter, String recomputeOtherFields, Map<String, String> identityParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = IdentityProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getSourceFilterParams(baseFilter), taskId, UUIDUtils.getUUID());
        String otherLayerName = this.dataServer.loadVectorLayer(otherIdentity, InputParamUtils.getSourceFilterParams(otherFilter), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.overlay(baseLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)baseIdentity, (CharSequence)baseLayerName), baseFilter, recomputeBaseFields, otherLayerName, org.apache.commons.lang3.StringUtils.equals((CharSequence)otherIdentity, (CharSequence)otherLayerName), otherFilter, recomputeOtherFields, processName, identityParams, resultLayerName, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u6807\u8bc6\u5206\u6790\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> dissolveProcess(String baseIdentity, Map<String, String> dissolveParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = DissolveProcess.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(dissolveParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, dissolveParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, jobId);
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u878d\u5408\u5206\u6790\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> distinctProcess(String baseIdentity, String recomputeFields, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(new HashMap<String, String>()), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        this.distinct(baseLayerName, recomputeFields, taskId, resultLayerName);
        log.info("\u5b8c\u6210\u53bb\u91cd\u8ba1\u7b97");
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u53bb\u91cd\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> connectivityProcess(String baseIdentity, Map<String, String> connectivityParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(connectivityParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        PluginParallelManager.runPlugin("connectivity", new Function<Object[], Void>(){

            @Override
            public Void apply(Object[] objects) {
                SpatialAnalysisServerImpl.this.connectivity((String)objects[0], (Map)objects[1], (String)objects[2], (String)objects[3]);
                return null;
            }
        }, new Object[]{baseLayerName, connectivityParams, resultLayerName, taskId}, this.jobManager, jobId, taskId);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u8fde\u901a\u6027\u5206\u6790\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> bufferProcess(String baseIdentity, Map<String, String> bufferParams, String dissolve_type, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(bufferParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        if (DISSOLVE_TYPE_CONNECTIVITY.equalsIgnoreCase(dissolve_type)) {
            PluginParallelManager.runPlugin("connectivity", objects -> {
                this.buffer((String)objects[0], (Map)objects[1], (String)objects[2], (String)objects[3], (String)objects[4]);
                return null;
            }, new Object[]{baseLayerName, bufferParams, dissolve_type, resultLayerName, taskId}, this.jobManager, jobId, taskId);
        } else {
            this.buffer(baseLayerName, bufferParams, dissolve_type, resultLayerName, taskId);
        }
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7ec4\u5408\u7f13\u51b2\u5206\u6790\u6d41\u7a0b!");
    }

    @Override
    public Map<String, Object> gridSplit(String baseIdentity, Map<String, String> splitParams, String resultIdentity, boolean persistDisk, String resultUrl, String taskId, String jobId) {
        String processName = VectorDataSetGridSplitProcess$.MODULE$.NAME();
        String baseLayerName = this.dataServer.loadVectorLayer(baseIdentity, InputParamUtils.getInputVectorParams(splitParams), taskId, UUIDUtils.getUUID());
        String resultLayerName = this.dataServer.generalResultLayerName(resultIdentity);
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), processName, splitParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
        if (persistDisk) {
            this.dataServer.saveVectorLayer(resultLayerName, resultUrl, taskId, jobId);
        }
        return ResponseBuilder.buildSuccess("\u5b8c\u6210\u7f51\u683c\u5256\u5206!");
    }

    public void overlayAssign(String baseLayerName, boolean baseIsMem, String baseFilter, String otherLayerName, boolean otherIsMem, String otherFilter, String assignFields, String assignType, boolean isConsiderNull, String defaultValues, String resultLayerName, String taskId) {
        String oFilterLayerName;
        log.info("\u8fdb\u5165\u53e0\u52a0\u8d4b\u503c\u6d41\u7a0b, \u53c2\u6570\u4e3a => baseFilter:" + baseFilter + ", otherFilter:" + otherFilter + ", assignFields:" + assignFields + ", assignType:" + assignType + ", isConsiderNull:" + this.toJSON(isConsiderNull) + ", defaultValues:" + defaultValues);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)assignFields)) {
            throw new ParamException("\u5fc5\u987b\u8bbe\u7f6e\u53e0\u52a0\u8d4b\u503c\u5b57\u6bb5\u540d\u79f0!", Thread.currentThread(), 3);
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        HashMap<String, String> defaultValueMap = new HashMap<String, String>();
        this.parseAssignParams(assignFields, defaultValues, fieldMap, defaultValueMap);
        log.info("\u8d4b\u503c\u5b57\u6bb5\u6620\u5c04:" + this.toJSON(fieldMap));
        log.info("\u8d4b\u503c\u5b57\u6bb5\u9ed8\u8ba4\u503c\u6620\u5c04:" + this.toJSON(defaultValueMap));
        RpcDescDataRespond baseLayerInfo = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), taskId, UUIDUtils.getUUID());
        Map baseLayerDescMap = baseLayerInfo.getDataDescMap();
        List baseLayerFieldNames = RpcRespondUtils.getVectorFieldInfo(baseLayerInfo).stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        if (CollectionUtils.containsAny(baseLayerFieldNames, fieldMap.values())) {
            throw new DuplicateException("\u539f\u59cb\u56fe\u5c42\u5b57\u6bb5\u5305\u542b\u8d4b\u503c\u540e\u7684\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8d4b\u503c\u5b57\u6bb5\u6620\u5c04", Thread.currentThread(), 3);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)baseLayerDescMap.get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY())))) {
            throw new NotSupportException("\u4e0d\u652f\u6301\u975e\u7a7a\u95f4\u56fe\u5c42\u8fdb\u884c\u53e0\u52a0\u8d4b\u503c\u64cd\u4f5c", Thread.currentThread(), 3);
        }
        RpcDescDataRespond otherLayerInfo = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(otherLayerName), taskId, UUIDUtils.getUUID());
        String bFilterLayerName = this.filter(baseLayerName, baseFilter, taskId, UUIDUtils.getUUID());
        if (!otherIsMem) {
            String extraFilter = GeometryBoundaryUtils.getExtraFilter(baseLayerInfo, otherLayerInfo, OVERLAY_OPTIMIZE_RATE).getOrDefault(1, null);
            log.info("\u8d4b\u503c\u56fe\u5c42\u65b0\u589e\u7a7a\u95f4\u7b5b\u9009\u6761\u4ef6: " + extraFilter);
            oFilterLayerName = this.filter(otherLayerName, GeometryBoundaryUtils.addExtraFilter(otherFilter, extraFilter), taskId, UUIDUtils.getUUID());
        } else {
            oFilterLayerName = this.filter(otherLayerName, otherFilter, taskId, UUIDUtils.getUUID());
        }
        log.info("\u5c5e\u6027\u7b5b\u9009\u540e\u7684\u57fa\u7840\u56fe\u5c42\u4e3a:" + bFilterLayerName);
        log.info("\u5c5e\u6027\u7b5b\u9009\u540e\u7684\u53e0\u52a0\u56fe\u5c42\u4e3a:" + oFilterLayerName);
        String otherTransLayerName = this.transFormCrs(oFilterLayerName, (String)baseLayerDescMap.get(VectorDataManager.DataDesc$.MODULE$.CRS()), taskId, UUIDUtils.getUUID());
        log.info("\u5750\u6807\u8f6c\u6362\u540e\u7684\u53e0\u52a0\u56fe\u5c42\u4e3a:" + otherTransLayerName);
        CreateOidLayerInfo createOidLayerInfo = this.createOid(bFilterLayerName, taskId, UUIDUtils.getUUID());
        this.client.getSparkRpcClientApi().persistData(AtlasTagUtils.getAtlasRpcDataTag(createOidLayerInfo.getLayerName()), taskId, UUIDUtils.getUUID());
        log.info("\u5b8c\u6210" + baseLayerName + "\u6570\u636e\u6301\u4e45\u5316!");
        String processName = IntersectionProcess$.MODULE$.NAME();
        String preResultLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_r_" + UUIDUtils.getUUID();
        HashMap<String, String> processParams = new HashMap<String, String>();
        processParams.put("atlas.process.vector.common.intersection.is.repair", "false");
        this.processServer.binaryProcess(createOidLayerInfo.getLayerName(), otherTransLayerName, processName, processParams, preResultLayerName, taskId, UUIDUtils.getUUID());
        log.info("\u53e0\u52a0\u6267\u884c\u7ed3\u679c\u56fe\u5c42\u4e3a:" + preResultLayerName);
        int[] startIndex = new int[]{1};
        int[] bAreaNameIndexFlag = new int[]{-1};
        int[] oAreaNameIndexFlag = new int[]{-1};
        Map<Integer, String> oidMap = this.getRenameMap(createOidLayerInfo.getLayerName(), null, bAreaNameIndexFlag, createOidLayerInfo.getOidName(), taskId, true, startIndex);
        Map<Integer, String> renameMap = this.getRenameMap(otherTransLayerName, null, oAreaNameIndexFlag, org.apache.commons.lang3.StringUtils.join(fieldMap.keySet(), (String)","), taskId, false, startIndex);
        this.logInfo(renameMap);
        this.assignStage(createOidLayerInfo.getLayerName(), createOidLayerInfo.isDelete(), preResultLayerName, oidMap, assignType, renameMap, fieldMap, isConsiderNull, defaultValueMap, resultLayerName, taskId);
    }

    public void parseAssignParams(String assignFields, String defaultValues, Map<String, String> fieldMap, Map<String, String> defaultValueMap) {
        String[] rawAssignField = org.apache.commons.lang3.StringUtils.split((String)assignFields, (String)",");
        String[] defaultValueArray = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defaultValues)) {
            defaultValueArray = org.apache.commons.lang3.StringUtils.split((String)defaultValues, (String)",");
        }
        for (int i = 0; i < rawAssignField.length; ++i) {
            String value;
            String key;
            if (rawAssignField[i].contains(":")) {
                String[] kv = rawAssignField[i].split(":");
                key = kv[0];
                value = kv[1];
            } else {
                key = rawAssignField[i];
                value = rawAssignField[i];
            }
            fieldMap.put(key, value);
            if (defaultValueArray == null) continue;
            defaultValueMap.put(key, defaultValueArray[i]);
        }
    }

    public void assignStage(String layerName, boolean deleteOid, String preMiddleLayer, Map<Integer, String> oidMap, String assignType, Map<Integer, String> renameMap, Map<String, String> assignFieldMap, boolean isConsiderNull, Map<String, String> defaultValueMap, String resultLayer, String taskId) {
        RpcDescDataRespond descDataRespond = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(preMiddleLayer), taskId, UUIDUtils.getUUID());
        List<FieldInfo> fieldInfos = RpcRespondUtils.getVectorFieldInfo(descDataRespond);
        List aFields = fieldInfos.stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        log.info("\u7edf\u8ba1\u8868\u7684\u5168\u90e8\u5b57\u6bb5\u4e3a:" + org.apache.commons.lang3.StringUtils.join(aFields, (String)","));
        int oidIndex = oidMap.keySet().toArray(new Integer[0])[0];
        String rOidName = oidMap.get(oidIndex);
        String oidName = fieldInfos.get(oidIndex).getFieldName();
        List rAssignFields = renameMap.keySet().stream().map(fieldInfos::get).map(FieldInfo::getFieldName).collect(Collectors.toList());
        String geometryField = (String)descDataRespond.getDataDescMap().get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)geometryField)) {
            throw new NotFoundException("\u4e0d\u80fd\u627e\u5230\u56fe\u5f62\u5b57\u6bb5!", Thread.currentThread(), 3);
        }
        ComputeLayerInfo computeLayerInfo = this.computeArea(preMiddleLayer, true, taskId, UUIDUtils.getUUID());
        ArrayList removeFields = new ArrayList();
        removeFields.addAll(aFields);
        ArrayList<String> retainFields = new ArrayList<String>();
        retainFields.add(oidName);
        retainFields.addAll(rAssignFields);
        retainFields.add(computeLayerInfo.getAreaName());
        removeFields.removeAll(retainFields);
        String middleLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_mid_" + UUIDUtils.getUUID();
        HashMap<String, String> processParams = new HashMap<String, String>();
        processParams.put(AtlasProcessFieldRemoveParams$.MODULE$.REMOVE_FIELDS(), org.apache.commons.lang3.StringUtils.join(removeFields, (String)","));
        this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(computeLayerInfo.getComputeLayerName()), FieldRemoveProcess$.MODULE$.NAME(), processParams, AtlasTagUtils.getAtlasRpcDataTag(middleLayer), taskId, UUIDUtils.getUUID());
        this.client.getSparkRpcClientApi().persistData(AtlasTagUtils.getAtlasRpcDataTag(middleLayer), taskId, UUIDUtils.getUUID());
        log.info("\u5b8c\u6210" + middleLayer + "\u6570\u636e\u6301\u4e45\u5316!");
        String statisticArea = "area_" + UUIDUtils.getUUID();
        String middleLayerView = RpcNameUtils.getViewName(middleLayer);
        String statisticSql = "select `" + oidName + "`,`" + org.apache.commons.lang3.StringUtils.join(rAssignFields, (String)"`,`") + "`,sum(`" + computeLayerInfo.getAreaName() + "`) as " + statisticArea + " from " + middleLayerView + " group by `" + oidName + "`,`" + org.apache.commons.lang3.StringUtils.join(rAssignFields, (String)"`,`") + "`";
        String statisticViewAlias = "a";
        String assignAreaField = "area_" + UUIDUtils.getUUID();
        String sumAreaField = "area_" + UUIDUtils.getUUID();
        String rowKeyField = "row_" + UUIDUtils.getUUID();
        String groupSql = "select " + statisticViewAlias + ".`" + oidName + "`," + statisticViewAlias + ".`" + org.apache.commons.lang3.StringUtils.join(rAssignFields, (String)("`," + statisticViewAlias + ".`")) + "`,row_number() over(partition by " + statisticViewAlias + ".`" + oidName + "` order by " + AssignType.getSparkSqlFunc(assignType, statisticViewAlias, statisticArea) + ")  as " + rowKeyField + ", sum(" + statisticViewAlias + ".`" + statisticArea + "`) over (partition by " + statisticViewAlias + ".`" + oidName + "`) " + sumAreaField + ", " + statisticViewAlias + ".`" + statisticArea + "` " + assignAreaField + " from (" + statisticSql + ") " + statisticViewAlias;
        String groupViewAlias = "b";
        String filterSql = "select " + groupViewAlias + ".`" + oidName + "`," + groupViewAlias + ".`" + org.apache.commons.lang3.StringUtils.join(rAssignFields, (String)("`," + groupViewAlias + ".`")) + "`," + groupViewAlias + ".`" + assignAreaField + "`," + groupViewAlias + ".`" + sumAreaField + "` from (" + groupSql + ") " + groupViewAlias + " where " + groupViewAlias + ".`" + rowKeyField + "`=1";
        String filterViewAlias = "c";
        String baseView = RpcNameUtils.getViewName(layerName);
        RpcDescDataRespond baseLayerInfo = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(layerName), taskId, UUIDUtils.getUUID());
        String baseGeomField = (String)baseLayerInfo.getDataDescMap().get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)baseGeomField)) {
            throw new NotFoundException("\u4e0d\u80fd\u627e\u5230\u56fe\u5f62\u5b57\u6bb5!", Thread.currentThread(), 3);
        }
        List baseLayerFields = RpcRespondUtils.getVectorFieldInfo(baseLayerInfo).stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        if (deleteOid) {
            baseLayerFields.remove(oidName);
        }
        String baseLayerAlias = "d";
        StringBuilder joinSqlBuilder = new StringBuilder("select " + baseLayerAlias + ".`" + org.apache.commons.lang3.StringUtils.join(baseLayerFields, (String)("`," + baseLayerAlias + ".`")) + "`,");
        if (isConsiderNull) {
            for (Integer i : renameMap.keySet()) {
                joinSqlBuilder.append(this.assignCaseWhenIncludeNull(baseLayerAlias, baseGeomField, assignType, filterViewAlias, assignAreaField, sumAreaField, (String)aFields.get(i), assignFieldMap.get(renameMap.get(i)), defaultValueMap.getOrDefault(renameMap.get(i), ""))).append(",");
            }
        } else {
            for (Integer i : renameMap.keySet()) {
                joinSqlBuilder.append(this.assignCaseWhen(filterViewAlias, assignAreaField, (String)aFields.get(i), assignFieldMap.get(renameMap.get(i)), defaultValueMap.getOrDefault(renameMap.get(i), ""))).append(",");
            }
        }
        joinSqlBuilder.deleteCharAt(joinSqlBuilder.length() - 1);
        joinSqlBuilder.append(" from " + baseView + " as " + baseLayerAlias + " left join (" + filterSql + ") as " + filterViewAlias + " on " + baseLayerAlias + ".`" + rOidName + "` = " + filterViewAlias + ".`" + oidName + "`");
        String joinSql = joinSqlBuilder.toString();
        log.info("\u6267\u884cSparkSql:" + joinSql);
        HashMap<String, String> sqlParams = new HashMap<String, String>();
        sqlParams.put(AtlasProcessRunSqlParams.SQL_EXPRESSION(), joinSql);
        sqlParams.put(SqlSimpleApiFactory.SAVE_STATISTIC_LAYER_ORDER(), "0");
        String message = this.client.getSparkRpcClientApi().listProcess(Arrays.asList(AtlasTagUtils.getAtlasRpcDataTag(layerName), AtlasTagUtils.getAtlasRpcDataTag(middleLayer)), RunSqlProcess$.MODULE$.NAME(), sqlParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayer), taskId, UUIDUtils.getUUID());
        log.info(message);
    }

    public String assignCaseWhenIncludeNull(String baseLayerAlias, String baseGeomField, String assignType, String groupViewAlias, String groupAreaField, String sumAreaField, String rawAssignField, String finalAssignField, String defaultValue) {
        return "case when " + groupViewAlias + ".`" + groupAreaField + "` is null then '" + defaultValue + "' else case when (st_area(" + baseLayerAlias + ".`" + baseGeomField + "`) - " + groupViewAlias + ".`" + sumAreaField + "`) " + AssignType.getSparkSqlCasWhen(assignType) + " " + groupViewAlias + ".`" + groupAreaField + "` then '" + defaultValue + "' else " + groupViewAlias + ".`" + rawAssignField + "` end end as " + finalAssignField;
    }

    public String assignCaseWhen(String groupViewAlias, String groupAreaField, String rawAssignField, String finalAssignField, String defaultValue) {
        return "case when " + groupViewAlias + ".`" + groupAreaField + "` is null then '" + defaultValue + "' else " + groupViewAlias + ".`" + rawAssignField + "` end as " + finalAssignField;
    }

    public void connectivity(String layerName, Map<String, String> connectivityParams, String resultLayer, String taskId) {
        String message = this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(layerName), VectorDataSetConnectedComponentsProcess.NAME(), connectivityParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayer), taskId, UUIDUtils.getUUID());
        log.info(message);
    }

    public void buffer(String baseName, Map<String, String> params, String dissolve_type, String resultName, String taskId) {
        HashMap<String, String> bufferParams = new HashMap<String, String>(params);
        if (bufferParams.containsKey(AtlasProcessBufferParams.END_TYPE())) {
            bufferParams.put(AtlasProcessBufferParams.END_TYPE(), BUFFER_DICT.get(params.get(AtlasProcessBufferParams.END_TYPE())).toString());
        }
        if (bufferParams.containsKey(AtlasProcessBufferParams.SIDE_TYPE())) {
            bufferParams.put(AtlasProcessBufferParams.SIDE_TYPE(), BUFFER_DICT.get(params.get(AtlasProcessBufferParams.SIDE_TYPE())).toString());
        }
        log.info("\u5f00\u59cb\u56fe\u6591\u7f13\u51b2\uff0c\u7f13\u51b2\u53c2\u6570\u4e3a:" + this.toJSON(bufferParams) + ", \u878d\u5408\u7c7b\u578b" + dissolve_type);
        String bufferLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_b_" + UUIDUtils.getUUID();
        this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(baseName), BufferProcess$.MODULE$.NAME(), bufferParams, AtlasTagUtils.getAtlasRpcDataTag(bufferLayer), taskId, UUIDUtils.getUUID());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dissolve_type) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)DISSOLVE_TYPE_NONE, (CharSequence)dissolve_type)) {
            switch (dissolve_type.toUpperCase()) {
                case "CONNECT": {
                    String FINAL_ID = "objectid";
                    String connectivityField = "c_" + UUIDUtils.getUUID();
                    String connectivityLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_c_" + UUIDUtils.getUUID();
                    HashMap<String, String> connectivityParams = new HashMap<String, String>();
                    connectivityParams.put(AtlasProcessConnectedComponentsParams.FIELD_NAME(), connectivityField);
                    this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(bufferLayer), VectorDataSetConnectedComponentsProcess.NAME(), connectivityParams, AtlasTagUtils.getAtlasRpcDataTag(connectivityLayer), taskId, UUIDUtils.getUUID());
                    String dissolveLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_d_" + UUIDUtils.getUUID();
                    HashMap<String, String> dissolveParams = new HashMap<String, String>();
                    dissolveParams.put(AtlasProcessDissolveParams.GROUP_FIELDS(), connectivityField);
                    this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(connectivityLayer), DissolveProcess.NAME(), dissolveParams, AtlasTagUtils.getAtlasRpcDataTag(dissolveLayer), taskId, UUIDUtils.getUUID());
                    HashMap<String, String> renameFieldParams = new HashMap<String, String>();
                    renameFieldParams.put(AtlasProcessFieldRenameParams.OLD_FIELDS(), connectivityField);
                    renameFieldParams.put(AtlasProcessFieldRenameParams.NEW_FIELDS(), FINAL_ID);
                    this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(dissolveLayer), FieldRenameProcess$.MODULE$.NAME(), renameFieldParams, AtlasTagUtils.getAtlasRpcDataTag(resultName), taskId, UUIDUtils.getUUID());
                    break;
                }
                case "GRID": {
                    throw new NotImplementedException("\u6682\u672a\u5b9e\u73b0\u5f53\u524d\u7f13\u51b2\u65b9\u6cd5:" + dissolve_type + "!", Thread.currentThread(), 3);
                }
                default: {
                    throw new NotSupportException("\u4e0d\u652f\u6301\u5f53\u524d\u878d\u5408\u65b9\u6cd5:" + dissolve_type + "!", Thread.currentThread(), 3);
                }
            }
        } else {
            this.dataServer.renameData(bufferLayer, resultName, taskId, UUIDUtils.getUUID());
        }
    }

    public void distinct(String baseLayerName, String recomputeFields, String taskId, String resultLayerName) {
        ComputeLayerInfo computerLayerInfo = this.computeArea(baseLayerName, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeFields), taskId, UUIDUtils.getUUID());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u7684\u57fa\u7840\u56fe\u5c42\u4e3a:" + computerLayerInfo.getComputeLayerName());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u57fa\u7840\u56fe\u5c42\u8ffd\u52a0\u7684\u9762\u79ef\u5b57\u6bb5\u4e3a:" + computerLayerInfo.getAreaName());
        String preResultLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_r_" + UUIDUtils.getUUID();
        this.processServer.unitaryProcess(computerLayerInfo.getComputeLayerName(), "overlay-distinct", new HashMap<String, String>(), preResultLayerName, taskId, UUIDUtils.getUUID());
        log.info("\u53e0\u52a0\u6267\u884c\u7ed3\u679c\u56fe\u5c42\u4e3a:" + preResultLayerName);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeFields)) {
            this.recomputeFields(baseLayerName, computerLayerInfo.getAreaName(), recomputeFields, null, null, null, preResultLayerName, resultLayerName, taskId);
        } else {
            this.dataServer.renameData(preResultLayerName, resultLayerName, taskId, UUIDUtils.getUUID());
        }
    }

    public void overlay(String baseLayerName, boolean baseIsMem, String baseFilter, String recomputeBaseFields, String otherLayerName, boolean otherIsMem, String otherFilter, String recomputeOtherFields, String processName, Map<String, String> processParams, String resultLayerName, String taskId) {
        log.info("\u8fdb\u5165\u901a\u7528\u53e0\u52a0\u6d41\u7a0b, \u53c2\u6570\u4e3a => baseFilter:" + baseFilter + ", recomputeBaseFields:" + recomputeBaseFields + ", otherFilter:" + otherFilter + ", recomputeOtherFields:" + recomputeOtherFields + ", processName:" + processName + ", processParams:" + this.toJSON(processParams));
        RpcDescDataRespond baseLayerInfo = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(baseLayerName), taskId, UUIDUtils.getUUID());
        Map baseLayerDescMap = baseLayerInfo.getDataDescMap();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)baseLayerDescMap.get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY())))) {
            throw new NotSupportException("\u4e0d\u652f\u6301\u975e\u7a7a\u95f4\u56fe\u5c42\u8fdb\u884c\u7a7a\u95f4\u8ba1\u7b97\u64cd\u4f5c", Thread.currentThread(), 3);
        }
        RpcDescDataRespond otherLayerInfo = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(otherLayerName), taskId, UUIDUtils.getUUID());
        String nBaseFilter = baseFilter;
        String nOtherFilter = otherFilter;
        if (org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)processName, (CharSequence[])new CharSequence[]{ClipProcess.NAME(), IntersectionProcess.NAME(), EraseProcess.NAME(), IdentityProcess.NAME()})) {
            Map<Integer, String> filterInfos = GeometryBoundaryUtils.getExtraFilter(baseLayerInfo, otherLayerInfo, OVERLAY_OPTIMIZE_RATE);
            if (org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)processName, (CharSequence[])new CharSequence[]{ClipProcess.NAME(), IntersectionProcess.NAME()}) && !baseIsMem) {
                String baseSpatialFilter = filterInfos.getOrDefault(0, null);
                log.info("\u57fa\u7840\u56fe\u5c42\u65b0\u589e\u7b5b\u9009\u6761\u4ef6:" + baseSpatialFilter);
                nBaseFilter = GeometryBoundaryUtils.addExtraFilter(baseFilter, baseSpatialFilter);
            }
            if (!otherIsMem) {
                String otherSpatialFilter = filterInfos.getOrDefault(1, null);
                log.info("\u53e0\u52a0\u56fe\u5c42\u65b0\u589e\u7b5b\u9009\u6761\u4ef6:" + otherSpatialFilter);
                nOtherFilter = GeometryBoundaryUtils.addExtraFilter(otherFilter, otherSpatialFilter);
            }
        }
        String bFilterLayerName = this.filter(baseLayerName, nBaseFilter, taskId, UUIDUtils.getUUID());
        String oFilterLayerName = this.filter(otherLayerName, nOtherFilter, taskId, UUIDUtils.getUUID());
        log.info("\u5c5e\u6027\u7b5b\u9009\u540e\u7684\u57fa\u7840\u56fe\u5c42\u4e3a:" + bFilterLayerName);
        log.info("\u5c5e\u6027\u7b5b\u9009\u540e\u7684\u53e0\u52a0\u56fe\u5c42\u4e3a:" + oFilterLayerName);
        String otherTransLayerName = this.transFormCrs(oFilterLayerName, (String)baseLayerDescMap.get(VectorDataManager.DataDesc$.MODULE$.CRS()), taskId, UUIDUtils.getUUID());
        log.info("\u5750\u6807\u8f6c\u6362\u540e\u7684\u53e0\u52a0\u56fe\u5c42\u4e3a:" + otherTransLayerName);
        ComputeLayerInfo bfComputerLayerInfo = this.computeArea(bFilterLayerName, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeBaseFields), taskId, UUIDUtils.getUUID());
        ComputeLayerInfo ofComputerLayerInfo = this.computeArea(otherTransLayerName, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeOtherFields), taskId, UUIDUtils.getUUID());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u7684\u57fa\u7840\u56fe\u5c42\u4e3a:" + bfComputerLayerInfo.getComputeLayerName());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u57fa\u7840\u56fe\u5c42\u8ffd\u52a0\u7684\u9762\u79ef\u5b57\u6bb5\u4e3a:" + bfComputerLayerInfo.getAreaName());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u7684\u53e0\u52a0\u56fe\u5c42\u4e3a:" + ofComputerLayerInfo.getComputeLayerName());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u53e0\u52a0\u56fe\u5c42\u56fe\u5c42\u8ffd\u52a0\u7684\u9762\u79ef\u5b57\u6bb5\u4e3a:" + ofComputerLayerInfo.getAreaName());
        String preResultLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_r_" + UUIDUtils.getUUID();
        this.processServer.binaryProcess(bfComputerLayerInfo.getComputeLayerName(), ofComputerLayerInfo.getComputeLayerName(), processName, processParams, preResultLayerName, taskId, UUIDUtils.getUUID());
        log.info("\u53e0\u52a0\u6267\u884c\u7ed3\u679c\u56fe\u5c42\u4e3a:" + preResultLayerName);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeBaseFields) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeOtherFields)) {
            this.recomputeFields(bfComputerLayerInfo.getComputeLayerName(), bfComputerLayerInfo.getAreaName(), recomputeBaseFields, ofComputerLayerInfo.getComputeLayerName(), ofComputerLayerInfo.getAreaName(), recomputeOtherFields, preResultLayerName, resultLayerName, taskId);
        } else {
            this.dataServer.renameData(preResultLayerName, resultLayerName, taskId, UUIDUtils.getUUID());
        }
    }

    public void recomputeFields(String bLayerName, String bAreaName, String recomputeBaseFields, String oLayerName, String oAreaName, String recomputeOtherFields, String overlayLayerName, String resultLayerName, String taskId) {
        ComputeLayerInfo computerLayerInfo = this.computeArea(overlayLayerName, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeBaseFields) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeOtherFields), taskId, UUIDUtils.getUUID());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u7684\u7ed3\u679c\u56fe\u5c42\u540d\u79f0\u4e3a:" + computerLayerInfo.getComputeLayerName());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u7684\u7ed3\u679c\u56fe\u5c42\u9762\u79ef\u5b57\u6bb5\u4e3a:" + computerLayerInfo.getAreaName());
        int[] startIndex = new int[]{1};
        int[] bAreaNameIndexFlag = new int[]{-1};
        int[] oAreaNameIndexFlag = new int[]{-1};
        Map<Integer, String> recomputeBaseFieldMap = this.getRenameMap(bLayerName, bAreaName, bAreaNameIndexFlag, recomputeBaseFields, taskId, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recomputeOtherFields), startIndex);
        Map<Integer, String> recomputeUnionFieldMap = this.getRenameMap(oLayerName, oAreaName, oAreaNameIndexFlag, recomputeOtherFields, taskId, false, startIndex);
        this.logInfo(recomputeBaseFieldMap);
        this.logInfo(recomputeUnionFieldMap);
        this.recomputeRunSQL(computerLayerInfo.getComputeLayerName(), bAreaNameIndexFlag[0], oAreaNameIndexFlag[0], computerLayerInfo.getAreaName(), recomputeBaseFieldMap, recomputeUnionFieldMap, resultLayerName, taskId);
    }

    public void recomputeRunSQL(String computeLayerName, int lAreaIndex, int rAreaIndex, String oAreaName, Map<Integer, String> recomputeBaseFieldMap, Map<Integer, String> recomputeOtherFieldMap, String resultLayerName, String taskId) {
        AtlasRpcDataTag computeDataDescTag = AtlasTagUtils.getAtlasRpcDataTag(computeLayerName);
        RpcDescDataRespond computeDataDescRespond = this.client.getSparkRpcClientApi().descData(computeDataDescTag, taskId, UUIDUtils.getUUID());
        List<String> fieldNames = RpcRespondUtils.getVectorFieldInfo(computeDataDescRespond).stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        log.info("\u9762\u79ef\u8ba1\u7b97\u540e\u7ed3\u679c\u56fe\u5c42\u7684\u5b57\u6bb5\u540d\u79f0\u4e3a:" + String.join((CharSequence)",", fieldNames));
        String computeLayerView = RpcNameUtils.getViewName(computeLayerName);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ");
        for (int fieldIndex = 0; fieldIndex < fieldNames.size(); ++fieldIndex) {
            if (fieldIndex == lAreaIndex || fieldIndex == rAreaIndex || org.apache.commons.lang3.StringUtils.equals((CharSequence)((CharSequence)fieldNames.get(fieldIndex)), (CharSequence)oAreaName)) continue;
            if (recomputeBaseFieldMap.containsKey(fieldIndex)) {
                this.appendComputeField(sqlBuilder, fieldNames.get(fieldIndex), fieldNames.get(lAreaIndex), oAreaName);
                continue;
            }
            if (recomputeOtherFieldMap.containsKey(fieldIndex)) {
                this.appendComputeField(sqlBuilder, fieldNames.get(fieldIndex), fieldNames.get(rAreaIndex), oAreaName);
                continue;
            }
            this.appendField(sqlBuilder, fieldNames.get(fieldIndex));
        }
        if (!recomputeBaseFieldMap.isEmpty()) {
            for (int rIndex : recomputeBaseFieldMap.keySet()) {
                this.renameRawComputeField(sqlBuilder, fieldNames, rIndex);
            }
        }
        if (!recomputeOtherFieldMap.isEmpty()) {
            for (int oIndex : recomputeOtherFieldMap.keySet()) {
                this.renameRawComputeField(sqlBuilder, fieldNames, oIndex);
            }
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(" from `").append(computeLayerView).append("`");
        String sql = sqlBuilder.toString();
        HashMap<String, String> sqlParams = new HashMap<String, String>();
        sqlParams.put(AtlasProcessRunSqlParams.SQL_EXPRESSION(), sql);
        sqlParams.put(SqlSimpleApiFactory.SAVE_STATISTIC_LAYER_ORDER(), "0");
        String message = this.client.getSparkRpcClientApi().listProcess(Collections.singletonList(AtlasTagUtils.getAtlasRpcDataTag(computeLayerName)), RunSqlProcess$.MODULE$.NAME(), sqlParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayerName), taskId, UUIDUtils.getUUID());
        log.info(message);
    }

    public void renameRawComputeField(StringBuilder sqlBuilder, List<String> fieldNames, int fieldIndex) {
        String fieldName = fieldNames.get(fieldIndex);
        String bakField = fieldName + BAK_FIELD_SUFFIX;
        bakField = StringUtils.getUniqueStringFromSeq((String)bakField, fieldNames);
        sqlBuilder.append("`").append(fieldName).append("` AS `").append(bakField).append("`,");
    }

    public void appendComputeField(StringBuilder sqlBuilder, String fieldName, String baseAreaName, String overAreaName) {
        sqlBuilder.append("`").append(fieldName).append("`*`").append(overAreaName).append("`/`").append(baseAreaName).append("` AS `").append(fieldName).append("`,");
    }

    public void appendField(StringBuilder sqlBuilder, String fieldName) {
        sqlBuilder.append("`").append(fieldName).append("`,");
    }

    public Map<Integer, String> getRenameMap(String layerName, String areaName, int[] areaIndexFlag, String recomputeFields, String taskId, boolean addIndexFlag, int[] startIndexFlag) {
        List<String> recomputeFieldList;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)recomputeFields) && !addIndexFlag) {
            return new HashMap<Integer, String>();
        }
        RpcDescDataRespond rpcDescDataRespond = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(layerName), taskId, UUIDUtils.getUUID());
        List<FieldInfo> fieldInfos = RpcRespondUtils.getVectorFieldInfo(rpcDescDataRespond);
        log.info("\u91cd\u7b97\u9762\u79ef\u524d\u5b57\u6bb5\u4e3a:" + fieldInfos.stream().map(FieldInfo::getFieldName).collect(Collectors.joining(",")));
        Map fieldDescMap = rpcDescDataRespond.getDataDescMap();
        String geometryField = (String)fieldDescMap.get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)geometryField)) {
            throw new NotFoundException("\u4e0d\u80fd\u627e\u5230\u56fe\u5f62\u5b57\u6bb5!", Thread.currentThread(), 3);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)recomputeFields)) {
            startIndexFlag[0] = startIndexFlag[0] + (fieldInfos.size() - 1);
            return new HashMap<Integer, String>();
        }
        int startIndex = startIndexFlag[0];
        List fieldNames = fieldInfos.stream().map(FieldInfo::getFieldName).filter(fd -> !org.apache.commons.lang3.StringUtils.equals((CharSequence)fd, (CharSequence)geometryField)).collect(Collectors.toList());
        if (!CollectionUtils.containsAll(fieldNames, recomputeFieldList = Arrays.stream(recomputeFields.split(",")).map(String::trim).collect(Collectors.toList()))) {
            throw new ParamException("\u5f53\u524d\u56fe\u5c42\u5b57\u6bb5:" + org.apache.commons.lang3.StringUtils.join(fieldNames, (String)",") + "\u4e0d\u5b8c\u5168\u5305\u542b\u91cd\u7b97\u7684\u56fe\u5c42\u5b57\u6bb5:" + recomputeFields, Thread.currentThread(), 3);
        }
        HashMap<Integer, String> renameMap = new HashMap<Integer, String>();
        recomputeFieldList.forEach(recomputeField -> renameMap.put(fieldNames.indexOf(recomputeField) + startIndex, (String)recomputeField));
        areaIndexFlag[0] = fieldNames.indexOf(areaName) + startIndex;
        startIndexFlag[0] = startIndexFlag[0] + fieldNames.size();
        return renameMap;
    }

    public LayerIdentityDto getLayerIdentityDto(String layerIdentity) {
        return (LayerIdentityDto)this.objectMapper.readValue(layerIdentity, LayerIdentityDto.class);
    }

    public List<String> getIdentities(LayerIdentityDto layerIdentityDto) {
        return layerIdentityDto.getDatas().stream().map(this::toJSON).collect(Collectors.toList());
    }

    public String toJSON(Object obj) {
        return this.objectMapper.writeValueAsString(obj);
    }

    public <T> T fromJSON(String jsonString, Class<T> clz) {
        return (T)this.objectMapper.readValue(jsonString, clz);
    }

    public String filter(String layerName, String filter, String taskId, String jobId) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filter)) {
            String tempLayerName = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_f_" + UUIDUtils.getUUID();
            HashMap<String, String> filterParams = new HashMap<String, String>();
            filterParams.put(AtlasProcessAttributeFilterParams.SQL_EXPRESSION(), filter);
            String message = this.processServer.filterProcess(layerName, filterParams, tempLayerName, taskId, jobId);
            log.info(message);
            return tempLayerName;
        }
        return layerName;
    }

    public ComputeLayerInfo computeArea(String layerName, boolean compute, String taskId, String jobId) {
        String areaName = "area_" + UUIDUtils.getUUID();
        return this.computeArea(layerName, compute, areaName, taskId, jobId);
    }

    public ComputeLayerInfo computeArea(String layerName, boolean compute, String areaName, String taskId, String jobId) {
        if (!compute) {
            return new ComputeLayerInfo(layerName, null);
        }
        String resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_a_" + UUIDUtils.getUUID();
        HashMap<String, String> calculatorParams = new HashMap<String, String>();
        calculatorParams.put(AtlasProcessCalculateParams.FIELD_NAME(), areaName);
        calculatorParams.put(AtlasProcessCalculateParams.CALCULATE_TARGET(), AtlasProcessCalculateParams.CalculateTarget$.MODULE$.ST_AREA());
        this.processServer.calculatorProcess(layerName, calculatorParams, resultLayer, taskId, jobId);
        return new ComputeLayerInfo(resultLayer, areaName);
    }

    public CreateOidLayerInfo createOid(String layerName, String taskId, String jobId) {
        Map descMap = this.client.getSparkRpcClientApi().descData(AtlasTagUtils.getAtlasRpcDataTag(layerName), taskId, jobId).getDataDescMap();
        boolean delete = false;
        String oidFields = "";
        String resultLayer = layerName;
        if (descMap.containsKey(VectorDataManager.DataDesc$.MODULE$.OID_FIELDS())) {
            oidFields = (String)descMap.get(VectorDataManager.DataDesc$.MODULE$.OID_FIELDS());
            if (oidFields.contains(",")) {
                log.warn("\u4e0d\u652f\u6301\u56fe\u5c42\u5305\u542b\u591a\u4e2aoid,\u9700\u8981\u91cd\u5efaoid!");
                delete = true;
            }
        } else {
            delete = true;
        }
        if (delete) {
            oidFields = "oid_" + UUIDUtils.getUUID();
            resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_o_id_" + UUIDUtils.getUUID();
            HashMap<String, String> createOidParams = new HashMap<String, String>();
            createOidParams.put(AtlasProcessCreateOidParams.FIELD_NAME(), oidFields);
            createOidParams.put(AtlasProcessCreateOidParams.LONG_FIELD(), "true");
            this.client.getSparkRpcClientApi().unitaryProcess(AtlasTagUtils.getAtlasRpcDataTag(layerName), CreateOidProcess$.MODULE$.NAME(), createOidParams, AtlasTagUtils.getAtlasRpcDataTag(resultLayer), taskId, UUIDUtils.getUUID());
        }
        return new CreateOidLayerInfo(delete, oidFields, resultLayer);
    }

    public String transFormCrs(String layerName, String crsString, String taskId, String jobId) {
        String resultLayer = AtlasDataName.TEMP_LAYER_PREFIX() + "_" + UUIDUtils.getUUID();
        HashMap<String, String> transformCRS = new HashMap<String, String>();
        transformCRS.put(AtlasProcessTransformCrsParams.TARGET_CRS(), crsString);
        this.processServer.unitaryProcess(layerName, TransformCrsProcess$.MODULE$.NAME(), transformCRS, resultLayer, taskId, jobId);
        return resultLayer;
    }

    public void logInfo(Map<Integer, String> fieldMap) {
        if (fieldMap != null && !fieldMap.isEmpty()) {
            log.info("\u539f\u59cb\u5b57\u6bb5\u5728\u7ed3\u679c\u5b57\u6bb5\u4e2d\u7684\u6620\u5c04\u4e3a:" + this.toJSON(fieldMap));
        }
    }
}

