/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.common.utils.RuntimeUtils;
import com.geoway.atlas.framework.spark.common.SparkRuntime;
import com.geoway.atlas.web.api.v2.init.SparkRuntimeArgs;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.ApplicationArguments;

public class ApplicationArgumentsUtils {
    private static final String START_MODE = "spark.start.mode";
    private static final String APP_NAME = "spark.appName";
    private static final String MEMORY_FUNC = "spark.memory.func";
    private static final String NUM_EXECUTORS = "spark.num.executors";
    private static final String EXECUTOR_CORES = "spark.executors.cores";
    private static final String EXECUTOR_MEMORY = "spark.executors.memory";
    public static final String SERVER_CENTER = "server.center";
    public static final String ATLAS_URL = "atlas.url";
    public static final String DOMAIN_INFO = "domain.info";
    public static final String MULTI_SERVER = "multi.server";

    public static String getSingleValue(ApplicationArguments args, String key) {
        List appNames = args.getOptionValues(key);
        if (CollectionUtils.isNotEmpty((Collection)appNames) && StringUtils.isNotEmpty((CharSequence)((CharSequence)appNames.get(0)))) {
            return ((String)appNames.get(0)).trim();
        }
        return null;
    }

    public static SparkRuntimeArgs fromApplicationArgs(ApplicationArguments args) {
        String startMode = ApplicationArgumentsUtils.getSingleValue(args, START_MODE);
        String appName = ApplicationArgumentsUtils.getSingleValue(args, APP_NAME);
        String memoryFunc = ApplicationArgumentsUtils.getSingleValue(args, MEMORY_FUNC);
        String numExecutors = ApplicationArgumentsUtils.getSingleValue(args, NUM_EXECUTORS);
        String executorCores = ApplicationArgumentsUtils.getSingleValue(args, EXECUTOR_CORES);
        String executorMem = ApplicationArgumentsUtils.getSingleValue(args, EXECUTOR_MEMORY);
        SparkRuntimeArgs sparkRuntimeArgs = new SparkRuntimeArgs(SparkRuntime.StartMode$.MODULE$.LOCAL(), APP_NAME, -1.0, 1, RuntimeUtils.getPhysicsCores(), 0.0);
        if (StringUtils.isNotBlank((CharSequence)startMode)) {
            sparkRuntimeArgs.setStartMode(startMode);
        }
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            sparkRuntimeArgs.setAppName(appName);
        }
        if (StringUtils.isNotBlank((CharSequence)memoryFunc)) {
            sparkRuntimeArgs.setMemoryFunc(Double.parseDouble(memoryFunc.trim()));
        }
        if (StringUtils.isNotBlank((CharSequence)numExecutors)) {
            sparkRuntimeArgs.setNumExecutors(Integer.parseInt(numExecutors));
        }
        if (StringUtils.isNotBlank((CharSequence)executorCores)) {
            sparkRuntimeArgs.setExecutorCores(Integer.parseInt(executorCores));
        }
        if (StringUtils.isNotBlank((CharSequence)executorMem)) {
            sparkRuntimeArgs.setExecutorMemory(ApplicationArgumentsUtils.getExecutorMemoryGb(executorMem));
        }
        return sparkRuntimeArgs;
    }

    private static Double getExecutorMemoryGb(String executorMem) {
        String executorMemTrim = executorMem.trim();
        int unitIndex = executorMemTrim.length() - 1;
        double memoryValue = Double.parseDouble(StringUtils.substring((String)executorMemTrim, (int)0, (int)unitIndex));
        String unit = StringUtils.substring((String)executorMemTrim, (int)unitIndex).toUpperCase();
        if ("M".equals(unit)) {
            memoryValue /= 1024.0;
        } else if (!"G".equals(unit)) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5185\u5b58\u5355\u4f4d:" + unit);
        }
        return memoryValue;
    }
}

