/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.algorithm.vector.common.geometry.GeometryFunctions;
import com.geoway.atlas.algorithm.vector.overlay.geom.AtlasOverlayOp;
import com.geoway.atlas.data.vector.common.crs.CrsUtils$;
import com.geoway.atlas.data.vector.common.jts.JTSUtils$;
import com.geoway.atlas.data.vector.common.wkt.WktUtils$;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.dataset.vector.manager.VectorDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryBoundaryUtils {
    public static Map<Integer, String> getExtraFilter(RpcDescDataRespond baseData, RpcDescDataRespond otherData, double limitRate) {
        Map baseDataDesc = baseData.getDataDescMap();
        Map otherDataDesc = otherData.getDataDescMap();
        Geometry baseBoundary = null;
        Geometry otherBoundary = null;
        if (baseDataDesc.containsKey(VectorDataManager.DataDesc$.MODULE$.BOUNDARY()) && ((baseBoundary = WktUtils$.MODULE$.read((String)baseDataDesc.get(VectorDataManager.DataDesc$.MODULE$.BOUNDARY()))).isEmpty() || GeometryUtils.isEmptyEnvelope((Geometry)baseBoundary))) {
            baseBoundary = null;
        }
        if (otherDataDesc.containsKey(VectorDataManager.DataDesc$.MODULE$.BOUNDARY()) && ((otherBoundary = WktUtils$.MODULE$.read((String)otherDataDesc.get(VectorDataManager.DataDesc$.MODULE$.BOUNDARY()))).isEmpty() || GeometryUtils.isEmptyEnvelope((Geometry)otherBoundary))) {
            otherBoundary = null;
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (baseBoundary != null && otherBoundary != null) {
            Geometry otherGeometry;
            Geometry baseGeometry;
            String base_crs_info = (String)baseDataDesc.get(VectorDataManager.DataDesc$.MODULE$.CRS());
            String other_crs_info = (String)otherDataDesc.get(VectorDataManager.DataDesc$.MODULE$.CRS());
            boolean equalCRS = false;
            CoordinateReferenceSystem baseCRS = null;
            CoordinateReferenceSystem otherCRS = null;
            if (StringUtils.equals((CharSequence)base_crs_info, (CharSequence)other_crs_info)) {
                equalCRS = true;
            } else {
                baseCRS = GeometryFunctions.parseCRSString((String)base_crs_info);
                otherCRS = GeometryFunctions.parseCRSString((String)other_crs_info);
                equalCRS = CrsUtils$.MODULE$.compareCrs(baseCRS, otherCRS);
            }
            if (equalCRS) {
                Geometry geometry2;
                baseGeometry = geometry2 = AtlasOverlayOp.intersection((Geometry)baseBoundary, (Geometry)otherBoundary);
                otherGeometry = geometry2;
            } else {
                baseGeometry = JTSUtils$.MODULE$.toGeometry(JTSUtils$.MODULE$.transform(otherBoundary.getEnvelopeInternal(), otherCRS, baseCRS));
                otherGeometry = JTSUtils$.MODULE$.toGeometry(JTSUtils$.MODULE$.transform(baseBoundary.getEnvelopeInternal(), baseCRS, otherCRS));
            }
            BiFunction<String, Geometry, String> filterFunction = (s, geometry) -> geometry != null && !geometry.isEmpty() ? "st_intersects(" + s + ", st_geomfromtext('" + WktUtils$.MODULE$.write(geometry) + "', " + (String)baseDataDesc.get(VectorDataManager.DataDesc$.MODULE$.CRS()) + "))" : "1=0";
            if (baseGeometry.getArea() / baseBoundary.getArea() < limitRate) {
                result.put(0, filterFunction.apply((String)baseDataDesc.get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY()), baseGeometry));
            }
            if (otherGeometry.getArea() / otherBoundary.getArea() < limitRate) {
                result.put(1, filterFunction.apply((String)otherDataDesc.get(VectorDataManager.DataDesc$.MODULE$.DEFAULT_GEOMETRY()), otherGeometry));
            }
        }
        return result;
    }

    public static String addExtraFilter(String rawFilter, String extraFilter) {
        if (StringUtils.isBlank((CharSequence)rawFilter)) {
            return extraFilter;
        }
        if (StringUtils.isBlank((CharSequence)extraFilter)) {
            return rawFilter;
        }
        return extraFilter + " AND (" + rawFilter + ")";
    }
}

