/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.component.rpc;

import com.geoway.atlas.data.vector.spark.common.rpc.client.SparkRpcClientApi;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Component;

@Component
public class RpcClientProxy {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxy.class);
    public static final String RPC_PORT = "atlas.rpc.port";
    @Autowired
    private ApplicationArguments arguments;
    private SparkRpcClientApi sparkRpcClientApi;
    @Autowired
    @Qualifier(value="rpcClientPool")
    private ExecutorService rpcClientPool;

    public void init() {
        String address = null;
        List serverPortOpt = this.arguments.getOptionValues(RPC_PORT);
        if (CollectionUtils.isNotEmpty((Collection)serverPortOpt) && serverPortOpt.size() == 1) {
            int port = Integer.parseInt((String)serverPortOpt.get(0));
            List addressOpt = this.arguments.getOptionValues("server.address");
            if (CollectionUtils.isNotEmpty((Collection)addressOpt)) {
                address = (String)addressOpt.get(0);
            }
            if (StringUtils.isNotBlank(address)) {
                this.sparkRpcClientApi = new SparkRpcClientApi(address, port, this.rpcClientPool);
            } else {
                String defaultAddress;
                try {
                    defaultAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    defaultAddress = "127.0.0.1";
                }
                this.sparkRpcClientApi = new SparkRpcClientApi(defaultAddress, port, this.rpcClientPool);
            }
        } else {
            log.warn("\u65e0\u6cd5\u627e\u5230\u5408\u6cd5\u7684rpc\u7aef\u53e3\u53f7\uff0c\u6ca1\u6709\u542f\u52a8rpc\u5ba2\u6237\u7aef!");
        }
    }

    public SparkRpcClientApi getSparkRpcClientApi() {
        return this.sparkRpcClientApi;
    }
}

