/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.domain.metadata;

import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.web.api.v2.domain.metadata.StorageDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LayerMetadata {
    public static final String SHAPEFILE = "shapefile";
    public static final String FILEGDB = "filegdb";
    public static final String JDBC = "jdbc";
    public static final String GW_VECTOR = "gw-vector";
    public static final String GEOJSON = "geojson";
    public static final String PARQUET = "parquet";
    public static final String GRAPH = "graph";
    public static final String GDAL_RASTER = "gdal-raster";
    public static final String GEOTIFF = "geotiff";
    public static final String SECRET = "secret";
    public static final List<String> VECTOR_FORMATS = new ArrayList<String>(){
        {
            this.add(LayerMetadata.SHAPEFILE);
            this.add(LayerMetadata.FILEGDB);
            this.add(LayerMetadata.JDBC);
            this.add(LayerMetadata.GW_VECTOR);
            this.add(LayerMetadata.GEOJSON);
            this.add(LayerMetadata.PARQUET);
        }
    };
    public static final List<String> RASTER_FORMATS = new ArrayList<String>(){
        {
            this.add(LayerMetadata.GDAL_RASTER);
            this.add(LayerMetadata.GEOTIFF);
        }
    };
    public static final List<String> GRAPH_FORMATS = new ArrayList<String>(){
        {
            this.add(LayerMetadata.GRAPH);
        }
    };
    public static final List<String> FORMATS = new ArrayList<String>(){
        {
            this.addAll(VECTOR_FORMATS);
            this.addAll(GRAPH_FORMATS);
            this.addAll(RASTER_FORMATS);
        }
    };
    public static final String SPARK = "spark";
    private String identity;
    private Map<String, List<String>> storageInfo;

    public StorageDesc getPreferStorageDesc(boolean isContainSpark, boolean throwIfNotFound) {
        if (isContainSpark && this.storageInfo.containsKey(SPARK) && !this.storageInfo.get(SPARK).isEmpty()) {
            return new StorageDesc(SPARK, this.storageInfo.get(SPARK).get(0));
        }
        if (this.storageInfo.containsKey(GW_VECTOR) && !this.storageInfo.get(GW_VECTOR).isEmpty()) {
            return new StorageDesc(GW_VECTOR, this.storageInfo.get(GW_VECTOR).get(0));
        }
        if (this.storageInfo.containsKey(SHAPEFILE) && !this.storageInfo.get(SHAPEFILE).isEmpty()) {
            return new StorageDesc(SHAPEFILE, this.storageInfo.get(SHAPEFILE).get(0));
        }
        if (this.storageInfo.containsKey(FILEGDB) && !this.storageInfo.get(FILEGDB).isEmpty()) {
            return new StorageDesc(FILEGDB, this.storageInfo.get(FILEGDB).get(0));
        }
        if (this.storageInfo.containsKey(JDBC) && !this.storageInfo.get(JDBC).isEmpty()) {
            return new StorageDesc(JDBC, this.storageInfo.get(JDBC).get(0));
        }
        if (throwIfNotFound) {
            throw new NotSupportException("\u672a\u80fd\u53d1\u73b0\u6570\u636e\u4fe1\u606f!", Thread.currentThread(), 3);
        }
        return null;
    }

    public String getIdentity() {
        return this.identity;
    }

    public Map<String, List<String>> getStorageInfo() {
        return this.storageInfo;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setStorageInfo(Map<String, List<String>> storageInfo) {
        this.storageInfo = storageInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayerMetadata)) {
            return false;
        }
        LayerMetadata other = (LayerMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identity = this.getIdentity();
        String other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        Map<String, List<String>> this$storageInfo = this.getStorageInfo();
        Map<String, List<String>> other$storageInfo = other.getStorageInfo();
        return !(this$storageInfo == null ? other$storageInfo != null : !((Object)this$storageInfo).equals(other$storageInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LayerMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        Map<String, List<String>> $storageInfo = this.getStorageInfo();
        result = result * 59 + ($storageInfo == null ? 43 : ((Object)$storageInfo).hashCode());
        return result;
    }

    public String toString() {
        return "LayerMetadata(identity=" + this.getIdentity() + ", storageInfo=" + this.getStorageInfo() + ")";
    }

    public LayerMetadata(String identity, Map<String, List<String>> storageInfo) {
        this.identity = identity;
        this.storageInfo = storageInfo;
    }

    public LayerMetadata() {
    }
}

