/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.job;

import com.geoway.atlas.common.error.GSparkException;
import com.geoway.atlas.common.utils.InheritableThreadLocalUtils;
import com.geoway.atlas.data.vector.spark.common.rpc.server.AtlasRpcServerException;
import com.geoway.atlas.data.vector.spark.common.rpc.server.GrpcExceptionUtil;
import com.geoway.atlas.data.vector.spark.common.rpc.task.JobManager$;
import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.job.JobManager;
import com.geoway.atlas.web.api.v2.utils.AccessLogBuilder;
import com.geoway.atlas.web.api.v2.utils.RequestUtils;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AsyncAop {
    private static final Logger log = LoggerFactory.getLogger(AsyncAop.class);
    @Autowired
    private JobManager jobManager;
    @Autowired
    @Qualifier(value="asyncJobPool")
    private ExecutorService asyncJobPool;

    @Around(value="@annotation(asdel)")
    public Map<String, Object> asyncMethod(ProceedingJoinPoint point, AsyncDeal asdel) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes());
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes, (boolean)true);
        HttpServletRequest request = requestAttributes.getRequest();
        Map<String, String> fieldJoinParams = RequestUtils.getParams(request, Arrays.asList("taskid", "jobid"));
        Object[] objs = point.getArgs();
        objs[objs.length - 1] = fieldJoinParams;
        log.info(AccessLogBuilder.getLog(request));
        String jobId = this.jobManager.getJobId(request);
        String rawTaskId = this.jobManager.getTaskId(request);
        Map<String, Object> response = ResponseBuilder.buildAsyncResponse(jobId);
        String jobStatus = this.jobManager.startJob(rawTaskId, jobId, ResponseBuilder.buildRunning(jobId));
        if (JobManager$.MODULE$.YES().equalsIgnoreCase(jobStatus)) {
            Future<?> future = this.asyncJobPool.submit(() -> {
                try {
                    InheritableThreadLocalUtils.setLocalProperty((String)InheritableThreadLocalUtils.ATLAS_TASK_ID(), (String)StringUtils.replace((String)rawTaskId, (String)"-", (String)""));
                    Map objectMap = (Map)point.proceed(objs);
                    this.jobManager.finishJob(rawTaskId, jobId, objectMap);
                    log.info("\u4efb\u52a1" + jobId + "\u6210\u529f!");
                }
                catch (Throwable throwable) {
                    Throwable nt;
                    RuntimeException nThrowable = throwable instanceof GSparkException ? (RuntimeException)throwable : (throwable instanceof StatusRuntimeException ? ((nt = GrpcExceptionUtil.unwrapException((StatusRuntimeException)((StatusRuntimeException)throwable))) instanceof RuntimeException ? (RuntimeException)nt : new AtlasRpcServerException(nt.getMessage(), nt.getStackTrace())) : (throwable instanceof RuntimeException ? (RuntimeException)throwable : new AtlasRpcServerException(throwable.getMessage(), throwable.getStackTrace())));
                    this.jobManager.finishJob(rawTaskId, jobId, ResponseBuilder.buildFailed(nThrowable));
                    log.error("\u4efb\u52a1" + jobId + "\u5931\u8d25!", (Throwable)nThrowable);
                }
            });
            this.jobManager.putFuture(rawTaskId, jobId, future);
        } else {
            log.warn("\u4efb\u52a1:" + rawTaskId + ",\u5de5\u4f5c\u9879:" + jobId + ",\u5df2\u7ecf\u6267\u884c\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!");
        }
        return response;
    }
}

