/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2.init;

import com.geoway.atlas.common.config.AtlasSystemProperties$;
import com.geoway.atlas.framework.spark.common.SparkRuntime$;
import com.geoway.atlas.framework.spark.vector.init.InitVectorSparkEnv$;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.component.rpc.RpcServiceProxy;
import com.geoway.atlas.web.api.v2.component.serverCenter.ServerCenter;
import com.geoway.atlas.web.api.v2.domain.rpc.ConnectInfo;
import com.geoway.atlas.web.api.v2.exception.AtlasException;
import com.geoway.atlas.web.api.v2.init.SparkRuntimeArgs;
import com.geoway.atlas.web.api.v2.utils.ApplicationArgumentsUtils;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.spark.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import scala.runtime.BoxedUnit;

@Order(value=0)
@Component
public class InitEnv
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(InitEnv.class);
    @Autowired
    private RpcClientProxy clientProxy;
    @Autowired
    private RpcServiceProxy serviceProxy;
    @Autowired
    private ServerCenter serverCenter;
    private static final String DEBUG_ENABLE = "atlas.debug.driver.dump.enable";
    private static final String DEBUG_DIR = "atlas.debug.driver.dump.dir";
    public static final String RPC_PORT = "atlas.rpc.port";
    private static final Integer DUMP_PRIORY = 90;

    public void run(ApplicationArguments args) {
        SparkRuntimeArgs sparkRuntimeArgs = ApplicationArgumentsUtils.fromApplicationArgs(args);
        SparkRuntime$.MODULE$.start(sparkRuntimeArgs.getStartMode(), sparkRuntimeArgs.getAppName(), sparkRuntimeArgs.getMemoryFunc().doubleValue(), sparkRuntimeArgs.getNumExecutors().intValue(), sparkRuntimeArgs.getExecutorCores().intValue());
        String port = ApplicationArgumentsUtils.getSingleValue(args, "server.port");
        InitVectorSparkEnv$.MODULE$.init();
        this.handleDebug(sparkRuntimeArgs.getAppName(), port);
        this.serviceProxy.init();
        this.clientProxy.init(this.getRpcConnectInfo(args));
        this.serverCenter.init(sparkRuntimeArgs);
        this.clientProxy.getSparkRpcClientApi().startMonitorTask(this.getEnvParams(args));
        log.info("\u670d\u52a1\u51c6\u5907\u5c31\u7eea!");
    }

    private ConnectInfo getRpcConnectInfo(ApplicationArguments arguments) {
        String address = null;
        List serverPortOpt = arguments.getOptionValues(RPC_PORT);
        if (CollectionUtils.isNotEmpty((Collection)serverPortOpt) && serverPortOpt.size() == 1) {
            int port = Integer.parseInt((String)serverPortOpt.get(0));
            List addressOpt = arguments.getOptionValues("server.address");
            if (CollectionUtils.isNotEmpty((Collection)addressOpt)) {
                address = (String)addressOpt.get(0);
            }
            return new ConnectInfo(address, Integer.valueOf(port));
        }
        throw new AtlasException("\u65e0\u6cd5\u627e\u5230\u5408\u6cd5\u7684rpc\u7aef\u53e3\u53f7\uff0c\u6ca1\u6709\u542f\u52a8rpc\u5ba2\u6237\u7aef!");
    }

    private Map<String, String> getEnvParams(ApplicationArguments args) {
        HashMap<String, String> envParams = new HashMap<String, String>();
        String atlasUrl = StringUtils.defaultString((String)ApplicationArgumentsUtils.getSingleValue(args, "atlas.url"));
        envParams.put("atlas.url", atlasUrl);
        return envParams;
    }

    private void handleDebug(String appName, String port) {
        if (Boolean.parseBoolean(AtlasSystemProperties$.MODULE$.getProperty(DEBUG_ENABLE, "false"))) {
            log.info("DRIVER\u5f00\u542fDEBUG\u6a21\u5f0f!");
            String dumpDir = System.getProperty(DEBUG_DIR);
            if (StringUtils.isBlank((CharSequence)dumpDir)) {
                dumpDir = "/tmp";
            }
            String finalDumpDir = dumpDir;
            ShutdownHookManager.addShutdownHook((int)DUMP_PRIORY, () -> {
                HotSpotDiagnosticMXBean mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
                try {
                    String dumpName = appName + "-" + port + "-" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".hprof";
                    log.info("\u5f00\u59cb\u751f\u6210dump\u6587\u4ef6:" + finalDumpDir + File.separatorChar + dumpName);
                    mxBean.dumpHeap(finalDumpDir + File.separatorChar + dumpName, true);
                    log.info("\u5b8c\u6210\u751f\u6210dump\u6587\u4ef6:" + finalDumpDir + File.separatorChar + dumpName);
                }
                catch (IOException e) {
                    log.error("\u65e0\u6cd5\u751f\u6210dump\u6587\u4ef6:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                return BoxedUnit.UNIT;
            });
        }
    }
}

