/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.web.api.v2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestContextListener;

@SpringBootApplication
@ServletComponentScan
public class AtlasWebSparkServer {
    private static final Logger log = LoggerFactory.getLogger(AtlasWebSparkServer.class);
    public static final String SERVER_ADDRESS = "server.address";
    public static final String SERVER_PORT = "server.port";
    public static final CountDownLatch cdl = new CountDownLatch(1);

    public static void main(String[] args) {
        boolean isLock = false;
        Class<?> clz = null;
        try {
            clz = Class.forName("com.geoway.atlas.license.authorize.LicenseCheck");
            isLock = true;
        }
        catch (ClassNotFoundException e) {
            log.warn("Not found soft lock!");
        }
        if (isLock) {
            Method method;
            try {
                method = clz.getMethod("isValid", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                boolean hasLicense = (Boolean)method.invoke(clz.newInstance(), 64204);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        SpringApplication.run(AtlasWebSparkServer.class, (String[])args);
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }
}

