package com.geoway.atlas.web.api.v2.controller.pkg;

import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.job.AsyncDeal;
import com.geoway.atlas.web.api.v2.service.pkg.DataManagerServer;
import com.geoway.atlas.web.api.v2.utils.MapUtils;
import com.geoway.atlas.web.api.v2.utils.TaskUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Map;

/**
 * @author zhaotong 2022/10/31 11:32
 */
@Api(value = "图层管理组合算子", tags = "图层管理组合算子")
@RequestMapping("/api/v2/package/manager")
@RestController
@Slf4j
@CrossOrigin(
        origins = {"*"}
)
public class DataManagerController {

    @Autowired
    private Constants constants;

    @Autowired
    private DataManagerServer dataManagerServer;


    @ApiOperation("属性筛选")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_filter_sql", value = "设置基础图层筛选信息"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/filter"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> filterProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_filter_sql", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_filter_fields", required = false) String selectFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.filterProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("数据转换")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_read_partition_column", value = "设置唯一标识字段"),
            @ApiImplicitParam(name = "atlas_data_vector_jdbc_storage_default_geometry", value = "指定空间字段名称"),
            @ApiImplicitParam(name = "atlas_process_filter_sql", value = "过滤条件表达式(where)"),
            @ApiImplicitParam(name = "atlas_process_filter_fields", value = "设置输出字段"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "atlas_storage_write_is_append", value = "是否追加写入"),
            @ApiImplicitParam(name = "atlas_storage_write_is_auto_pk", value = "是否为自增主键"),
            @ApiImplicitParam(name = "atlas_storage_write_pk_name", value = "主键名称"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/io"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> vectorIoProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_read_partition_column", required = false) String partitionField,
            @RequestParam(value = "atlas_data_vector_jdbc_storage_default_geometry", required = false) String selectGeom,
            @RequestParam(value = "atlas_process_filter_sql", required = false) String baseFilter,
            @RequestParam(value = "atlas_process_filter_fields", required = false) String selectFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "atlas_storage_write_is_append", required = false, defaultValue = "false") boolean isAppend,
            @RequestParam(value = "atlas_storage_write_is_auto_pk", required = false, defaultValue = "true") boolean autoPk,
            @RequestParam(value = "atlas_storage_write_pk_name", required = false) String pkName,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.vectorIoProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("图数据转换")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_dataset_graph_node_class", value = "设置读取节点的类别"),
            @ApiImplicitParam(name = "atlas_dataset_graph_node_properties_enable", value = "是否读取节点props属性"),
            @ApiImplicitParam(name = "atlas_dataset_graph_node_filter", value = "设置节点过滤条件表达式(cypher)"),
            @ApiImplicitParam(name = "atlas_dataset_graph_edge_class", value = "设置读取边的类别"),
            @ApiImplicitParam(name = "atlas_dataset_graph_edge_properties_enable", value = "是否读取边props属性"),
            @ApiImplicitParam(name = "atlas_dataset_graph_edge_filter", value = "设置边过滤条件表达式(cypher)"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "atlas_dataset_write_save_node", value = "是否保存节点"),
            @ApiImplicitParam(name = "atlas_storage_write_node_is_append", value = "是否更新已有节点"),
            @ApiImplicitParam(name = "atlas_dataset_write_save_edge", value = "是否保存边"),
            @ApiImplicitParam(name = "atlas_storage_write_edge_is_append", value = "是否更新已有边"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/graph/io"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> graphIoProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_dataset_graph_node_class", required = false) String nodeClass,
            @RequestParam(value = "atlas_dataset_graph_node_properties_enable", required = false, defaultValue = "true") boolean enableNodeProps,
            @RequestParam(value = "atlas_dataset_graph_node_filter", required = false) String nodeFilter,
            @RequestParam(value = "atlas_dataset_graph_edge_class", required = false) String edgeClass,
            @RequestParam(value = "atlas_dataset_graph_edge_properties_enable", required = false, defaultValue = "true") boolean enableEdgeProps,
            @RequestParam(value = "atlas_dataset_graph_edge_filter", required = false) String edgeFilter,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "atlas_dataset_write_save_node", required = false, defaultValue = "true") boolean saveNode,
            @RequestParam(value = "atlas_storage_write_node_is_append", required = false, defaultValue = "true") boolean nodeIsAppend,
            @RequestParam(value = "atlas_dataset_write_save_edge", required = false, defaultValue = "true") boolean saveEdge,
            @RequestParam(value = "atlas_storage_write_edge_is_append", required = false, defaultValue = "true") boolean edgeIsAppend,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.graphIoProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("实体关系构建")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_src_id", value = "设置源节点的唯一标识字段名称", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_src_name", value = "设置源节点名字的字段名称"),
            @ApiImplicitParam(name = "atlas_data_graph_src_class", value = "设置源节点类别的字段名称", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_src_props", value = "设置源节点属性的字段列表"),
            @ApiImplicitParam(name = "atlas_data_graph_dst_id", value = "设置目标节点的唯一标识字段", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_dst_name", value = "设置目标节点名字的字段名称"),
            @ApiImplicitParam(name = "atlas_data_graph_dst_class", value = "设置目标节点类别的字段名称", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_dst_props", value = "设置目标节点属性的字段列表"),
            @ApiImplicitParam(name = "atlas_data_graph_edge_id", value = "设置边的唯一标识字段", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_edge_name", value = "设置边名字的字段名称"),
            @ApiImplicitParam(name = "atlas_data_graph_edge_class", value = "设置边类别的字段名称", required = true),
            @ApiImplicitParam(name = "atlas_data_graph_edge_props", value = "设置边属性的字段列表"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果标识"),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/graph_production"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> toGraphProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_graph_src_id") String srcId,
            @RequestParam(value = "atlas_data_graph_src_name", required = false) String srcName,
            @RequestParam(value = "atlas_data_graph_src_class") String srcClass,
            @RequestParam(value = "atlas_data_graph_src_props", required = false) String srcProps,
            @RequestParam(value = "atlas_data_graph_dst_id") String dstId,
            @RequestParam(value = "atlas_data_graph_dst_name", required = false) String dstName,
            @RequestParam(value = "atlas_data_graph_dst_class") String dstClass,
            @RequestParam(value = "atlas_data_graph_dst_props", required = false) String dstProps,
            @RequestParam(value = "atlas_data_graph_edge_id") String edgeId,
            @RequestParam(value = "atlas_data_graph_edge_name", required = false) String edgeName,
            @RequestParam(value = "atlas_data_graph_edge_class") String edgeClass,
            @RequestParam(value = "atlas_data_graph_edge_props", required = false) String edgeProps,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.toGraphProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("字段计算器")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_field_calc_sql_expression", value = "设置字段计算sql表达式"),
            @ApiImplicitParam(name = "atlas_process_field_calc_name", value = "设置计算字段名称"),
            @ApiImplicitParam(name = "atlas_process_field_calc_is_new", value = "是否为新增字段"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/field/calculate"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> calcFieldProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_field_calc_sql_expression", required = false) String sqlExpression,
            @RequestParam(value = "atlas_process_field_calc_name", required = false) String fieldName,
            @RequestParam(value = "atlas_process_field_calc_is_new", required = false, defaultValue = "true") Boolean isNew,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.calcFieldProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("图斑生成")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_geometry_generator_sql_expression", value = "设置图斑生成表达式"),
            @ApiImplicitParam(name = "atlas_process_geometry_generator_name", value = "设置图斑字段名称"),
            @ApiImplicitParam(name = "atlas_process_geometry_generator_srid", value = "设置图斑的坐标srid"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/geometry/generator"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> geoGeneratorProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_geometry_generator_sql_expression", required = false) String sqlExpression,
            @RequestParam(value = "atlas_process_geometry_generator_name", required = false) String geoName,
            @RequestParam(value = "atlas_process_geometry_generator_srid", required = false) Integer srid,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.geoGeneratorProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("多字段计算器")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_field_calc_sql_expression", value = "设置字段计算sql表达式"),
            @ApiImplicitParam(name = "atlas_process_field_calc_name", value = "设置保留的原字段名称"),
            @ApiImplicitParam(name = "atlas_process_field_diff_name", value = "设置排除的原字段名称"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/field/multi_calculate"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> multiCalcFieldProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_field_calc_sql_expression") String sqlExpression,
            @RequestParam(value = "atlas_process_field_calc_name", required = false) String fieldName,
            @RequestParam(value = "atlas_process_field_diff_name", required = false) String diffName,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        paramMaps.put(constants.fieldCalculatorMode(),
                Integer.toString(constants.fieldCalculatorModeMulti()));
        return dataManagerServer.calcFieldProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("字段重命名")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_field_old_params", value = "设置原始字段名称"),
            @ApiImplicitParam(name = "atlas_process_field_new_params", value = "设置重命名后字段名称"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/field/rename"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> fieldRenameProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_field_old_params", required = false) String oldFields,
            @RequestParam(value = "atlas_process_field_new_params", required = false) String newFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.fieldRenameProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("坐标转换")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_crs_trans_params", value = "设置坐标转换参数"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/project"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> projectProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_crs_trans_params", required = false) String targetCrs,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.projectProcess(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("矢量拼接")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_merge_select_fields", value = "设置选取的字段名称"),
            @ApiImplicitParam(name = "atlas_process_merge_unity_geometry_field", value = "设置唯一图形字段名称"),
            @ApiImplicitParam(name = "atlas_process_merge_unity_proj", value = "设置投影坐标参数"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/merge"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> mergeProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_data_merge_identity") String mergeIdentity,
            @RequestParam(value = "atlas_process_merge_select_fields", required = false) String selectFields,
            @RequestParam(value = "atlas_process_merge_unity_geometry_field", required = false) String geomField,
            @RequestParam(value = "atlas_process_merge_unity_proj", required = false) String targetCrs,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.merge.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.mergeProcess(
                baseIdentity,
                mergeIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }


    @ApiOperation("属性连接")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_field_left_base_fields", value = "属性连接基于的基础图层字段", required = true),
            @ApiImplicitParam(name = "atlas_data_other_identity", value = "设置连接图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_field_right_base_fields", value = "属性连接基于的连接图层字段", required = true),
            @ApiImplicitParam(name = "atlas_process_field_join_fields", value = "连接到基础图层的字段映射"),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/field/join"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> fieldJoinProcess(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_field_left_base_fields") String leftBaseField,
            @RequestParam(value = "atlas_data_other_identity") String otherIdentity,
            @RequestParam(value = "atlas_process_field_right_base_fields") String rightBaseField,
            @RequestParam(value = "atlas_process_field_join_fields", required = false) String joinFields,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.other.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.fieldJoinProcess(
                baseIdentity,
                otherIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

    @ApiOperation("面重叠检查")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "atlas_data_base_identity", value = "设置基础图层标识", required = true),
            @ApiImplicitParam(name = "atlas_process_overlay_relate_oid_exist", value = "设置唯一标识字段是否存在"),
            @ApiImplicitParam(name = "atlas_process_overlay_relate_oid", value = "设置唯一标识字段名称", required = true),
            @ApiImplicitParam(name = "atlas_process_overlay_relate_field", value = "设置关联字段名称", required = true),
            @ApiImplicitParam(name = "atlas_data_result_identity", value = "设置结果图层标识", required = true),
            @ApiImplicitParam(name = "atlas_data_result_persist_disk", value = "是否持久化存储"),
            @ApiImplicitParam(name = "atlas_data_result_persist_url", value = "持久化存储url"),
            @ApiImplicitParam(name = "taskid", defaultValue = "", value = "作业id"),
            @ApiImplicitParam(name = "jobid", defaultValue = "", value = "任务项id")
    })
    @RequestMapping(value = {"/vector/relate/overlay"}, method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_VALUE)
    @AsyncDeal
    public Map<String, Object> overlayRelate(
            @RequestParam(value = "atlas_data_base_identity") String baseIdentity,
            @RequestParam(value = "atlas_process_overlay_relate_oid_exist", required = false, defaultValue = "false") boolean oidExist,
            @RequestParam(value = "atlas_process_overlay_relate_oid") String relateOid,
            @RequestParam(value = "atlas_process_overlay_relate_field") String relateField,
            @RequestParam(value = "atlas_data_result_identity") String resultIdentity,
            @RequestParam(value = "atlas_data_result_persist_disk", required = false, defaultValue = "false") boolean persistDisk,
            @RequestParam(value = "atlas_data_result_persist_url", required = false) String persistUrl,
            @RequestParam(value = "taskid", defaultValue = "", required = false) String taskId,
            @RequestParam(value = "jobid", defaultValue = "", required = false) String jobId,
            Map<String, String> paramMaps) {
        // TODO 后面在filter中过滤
        String nTaskId = TaskUtils.removeDelimiter(taskId);
        // 获取所有的输入参数
        MapUtils.filterKeys(paramMaps,
                Arrays.asList(
                        "atlas.data.base.identity",
                        "atlas.data.result.identity",
                        "atlas.data.result.persist.disk",
                        "atlas.data.result.persist.url",
                        "taskid",
                        "jobid"));
        return dataManagerServer.overlayRelate(
                baseIdentity,
                paramMaps,
                resultIdentity,
                persistDisk,
                persistUrl,
                nTaskId,
                jobId);
    }

}
