package com.geoway.atlas.web.api.v2.exception;

import com.geoway.atlas.web.api.v2.utils.AccessLogBuilder;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;

/**
 * 主要用于异步方法调用
 *
 * @author zhaotong
 * @version 1.0
 * @description
 * @date 2021/5/12 10:16
 */
@Aspect
@Slf4j
public class ExceptionAop {

    @Around("@annotation(exdel)")
    public Map<String, Object> handleException(ProceedingJoinPoint point, ExceptionDeal exdel) {
        HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(
                RequestContextHolder.getRequestAttributes())).getRequest();
        /** 添加埋点日志 */
        if (exdel.isLog()) {
            log.info(AccessLogBuilder.getLog(request));
        }
        try {
            return (Map<String, Object>) point.proceed(point.getArgs());
        } catch (Throwable throwable) {
            return ResponseBuilder.buildFailed(throwable);
        }
    }

}
