package com.geoway.atlas.web.api.v2.license.authorize;

/**
 * @author zhaotong
 * @version 1.0
 * @description
 * @date 2021/4/29 19:25
 */


import com.geoway.atlas.hasp.AtlasHaspJNI;
import com.geoway.atlas.web.api.v2.license.jna.JnaInvoke;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LicenseCheck {

    private static ConcurrentMap<String, Boolean> licenses;

    public static boolean isValid() {
        byte[] messageBytes = new byte[100];
        final boolean login = AtlasHaspJNI.verifyHaspLock(CHECK_MODULE.MAIN, CHECK_MODULE.MAIN, messageBytes);
        if (login) {
            messageBytes = new byte[100];
            final boolean algorithmCheck = AtlasHaspJNI.verifyHaspLock(CHECK_MODULE.ALGORITHM, CHECK_MODULE.ALGORITHM, messageBytes);
            if (algorithmCheck) {
                return true;
            } else {
                throw new LicenseCheckException(new String(messageBytes, StandardCharsets.UTF_8));
            }
        } else {
            String error = new String(messageBytes, StandardCharsets.UTF_8);
            messageBytes = new byte[100];
            final boolean IMELogin = AtlasHaspJNI.verifyHaspLock(CHECK_MODULE.IME_MAIN, CHECK_MODULE.IME_MAIN, messageBytes);
            if (IMELogin) {
                return true;
            } else {
                throw new LicenseCheckException(error);
            }
        }
    }

    public static boolean checkModule(final int module) {
        final String moduleName = "MODULE" + module;
        if (licenses.containsKey(moduleName)) {
            return licenses.get(moduleName);
        }
        isValid();
        final boolean login = JnaInvoke.DaemonFuncs_CheckModule(module);
        if (!login) {
            final String error = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            throw new LicenseCheckException(error);
        }
        final boolean check = JnaInvoke.DaemonFuncs_Check();
        if (!check) {
            final String error2 = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            throw new LicenseCheckException(error2);
        }
        licenses.put(moduleName, check);
        return check;
    }

    public static boolean checkModuleNoException(final int module) {
        final String moduleName = "MODULE" + module;
        if (licenses.containsKey(moduleName)) {
            return licenses.get(moduleName);
        }
        isValid();
        final boolean login = JnaInvoke.DaemonFuncs_CheckModule(module);
        if (!login) {
            final String error = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            return false;
        }
        final boolean check = JnaInvoke.DaemonFuncs_Check();
        if (!check) {
            final String error2 = JnaInvoke.DaemonFuncs_GetLastMessage().toString();
            return false;
        }
        licenses.put(moduleName, check);
        return check;
    }

    public static void main(final String[] args) {
        final boolean valid = isValid();
        System.out.println("main module:" + valid);
    }

    static {
        licenses = new ConcurrentHashMap<String, Boolean>();
    }
}
