package com.geoway.atlas.web.api.v2.service.impl;

import com.geoway.atlas.common.error.CancelOpException;
import com.geoway.atlas.web.api.v2.component.rpc.RpcClientProxy;
import com.geoway.atlas.web.api.v2.job.JobManager;
import com.geoway.atlas.web.api.v2.service.AtlasServer;
import com.geoway.atlas.web.api.v2.utils.ResponseBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Atlas任务执行信息
 *
 * @author zhaotong 2022/9/7 10:01
 */
@Service
@Slf4j
public class AtlasServerImpl implements AtlasServer {

    @Autowired
    private JobManager jobManager;

    @Autowired
    private RpcClientProxy rpcClientProxy;

    @Override
    public Map<String, Object> jobResult(String jobId) {
        return jobManager.getJobInfo(jobId);
    }

    @Override
    public Map<String, Object> canceljob(String rawTaskId, String jobId) {
        log.info("1.设置停止任务的响应信息");
        jobManager.cancelJob(rawTaskId, jobId);
        log.info("2.停止异步任务");
        jobManager.stopFutures(rawTaskId);
        log.info("3.通知服务端停止任务");
        rpcClientProxy.getSparkRpcClientApi().cancelTask(rawTaskId);
        return ResponseBuilder.buildSuccess("停止任务成功");
    }

    @Override
    public Map<String, Object> jobDemo(long duration) {
        try {
            System.out.println("算子已启动");
            Thread.sleep(duration);
        } catch (InterruptedException interruptedException) {
            throw new CancelOpException("线程终止!", Thread.currentThread(), 3);
        }
        return ResponseBuilder.buildSuccess("你好");
    }
}
