package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.component.bean.AtlasGisToolkitBeanFactory;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhaotong 2023/11/13 12:56
 */
public class InputParamUtils {

    public static Constants constants = AtlasGisToolkitBeanFactory.getBean(Constants.class);

    public static Map<String, String> getInputVectorParams(Map<String, String> allParams) {
        Map<String, String> inputVectorParams = new HashMap<>();

        if (allParams.containsKey(constants.schemaFilterSql())) {
            String value = allParams.get(constants.schemaFilterSql());
            if (StringUtils.isNotBlank(value)) {
                inputVectorParams.put(constants.schemaFilterSql(), value);
            }
        }

        if (allParams.containsKey(constants.filterExpression())) {
            String value = allParams.get(constants.filterExpression());
            if (StringUtils.isNotBlank(value)) {
                inputVectorParams.put(constants.schemaFilterSql(), value);
            }
        }

        if (allParams.containsKey(constants.schemaSelectColumns())) {
            String value = allParams.get(constants.schemaSelectColumns());
            if (StringUtils.isNotBlank(value)) {
                inputVectorParams.put(constants.schemaSelectColumns(), value);
            }
        }

        if (allParams.containsKey(constants.filterSelectFields())) {
            String value = allParams.get(constants.filterSelectFields());
            if (StringUtils.isNotBlank(value)) {
                inputVectorParams.put(constants.schemaSelectColumns(), value);
            }
        }

        return inputVectorParams;
    }


    public static Map<String, String> getSourceFilterParams(String filterSql) {
        Map<String, String> inputVectorParams = new HashMap<>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(filterSql)) {
            inputVectorParams.put(constants.schemaFilterSql(), filterSql);
        }

        return inputVectorParams;
    }
}
