package com.geoway.atlas.web.api.v2.utils;

import com.geoway.atlas.common.error.NoExpectException;
import com.geoway.atlas.common.error.ParamException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhaotong 2022/9/8 9:22
 */
public class RequestUtils {

    public static final String SENIOR_PARAMS = "atlas_senior_params";

    /**
     * 获取参数信息
     *
     * @param request http请求信息
     * @return 返回参数描述映射
     */
    public static Map<String, String> getParams(HttpServletRequest request, List<String> exceptKeys) {
        Map<String, String[]> parameterMap = request.getParameterMap();
        Map<String, String> params = new HashMap<>();

        // 将参数放到结果集合中
        for (String key : parameterMap.keySet()) {
            if (!exceptKeys.contains(key)) {
                if (SENIOR_PARAMS.equalsIgnoreCase(key)) {
                    String parameters = request.getParameterValues(key)[0];
                    if (StringUtils.isNotBlank(parameters)) {
                        String[] paramArray = (" " + parameters).split("\\s+--");
                        if (paramArray.length > 1) {
                            for (int i = 1; i < paramArray.length; i++) {
                                int equalIndex = paramArray[i].indexOf("=");
                                if (equalIndex == -1) {
                                    throw new ParamException("参数输入错误，无法找到等于号=!", Thread.currentThread(), 3);
                                }
                                String k = StringUtils.replace(paramArray[i].substring(0, equalIndex).trim(),
                                        "_", ".");
                                String v = paramArray[i].substring(equalIndex + 1).trim();
                                if (StringUtils.isNotBlank(v)) {
                                    params.put(k, v);
                                }
                            }
                        }
                    }
                } else {
                    String v = request.getParameter(key);
                    if (StringUtils.isNotBlank(v)) {
                        params.put(StringUtils.replace(key, "_", "."), request.getParameter(key));
                    }
                }
            }
        }

        return params;
    }
}
