package com.geoway.atlas.web.api.v2.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.geoway.atlas.data.vector.spark.common.rpc.RpcDescDataRespond;
import com.geoway.atlas.data.vector.spark.common.rpc.common.Constants;
import com.geoway.atlas.web.api.v2.component.bean.AtlasGisToolkitBeanFactory;
import com.geoway.atlas.web.api.v2.dto.vector.FieldInfo;
import lombok.SneakyThrows;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author zhaotong 2024/4/9 10:56
 */
public class RpcDescRespondUtils {

    public static Constants constants = AtlasGisToolkitBeanFactory.getBean(Constants.class);
    // FieldInfo(fieldName: String, fieldType: String)
    @SneakyThrows
    public static List<FieldInfo> getVectorFieldInfo(RpcDescDataRespond rpcDescDataRespond) {
        Map<String, String> dataDescMap = rpcDescDataRespond.getDataDescMap();
        if (dataDescMap.containsKey(constants.dataDescFields())) {
            return AtlasGisToolkitBeanFactory.getObjectMapper().readValue(
                    dataDescMap.get(constants.dataDescFields()), new TypeReference<List<FieldInfo>>() {
                    });
        }
        return new ArrayList<>();
    }
}
